package software.amazon.awscdk.services.appconfig;

/**
 * Defines an action for an extension.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function fn;
 * Extension.Builder.create(this, "MyExtension")
 *         .actions(List.of(
 *             Action.Builder.create()
 *                     .actionPoints(List.of(ActionPoint.ON_DEPLOYMENT_START))
 *                     .eventDestination(new LambdaDestination(fn))
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:26.830Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.Action")
public class Action extends software.amazon.jsii.JsiiObject {

    protected Action(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Action(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Action(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The action points that will trigger the extension action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appconfig.ActionPoint> getActionPoints() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "actionPoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ActionPoint.class))));
    }

    /**
     * The event destination for the action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination getEventDestination() {
        return software.amazon.jsii.Kernel.get(this, "eventDestination", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IEventDestination.class));
    }

    /**
     * The description for the action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The execution role for the action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getExecutionRole() {
        return software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * The flag that specifies whether to create the execution role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getInvokeWithoutExecutionRole() {
        return software.amazon.jsii.Kernel.get(this, "invokeWithoutExecutionRole", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The name for the action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appconfig.Action}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appconfig.Action> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.appconfig.ActionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.appconfig.ActionProps.Builder();
        }

        /**
         * The action points that will trigger the extension action.
         * <p>
         * @return {@code this}
         * @param actionPoints The action points that will trigger the extension action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionPoints(final java.util.List<? extends software.amazon.awscdk.services.appconfig.ActionPoint> actionPoints) {
            this.props.actionPoints(actionPoints);
            return this;
        }

        /**
         * The event destination for the action.
         * <p>
         * @return {@code this}
         * @param eventDestination The event destination for the action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventDestination(final software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
            this.props.eventDestination(eventDestination);
            return this;
        }

        /**
         * The description for the action.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description The description for the action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The execution role for the action.
         * <p>
         * Default: - A role is generated.
         * <p>
         * @return {@code this}
         * @param executionRole The execution role for the action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(final software.amazon.awscdk.services.iam.IRole executionRole) {
            this.props.executionRole(executionRole);
            return this;
        }

        /**
         * The flag that specifies whether or not to create the execution role.
         * <p>
         * If set to true, then the role will not be auto-generated under the assumption
         * there is already the corresponding resource-based policy attached to the event
         * destination. If false, the execution role will be generated if not provided.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param invokeWithoutExecutionRole The flag that specifies whether or not to create the execution role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invokeWithoutExecutionRole(final java.lang.Boolean invokeWithoutExecutionRole) {
            this.props.invokeWithoutExecutionRole(invokeWithoutExecutionRole);
            return this;
        }

        /**
         * The name for the action.
         * <p>
         * Default: - A name is generated.
         * <p>
         * @return {@code this}
         * @param name The name for the action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appconfig.Action}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appconfig.Action build() {
            return new software.amazon.awscdk.services.appconfig.Action(
                this.props.build()
            );
        }
    }
}
