package software.amazon.awscdk.services.appconfig;

/**
 * Properties for defining a <code>CfnHostedConfigurationVersion</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appconfig.*;
 * CfnHostedConfigurationVersionProps cfnHostedConfigurationVersionProps = CfnHostedConfigurationVersionProps.builder()
 *         .applicationId("applicationId")
 *         .configurationProfileId("configurationProfileId")
 *         .content("content")
 *         .contentType("contentType")
 *         // the properties below are optional
 *         .description("description")
 *         .latestVersionNumber(123)
 *         .versionLabel("versionLabel")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:26.851Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.CfnHostedConfigurationVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnHostedConfigurationVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnHostedConfigurationVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The application ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-applicationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-applicationid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationId();

    /**
     * The configuration profile ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-configurationprofileid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-configurationprofileid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConfigurationProfileId();

    /**
     * The configuration data, as bytes.
     * <p>
     * <blockquote>
     * <p>
     * AWS AppConfig accepts any type of data, including text formats like JSON or TOML, or binary formats like protocol buffers or compressed data.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-content">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-content</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getContent();

    /**
     * A standard MIME type describing the format of the configuration content.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-contenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-contenttype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getContentType();

    /**
     * A description of the configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * An optional locking token used to prevent race conditions from overwriting configuration updates when creating a new version.
     * <p>
     * To ensure your data is not overwritten when creating multiple hosted configuration versions in rapid succession, specify the version number of the latest hosted configuration version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-latestversionnumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-latestversionnumber</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getLatestVersionNumber() {
        return null;
    }

    /**
     * A user-defined label for an AWS AppConfig hosted configuration version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-versionlabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-versionlabel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersionLabel() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnHostedConfigurationVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnHostedConfigurationVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnHostedConfigurationVersionProps> {
        java.lang.String applicationId;
        java.lang.String configurationProfileId;
        java.lang.String content;
        java.lang.String contentType;
        java.lang.String description;
        java.lang.Number latestVersionNumber;
        java.lang.String versionLabel;

        /**
         * Sets the value of {@link CfnHostedConfigurationVersionProps#getApplicationId}
         * @param applicationId The application ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(java.lang.String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostedConfigurationVersionProps#getConfigurationProfileId}
         * @param configurationProfileId The configuration profile ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationProfileId(java.lang.String configurationProfileId) {
            this.configurationProfileId = configurationProfileId;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostedConfigurationVersionProps#getContent}
         * @param content The configuration data, as bytes. This parameter is required.
         *                <blockquote>
         *                <p>
         *                AWS AppConfig accepts any type of data, including text formats like JSON or TOML, or binary formats like protocol buffers or compressed data.
         *                <p>
         *                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder content(java.lang.String content) {
            this.content = content;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostedConfigurationVersionProps#getContentType}
         * @param contentType A standard MIME type describing the format of the configuration content. This parameter is required.
         *                    For more information, see <a href="https://docs.aws.amazon.com/https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">Content-Type</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentType(java.lang.String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostedConfigurationVersionProps#getDescription}
         * @param description A description of the configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostedConfigurationVersionProps#getLatestVersionNumber}
         * @param latestVersionNumber An optional locking token used to prevent race conditions from overwriting configuration updates when creating a new version.
         *                            To ensure your data is not overwritten when creating multiple hosted configuration versions in rapid succession, specify the version number of the latest hosted configuration version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder latestVersionNumber(java.lang.Number latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
            return this;
        }

        /**
         * Sets the value of {@link CfnHostedConfigurationVersionProps#getVersionLabel}
         * @param versionLabel A user-defined label for an AWS AppConfig hosted configuration version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionLabel(java.lang.String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnHostedConfigurationVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnHostedConfigurationVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnHostedConfigurationVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnHostedConfigurationVersionProps {
        private final java.lang.String applicationId;
        private final java.lang.String configurationProfileId;
        private final java.lang.String content;
        private final java.lang.String contentType;
        private final java.lang.String description;
        private final java.lang.Number latestVersionNumber;
        private final java.lang.String versionLabel;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationId = software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configurationProfileId = software.amazon.jsii.Kernel.get(this, "configurationProfileId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.content = software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.latestVersionNumber = software.amazon.jsii.Kernel.get(this, "latestVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.versionLabel = software.amazon.jsii.Kernel.get(this, "versionLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationId = java.util.Objects.requireNonNull(builder.applicationId, "applicationId is required");
            this.configurationProfileId = java.util.Objects.requireNonNull(builder.configurationProfileId, "configurationProfileId is required");
            this.content = java.util.Objects.requireNonNull(builder.content, "content is required");
            this.contentType = java.util.Objects.requireNonNull(builder.contentType, "contentType is required");
            this.description = builder.description;
            this.latestVersionNumber = builder.latestVersionNumber;
            this.versionLabel = builder.versionLabel;
        }

        @Override
        public final java.lang.String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final java.lang.String getConfigurationProfileId() {
            return this.configurationProfileId;
        }

        @Override
        public final java.lang.String getContent() {
            return this.content;
        }

        @Override
        public final java.lang.String getContentType() {
            return this.contentType;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Number getLatestVersionNumber() {
            return this.latestVersionNumber;
        }

        @Override
        public final java.lang.String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationId", om.valueToTree(this.getApplicationId()));
            data.set("configurationProfileId", om.valueToTree(this.getConfigurationProfileId()));
            data.set("content", om.valueToTree(this.getContent()));
            data.set("contentType", om.valueToTree(this.getContentType()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getLatestVersionNumber() != null) {
                data.set("latestVersionNumber", om.valueToTree(this.getLatestVersionNumber()));
            }
            if (this.getVersionLabel() != null) {
                data.set("versionLabel", om.valueToTree(this.getVersionLabel()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appconfig.CfnHostedConfigurationVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnHostedConfigurationVersionProps.Jsii$Proxy that = (CfnHostedConfigurationVersionProps.Jsii$Proxy) o;

            if (!applicationId.equals(that.applicationId)) return false;
            if (!configurationProfileId.equals(that.configurationProfileId)) return false;
            if (!content.equals(that.content)) return false;
            if (!contentType.equals(that.contentType)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.latestVersionNumber != null ? !this.latestVersionNumber.equals(that.latestVersionNumber) : that.latestVersionNumber != null) return false;
            return this.versionLabel != null ? this.versionLabel.equals(that.versionLabel) : that.versionLabel == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applicationId.hashCode();
            result = 31 * result + (this.configurationProfileId.hashCode());
            result = 31 * result + (this.content.hashCode());
            result = 31 * result + (this.contentType.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.latestVersionNumber != null ? this.latestVersionNumber.hashCode() : 0);
            result = 31 * result + (this.versionLabel != null ? this.versionLabel.hashCode() : 0);
            return result;
        }
    }
}
