package software.amazon.awscdk.services.appconfig;

/**
 * Options for the Extension construct.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appconfig.*;
 * Parameter parameter;
 * ExtensionOptions extensionOptions = ExtensionOptions.builder()
 *         .description("description")
 *         .extensionName("extensionName")
 *         .latestVersionNumber(123)
 *         .parameters(List.of(parameter))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:26.877Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.ExtensionOptions")
@software.amazon.jsii.Jsii.Proxy(ExtensionOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ExtensionOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * A description of the extension.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The name of the extension.
     * <p>
     * Default: - A name is generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExtensionName() {
        return null;
    }

    /**
     * The latest version number of the extension.
     * <p>
     * When you create a new version,
     * specify the most recent current version number. For example, you create version 3,
     * enter 2 for this field.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getLatestVersionNumber() {
        return null;
    }

    /**
     * The parameters accepted for the extension.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appconfig.Parameter> getParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ExtensionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ExtensionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ExtensionOptions> {
        java.lang.String description;
        java.lang.String extensionName;
        java.lang.Number latestVersionNumber;
        java.util.List<software.amazon.awscdk.services.appconfig.Parameter> parameters;

        /**
         * Sets the value of {@link ExtensionOptions#getDescription}
         * @param description A description of the extension.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ExtensionOptions#getExtensionName}
         * @param extensionName The name of the extension.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extensionName(java.lang.String extensionName) {
            this.extensionName = extensionName;
            return this;
        }

        /**
         * Sets the value of {@link ExtensionOptions#getLatestVersionNumber}
         * @param latestVersionNumber The latest version number of the extension.
         *                            When you create a new version,
         *                            specify the most recent current version number. For example, you create version 3,
         *                            enter 2 for this field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder latestVersionNumber(java.lang.Number latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
            return this;
        }

        /**
         * Sets the value of {@link ExtensionOptions#getParameters}
         * @param parameters The parameters accepted for the extension.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder parameters(java.util.List<? extends software.amazon.awscdk.services.appconfig.Parameter> parameters) {
            this.parameters = (java.util.List<software.amazon.awscdk.services.appconfig.Parameter>)parameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ExtensionOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ExtensionOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ExtensionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExtensionOptions {
        private final java.lang.String description;
        private final java.lang.String extensionName;
        private final java.lang.Number latestVersionNumber;
        private final java.util.List<software.amazon.awscdk.services.appconfig.Parameter> parameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.extensionName = software.amazon.jsii.Kernel.get(this, "extensionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.latestVersionNumber = software.amazon.jsii.Kernel.get(this, "latestVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.Parameter.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = builder.description;
            this.extensionName = builder.extensionName;
            this.latestVersionNumber = builder.latestVersionNumber;
            this.parameters = (java.util.List<software.amazon.awscdk.services.appconfig.Parameter>)builder.parameters;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getExtensionName() {
            return this.extensionName;
        }

        @Override
        public final java.lang.Number getLatestVersionNumber() {
            return this.latestVersionNumber;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appconfig.Parameter> getParameters() {
            return this.parameters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getExtensionName() != null) {
                data.set("extensionName", om.valueToTree(this.getExtensionName()));
            }
            if (this.getLatestVersionNumber() != null) {
                data.set("latestVersionNumber", om.valueToTree(this.getLatestVersionNumber()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appconfig.ExtensionOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ExtensionOptions.Jsii$Proxy that = (ExtensionOptions.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.extensionName != null ? !this.extensionName.equals(that.extensionName) : that.extensionName != null) return false;
            if (this.latestVersionNumber != null ? !this.latestVersionNumber.equals(that.latestVersionNumber) : that.latestVersionNumber != null) return false;
            return this.parameters != null ? this.parameters.equals(that.parameters) : that.parameters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.extensionName != null ? this.extensionName.hashCode() : 0);
            result = 31 * result + (this.latestVersionNumber != null ? this.latestVersionNumber.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            return result;
        }
    }
}
