package software.amazon.awscdk.services.appconfig;

/**
 * Defines monitors that will be associated with an AWS AppConfig environment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Application application;
 * Alarm alarm;
 * CompositeAlarm compositeAlarm;
 * Environment.Builder.create(this, "MyEnvironment")
 *         .application(application)
 *         .monitors(List.of(Monitor.fromCloudWatchAlarm(alarm), Monitor.fromCloudWatchAlarm(compositeAlarm)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:26.892Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.Monitor")
public abstract class Monitor extends software.amazon.jsii.JsiiObject {

    protected Monitor(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Monitor(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Monitor() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Creates a Monitor from a CfnEnvironment.MonitorsProperty construct.
     * <p>
     * @param monitorsProperty The monitors property. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.Monitor fromCfnMonitorsProperty(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.CfnEnvironment.MonitorsProperty monitorsProperty) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.Monitor.class, "fromCfnMonitorsProperty", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.Monitor.class), new Object[] { java.util.Objects.requireNonNull(monitorsProperty, "monitorsProperty is required") });
    }

    /**
     * Creates a Monitor from a CloudWatch alarm.
     * <p>
     * If the alarm role is not specified, a role will
     * be generated.
     * <p>
     * @param alarm The Amazon CloudWatch alarm. This parameter is required.
     * @param alarmRole The IAM role for AWS AppConfig to view the alarm state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.Monitor fromCloudWatchAlarm(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IAlarm alarm, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole alarmRole) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.Monitor.class, "fromCloudWatchAlarm", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.Monitor.class), new Object[] { java.util.Objects.requireNonNull(alarm, "alarm is required"), alarmRole });
    }

    /**
     * Creates a Monitor from a CloudWatch alarm.
     * <p>
     * If the alarm role is not specified, a role will
     * be generated.
     * <p>
     * @param alarm The Amazon CloudWatch alarm. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.Monitor fromCloudWatchAlarm(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IAlarm alarm) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.Monitor.class, "fromCloudWatchAlarm", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.Monitor.class), new Object[] { java.util.Objects.requireNonNull(alarm, "alarm is required") });
    }

    /**
     * The alarm ARN for AWS AppConfig to monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getAlarmArn();

    /**
     * The type of monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.MonitorType getMonitorType();

    /**
     * The IAM role ARN for AWS AppConfig to view the alarm state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable java.lang.String getAlarmRoleArn();

    /**
     * Indicates whether a CloudWatch alarm is a composite alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable java.lang.Boolean getIsCompositeAlarm();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appconfig.Monitor {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The alarm ARN for AWS AppConfig to monitor.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getAlarmArn() {
            return software.amazon.jsii.Kernel.get(this, "alarmArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The type of monitor.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.MonitorType getMonitorType() {
            return software.amazon.jsii.Kernel.get(this, "monitorType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.MonitorType.class));
        }

        /**
         * The IAM role ARN for AWS AppConfig to view the alarm state.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.String getAlarmRoleArn() {
            return software.amazon.jsii.Kernel.get(this, "alarmRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Indicates whether a CloudWatch alarm is a composite alarm.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Boolean getIsCompositeAlarm() {
            return software.amazon.jsii.Kernel.get(this, "isCompositeAlarm", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }
    }
}
