package software.amazon.awscdk.services.appflow;

/**
 * Properties for defining a <code>CfnConnector</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appflow.*;
 * CfnConnectorProps cfnConnectorProps = CfnConnectorProps.builder()
 *         .connectorProvisioningConfig(ConnectorProvisioningConfigProperty.builder()
 *                 .lambda(LambdaConnectorProvisioningConfigProperty.builder()
 *                         .lambdaArn("lambdaArn")
 *                         .build())
 *                 .build())
 *         .connectorProvisioningType("connectorProvisioningType")
 *         // the properties below are optional
 *         .connectorLabel("connectorLabel")
 *         .description("description")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connector.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:26.953Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProps")
@software.amazon.jsii.Jsii.Proxy(CfnConnectorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConnectorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The configuration required for registering the connector.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connector.html#cfn-appflow-connector-connectorprovisioningconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connector.html#cfn-appflow-connector-connectorprovisioningconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConnectorProvisioningConfig();

    /**
     * The provisioning type used to register the connector.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connector.html#cfn-appflow-connector-connectorprovisioningtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connector.html#cfn-appflow-connector-connectorprovisioningtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectorProvisioningType();

    /**
     * The label used for registering the connector.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connector.html#cfn-appflow-connector-connectorlabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connector.html#cfn-appflow-connector-connectorlabel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectorLabel() {
        return null;
    }

    /**
     * A description about the connector runtime setting.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connector.html#cfn-appflow-connector-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-connector.html#cfn-appflow-connector-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConnectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConnectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConnectorProps> {
        java.lang.Object connectorProvisioningConfig;
        java.lang.String connectorProvisioningType;
        java.lang.String connectorLabel;
        java.lang.String description;

        /**
         * Sets the value of {@link CfnConnectorProps#getConnectorProvisioningConfig}
         * @param connectorProvisioningConfig The configuration required for registering the connector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorProvisioningConfig(software.amazon.awscdk.IResolvable connectorProvisioningConfig) {
            this.connectorProvisioningConfig = connectorProvisioningConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getConnectorProvisioningConfig}
         * @param connectorProvisioningConfig The configuration required for registering the connector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorProvisioningConfig(software.amazon.awscdk.services.appflow.CfnConnector.ConnectorProvisioningConfigProperty connectorProvisioningConfig) {
            this.connectorProvisioningConfig = connectorProvisioningConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getConnectorProvisioningType}
         * @param connectorProvisioningType The provisioning type used to register the connector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorProvisioningType(java.lang.String connectorProvisioningType) {
            this.connectorProvisioningType = connectorProvisioningType;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getConnectorLabel}
         * @param connectorLabel The label used for registering the connector.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorLabel(java.lang.String connectorLabel) {
            this.connectorLabel = connectorLabel;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getDescription}
         * @param description A description about the connector runtime setting.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConnectorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConnectorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConnectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConnectorProps {
        private final java.lang.Object connectorProvisioningConfig;
        private final java.lang.String connectorProvisioningType;
        private final java.lang.String connectorLabel;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectorProvisioningConfig = software.amazon.jsii.Kernel.get(this, "connectorProvisioningConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.connectorProvisioningType = software.amazon.jsii.Kernel.get(this, "connectorProvisioningType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectorLabel = software.amazon.jsii.Kernel.get(this, "connectorLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectorProvisioningConfig = java.util.Objects.requireNonNull(builder.connectorProvisioningConfig, "connectorProvisioningConfig is required");
            this.connectorProvisioningType = java.util.Objects.requireNonNull(builder.connectorProvisioningType, "connectorProvisioningType is required");
            this.connectorLabel = builder.connectorLabel;
            this.description = builder.description;
        }

        @Override
        public final java.lang.Object getConnectorProvisioningConfig() {
            return this.connectorProvisioningConfig;
        }

        @Override
        public final java.lang.String getConnectorProvisioningType() {
            return this.connectorProvisioningType;
        }

        @Override
        public final java.lang.String getConnectorLabel() {
            return this.connectorLabel;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("connectorProvisioningConfig", om.valueToTree(this.getConnectorProvisioningConfig()));
            data.set("connectorProvisioningType", om.valueToTree(this.getConnectorProvisioningType()));
            if (this.getConnectorLabel() != null) {
                data.set("connectorLabel", om.valueToTree(this.getConnectorLabel()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConnectorProps.Jsii$Proxy that = (CfnConnectorProps.Jsii$Proxy) o;

            if (!connectorProvisioningConfig.equals(that.connectorProvisioningConfig)) return false;
            if (!connectorProvisioningType.equals(that.connectorProvisioningType)) return false;
            if (this.connectorLabel != null ? !this.connectorLabel.equals(that.connectorLabel) : that.connectorLabel != null) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public final int hashCode() {
            int result = this.connectorProvisioningConfig.hashCode();
            result = 31 * result + (this.connectorProvisioningType.hashCode());
            result = 31 * result + (this.connectorLabel != null ? this.connectorLabel.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
