package software.amazon.awscdk.services.appsync;

/**
 * AppSync definition.
 * <p>
 * Specify how you want to define your AppSync API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi sourceApi = GraphqlApi.Builder.create(this, "FirstSourceAPI")
 *         .name("FirstSourceAPI")
 *         .definition(Definition.fromFile(join(__dirname, "appsync.merged-api-1.graphql")))
 *         .build();
 * IGraphqlApi importedMergedApi = GraphqlApi.fromGraphqlApiAttributes(this, "ImportedMergedApi", GraphqlApiAttributes.builder()
 *         .graphqlApiId("MyApiId")
 *         .graphqlApiArn("MyApiArn")
 *         .build());
 * IRole importedExecutionRole = Role.fromRoleArn(this, "ExecutionRole", "arn:aws:iam::ACCOUNT:role/MyExistingRole");
 * SourceApiAssociation.Builder.create(this, "SourceApiAssociation2")
 *         .sourceApi(sourceApi)
 *         .mergedApi(importedMergedApi)
 *         .mergeType(MergeType.MANUAL_MERGE)
 *         .mergedApiExecutionRole(importedExecutionRole)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:27.514Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.Definition")
public abstract class Definition extends software.amazon.jsii.JsiiObject {

    protected Definition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Definition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Definition() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Schema from file, allows schema definition through schema.graphql file.
     * <p>
     * @return Definition with schema from file
     * @param filePath the file path of the schema file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Definition fromFile(final @org.jetbrains.annotations.NotNull java.lang.String filePath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.Definition.class, "fromFile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Definition.class), new Object[] { java.util.Objects.requireNonNull(filePath, "filePath is required") });
    }

    /**
     * Schema from schema object.
     * <p>
     * @return Definition with schema from file
     * @param schema SchemaFile.fromAsset(filePath: string) allows schema definition through schema.graphql file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Definition fromSchema(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ISchema schema) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.Definition.class, "fromSchema", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Definition.class), new Object[] { java.util.Objects.requireNonNull(schema, "schema is required") });
    }

    /**
     * Schema from existing AppSync APIs - used for creating a AppSync Merged API.
     * <p>
     * @return Definition with for AppSync Merged API
     * @param sourceApiOptions Configuration for AppSync Merged API. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Definition fromSourceApis(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.SourceApiOptions sourceApiOptions) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.Definition.class, "fromSourceApis", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Definition.class), new Object[] { java.util.Objects.requireNonNull(sourceApiOptions, "sourceApiOptions is required") });
    }

    /**
     * Schema, when AppSync API is created from schema file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.ISchema getSchema() {
        return software.amazon.jsii.Kernel.get(this, "schema", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.ISchema.class));
    }

    /**
     * Source APIs for Merged API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.SourceApiOptions getSourceApiOptions() {
        return software.amazon.jsii.Kernel.get(this, "sourceApiOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.SourceApiOptions.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appsync.Definition {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
