package software.amazon.awscdk.services.appsync;

/**
 * Merge type used to associate the source API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * // first source API
 * GraphqlApi firstApi = GraphqlApi.Builder.create(this, "FirstSourceAPI")
 *         .name("FirstSourceAPI")
 *         .definition(Definition.fromFile(join(__dirname, "appsync.merged-api-1.graphql")))
 *         .build();
 * // second source API
 * GraphqlApi secondApi = GraphqlApi.Builder.create(this, "SecondSourceAPI")
 *         .name("SecondSourceAPI")
 *         .definition(Definition.fromFile(join(__dirname, "appsync.merged-api-2.graphql")))
 *         .build();
 * // Merged API
 * GraphqlApi mergedApi = GraphqlApi.Builder.create(this, "MergedAPI")
 *         .name("MergedAPI")
 *         .definition(Definition.fromSourceApis(SourceApiOptions.builder()
 *                 .sourceApis(List.of(SourceApi.builder()
 *                         .sourceApi(firstApi)
 *                         .mergeType(MergeType.MANUAL_MERGE)
 *                         .build(), SourceApi.builder()
 *                         .sourceApi(secondApi)
 *                         .mergeType(MergeType.AUTO_MERGE)
 *                         .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:27.548Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.MergeType")
public enum MergeType {
    /**
     * Manual merge.
     * <p>
     * The merge must be triggered manually when the source API has changed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MANUAL_MERGE,
    /**
     * Auto merge.
     * <p>
     * The merge is triggered automatically when the source API has changed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AUTO_MERGE,
}
