package software.amazon.awscdk.services.appsync;

/**
 * AppSync SourceApiAssociation which associates an AppSync source API to an AppSync Merged API.
 * <p>
 * The initial creation of the SourceApiAssociation merges the source API into the Merged API schema.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi sourceApi = GraphqlApi.Builder.create(this, "FirstSourceAPI")
 *         .name("FirstSourceAPI")
 *         .definition(Definition.fromFile(join(__dirname, "appsync.merged-api-1.graphql")))
 *         .build();
 * IGraphqlApi importedMergedApi = GraphqlApi.fromGraphqlApiAttributes(this, "ImportedMergedApi", GraphqlApiAttributes.builder()
 *         .graphqlApiId("MyApiId")
 *         .graphqlApiArn("MyApiArn")
 *         .build());
 * IRole importedExecutionRole = Role.fromRoleArn(this, "ExecutionRole", "arn:aws:iam::ACCOUNT:role/MyExistingRole");
 * SourceApiAssociation.Builder.create(this, "SourceApiAssociation2")
 *         .sourceApi(sourceApi)
 *         .mergedApi(importedMergedApi)
 *         .mergeType(MergeType.MANUAL_MERGE)
 *         .mergedApiExecutionRole(importedExecutionRole)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:27.558Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.SourceApiAssociation")
public class SourceApiAssociation extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.appsync.ISourceApiAssociation {

    protected SourceApiAssociation(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SourceApiAssociation(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SourceApiAssociation(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.SourceApiAssociationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import Appsync Source Api Association from source API, merged api, and merge type.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ISourceApiAssociation fromSourceApiAssociationAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.SourceApiAssociationAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.SourceApiAssociation.class, "fromSourceApiAssociationAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.ISourceApiAssociation.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * The underlying CFN source api association resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.CfnSourceApiAssociation getAssociation() {
        return software.amazon.jsii.Kernel.get(this, "association", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.CfnSourceApiAssociation.class));
    }

    /**
     * The association arn.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssociationArn() {
        return software.amazon.jsii.Kernel.get(this, "associationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The association id.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssociationId() {
        return software.amazon.jsii.Kernel.get(this, "associationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The merged api in the association.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IGraphqlApi getMergedApi() {
        return software.amazon.jsii.Kernel.get(this, "mergedApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IGraphqlApi.class));
    }

    /**
     * The merge type for the source api association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.MergeType getMergeType() {
        return software.amazon.jsii.Kernel.get(this, "mergeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MergeType.class));
    }

    /**
     * The source api in the association.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IGraphqlApi getSourceApi() {
        return software.amazon.jsii.Kernel.get(this, "sourceApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IGraphqlApi.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appsync.SourceApiAssociation}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.SourceApiAssociation> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.SourceApiAssociationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.SourceApiAssociationProps.Builder();
        }

        /**
         * The merged api to associate.
         * <p>
         * @return {@code this}
         * @param mergedApi The merged api to associate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mergedApi(final software.amazon.awscdk.services.appsync.IGraphqlApi mergedApi) {
            this.props.mergedApi(mergedApi);
            return this;
        }

        /**
         * The merged api execution role for adding the access policy for the source api.
         * <p>
         * @return {@code this}
         * @param mergedApiExecutionRole The merged api execution role for adding the access policy for the source api. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mergedApiExecutionRole(final software.amazon.awscdk.services.iam.IRole mergedApiExecutionRole) {
            this.props.mergedApiExecutionRole(mergedApiExecutionRole);
            return this;
        }

        /**
         * The source api to associate.
         * <p>
         * @return {@code this}
         * @param sourceApi The source api to associate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceApi(final software.amazon.awscdk.services.appsync.IGraphqlApi sourceApi) {
            this.props.sourceApi(sourceApi);
            return this;
        }

        /**
         * The description of the source api association.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param description The description of the source api association. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The merge type for the source.
         * <p>
         * Default: - AUTO_MERGE
         * <p>
         * @return {@code this}
         * @param mergeType The merge type for the source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mergeType(final software.amazon.awscdk.services.appsync.MergeType mergeType) {
            this.props.mergeType(mergeType);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appsync.SourceApiAssociation}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appsync.SourceApiAssociation build() {
            return new software.amazon.awscdk.services.appsync.SourceApiAssociation(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
