package software.amazon.awscdk.services.appsync;

/**
 * Additional API configuration for creating a AppSync Merged API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * // first source API
 * GraphqlApi firstApi = GraphqlApi.Builder.create(this, "FirstSourceAPI")
 *         .name("FirstSourceAPI")
 *         .definition(Definition.fromFile(join(__dirname, "appsync.merged-api-1.graphql")))
 *         .build();
 * // second source API
 * GraphqlApi secondApi = GraphqlApi.Builder.create(this, "SecondSourceAPI")
 *         .name("SecondSourceAPI")
 *         .definition(Definition.fromFile(join(__dirname, "appsync.merged-api-2.graphql")))
 *         .build();
 * // Merged API
 * GraphqlApi mergedApi = GraphqlApi.Builder.create(this, "MergedAPI")
 *         .name("MergedAPI")
 *         .definition(Definition.fromSourceApis(SourceApiOptions.builder()
 *                 .sourceApis(List.of(SourceApi.builder()
 *                         .sourceApi(firstApi)
 *                         .mergeType(MergeType.MANUAL_MERGE)
 *                         .build(), SourceApi.builder()
 *                         .sourceApi(secondApi)
 *                         .mergeType(MergeType.AUTO_MERGE)
 *                         .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:27.559Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.SourceApiOptions")
@software.amazon.jsii.Jsii.Proxy(SourceApiOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SourceApiOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Definition of source APIs associated with this Merged API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appsync.SourceApi> getSourceApis();

    /**
     * IAM Role used to validate access to source APIs at runtime and to update the merged API endpoint with the source API changes.
     * <p>
     * Default: - An IAM Role with acccess to source schemas will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.Role getMergedApiExecutionRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SourceApiOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SourceApiOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SourceApiOptions> {
        java.util.List<software.amazon.awscdk.services.appsync.SourceApi> sourceApis;
        software.amazon.awscdk.services.iam.Role mergedApiExecutionRole;

        /**
         * Sets the value of {@link SourceApiOptions#getSourceApis}
         * @param sourceApis Definition of source APIs associated with this Merged API. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder sourceApis(java.util.List<? extends software.amazon.awscdk.services.appsync.SourceApi> sourceApis) {
            this.sourceApis = (java.util.List<software.amazon.awscdk.services.appsync.SourceApi>)sourceApis;
            return this;
        }

        /**
         * Sets the value of {@link SourceApiOptions#getMergedApiExecutionRole}
         * @param mergedApiExecutionRole IAM Role used to validate access to source APIs at runtime and to update the merged API endpoint with the source API changes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mergedApiExecutionRole(software.amazon.awscdk.services.iam.Role mergedApiExecutionRole) {
            this.mergedApiExecutionRole = mergedApiExecutionRole;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SourceApiOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SourceApiOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SourceApiOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceApiOptions {
        private final java.util.List<software.amazon.awscdk.services.appsync.SourceApi> sourceApis;
        private final software.amazon.awscdk.services.iam.Role mergedApiExecutionRole;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sourceApis = software.amazon.jsii.Kernel.get(this, "sourceApis", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.SourceApi.class)));
            this.mergedApiExecutionRole = software.amazon.jsii.Kernel.get(this, "mergedApiExecutionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Role.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sourceApis = (java.util.List<software.amazon.awscdk.services.appsync.SourceApi>)java.util.Objects.requireNonNull(builder.sourceApis, "sourceApis is required");
            this.mergedApiExecutionRole = builder.mergedApiExecutionRole;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appsync.SourceApi> getSourceApis() {
            return this.sourceApis;
        }

        @Override
        public final software.amazon.awscdk.services.iam.Role getMergedApiExecutionRole() {
            return this.mergedApiExecutionRole;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sourceApis", om.valueToTree(this.getSourceApis()));
            if (this.getMergedApiExecutionRole() != null) {
                data.set("mergedApiExecutionRole", om.valueToTree(this.getMergedApiExecutionRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.SourceApiOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SourceApiOptions.Jsii$Proxy that = (SourceApiOptions.Jsii$Proxy) o;

            if (!sourceApis.equals(that.sourceApis)) return false;
            return this.mergedApiExecutionRole != null ? this.mergedApiExecutionRole.equals(that.mergedApiExecutionRole) : that.mergedApiExecutionRole == null;
        }

        @Override
        public final int hashCode() {
            int result = this.sourceApis.hashCode();
            result = 31 * result + (this.mergedApiExecutionRole != null ? this.mergedApiExecutionRole.hashCode() : 0);
            return result;
        }
    }
}
