package software.amazon.awscdk.services.autoscaling;

/**
 * Customization options for Signal handling.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * IMachineImage machineImage;
 * AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(machineImage)
 *         // ...
 *         .init(CloudFormationInit.fromElements(InitFile.fromString("/etc/my_instance", "This got written during instance startup")))
 *         .signals(Signals.waitForAll(SignalsOptions.builder()
 *                 .timeout(Duration.minutes(10))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:27.786Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.SignalsOptions")
@software.amazon.jsii.Jsii.Proxy(SignalsOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SignalsOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The percentage of signals that need to be successful.
     * <p>
     * If this number is less than 100, a percentage of signals may be failure
     * signals while still succeeding the creation or update in CloudFormation.
     * <p>
     * Default: 100
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinSuccessPercentage() {
        return null;
    }

    /**
     * How long to wait for the signals to be sent.
     * <p>
     * This should reflect how long it takes your instances to start up
     * (including instance start time and instance initialization time).
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SignalsOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SignalsOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SignalsOptions> {
        java.lang.Number minSuccessPercentage;
        software.amazon.awscdk.Duration timeout;

        /**
         * Sets the value of {@link SignalsOptions#getMinSuccessPercentage}
         * @param minSuccessPercentage The percentage of signals that need to be successful.
         *                             If this number is less than 100, a percentage of signals may be failure
         *                             signals while still succeeding the creation or update in CloudFormation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minSuccessPercentage(java.lang.Number minSuccessPercentage) {
            this.minSuccessPercentage = minSuccessPercentage;
            return this;
        }

        /**
         * Sets the value of {@link SignalsOptions#getTimeout}
         * @param timeout How long to wait for the signals to be sent.
         *                This should reflect how long it takes your instances to start up
         *                (including instance start time and instance initialization time).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SignalsOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SignalsOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SignalsOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SignalsOptions {
        private final java.lang.Number minSuccessPercentage;
        private final software.amazon.awscdk.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.minSuccessPercentage = software.amazon.jsii.Kernel.get(this, "minSuccessPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.minSuccessPercentage = builder.minSuccessPercentage;
            this.timeout = builder.timeout;
        }

        @Override
        public final java.lang.Number getMinSuccessPercentage() {
            return this.minSuccessPercentage;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMinSuccessPercentage() != null) {
                data.set("minSuccessPercentage", om.valueToTree(this.getMinSuccessPercentage()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.SignalsOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SignalsOptions.Jsii$Proxy that = (SignalsOptions.Jsii$Proxy) o;

            if (this.minSuccessPercentage != null ? !this.minSuccessPercentage.equals(that.minSuccessPercentage) : that.minSuccessPercentage != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.minSuccessPercentage != null ? this.minSuccessPercentage.hashCode() : 0;
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
