package software.amazon.awscdk.services.batch;

/**
 * The action to take when a job is at the head of the job queue in the specified state for the specified period of time.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * JobQueue.Builder.create(this, "JobQueue")
 *         .jobStateTimeLimitActions(List.of(JobStateTimeLimitAction.builder()
 *                 .action(JobStateTimeLimitActionsAction.CANCEL)
 *                 .maxTime(Duration.minutes(10))
 *                 .reason(JobStateTimeLimitActionsReason.INSUFFICIENT_INSTANCE_CAPACITY)
 *                 .state(JobStateTimeLimitActionsState.RUNNABLE)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:28.073Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.JobStateTimeLimitActionsAction")
public enum JobStateTimeLimitActionsAction {
    /**
     * Cancel the job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CANCEL,
}
