package software.amazon.awscdk.services.bedrock;

/**
 * A Bedrock provisioned model.
 * <p>
 * Note: CloudFormation does not currently support creating Bedrock Provisioned Throughput
 * resources outside of a custom resource. You can import provisioned models created by
 * provisioning throughput in Bedrock outside the CDK or via a custom resource with
 * {@link ProvisionedModel#fromProvisionedModelArn }.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.bedrock.*;
 * ProvisionedModel.fromProvisionedModelArn(this, "Model", "arn:aws:bedrock:us-east-2:123456789012:provisioned-model/abc-123");
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html">https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:28.265Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.ProvisionedModel")
public class ProvisionedModel extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.bedrock.IModel {

    protected ProvisionedModel(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ProvisionedModel(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Import an provisioned model given an ARN.
     * <p>
     * @param _scope This parameter is required.
     * @param _id This parameter is required.
     * @param provisionedModelArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.IModel fromProvisionedModelArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull java.lang.String _id, final @org.jetbrains.annotations.NotNull java.lang.String provisionedModelArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.bedrock.ProvisionedModel.class, "fromProvisionedModelArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.IModel.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_id, "_id is required"), java.util.Objects.requireNonNull(provisionedModelArn, "provisionedModelArn is required") });
    }

    /**
     * The ARN of the provisioned model.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getModelArn() {
        return software.amazon.jsii.Kernel.get(this, "modelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
