package software.amazon.awscdk.services.budgets;

/**
 * Properties for defining a <code>CfnBudget</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.budgets.*;
 * Object costFilters;
 * Object plannedBudgetLimits;
 * CfnBudgetProps cfnBudgetProps = CfnBudgetProps.builder()
 *         .budget(BudgetDataProperty.builder()
 *                 .budgetType("budgetType")
 *                 .timeUnit("timeUnit")
 *                 // the properties below are optional
 *                 .autoAdjustData(AutoAdjustDataProperty.builder()
 *                         .autoAdjustType("autoAdjustType")
 *                         // the properties below are optional
 *                         .historicalOptions(HistoricalOptionsProperty.builder()
 *                                 .budgetAdjustmentPeriod(123)
 *                                 .build())
 *                         .build())
 *                 .budgetLimit(SpendProperty.builder()
 *                         .amount(123)
 *                         .unit("unit")
 *                         .build())
 *                 .budgetName("budgetName")
 *                 .costFilters(costFilters)
 *                 .costTypes(CostTypesProperty.builder()
 *                         .includeCredit(false)
 *                         .includeDiscount(false)
 *                         .includeOtherSubscription(false)
 *                         .includeRecurring(false)
 *                         .includeRefund(false)
 *                         .includeSubscription(false)
 *                         .includeSupport(false)
 *                         .includeTax(false)
 *                         .includeUpfront(false)
 *                         .useAmortized(false)
 *                         .useBlended(false)
 *                         .build())
 *                 .plannedBudgetLimits(plannedBudgetLimits)
 *                 .timePeriod(TimePeriodProperty.builder()
 *                         .end("end")
 *                         .start("start")
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .notificationsWithSubscribers(List.of(NotificationWithSubscribersProperty.builder()
 *                 .notification(NotificationProperty.builder()
 *                         .comparisonOperator("comparisonOperator")
 *                         .notificationType("notificationType")
 *                         .threshold(123)
 *                         // the properties below are optional
 *                         .thresholdType("thresholdType")
 *                         .build())
 *                 .subscribers(List.of(SubscriberProperty.builder()
 *                         .address("address")
 *                         .subscriptionType("subscriptionType")
 *                         .build()))
 *                 .build()))
 *         .resourceTags(List.of(ResourceTagProperty.builder()
 *                 .key("key")
 *                 // the properties below are optional
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:28.298Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_budgets.CfnBudgetProps")
@software.amazon.jsii.Jsii.Proxy(CfnBudgetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnBudgetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The budget object that you want to create.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-budget">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-budget</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getBudget();

    /**
     * A notification that you want to associate with a budget.
     * <p>
     * A budget can have up to five notifications, and each notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and subscribers in your <code>CreateBudget</code> call, AWS creates the notifications and subscribers for you.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-notificationswithsubscribers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-notificationswithsubscribers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNotificationsWithSubscribers() {
        return null;
    }

    /**
     * An optional list of tags to associate with the specified budget.
     * <p>
     * Each tag consists of a key and a value, and each key must be unique for the resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-resourcetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-resourcetags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getResourceTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnBudgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnBudgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnBudgetProps> {
        java.lang.Object budget;
        java.lang.Object notificationsWithSubscribers;
        java.lang.Object resourceTags;

        /**
         * Sets the value of {@link CfnBudgetProps#getBudget}
         * @param budget The budget object that you want to create. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder budget(software.amazon.awscdk.IResolvable budget) {
            this.budget = budget;
            return this;
        }

        /**
         * Sets the value of {@link CfnBudgetProps#getBudget}
         * @param budget The budget object that you want to create. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder budget(software.amazon.awscdk.services.budgets.CfnBudget.BudgetDataProperty budget) {
            this.budget = budget;
            return this;
        }

        /**
         * Sets the value of {@link CfnBudgetProps#getNotificationsWithSubscribers}
         * @param notificationsWithSubscribers A notification that you want to associate with a budget.
         *                                     A budget can have up to five notifications, and each notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and subscribers in your <code>CreateBudget</code> call, AWS creates the notifications and subscribers for you.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationsWithSubscribers(software.amazon.awscdk.IResolvable notificationsWithSubscribers) {
            this.notificationsWithSubscribers = notificationsWithSubscribers;
            return this;
        }

        /**
         * Sets the value of {@link CfnBudgetProps#getNotificationsWithSubscribers}
         * @param notificationsWithSubscribers A notification that you want to associate with a budget.
         *                                     A budget can have up to five notifications, and each notification can have one SNS subscriber and up to 10 email subscribers. If you include notifications and subscribers in your <code>CreateBudget</code> call, AWS creates the notifications and subscribers for you.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationsWithSubscribers(java.util.List<? extends java.lang.Object> notificationsWithSubscribers) {
            this.notificationsWithSubscribers = notificationsWithSubscribers;
            return this;
        }

        /**
         * Sets the value of {@link CfnBudgetProps#getResourceTags}
         * @param resourceTags An optional list of tags to associate with the specified budget.
         *                     Each tag consists of a key and a value, and each key must be unique for the resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTags(software.amazon.awscdk.IResolvable resourceTags) {
            this.resourceTags = resourceTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnBudgetProps#getResourceTags}
         * @param resourceTags An optional list of tags to associate with the specified budget.
         *                     Each tag consists of a key and a value, and each key must be unique for the resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTags(java.util.List<? extends java.lang.Object> resourceTags) {
            this.resourceTags = resourceTags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnBudgetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnBudgetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnBudgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnBudgetProps {
        private final java.lang.Object budget;
        private final java.lang.Object notificationsWithSubscribers;
        private final java.lang.Object resourceTags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.budget = software.amazon.jsii.Kernel.get(this, "budget", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.notificationsWithSubscribers = software.amazon.jsii.Kernel.get(this, "notificationsWithSubscribers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resourceTags = software.amazon.jsii.Kernel.get(this, "resourceTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.budget = java.util.Objects.requireNonNull(builder.budget, "budget is required");
            this.notificationsWithSubscribers = builder.notificationsWithSubscribers;
            this.resourceTags = builder.resourceTags;
        }

        @Override
        public final java.lang.Object getBudget() {
            return this.budget;
        }

        @Override
        public final java.lang.Object getNotificationsWithSubscribers() {
            return this.notificationsWithSubscribers;
        }

        @Override
        public final java.lang.Object getResourceTags() {
            return this.resourceTags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("budget", om.valueToTree(this.getBudget()));
            if (this.getNotificationsWithSubscribers() != null) {
                data.set("notificationsWithSubscribers", om.valueToTree(this.getNotificationsWithSubscribers()));
            }
            if (this.getResourceTags() != null) {
                data.set("resourceTags", om.valueToTree(this.getResourceTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_budgets.CfnBudgetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnBudgetProps.Jsii$Proxy that = (CfnBudgetProps.Jsii$Proxy) o;

            if (!budget.equals(that.budget)) return false;
            if (this.notificationsWithSubscribers != null ? !this.notificationsWithSubscribers.equals(that.notificationsWithSubscribers) : that.notificationsWithSubscribers != null) return false;
            return this.resourceTags != null ? this.resourceTags.equals(that.resourceTags) : that.resourceTags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.budget.hashCode();
            result = 31 * result + (this.notificationsWithSubscribers != null ? this.notificationsWithSubscribers.hashCode() : 0);
            result = 31 * result + (this.resourceTags != null ? this.resourceTags.hashCode() : 0);
            return result;
        }
    }
}
