package software.amazon.awscdk.services.cloudwatch;

/**
 * Options shared by most methods accepting metric options.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.cloudwatch.*;
 * CommonMetricOptions commonMetricOptions = CommonMetricOptions.builder()
 *         .account("account")
 *         .color("color")
 *         .dimensionsMap(Map.of(
 *                 "dimensionsMapKey", "dimensionsMap"))
 *         .label("label")
 *         .period(Duration.minutes(30))
 *         .region("region")
 *         .statistic("statistic")
 *         .unit(Unit.SECONDS)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:28.832Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CommonMetricOptions")
@software.amazon.jsii.Jsii.Proxy(CommonMetricOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CommonMetricOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Account which this metric comes from.
     * <p>
     * Default: - Deployment account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccount() {
        return null;
    }

    /**
     * The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The <code>Color</code> class has a set of standard colors that can be used here.
     * <p>
     * Default: - Automatic color
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getColor() {
        return null;
    }

    /**
     * Dimensions of the metric.
     * <p>
     * Default: - No dimensions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getDimensionsMap() {
        return null;
    }

    /**
     * Label for this metric when added to a Graph in a Dashboard.
     * <p>
     * You can use <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">dynamic labels</a>
     * to show summary information about the entire displayed time series
     * in the legend. For example, if you use:
     * <p>
     * <blockquote><pre>
     * [max: ${MAX}] MyMetric
     * </pre></blockquote>
     * <p>
     * As the metric label, the maximum value in the visible range will
     * be shown next to the time series name in the graph's legend.
     * <p>
     * Default: - No label
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLabel() {
        return null;
    }

    /**
     * The period over which the specified statistic is applied.
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getPeriod() {
        return null;
    }

    /**
     * Region which this metric comes from.
     * <p>
     * Default: - Deployment region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * What function to use for aggregating.
     * <p>
     * Use the <code>aws_cloudwatch.Stats</code> helper class to construct valid input strings.
     * <p>
     * Can be one of the following:
     * <p>
     * <ul>
     * <li>"Minimum" | "min"</li>
     * <li>"Maximum" | "max"</li>
     * <li>"Average" | "avg"</li>
     * <li>"Sum" | "sum"</li>
     * <li>"SampleCount | "n"</li>
     * <li>"pNN.NN"</li>
     * <li>"tmNN.NN" | "tm(NN.NN%:NN.NN%)"</li>
     * <li>"iqm"</li>
     * <li>"wmNN.NN" | "wm(NN.NN%:NN.NN%)"</li>
     * <li>"tcNN.NN" | "tc(NN.NN%:NN.NN%)"</li>
     * <li>"tsNN.NN" | "ts(NN.NN%:NN.NN%)"</li>
     * </ul>
     * <p>
     * Default: Average
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatistic() {
        return null;
    }

    /**
     * Unit used to filter the metric stream.
     * <p>
     * Only refer to datums emitted to the metric stream with the given unit and
     * ignore all others. Only useful when datums are being emitted to the same
     * metric stream under different units.
     * <p>
     * The default is to use all matric datums in the stream, regardless of unit,
     * which is recommended in nearly all cases.
     * <p>
     * CloudWatch does not honor this property for graphs.
     * <p>
     * Default: - All metric datums in the given metric stream
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.Unit getUnit() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CommonMetricOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CommonMetricOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CommonMetricOptions> {
        java.lang.String account;
        java.lang.String color;
        java.util.Map<java.lang.String, java.lang.String> dimensionsMap;
        java.lang.String label;
        software.amazon.awscdk.Duration period;
        java.lang.String region;
        java.lang.String statistic;
        software.amazon.awscdk.services.cloudwatch.Unit unit;

        /**
         * Sets the value of {@link CommonMetricOptions#getAccount}
         * @param account Account which this metric comes from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link CommonMetricOptions#getColor}
         * @param color The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The <code>Color</code> class has a set of standard colors that can be used here.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder color(java.lang.String color) {
            this.color = color;
            return this;
        }

        /**
         * Sets the value of {@link CommonMetricOptions#getDimensionsMap}
         * @param dimensionsMap Dimensions of the metric.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimensionsMap(java.util.Map<java.lang.String, java.lang.String> dimensionsMap) {
            this.dimensionsMap = dimensionsMap;
            return this;
        }

        /**
         * Sets the value of {@link CommonMetricOptions#getLabel}
         * @param label Label for this metric when added to a Graph in a Dashboard.
         *              You can use <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">dynamic labels</a>
         *              to show summary information about the entire displayed time series
         *              in the legend. For example, if you use:
         *              <p>
         *              <blockquote><pre>
         *              [max: ${MAX}] MyMetric
         *              </pre></blockquote>
         *              <p>
         *              As the metric label, the maximum value in the visible range will
         *              be shown next to the time series name in the graph's legend.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder label(java.lang.String label) {
            this.label = label;
            return this;
        }

        /**
         * Sets the value of {@link CommonMetricOptions#getPeriod}
         * @param period The period over which the specified statistic is applied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(software.amazon.awscdk.Duration period) {
            this.period = period;
            return this;
        }

        /**
         * Sets the value of {@link CommonMetricOptions#getRegion}
         * @param region Region which this metric comes from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link CommonMetricOptions#getStatistic}
         * @param statistic What function to use for aggregating.
         *                  Use the <code>aws_cloudwatch.Stats</code> helper class to construct valid input strings.
         *                  <p>
         *                  Can be one of the following:
         *                  <p>
         *                  <ul>
         *                  <li>"Minimum" | "min"</li>
         *                  <li>"Maximum" | "max"</li>
         *                  <li>"Average" | "avg"</li>
         *                  <li>"Sum" | "sum"</li>
         *                  <li>"SampleCount | "n"</li>
         *                  <li>"pNN.NN"</li>
         *                  <li>"tmNN.NN" | "tm(NN.NN%:NN.NN%)"</li>
         *                  <li>"iqm"</li>
         *                  <li>"wmNN.NN" | "wm(NN.NN%:NN.NN%)"</li>
         *                  <li>"tcNN.NN" | "tc(NN.NN%:NN.NN%)"</li>
         *                  <li>"tsNN.NN" | "ts(NN.NN%:NN.NN%)"</li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statistic(java.lang.String statistic) {
            this.statistic = statistic;
            return this;
        }

        /**
         * Sets the value of {@link CommonMetricOptions#getUnit}
         * @param unit Unit used to filter the metric stream.
         *             Only refer to datums emitted to the metric stream with the given unit and
         *             ignore all others. Only useful when datums are being emitted to the same
         *             metric stream under different units.
         *             <p>
         *             The default is to use all matric datums in the stream, regardless of unit,
         *             which is recommended in nearly all cases.
         *             <p>
         *             CloudWatch does not honor this property for graphs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unit(software.amazon.awscdk.services.cloudwatch.Unit unit) {
            this.unit = unit;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonMetricOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CommonMetricOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CommonMetricOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommonMetricOptions {
        private final java.lang.String account;
        private final java.lang.String color;
        private final java.util.Map<java.lang.String, java.lang.String> dimensionsMap;
        private final java.lang.String label;
        private final software.amazon.awscdk.Duration period;
        private final java.lang.String region;
        private final java.lang.String statistic;
        private final software.amazon.awscdk.services.cloudwatch.Unit unit;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.account = software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.color = software.amazon.jsii.Kernel.get(this, "color", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dimensionsMap = software.amazon.jsii.Kernel.get(this, "dimensionsMap", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.label = software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Unit.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.account = builder.account;
            this.color = builder.color;
            this.dimensionsMap = builder.dimensionsMap;
            this.label = builder.label;
            this.period = builder.period;
            this.region = builder.region;
            this.statistic = builder.statistic;
            this.unit = builder.unit;
        }

        @Override
        public final java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public final java.lang.String getColor() {
            return this.color;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getDimensionsMap() {
            return this.dimensionsMap;
        }

        @Override
        public final java.lang.String getLabel() {
            return this.label;
        }

        @Override
        public final software.amazon.awscdk.Duration getPeriod() {
            return this.period;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getStatistic() {
            return this.statistic;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.Unit getUnit() {
            return this.unit;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccount() != null) {
                data.set("account", om.valueToTree(this.getAccount()));
            }
            if (this.getColor() != null) {
                data.set("color", om.valueToTree(this.getColor()));
            }
            if (this.getDimensionsMap() != null) {
                data.set("dimensionsMap", om.valueToTree(this.getDimensionsMap()));
            }
            if (this.getLabel() != null) {
                data.set("label", om.valueToTree(this.getLabel()));
            }
            if (this.getPeriod() != null) {
                data.set("period", om.valueToTree(this.getPeriod()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getStatistic() != null) {
                data.set("statistic", om.valueToTree(this.getStatistic()));
            }
            if (this.getUnit() != null) {
                data.set("unit", om.valueToTree(this.getUnit()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.CommonMetricOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CommonMetricOptions.Jsii$Proxy that = (CommonMetricOptions.Jsii$Proxy) o;

            if (this.account != null ? !this.account.equals(that.account) : that.account != null) return false;
            if (this.color != null ? !this.color.equals(that.color) : that.color != null) return false;
            if (this.dimensionsMap != null ? !this.dimensionsMap.equals(that.dimensionsMap) : that.dimensionsMap != null) return false;
            if (this.label != null ? !this.label.equals(that.label) : that.label != null) return false;
            if (this.period != null ? !this.period.equals(that.period) : that.period != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.statistic != null ? !this.statistic.equals(that.statistic) : that.statistic != null) return false;
            return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
        }

        @Override
        public final int hashCode() {
            int result = this.account != null ? this.account.hashCode() : 0;
            result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
            result = 31 * result + (this.dimensionsMap != null ? this.dimensionsMap.hashCode() : 0);
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.statistic != null ? this.statistic.hashCode() : 0);
            result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
            return result;
        }
    }
}
