package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for creating a Composite Alarm.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Alarm alarm1;
 * Alarm alarm2;
 * Alarm alarm3;
 * Alarm alarm4;
 * IAlarmRule alarmRule = AlarmRule.anyOf(AlarmRule.allOf(AlarmRule.anyOf(alarm1, AlarmRule.fromAlarm(alarm2, AlarmState.OK), alarm3), AlarmRule.not(AlarmRule.fromAlarm(alarm4, AlarmState.INSUFFICIENT_DATA))), AlarmRule.fromBoolean(false));
 * CompositeAlarm.Builder.create(this, "MyAwesomeCompositeAlarm")
 *         .alarmRule(alarmRule)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:28.834Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CompositeAlarmProps")
@software.amazon.jsii.Jsii.Proxy(CompositeAlarmProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CompositeAlarmProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Expression that specifies which other alarms are to be evaluated to determine this composite alarm's state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IAlarmRule getAlarmRule();

    /**
     * Whether the actions for this alarm are enabled.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getActionsEnabled() {
        return null;
    }

    /**
     * Actions will be suppressed if the suppressor alarm is in the ALARM state.
     * <p>
     * Default: - alarm will not be suppressed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.IAlarm getActionsSuppressor() {
        return null;
    }

    /**
     * The maximum duration that the composite alarm waits after suppressor alarm goes out of the ALARM state.
     * <p>
     * After this time, the composite alarm performs its actions.
     * <p>
     * Default: - 1 minute extension period will be set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getActionsSuppressorExtensionPeriod() {
        return null;
    }

    /**
     * The maximum duration that the composite alarm waits for the suppressor alarm to go into the ALARM state.
     * <p>
     * After this time, the composite alarm performs its actions.
     * <p>
     * Default: - 1 minute wait period will be set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getActionsSuppressorWaitPeriod() {
        return null;
    }

    /**
     * Description for the alarm.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlarmDescription() {
        return null;
    }

    /**
     * Name of the alarm.
     * <p>
     * Default: - Automatically generated name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCompositeAlarmName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CompositeAlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CompositeAlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CompositeAlarmProps> {
        software.amazon.awscdk.services.cloudwatch.IAlarmRule alarmRule;
        java.lang.Boolean actionsEnabled;
        software.amazon.awscdk.services.cloudwatch.IAlarm actionsSuppressor;
        software.amazon.awscdk.Duration actionsSuppressorExtensionPeriod;
        software.amazon.awscdk.Duration actionsSuppressorWaitPeriod;
        java.lang.String alarmDescription;
        java.lang.String compositeAlarmName;

        /**
         * Sets the value of {@link CompositeAlarmProps#getAlarmRule}
         * @param alarmRule Expression that specifies which other alarms are to be evaluated to determine this composite alarm's state. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmRule(software.amazon.awscdk.services.cloudwatch.IAlarmRule alarmRule) {
            this.alarmRule = alarmRule;
            return this;
        }

        /**
         * Sets the value of {@link CompositeAlarmProps#getActionsEnabled}
         * @param actionsEnabled Whether the actions for this alarm are enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsEnabled(java.lang.Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CompositeAlarmProps#getActionsSuppressor}
         * @param actionsSuppressor Actions will be suppressed if the suppressor alarm is in the ALARM state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsSuppressor(software.amazon.awscdk.services.cloudwatch.IAlarm actionsSuppressor) {
            this.actionsSuppressor = actionsSuppressor;
            return this;
        }

        /**
         * Sets the value of {@link CompositeAlarmProps#getActionsSuppressorExtensionPeriod}
         * @param actionsSuppressorExtensionPeriod The maximum duration that the composite alarm waits after suppressor alarm goes out of the ALARM state.
         *                                         After this time, the composite alarm performs its actions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsSuppressorExtensionPeriod(software.amazon.awscdk.Duration actionsSuppressorExtensionPeriod) {
            this.actionsSuppressorExtensionPeriod = actionsSuppressorExtensionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CompositeAlarmProps#getActionsSuppressorWaitPeriod}
         * @param actionsSuppressorWaitPeriod The maximum duration that the composite alarm waits for the suppressor alarm to go into the ALARM state.
         *                                    After this time, the composite alarm performs its actions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsSuppressorWaitPeriod(software.amazon.awscdk.Duration actionsSuppressorWaitPeriod) {
            this.actionsSuppressorWaitPeriod = actionsSuppressorWaitPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CompositeAlarmProps#getAlarmDescription}
         * @param alarmDescription Description for the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmDescription(java.lang.String alarmDescription) {
            this.alarmDescription = alarmDescription;
            return this;
        }

        /**
         * Sets the value of {@link CompositeAlarmProps#getCompositeAlarmName}
         * @param compositeAlarmName Name of the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compositeAlarmName(java.lang.String compositeAlarmName) {
            this.compositeAlarmName = compositeAlarmName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CompositeAlarmProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CompositeAlarmProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CompositeAlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CompositeAlarmProps {
        private final software.amazon.awscdk.services.cloudwatch.IAlarmRule alarmRule;
        private final java.lang.Boolean actionsEnabled;
        private final software.amazon.awscdk.services.cloudwatch.IAlarm actionsSuppressor;
        private final software.amazon.awscdk.Duration actionsSuppressorExtensionPeriod;
        private final software.amazon.awscdk.Duration actionsSuppressorWaitPeriod;
        private final java.lang.String alarmDescription;
        private final java.lang.String compositeAlarmName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.alarmRule = software.amazon.jsii.Kernel.get(this, "alarmRule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IAlarmRule.class));
            this.actionsEnabled = software.amazon.jsii.Kernel.get(this, "actionsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.actionsSuppressor = software.amazon.jsii.Kernel.get(this, "actionsSuppressor", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IAlarm.class));
            this.actionsSuppressorExtensionPeriod = software.amazon.jsii.Kernel.get(this, "actionsSuppressorExtensionPeriod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.actionsSuppressorWaitPeriod = software.amazon.jsii.Kernel.get(this, "actionsSuppressorWaitPeriod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.alarmDescription = software.amazon.jsii.Kernel.get(this, "alarmDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.compositeAlarmName = software.amazon.jsii.Kernel.get(this, "compositeAlarmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.alarmRule = java.util.Objects.requireNonNull(builder.alarmRule, "alarmRule is required");
            this.actionsEnabled = builder.actionsEnabled;
            this.actionsSuppressor = builder.actionsSuppressor;
            this.actionsSuppressorExtensionPeriod = builder.actionsSuppressorExtensionPeriod;
            this.actionsSuppressorWaitPeriod = builder.actionsSuppressorWaitPeriod;
            this.alarmDescription = builder.alarmDescription;
            this.compositeAlarmName = builder.compositeAlarmName;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.IAlarmRule getAlarmRule() {
            return this.alarmRule;
        }

        @Override
        public final java.lang.Boolean getActionsEnabled() {
            return this.actionsEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.IAlarm getActionsSuppressor() {
            return this.actionsSuppressor;
        }

        @Override
        public final software.amazon.awscdk.Duration getActionsSuppressorExtensionPeriod() {
            return this.actionsSuppressorExtensionPeriod;
        }

        @Override
        public final software.amazon.awscdk.Duration getActionsSuppressorWaitPeriod() {
            return this.actionsSuppressorWaitPeriod;
        }

        @Override
        public final java.lang.String getAlarmDescription() {
            return this.alarmDescription;
        }

        @Override
        public final java.lang.String getCompositeAlarmName() {
            return this.compositeAlarmName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("alarmRule", om.valueToTree(this.getAlarmRule()));
            if (this.getActionsEnabled() != null) {
                data.set("actionsEnabled", om.valueToTree(this.getActionsEnabled()));
            }
            if (this.getActionsSuppressor() != null) {
                data.set("actionsSuppressor", om.valueToTree(this.getActionsSuppressor()));
            }
            if (this.getActionsSuppressorExtensionPeriod() != null) {
                data.set("actionsSuppressorExtensionPeriod", om.valueToTree(this.getActionsSuppressorExtensionPeriod()));
            }
            if (this.getActionsSuppressorWaitPeriod() != null) {
                data.set("actionsSuppressorWaitPeriod", om.valueToTree(this.getActionsSuppressorWaitPeriod()));
            }
            if (this.getAlarmDescription() != null) {
                data.set("alarmDescription", om.valueToTree(this.getAlarmDescription()));
            }
            if (this.getCompositeAlarmName() != null) {
                data.set("compositeAlarmName", om.valueToTree(this.getCompositeAlarmName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.CompositeAlarmProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CompositeAlarmProps.Jsii$Proxy that = (CompositeAlarmProps.Jsii$Proxy) o;

            if (!alarmRule.equals(that.alarmRule)) return false;
            if (this.actionsEnabled != null ? !this.actionsEnabled.equals(that.actionsEnabled) : that.actionsEnabled != null) return false;
            if (this.actionsSuppressor != null ? !this.actionsSuppressor.equals(that.actionsSuppressor) : that.actionsSuppressor != null) return false;
            if (this.actionsSuppressorExtensionPeriod != null ? !this.actionsSuppressorExtensionPeriod.equals(that.actionsSuppressorExtensionPeriod) : that.actionsSuppressorExtensionPeriod != null) return false;
            if (this.actionsSuppressorWaitPeriod != null ? !this.actionsSuppressorWaitPeriod.equals(that.actionsSuppressorWaitPeriod) : that.actionsSuppressorWaitPeriod != null) return false;
            if (this.alarmDescription != null ? !this.alarmDescription.equals(that.alarmDescription) : that.alarmDescription != null) return false;
            return this.compositeAlarmName != null ? this.compositeAlarmName.equals(that.compositeAlarmName) : that.compositeAlarmName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.alarmRule.hashCode();
            result = 31 * result + (this.actionsEnabled != null ? this.actionsEnabled.hashCode() : 0);
            result = 31 * result + (this.actionsSuppressor != null ? this.actionsSuppressor.hashCode() : 0);
            result = 31 * result + (this.actionsSuppressorExtensionPeriod != null ? this.actionsSuppressorExtensionPeriod.hashCode() : 0);
            result = 31 * result + (this.actionsSuppressorWaitPeriod != null ? this.actionsSuppressorWaitPeriod.hashCode() : 0);
            result = 31 * result + (this.alarmDescription != null ? this.alarmDescription.hashCode() : 0);
            result = 31 * result + (this.compositeAlarmName != null ? this.compositeAlarmName.hashCode() : 0);
            return result;
        }
    }
}
