package software.amazon.awscdk.services.cloudwatch;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cloudwatch.*;
 * Dashboard dashboard = Dashboard.Builder.create(this, "Dash")
 *         .defaultInterval(Duration.days(7))
 *         .variables(List.of(DashboardVariable.Builder.create()
 *                 .id("functionName")
 *                 .type(VariableType.PATTERN)
 *                 .label("Function")
 *                 .inputType(VariableInputType.RADIO)
 *                 .value("originalFuncNameInDashboard")
 *                 // equivalent to cw.Values.fromSearch('{AWS/Lambda,FunctionName} MetricName=\"Duration\"', 'FunctionName')
 *                 .values(Values.fromSearchComponents(SearchComponents.builder()
 *                         .namespace("AWS/Lambda")
 *                         .dimensions(List.of("FunctionName"))
 *                         .metricName("Duration")
 *                         .populateFrom("FunctionName")
 *                         .build()))
 *                 .defaultValue(DefaultValue.FIRST)
 *                 .visible(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:28.881Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.VariableInputType")
public enum VariableInputType {
    /**
     * Freeform text input box.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INPUT,
    /**
     * A dropdown of pre-defined values, or values filled in from a metric search query.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RADIO,
    /**
     * A set of pre-defined radio buttons, which can also be defined from a metric search query.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SELECT,
}
