package software.amazon.awscdk.services.codebuild;

/**
 * Local cache modes to enable for the CodeBuild Project.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Project.Builder.create(this, "Project")
 *         .source(Source.gitHubEnterprise(GitHubEnterpriseSourceProps.builder()
 *                 .httpsCloneUrl("https://my-github-enterprise.com/owner/repo")
 *                 .build()))
 *         // Enable Docker AND custom caching
 *         .cache(Cache.local(LocalCacheMode.DOCKER_LAYER, LocalCacheMode.CUSTOM))
 *         // BuildSpec with a 'cache' section necessary for 'CUSTOM' caching. This can
 *         // also come from 'buildspec.yml' in your source.
 *         .buildSpec(BuildSpec.fromObject(Map.of(
 *                 "version", "0.2",
 *                 "phases", Map.of(
 *                         "build", Map.of(
 *                                 "commands", List.of("..."))),
 *                 "cache", Map.of(
 *                         "paths", List.of("/root/cachedir/**&#47;*")))))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:29.010Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.LocalCacheMode")
public enum LocalCacheMode {
    /**
     * Caches Git metadata for primary and secondary sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SOURCE,
    /**
     * Caches existing Docker layers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DOCKER_LAYER,
    /**
     * Caches directories you specify in the buildspec file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CUSTOM,
}
