package software.amazon.awscdk.services.codepipeline.actions;

/**
 * CodePipeline Source that is provided by an AWS CodeCommit repository.
 * <p>
 * If the CodeCommit repository is in a different account, you must use
 * <code>CodeCommitTrigger.EVENTS</code> to trigger the pipeline.
 * <p>
 * (That is because the Pipeline structure normally only has a <code>RepositoryName</code>
 * field, and that is not enough for the pipeline to locate the repository's
 * source account. However, if the pipeline is triggered via an EventBridge
 * event, the event itself has the full repository ARN in there, allowing the
 * pipeline to locate the repository).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Source stage: read from repository
 * Repository repo = Repository.Builder.create(stack, "TemplateRepo")
 *         .repositoryName("template-repo")
 *         .build();
 * Artifact sourceOutput = new Artifact("SourceArtifact");
 * CodeCommitSourceAction source = CodeCommitSourceAction.Builder.create()
 *         .actionName("Source")
 *         .repository(repo)
 *         .output(sourceOutput)
 *         .trigger(CodeCommitTrigger.POLL)
 *         .build();
 * Map&lt;String, Object&gt; sourceStage = Map.of(
 *         "stageName", "Source",
 *         "actions", List.of(source));
 * // Deployment stage: create and deploy changeset with manual approval
 * String stackName = "OurStack";
 * String changeSetName = "StagedChangeSet";
 * Map&lt;String, Object&gt; prodStage = Map.of(
 *         "stageName", "Deploy",
 *         "actions", List.of(
 *             CloudFormationCreateReplaceChangeSetAction.Builder.create()
 *                     .actionName("PrepareChanges")
 *                     .stackName(stackName)
 *                     .changeSetName(changeSetName)
 *                     .adminPermissions(true)
 *                     .templatePath(sourceOutput.atPath("template.yaml"))
 *                     .runOrder(1)
 *                     .build(),
 *             ManualApprovalAction.Builder.create()
 *                     .actionName("ApproveChanges")
 *                     .runOrder(2)
 *                     .build(),
 *             CloudFormationExecuteChangeSetAction.Builder.create()
 *                     .actionName("ExecuteChanges")
 *                     .stackName(stackName)
 *                     .changeSetName(changeSetName)
 *                     .runOrder(3)
 *                     .build()));
 * Pipeline.Builder.create(stack, "Pipeline")
 *         .crossAccountKeys(true)
 *         .stages(List.of(sourceStage, prodStage))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:29.302Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.CodeCommitSourceAction")
public class CodeCommitSourceAction extends software.amazon.awscdk.services.codepipeline.actions.Action {

    protected CodeCommitSourceAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CodeCommitSourceAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CodeCommitSourceAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.CodeCommitSourceActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * This is a renamed version of the <code>IAction.bind</code> method.
     * <p>
     * @param _scope This parameter is required.
     * @param stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionConfig bound(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bound", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(stage, "stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * The variables emitted by this action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.CodeCommitSourceVariables getVariables() {
        return software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.CodeCommitSourceVariables.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.actions.CodeCommitSourceAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.actions.CodeCommitSourceAction> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.codepipeline.actions.CodeCommitSourceActionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.codepipeline.actions.CodeCommitSourceActionProps.Builder();
        }

        /**
         * The physical, human-readable name of the Action.
         * <p>
         * Note that Action names must be unique within a single Stage.
         * <p>
         * @return {@code this}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(final java.lang.String actionName) {
            this.props.actionName(actionName);
            return this;
        }

        /**
         * The runOrder property for this Action.
         * <p>
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html</a>
         * @param runOrder The runOrder property for this Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(final java.lang.Number runOrder) {
            this.props.runOrder(runOrder);
            return this;
        }

        /**
         * The name of the namespace to use for variables emitted by this action.
         * <p>
         * Default: - a name will be generated, based on the stage and action names,
         * if any of the action's variables were referenced - otherwise,
         * no namespace will be set
         * <p>
         * @return {@code this}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(final java.lang.String variablesNamespace) {
            this.props.variablesNamespace(variablesNamespace);
            return this;
        }

        /**
         * The Role in which context's this Action will be executing in.
         * <p>
         * The Pipeline's Role will assume this Role
         * (the required permissions for that will be granted automatically)
         * right before executing this Action.
         * This Action will be passed into your <code>IAction.bind</code>
         * method in the <code>ActionBindOptions.role</code> property.
         * <p>
         * Default: a new Role will be generated
         * <p>
         * @return {@code this}
         * @param role The Role in which context's this Action will be executing in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * @return {@code this}
         * @param output This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder output(final software.amazon.awscdk.services.codepipeline.Artifact output) {
            this.props.output(output);
            return this;
        }

        /**
         * The CodeCommit repository.
         * <p>
         * @return {@code this}
         * @param repository The CodeCommit repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repository(final software.amazon.awscdk.services.codecommit.IRepository repository) {
            this.props.repository(repository);
            return this;
        }

        /**
         * Default: 'master'
         * <p>
         * @return {@code this}
         * @param branch This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder branch(final java.lang.String branch) {
            this.props.branch(branch);
            return this;
        }

        /**
         * Whether the output should be the contents of the repository (which is the default), or a link that allows CodeBuild to clone the repository before building.
         * <p>
         * <strong>Note</strong>: if this option is true,
         * then only CodeBuild actions can use the resulting <code>output</code>.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodeCommit.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodeCommit.html</a>
         * @param codeBuildCloneOutput Whether the output should be the contents of the repository (which is the default), or a link that allows CodeBuild to clone the repository before building. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeBuildCloneOutput(final java.lang.Boolean codeBuildCloneOutput) {
            this.props.codeBuildCloneOutput(codeBuildCloneOutput);
            return this;
        }

        /**
         * You can pass a <code>customEventRule</code> to set up a custom event rule for the CodeCommit source action.
         * <p>
         * You must provide the <code>eventPattern</code> and <code>target</code> properties in the <code>customEventRule</code> object.
         * Check which <code>eventPattern</code> to use: https://docs.aws.amazon.com/codecommit/latest/userguide/monitoring-events.html
         * <p>
         * Default: Event rule which is triggered by CodeCommit repository on commit
         * <p>
         * @return {@code this}
         * @param customEventRule You can pass a <code>customEventRule</code> to set up a custom event rule for the CodeCommit source action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customEventRule(final software.amazon.awscdk.services.codepipeline.actions.ICustomEventRule customEventRule) {
            this.props.customEventRule(customEventRule);
            return this;
        }

        /**
         * Role to be used by on commit event rule.
         * <p>
         * Used only when trigger value is CodeCommitTrigger.EVENTS.
         * <p>
         * Default: a new role will be created.
         * <p>
         * @return {@code this}
         * @param eventRole Role to be used by on commit event rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventRole(final software.amazon.awscdk.services.iam.IRole eventRole) {
            this.props.eventRole(eventRole);
            return this;
        }

        /**
         * How should CodePipeline detect source changes for this Action.
         * <p>
         * Default: CodeCommitTrigger.EVENTS
         * <p>
         * @return {@code this}
         * @param trigger How should CodePipeline detect source changes for this Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trigger(final software.amazon.awscdk.services.codepipeline.actions.CodeCommitTrigger trigger) {
            this.props.trigger(trigger);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codepipeline.actions.CodeCommitSourceAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.actions.CodeCommitSourceAction build() {
            return new software.amazon.awscdk.services.codepipeline.actions.CodeCommitSourceAction(
                this.props.build()
            );
        }
    }
}
