package software.amazon.awscdk.services.cognito;

/**
 * Represents an identity provider that integrates with Facebook Login.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * ProviderAttribute providerAttribute;
 * UserPool userPool;
 * UserPoolIdentityProviderFacebook userPoolIdentityProviderFacebook = UserPoolIdentityProviderFacebook.Builder.create(this, "MyUserPoolIdentityProviderFacebook")
 *         .clientId("clientId")
 *         .clientSecret("clientSecret")
 *         .userPool(userPool)
 *         // the properties below are optional
 *         .apiVersion("apiVersion")
 *         .attributeMapping(AttributeMapping.builder()
 *                 .address(providerAttribute)
 *                 .birthdate(providerAttribute)
 *                 .custom(Map.of(
 *                         "customKey", providerAttribute))
 *                 .email(providerAttribute)
 *                 .familyName(providerAttribute)
 *                 .fullname(providerAttribute)
 *                 .gender(providerAttribute)
 *                 .givenName(providerAttribute)
 *                 .lastUpdateTime(providerAttribute)
 *                 .locale(providerAttribute)
 *                 .middleName(providerAttribute)
 *                 .nickname(providerAttribute)
 *                 .phoneNumber(providerAttribute)
 *                 .preferredUsername(providerAttribute)
 *                 .profilePage(providerAttribute)
 *                 .profilePicture(providerAttribute)
 *                 .timezone(providerAttribute)
 *                 .website(providerAttribute)
 *                 .build())
 *         .scopes(List.of("scopes"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:29.536Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolIdentityProviderFacebook")
public class UserPoolIdentityProviderFacebook extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.cognito.IUserPoolIdentityProvider {

    protected UserPoolIdentityProviderFacebook(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPoolIdentityProviderFacebook(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public UserPoolIdentityProviderFacebook(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolIdentityProviderFacebookProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object configureAttributeMapping() {
        return software.amazon.jsii.Kernel.call(this, "configureAttributeMapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The primary identifier of this identity provider.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProviderName() {
        return software.amazon.jsii.Kernel.get(this, "providerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.UserPoolIdentityProviderFacebook}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.UserPoolIdentityProviderFacebook> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.UserPoolIdentityProviderFacebookProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.UserPoolIdentityProviderFacebookProps.Builder();
        }

        /**
         * The user pool to which this construct provides identities.
         * <p>
         * @return {@code this}
         * @param userPool The user pool to which this construct provides identities. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPool(final software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.props.userPool(userPool);
            return this;
        }

        /**
         * Mapping attributes from the identity provider to standard and custom attributes of the user pool.
         * <p>
         * Default: - no attribute mapping
         * <p>
         * @return {@code this}
         * @param attributeMapping Mapping attributes from the identity provider to standard and custom attributes of the user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeMapping(final software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping) {
            this.props.attributeMapping(attributeMapping);
            return this;
        }

        /**
         * The client id recognized by Facebook APIs.
         * <p>
         * @return {@code this}
         * @param clientId The client id recognized by Facebook APIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientId(final java.lang.String clientId) {
            this.props.clientId(clientId);
            return this;
        }

        /**
         * The client secret to be accompanied with clientId for Facebook to authenticate the client.
         * <p>
         * @return {@code this}
         * @see <a href="https://developers.facebook.com/docs/facebook-login/security#appsecret">https://developers.facebook.com/docs/facebook-login/security#appsecret</a>
         * @param clientSecret The client secret to be accompanied with clientId for Facebook to authenticate the client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientSecret(final java.lang.String clientSecret) {
            this.props.clientSecret(clientSecret);
            return this;
        }

        /**
         * The Facebook API version to use.
         * <p>
         * Default: - to the oldest version supported by Facebook
         * <p>
         * @return {@code this}
         * @param apiVersion The Facebook API version to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiVersion(final java.lang.String apiVersion) {
            this.props.apiVersion(apiVersion);
            return this;
        }

        /**
         * The list of Facebook permissions to obtain for getting access to the Facebook profile.
         * <p>
         * Default: [ public_profile ]
         * <p>
         * @return {@code this}
         * @see <a href="https://developers.facebook.com/docs/facebook-login/permissions">https://developers.facebook.com/docs/facebook-login/permissions</a>
         * @param scopes The list of Facebook permissions to obtain for getting access to the Facebook profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scopes(final java.util.List<java.lang.String> scopes) {
            this.props.scopes(scopes);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cognito.UserPoolIdentityProviderFacebook}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.UserPoolIdentityProviderFacebook build() {
            return new software.amazon.awscdk.services.cognito.UserPoolIdentityProviderFacebook(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
