package software.amazon.awscdk.services.connectcampaigns;

/**
 * Contains information about an outbound campaign.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connectcampaigns.*;
 * CfnCampaign cfnCampaign = CfnCampaign.Builder.create(this, "MyCfnCampaign")
 *         .connectInstanceArn("connectInstanceArn")
 *         .dialerConfig(DialerConfigProperty.builder()
 *                 .agentlessDialerConfig(AgentlessDialerConfigProperty.builder()
 *                         .dialingCapacity(123)
 *                         .build())
 *                 .predictiveDialerConfig(PredictiveDialerConfigProperty.builder()
 *                         .bandwidthAllocation(123)
 *                         // the properties below are optional
 *                         .dialingCapacity(123)
 *                         .build())
 *                 .progressiveDialerConfig(ProgressiveDialerConfigProperty.builder()
 *                         .bandwidthAllocation(123)
 *                         // the properties below are optional
 *                         .dialingCapacity(123)
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .outboundCallConfig(OutboundCallConfigProperty.builder()
 *                 .connectContactFlowArn("connectContactFlowArn")
 *                 // the properties below are optional
 *                 .answerMachineDetectionConfig(AnswerMachineDetectionConfigProperty.builder()
 *                         .enableAnswerMachineDetection(false)
 *                         // the properties below are optional
 *                         .awaitAnswerMachinePrompt(false)
 *                         .build())
 *                 .connectQueueArn("connectQueueArn")
 *                 .connectSourcePhoneNumber("connectSourcePhoneNumber")
 *                 .build())
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:29.795Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaigns.CfnCampaign")
public class CfnCampaign extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnCampaign(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCampaign(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.connectcampaigns.CfnCampaign.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCampaign(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connectcampaigns.CfnCampaignProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the high-volume outbound campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon Connect instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConnectInstanceArn() {
        return software.amazon.jsii.Kernel.get(this, "connectInstanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon Connect instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectInstanceArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectInstanceArn", java.util.Objects.requireNonNull(value, "connectInstanceArn is required"));
    }

    /**
     * Contains information about the dialer configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDialerConfig() {
        return software.amazon.jsii.Kernel.get(this, "dialerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains information about the dialer configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDialerConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dialerConfig", java.util.Objects.requireNonNull(value, "dialerConfig is required"));
    }

    /**
     * Contains information about the dialer configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDialerConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connectcampaigns.CfnCampaign.DialerConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "dialerConfig", java.util.Objects.requireNonNull(value, "dialerConfig is required"));
    }

    /**
     * The name of the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Contains information about the outbound call configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getOutboundCallConfig() {
        return software.amazon.jsii.Kernel.get(this, "outboundCallConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains information about the outbound call configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutboundCallConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "outboundCallConfig", java.util.Objects.requireNonNull(value, "outboundCallConfig is required"));
    }

    /**
     * Contains information about the outbound call configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutboundCallConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connectcampaigns.CfnCampaign.OutboundCallConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "outboundCallConfig", java.util.Objects.requireNonNull(value, "outboundCallConfig is required"));
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Contains agentless dialer configuration for an outbound campaign.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaigns.*;
     * AgentlessDialerConfigProperty agentlessDialerConfigProperty = AgentlessDialerConfigProperty.builder()
     *         .dialingCapacity(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-agentlessdialerconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-agentlessdialerconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaigns.CfnCampaign.AgentlessDialerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AgentlessDialerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AgentlessDialerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The allocation of dialing capacity between multiple active campaigns.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-agentlessdialerconfig.html#cfn-connectcampaigns-campaign-agentlessdialerconfig-dialingcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-agentlessdialerconfig.html#cfn-connectcampaigns-campaign-agentlessdialerconfig-dialingcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDialingCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AgentlessDialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AgentlessDialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AgentlessDialerConfigProperty> {
            java.lang.Number dialingCapacity;

            /**
             * Sets the value of {@link AgentlessDialerConfigProperty#getDialingCapacity}
             * @param dialingCapacity The allocation of dialing capacity between multiple active campaigns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dialingCapacity(java.lang.Number dialingCapacity) {
                this.dialingCapacity = dialingCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AgentlessDialerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AgentlessDialerConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AgentlessDialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AgentlessDialerConfigProperty {
            private final java.lang.Number dialingCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dialingCapacity = software.amazon.jsii.Kernel.get(this, "dialingCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dialingCapacity = builder.dialingCapacity;
            }

            @Override
            public final java.lang.Number getDialingCapacity() {
                return this.dialingCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDialingCapacity() != null) {
                    data.set("dialingCapacity", om.valueToTree(this.getDialingCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaigns.CfnCampaign.AgentlessDialerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AgentlessDialerConfigProperty.Jsii$Proxy that = (AgentlessDialerConfigProperty.Jsii$Proxy) o;

                return this.dialingCapacity != null ? this.dialingCapacity.equals(that.dialingCapacity) : that.dialingCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dialingCapacity != null ? this.dialingCapacity.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains information about answering machine detection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaigns.*;
     * AnswerMachineDetectionConfigProperty answerMachineDetectionConfigProperty = AnswerMachineDetectionConfigProperty.builder()
     *         .enableAnswerMachineDetection(false)
     *         // the properties below are optional
     *         .awaitAnswerMachinePrompt(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-answermachinedetectionconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-answermachinedetectionconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaigns.CfnCampaign.AnswerMachineDetectionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AnswerMachineDetectionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnswerMachineDetectionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether answering machine detection is enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-answermachinedetectionconfig.html#cfn-connectcampaigns-campaign-answermachinedetectionconfig-enableanswermachinedetection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-answermachinedetectionconfig.html#cfn-connectcampaigns-campaign-answermachinedetectionconfig-enableanswermachinedetection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnableAnswerMachineDetection();

        /**
         * Whether waiting for answer machine prompt is enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-answermachinedetectionconfig.html#cfn-connectcampaigns-campaign-answermachinedetectionconfig-awaitanswermachineprompt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-answermachinedetectionconfig.html#cfn-connectcampaigns-campaign-answermachinedetectionconfig-awaitanswermachineprompt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwaitAnswerMachinePrompt() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnswerMachineDetectionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnswerMachineDetectionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnswerMachineDetectionConfigProperty> {
            java.lang.Object enableAnswerMachineDetection;
            java.lang.Object awaitAnswerMachinePrompt;

            /**
             * Sets the value of {@link AnswerMachineDetectionConfigProperty#getEnableAnswerMachineDetection}
             * @param enableAnswerMachineDetection Whether answering machine detection is enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableAnswerMachineDetection(java.lang.Boolean enableAnswerMachineDetection) {
                this.enableAnswerMachineDetection = enableAnswerMachineDetection;
                return this;
            }

            /**
             * Sets the value of {@link AnswerMachineDetectionConfigProperty#getEnableAnswerMachineDetection}
             * @param enableAnswerMachineDetection Whether answering machine detection is enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableAnswerMachineDetection(software.amazon.awscdk.IResolvable enableAnswerMachineDetection) {
                this.enableAnswerMachineDetection = enableAnswerMachineDetection;
                return this;
            }

            /**
             * Sets the value of {@link AnswerMachineDetectionConfigProperty#getAwaitAnswerMachinePrompt}
             * @param awaitAnswerMachinePrompt Whether waiting for answer machine prompt is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awaitAnswerMachinePrompt(java.lang.Boolean awaitAnswerMachinePrompt) {
                this.awaitAnswerMachinePrompt = awaitAnswerMachinePrompt;
                return this;
            }

            /**
             * Sets the value of {@link AnswerMachineDetectionConfigProperty#getAwaitAnswerMachinePrompt}
             * @param awaitAnswerMachinePrompt Whether waiting for answer machine prompt is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awaitAnswerMachinePrompt(software.amazon.awscdk.IResolvable awaitAnswerMachinePrompt) {
                this.awaitAnswerMachinePrompt = awaitAnswerMachinePrompt;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnswerMachineDetectionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnswerMachineDetectionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnswerMachineDetectionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnswerMachineDetectionConfigProperty {
            private final java.lang.Object enableAnswerMachineDetection;
            private final java.lang.Object awaitAnswerMachinePrompt;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableAnswerMachineDetection = software.amazon.jsii.Kernel.get(this, "enableAnswerMachineDetection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.awaitAnswerMachinePrompt = software.amazon.jsii.Kernel.get(this, "awaitAnswerMachinePrompt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableAnswerMachineDetection = java.util.Objects.requireNonNull(builder.enableAnswerMachineDetection, "enableAnswerMachineDetection is required");
                this.awaitAnswerMachinePrompt = builder.awaitAnswerMachinePrompt;
            }

            @Override
            public final java.lang.Object getEnableAnswerMachineDetection() {
                return this.enableAnswerMachineDetection;
            }

            @Override
            public final java.lang.Object getAwaitAnswerMachinePrompt() {
                return this.awaitAnswerMachinePrompt;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enableAnswerMachineDetection", om.valueToTree(this.getEnableAnswerMachineDetection()));
                if (this.getAwaitAnswerMachinePrompt() != null) {
                    data.set("awaitAnswerMachinePrompt", om.valueToTree(this.getAwaitAnswerMachinePrompt()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaigns.CfnCampaign.AnswerMachineDetectionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnswerMachineDetectionConfigProperty.Jsii$Proxy that = (AnswerMachineDetectionConfigProperty.Jsii$Proxy) o;

                if (!enableAnswerMachineDetection.equals(that.enableAnswerMachineDetection)) return false;
                return this.awaitAnswerMachinePrompt != null ? this.awaitAnswerMachinePrompt.equals(that.awaitAnswerMachinePrompt) : that.awaitAnswerMachinePrompt == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableAnswerMachineDetection.hashCode();
                result = 31 * result + (this.awaitAnswerMachinePrompt != null ? this.awaitAnswerMachinePrompt.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains dialer configuration for an outbound campaign.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaigns.*;
     * DialerConfigProperty dialerConfigProperty = DialerConfigProperty.builder()
     *         .agentlessDialerConfig(AgentlessDialerConfigProperty.builder()
     *                 .dialingCapacity(123)
     *                 .build())
     *         .predictiveDialerConfig(PredictiveDialerConfigProperty.builder()
     *                 .bandwidthAllocation(123)
     *                 // the properties below are optional
     *                 .dialingCapacity(123)
     *                 .build())
     *         .progressiveDialerConfig(ProgressiveDialerConfigProperty.builder()
     *                 .bandwidthAllocation(123)
     *                 // the properties below are optional
     *                 .dialingCapacity(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-dialerconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-dialerconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaigns.CfnCampaign.DialerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DialerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DialerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration of the agentless dialer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-dialerconfig.html#cfn-connectcampaigns-campaign-dialerconfig-agentlessdialerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-dialerconfig.html#cfn-connectcampaigns-campaign-dialerconfig-agentlessdialerconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAgentlessDialerConfig() {
            return null;
        }

        /**
         * The configuration of the predictive dialer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-dialerconfig.html#cfn-connectcampaigns-campaign-dialerconfig-predictivedialerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-dialerconfig.html#cfn-connectcampaigns-campaign-dialerconfig-predictivedialerconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPredictiveDialerConfig() {
            return null;
        }

        /**
         * The configuration of the progressive dialer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-dialerconfig.html#cfn-connectcampaigns-campaign-dialerconfig-progressivedialerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-dialerconfig.html#cfn-connectcampaigns-campaign-dialerconfig-progressivedialerconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProgressiveDialerConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DialerConfigProperty> {
            java.lang.Object agentlessDialerConfig;
            java.lang.Object predictiveDialerConfig;
            java.lang.Object progressiveDialerConfig;

            /**
             * Sets the value of {@link DialerConfigProperty#getAgentlessDialerConfig}
             * @param agentlessDialerConfig The configuration of the agentless dialer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder agentlessDialerConfig(software.amazon.awscdk.IResolvable agentlessDialerConfig) {
                this.agentlessDialerConfig = agentlessDialerConfig;
                return this;
            }

            /**
             * Sets the value of {@link DialerConfigProperty#getAgentlessDialerConfig}
             * @param agentlessDialerConfig The configuration of the agentless dialer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder agentlessDialerConfig(software.amazon.awscdk.services.connectcampaigns.CfnCampaign.AgentlessDialerConfigProperty agentlessDialerConfig) {
                this.agentlessDialerConfig = agentlessDialerConfig;
                return this;
            }

            /**
             * Sets the value of {@link DialerConfigProperty#getPredictiveDialerConfig}
             * @param predictiveDialerConfig The configuration of the predictive dialer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predictiveDialerConfig(software.amazon.awscdk.IResolvable predictiveDialerConfig) {
                this.predictiveDialerConfig = predictiveDialerConfig;
                return this;
            }

            /**
             * Sets the value of {@link DialerConfigProperty#getPredictiveDialerConfig}
             * @param predictiveDialerConfig The configuration of the predictive dialer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predictiveDialerConfig(software.amazon.awscdk.services.connectcampaigns.CfnCampaign.PredictiveDialerConfigProperty predictiveDialerConfig) {
                this.predictiveDialerConfig = predictiveDialerConfig;
                return this;
            }

            /**
             * Sets the value of {@link DialerConfigProperty#getProgressiveDialerConfig}
             * @param progressiveDialerConfig The configuration of the progressive dialer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder progressiveDialerConfig(software.amazon.awscdk.IResolvable progressiveDialerConfig) {
                this.progressiveDialerConfig = progressiveDialerConfig;
                return this;
            }

            /**
             * Sets the value of {@link DialerConfigProperty#getProgressiveDialerConfig}
             * @param progressiveDialerConfig The configuration of the progressive dialer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder progressiveDialerConfig(software.amazon.awscdk.services.connectcampaigns.CfnCampaign.ProgressiveDialerConfigProperty progressiveDialerConfig) {
                this.progressiveDialerConfig = progressiveDialerConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DialerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DialerConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DialerConfigProperty {
            private final java.lang.Object agentlessDialerConfig;
            private final java.lang.Object predictiveDialerConfig;
            private final java.lang.Object progressiveDialerConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.agentlessDialerConfig = software.amazon.jsii.Kernel.get(this, "agentlessDialerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.predictiveDialerConfig = software.amazon.jsii.Kernel.get(this, "predictiveDialerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.progressiveDialerConfig = software.amazon.jsii.Kernel.get(this, "progressiveDialerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.agentlessDialerConfig = builder.agentlessDialerConfig;
                this.predictiveDialerConfig = builder.predictiveDialerConfig;
                this.progressiveDialerConfig = builder.progressiveDialerConfig;
            }

            @Override
            public final java.lang.Object getAgentlessDialerConfig() {
                return this.agentlessDialerConfig;
            }

            @Override
            public final java.lang.Object getPredictiveDialerConfig() {
                return this.predictiveDialerConfig;
            }

            @Override
            public final java.lang.Object getProgressiveDialerConfig() {
                return this.progressiveDialerConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAgentlessDialerConfig() != null) {
                    data.set("agentlessDialerConfig", om.valueToTree(this.getAgentlessDialerConfig()));
                }
                if (this.getPredictiveDialerConfig() != null) {
                    data.set("predictiveDialerConfig", om.valueToTree(this.getPredictiveDialerConfig()));
                }
                if (this.getProgressiveDialerConfig() != null) {
                    data.set("progressiveDialerConfig", om.valueToTree(this.getProgressiveDialerConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaigns.CfnCampaign.DialerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DialerConfigProperty.Jsii$Proxy that = (DialerConfigProperty.Jsii$Proxy) o;

                if (this.agentlessDialerConfig != null ? !this.agentlessDialerConfig.equals(that.agentlessDialerConfig) : that.agentlessDialerConfig != null) return false;
                if (this.predictiveDialerConfig != null ? !this.predictiveDialerConfig.equals(that.predictiveDialerConfig) : that.predictiveDialerConfig != null) return false;
                return this.progressiveDialerConfig != null ? this.progressiveDialerConfig.equals(that.progressiveDialerConfig) : that.progressiveDialerConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.agentlessDialerConfig != null ? this.agentlessDialerConfig.hashCode() : 0;
                result = 31 * result + (this.predictiveDialerConfig != null ? this.predictiveDialerConfig.hashCode() : 0);
                result = 31 * result + (this.progressiveDialerConfig != null ? this.progressiveDialerConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains outbound call configuration for an outbound campaign.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaigns.*;
     * OutboundCallConfigProperty outboundCallConfigProperty = OutboundCallConfigProperty.builder()
     *         .connectContactFlowArn("connectContactFlowArn")
     *         // the properties below are optional
     *         .answerMachineDetectionConfig(AnswerMachineDetectionConfigProperty.builder()
     *                 .enableAnswerMachineDetection(false)
     *                 // the properties below are optional
     *                 .awaitAnswerMachinePrompt(false)
     *                 .build())
     *         .connectQueueArn("connectQueueArn")
     *         .connectSourcePhoneNumber("connectSourcePhoneNumber")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-outboundcallconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-outboundcallconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaigns.CfnCampaign.OutboundCallConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(OutboundCallConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutboundCallConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-outboundcallconfig.html#cfn-connectcampaigns-campaign-outboundcallconfig-connectcontactflowarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-outboundcallconfig.html#cfn-connectcampaigns-campaign-outboundcallconfig-connectcontactflowarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConnectContactFlowArn();

        /**
         * Whether answering machine detection has been enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-outboundcallconfig.html#cfn-connectcampaigns-campaign-outboundcallconfig-answermachinedetectionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-outboundcallconfig.html#cfn-connectcampaigns-campaign-outboundcallconfig-answermachinedetectionconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnswerMachineDetectionConfig() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the queue.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-outboundcallconfig.html#cfn-connectcampaigns-campaign-outboundcallconfig-connectqueuearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-outboundcallconfig.html#cfn-connectcampaigns-campaign-outboundcallconfig-connectqueuearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectQueueArn() {
            return null;
        }

        /**
         * The phone number associated with the outbound call.
         * <p>
         * This is the caller ID that is displayed to customers when an agent calls them.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-outboundcallconfig.html#cfn-connectcampaigns-campaign-outboundcallconfig-connectsourcephonenumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-outboundcallconfig.html#cfn-connectcampaigns-campaign-outboundcallconfig-connectsourcephonenumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectSourcePhoneNumber() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutboundCallConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutboundCallConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutboundCallConfigProperty> {
            java.lang.String connectContactFlowArn;
            java.lang.Object answerMachineDetectionConfig;
            java.lang.String connectQueueArn;
            java.lang.String connectSourcePhoneNumber;

            /**
             * Sets the value of {@link OutboundCallConfigProperty#getConnectContactFlowArn}
             * @param connectContactFlowArn The Amazon Resource Name (ARN) of the flow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectContactFlowArn(java.lang.String connectContactFlowArn) {
                this.connectContactFlowArn = connectContactFlowArn;
                return this;
            }

            /**
             * Sets the value of {@link OutboundCallConfigProperty#getAnswerMachineDetectionConfig}
             * @param answerMachineDetectionConfig Whether answering machine detection has been enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder answerMachineDetectionConfig(software.amazon.awscdk.IResolvable answerMachineDetectionConfig) {
                this.answerMachineDetectionConfig = answerMachineDetectionConfig;
                return this;
            }

            /**
             * Sets the value of {@link OutboundCallConfigProperty#getAnswerMachineDetectionConfig}
             * @param answerMachineDetectionConfig Whether answering machine detection has been enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder answerMachineDetectionConfig(software.amazon.awscdk.services.connectcampaigns.CfnCampaign.AnswerMachineDetectionConfigProperty answerMachineDetectionConfig) {
                this.answerMachineDetectionConfig = answerMachineDetectionConfig;
                return this;
            }

            /**
             * Sets the value of {@link OutboundCallConfigProperty#getConnectQueueArn}
             * @param connectQueueArn The Amazon Resource Name (ARN) of the queue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectQueueArn(java.lang.String connectQueueArn) {
                this.connectQueueArn = connectQueueArn;
                return this;
            }

            /**
             * Sets the value of {@link OutboundCallConfigProperty#getConnectSourcePhoneNumber}
             * @param connectSourcePhoneNumber The phone number associated with the outbound call.
             *                                 This is the caller ID that is displayed to customers when an agent calls them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectSourcePhoneNumber(java.lang.String connectSourcePhoneNumber) {
                this.connectSourcePhoneNumber = connectSourcePhoneNumber;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutboundCallConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutboundCallConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutboundCallConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutboundCallConfigProperty {
            private final java.lang.String connectContactFlowArn;
            private final java.lang.Object answerMachineDetectionConfig;
            private final java.lang.String connectQueueArn;
            private final java.lang.String connectSourcePhoneNumber;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectContactFlowArn = software.amazon.jsii.Kernel.get(this, "connectContactFlowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.answerMachineDetectionConfig = software.amazon.jsii.Kernel.get(this, "answerMachineDetectionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.connectQueueArn = software.amazon.jsii.Kernel.get(this, "connectQueueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectSourcePhoneNumber = software.amazon.jsii.Kernel.get(this, "connectSourcePhoneNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectContactFlowArn = java.util.Objects.requireNonNull(builder.connectContactFlowArn, "connectContactFlowArn is required");
                this.answerMachineDetectionConfig = builder.answerMachineDetectionConfig;
                this.connectQueueArn = builder.connectQueueArn;
                this.connectSourcePhoneNumber = builder.connectSourcePhoneNumber;
            }

            @Override
            public final java.lang.String getConnectContactFlowArn() {
                return this.connectContactFlowArn;
            }

            @Override
            public final java.lang.Object getAnswerMachineDetectionConfig() {
                return this.answerMachineDetectionConfig;
            }

            @Override
            public final java.lang.String getConnectQueueArn() {
                return this.connectQueueArn;
            }

            @Override
            public final java.lang.String getConnectSourcePhoneNumber() {
                return this.connectSourcePhoneNumber;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("connectContactFlowArn", om.valueToTree(this.getConnectContactFlowArn()));
                if (this.getAnswerMachineDetectionConfig() != null) {
                    data.set("answerMachineDetectionConfig", om.valueToTree(this.getAnswerMachineDetectionConfig()));
                }
                if (this.getConnectQueueArn() != null) {
                    data.set("connectQueueArn", om.valueToTree(this.getConnectQueueArn()));
                }
                if (this.getConnectSourcePhoneNumber() != null) {
                    data.set("connectSourcePhoneNumber", om.valueToTree(this.getConnectSourcePhoneNumber()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaigns.CfnCampaign.OutboundCallConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutboundCallConfigProperty.Jsii$Proxy that = (OutboundCallConfigProperty.Jsii$Proxy) o;

                if (!connectContactFlowArn.equals(that.connectContactFlowArn)) return false;
                if (this.answerMachineDetectionConfig != null ? !this.answerMachineDetectionConfig.equals(that.answerMachineDetectionConfig) : that.answerMachineDetectionConfig != null) return false;
                if (this.connectQueueArn != null ? !this.connectQueueArn.equals(that.connectQueueArn) : that.connectQueueArn != null) return false;
                return this.connectSourcePhoneNumber != null ? this.connectSourcePhoneNumber.equals(that.connectSourcePhoneNumber) : that.connectSourcePhoneNumber == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectContactFlowArn.hashCode();
                result = 31 * result + (this.answerMachineDetectionConfig != null ? this.answerMachineDetectionConfig.hashCode() : 0);
                result = 31 * result + (this.connectQueueArn != null ? this.connectQueueArn.hashCode() : 0);
                result = 31 * result + (this.connectSourcePhoneNumber != null ? this.connectSourcePhoneNumber.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains predictive dialer configuration for an outbound campaign.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaigns.*;
     * PredictiveDialerConfigProperty predictiveDialerConfigProperty = PredictiveDialerConfigProperty.builder()
     *         .bandwidthAllocation(123)
     *         // the properties below are optional
     *         .dialingCapacity(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-predictivedialerconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-predictivedialerconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaigns.CfnCampaign.PredictiveDialerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveDialerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveDialerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Bandwidth allocation for the predictive dialer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-predictivedialerconfig.html#cfn-connectcampaigns-campaign-predictivedialerconfig-bandwidthallocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-predictivedialerconfig.html#cfn-connectcampaigns-campaign-predictivedialerconfig-bandwidthallocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getBandwidthAllocation();

        /**
         * The allocation of dialing capacity between multiple active campaigns.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-predictivedialerconfig.html#cfn-connectcampaigns-campaign-predictivedialerconfig-dialingcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-predictivedialerconfig.html#cfn-connectcampaigns-campaign-predictivedialerconfig-dialingcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDialingCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredictiveDialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveDialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveDialerConfigProperty> {
            java.lang.Number bandwidthAllocation;
            java.lang.Number dialingCapacity;

            /**
             * Sets the value of {@link PredictiveDialerConfigProperty#getBandwidthAllocation}
             * @param bandwidthAllocation Bandwidth allocation for the predictive dialer. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bandwidthAllocation(java.lang.Number bandwidthAllocation) {
                this.bandwidthAllocation = bandwidthAllocation;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveDialerConfigProperty#getDialingCapacity}
             * @param dialingCapacity The allocation of dialing capacity between multiple active campaigns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dialingCapacity(java.lang.Number dialingCapacity) {
                this.dialingCapacity = dialingCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveDialerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveDialerConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveDialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveDialerConfigProperty {
            private final java.lang.Number bandwidthAllocation;
            private final java.lang.Number dialingCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bandwidthAllocation = software.amazon.jsii.Kernel.get(this, "bandwidthAllocation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.dialingCapacity = software.amazon.jsii.Kernel.get(this, "dialingCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bandwidthAllocation = java.util.Objects.requireNonNull(builder.bandwidthAllocation, "bandwidthAllocation is required");
                this.dialingCapacity = builder.dialingCapacity;
            }

            @Override
            public final java.lang.Number getBandwidthAllocation() {
                return this.bandwidthAllocation;
            }

            @Override
            public final java.lang.Number getDialingCapacity() {
                return this.dialingCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bandwidthAllocation", om.valueToTree(this.getBandwidthAllocation()));
                if (this.getDialingCapacity() != null) {
                    data.set("dialingCapacity", om.valueToTree(this.getDialingCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaigns.CfnCampaign.PredictiveDialerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveDialerConfigProperty.Jsii$Proxy that = (PredictiveDialerConfigProperty.Jsii$Proxy) o;

                if (!bandwidthAllocation.equals(that.bandwidthAllocation)) return false;
                return this.dialingCapacity != null ? this.dialingCapacity.equals(that.dialingCapacity) : that.dialingCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bandwidthAllocation.hashCode();
                result = 31 * result + (this.dialingCapacity != null ? this.dialingCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains progressive dialer configuration for an outbound campaign.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connectcampaigns.*;
     * ProgressiveDialerConfigProperty progressiveDialerConfigProperty = ProgressiveDialerConfigProperty.builder()
     *         .bandwidthAllocation(123)
     *         // the properties below are optional
     *         .dialingCapacity(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-progressivedialerconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-progressivedialerconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connectcampaigns.CfnCampaign.ProgressiveDialerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ProgressiveDialerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProgressiveDialerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Bandwidth allocation for the progressive dialer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-progressivedialerconfig.html#cfn-connectcampaigns-campaign-progressivedialerconfig-bandwidthallocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-progressivedialerconfig.html#cfn-connectcampaigns-campaign-progressivedialerconfig-bandwidthallocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getBandwidthAllocation();

        /**
         * The allocation of dialing capacity between multiple active campaigns.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-progressivedialerconfig.html#cfn-connectcampaigns-campaign-progressivedialerconfig-dialingcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connectcampaigns-campaign-progressivedialerconfig.html#cfn-connectcampaigns-campaign-progressivedialerconfig-dialingcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDialingCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProgressiveDialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProgressiveDialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProgressiveDialerConfigProperty> {
            java.lang.Number bandwidthAllocation;
            java.lang.Number dialingCapacity;

            /**
             * Sets the value of {@link ProgressiveDialerConfigProperty#getBandwidthAllocation}
             * @param bandwidthAllocation Bandwidth allocation for the progressive dialer. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bandwidthAllocation(java.lang.Number bandwidthAllocation) {
                this.bandwidthAllocation = bandwidthAllocation;
                return this;
            }

            /**
             * Sets the value of {@link ProgressiveDialerConfigProperty#getDialingCapacity}
             * @param dialingCapacity The allocation of dialing capacity between multiple active campaigns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dialingCapacity(java.lang.Number dialingCapacity) {
                this.dialingCapacity = dialingCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProgressiveDialerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProgressiveDialerConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProgressiveDialerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProgressiveDialerConfigProperty {
            private final java.lang.Number bandwidthAllocation;
            private final java.lang.Number dialingCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bandwidthAllocation = software.amazon.jsii.Kernel.get(this, "bandwidthAllocation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.dialingCapacity = software.amazon.jsii.Kernel.get(this, "dialingCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bandwidthAllocation = java.util.Objects.requireNonNull(builder.bandwidthAllocation, "bandwidthAllocation is required");
                this.dialingCapacity = builder.dialingCapacity;
            }

            @Override
            public final java.lang.Number getBandwidthAllocation() {
                return this.bandwidthAllocation;
            }

            @Override
            public final java.lang.Number getDialingCapacity() {
                return this.dialingCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bandwidthAllocation", om.valueToTree(this.getBandwidthAllocation()));
                if (this.getDialingCapacity() != null) {
                    data.set("dialingCapacity", om.valueToTree(this.getDialingCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connectcampaigns.CfnCampaign.ProgressiveDialerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProgressiveDialerConfigProperty.Jsii$Proxy that = (ProgressiveDialerConfigProperty.Jsii$Proxy) o;

                if (!bandwidthAllocation.equals(that.bandwidthAllocation)) return false;
                return this.dialingCapacity != null ? this.dialingCapacity.equals(that.dialingCapacity) : that.dialingCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bandwidthAllocation.hashCode();
                result = 31 * result + (this.dialingCapacity != null ? this.dialingCapacity.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.connectcampaigns.CfnCampaign}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.connectcampaigns.CfnCampaign> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.connectcampaigns.CfnCampaignProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.connectcampaigns.CfnCampaignProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the Amazon Connect instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-connectinstancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-connectinstancearn</a>
         * @param connectInstanceArn The Amazon Resource Name (ARN) of the Amazon Connect instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectInstanceArn(final java.lang.String connectInstanceArn) {
            this.props.connectInstanceArn(connectInstanceArn);
            return this;
        }

        /**
         * Contains information about the dialer configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-dialerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-dialerconfig</a>
         * @param dialerConfig Contains information about the dialer configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dialerConfig(final software.amazon.awscdk.IResolvable dialerConfig) {
            this.props.dialerConfig(dialerConfig);
            return this;
        }
        /**
         * Contains information about the dialer configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-dialerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-dialerconfig</a>
         * @param dialerConfig Contains information about the dialer configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dialerConfig(final software.amazon.awscdk.services.connectcampaigns.CfnCampaign.DialerConfigProperty dialerConfig) {
            this.props.dialerConfig(dialerConfig);
            return this;
        }

        /**
         * The name of the campaign.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-name</a>
         * @param name The name of the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Contains information about the outbound call configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-outboundcallconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-outboundcallconfig</a>
         * @param outboundCallConfig Contains information about the outbound call configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outboundCallConfig(final software.amazon.awscdk.IResolvable outboundCallConfig) {
            this.props.outboundCallConfig(outboundCallConfig);
            return this;
        }
        /**
         * Contains information about the outbound call configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-outboundcallconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-outboundcallconfig</a>
         * @param outboundCallConfig Contains information about the outbound call configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outboundCallConfig(final software.amazon.awscdk.services.connectcampaigns.CfnCampaign.OutboundCallConfigProperty outboundCallConfig) {
            this.props.outboundCallConfig(outboundCallConfig);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for this resource.
         * <p>
         * For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connectcampaigns-campaign.html#cfn-connectcampaigns-campaign-tags</a>
         * @param tags The tags used to organize, track, or control access for this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.connectcampaigns.CfnCampaign}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.connectcampaigns.CfnCampaign build() {
            return new software.amazon.awscdk.services.connectcampaigns.CfnCampaign(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
