package software.amazon.awscdk.services.datazone;

/**
 * Properties for defining a <code>CfnEnvironmentProfile</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datazone.*;
 * CfnEnvironmentProfileProps cfnEnvironmentProfileProps = CfnEnvironmentProfileProps.builder()
 *         .awsAccountId("awsAccountId")
 *         .awsAccountRegion("awsAccountRegion")
 *         .domainIdentifier("domainIdentifier")
 *         .environmentBlueprintIdentifier("environmentBlueprintIdentifier")
 *         .name("name")
 *         .projectIdentifier("projectIdentifier")
 *         // the properties below are optional
 *         .description("description")
 *         .userParameters(List.of(EnvironmentParameterProperty.builder()
 *                 .name("name")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:30.012Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnEnvironmentProfileProps")
@software.amazon.jsii.Jsii.Proxy(CfnEnvironmentProfileProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEnvironmentProfileProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of an AWS account in which an environment profile exists.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-awsaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-awsaccountid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAwsAccountId();

    /**
     * The AWS Region in which an environment profile exists.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-awsaccountregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-awsaccountregion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAwsAccountRegion();

    /**
     * The identifier of the Amazon DataZone domain in which the environment profile exists.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-domainidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-domainidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainIdentifier();

    /**
     * The identifier of a blueprint with which an environment profile is created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-environmentblueprintidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-environmentblueprintidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentBlueprintIdentifier();

    /**
     * The name of the environment profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The identifier of a project in which an environment profile exists.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-projectidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-projectidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProjectIdentifier();

    /**
     * The description of the environment profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The user parameters of this Amazon DataZone environment profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-userparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-environmentprofile.html#cfn-datazone-environmentprofile-userparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUserParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEnvironmentProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEnvironmentProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEnvironmentProfileProps> {
        java.lang.String awsAccountId;
        java.lang.String awsAccountRegion;
        java.lang.String domainIdentifier;
        java.lang.String environmentBlueprintIdentifier;
        java.lang.String name;
        java.lang.String projectIdentifier;
        java.lang.String description;
        java.lang.Object userParameters;

        /**
         * Sets the value of {@link CfnEnvironmentProfileProps#getAwsAccountId}
         * @param awsAccountId The identifier of an AWS account in which an environment profile exists. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(java.lang.String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProfileProps#getAwsAccountRegion}
         * @param awsAccountRegion The AWS Region in which an environment profile exists. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountRegion(java.lang.String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProfileProps#getDomainIdentifier}
         * @param domainIdentifier The identifier of the Amazon DataZone domain in which the environment profile exists. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIdentifier(java.lang.String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProfileProps#getEnvironmentBlueprintIdentifier}
         * @param environmentBlueprintIdentifier The identifier of a blueprint with which an environment profile is created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentBlueprintIdentifier(java.lang.String environmentBlueprintIdentifier) {
            this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProfileProps#getName}
         * @param name The name of the environment profile. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProfileProps#getProjectIdentifier}
         * @param projectIdentifier The identifier of a project in which an environment profile exists. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectIdentifier(java.lang.String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProfileProps#getDescription}
         * @param description The description of the environment profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProfileProps#getUserParameters}
         * @param userParameters The user parameters of this Amazon DataZone environment profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userParameters(software.amazon.awscdk.IResolvable userParameters) {
            this.userParameters = userParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProfileProps#getUserParameters}
         * @param userParameters The user parameters of this Amazon DataZone environment profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userParameters(java.util.List<? extends java.lang.Object> userParameters) {
            this.userParameters = userParameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEnvironmentProfileProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEnvironmentProfileProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEnvironmentProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEnvironmentProfileProps {
        private final java.lang.String awsAccountId;
        private final java.lang.String awsAccountRegion;
        private final java.lang.String domainIdentifier;
        private final java.lang.String environmentBlueprintIdentifier;
        private final java.lang.String name;
        private final java.lang.String projectIdentifier;
        private final java.lang.String description;
        private final java.lang.Object userParameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.awsAccountRegion = software.amazon.jsii.Kernel.get(this, "awsAccountRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainIdentifier = software.amazon.jsii.Kernel.get(this, "domainIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentBlueprintIdentifier = software.amazon.jsii.Kernel.get(this, "environmentBlueprintIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.projectIdentifier = software.amazon.jsii.Kernel.get(this, "projectIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userParameters = software.amazon.jsii.Kernel.get(this, "userParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.awsAccountId = java.util.Objects.requireNonNull(builder.awsAccountId, "awsAccountId is required");
            this.awsAccountRegion = java.util.Objects.requireNonNull(builder.awsAccountRegion, "awsAccountRegion is required");
            this.domainIdentifier = java.util.Objects.requireNonNull(builder.domainIdentifier, "domainIdentifier is required");
            this.environmentBlueprintIdentifier = java.util.Objects.requireNonNull(builder.environmentBlueprintIdentifier, "environmentBlueprintIdentifier is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.projectIdentifier = java.util.Objects.requireNonNull(builder.projectIdentifier, "projectIdentifier is required");
            this.description = builder.description;
            this.userParameters = builder.userParameters;
        }

        @Override
        public final java.lang.String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final java.lang.String getAwsAccountRegion() {
            return this.awsAccountRegion;
        }

        @Override
        public final java.lang.String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        @Override
        public final java.lang.String getEnvironmentBlueprintIdentifier() {
            return this.environmentBlueprintIdentifier;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getProjectIdentifier() {
            return this.projectIdentifier;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getUserParameters() {
            return this.userParameters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
            data.set("awsAccountRegion", om.valueToTree(this.getAwsAccountRegion()));
            data.set("domainIdentifier", om.valueToTree(this.getDomainIdentifier()));
            data.set("environmentBlueprintIdentifier", om.valueToTree(this.getEnvironmentBlueprintIdentifier()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("projectIdentifier", om.valueToTree(this.getProjectIdentifier()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getUserParameters() != null) {
                data.set("userParameters", om.valueToTree(this.getUserParameters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnEnvironmentProfileProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEnvironmentProfileProps.Jsii$Proxy that = (CfnEnvironmentProfileProps.Jsii$Proxy) o;

            if (!awsAccountId.equals(that.awsAccountId)) return false;
            if (!awsAccountRegion.equals(that.awsAccountRegion)) return false;
            if (!domainIdentifier.equals(that.domainIdentifier)) return false;
            if (!environmentBlueprintIdentifier.equals(that.environmentBlueprintIdentifier)) return false;
            if (!name.equals(that.name)) return false;
            if (!projectIdentifier.equals(that.projectIdentifier)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.userParameters != null ? this.userParameters.equals(that.userParameters) : that.userParameters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.awsAccountId.hashCode();
            result = 31 * result + (this.awsAccountRegion.hashCode());
            result = 31 * result + (this.domainIdentifier.hashCode());
            result = 31 * result + (this.environmentBlueprintIdentifier.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.projectIdentifier.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.userParameters != null ? this.userParameters.hashCode() : 0);
            return result;
        }
    }
}
