package software.amazon.awscdk.services.devicefarm;

/**
 * Represents a request to the create device pool operation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.devicefarm.*;
 * CfnDevicePool cfnDevicePool = CfnDevicePool.Builder.create(this, "MyCfnDevicePool")
 *         .name("name")
 *         .projectArn("projectArn")
 *         .rules(List.of(RuleProperty.builder()
 *                 .attribute("attribute")
 *                 .operator("operator")
 *                 .value("value")
 *                 .build()))
 *         // the properties below are optional
 *         .description("description")
 *         .maxDevices(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-devicepool.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-devicepool.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:30.087Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_devicefarm.CfnDevicePool")
public class CfnDevicePool extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnDevicePool(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDevicePool(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.devicefarm.CfnDevicePool.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDevicePool(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.devicefarm.CfnDevicePoolProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the device pool.
     * <p>
     * See <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource names</a> in the <em>General Reference guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The device pool's name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The device pool's name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The ARN of the project for the device pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProjectArn() {
        return software.amazon.jsii.Kernel.get(this, "projectArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the project for the device pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProjectArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "projectArn", java.util.Objects.requireNonNull(value, "projectArn is required"));
    }

    /**
     * The device pool's rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRules() {
        return software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The device pool's rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRules(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rules", java.util.Objects.requireNonNull(value, "rules is required"));
    }

    /**
     * The device pool's rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRules(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.devicefarm.CfnDevicePool.RuleProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.devicefarm.CfnDevicePool.RuleProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "rules", java.util.Objects.requireNonNull(value, "rules is required"));
    }

    /**
     * The device pool's description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The device pool's description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The number of devices that Device Farm can add to your device pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxDevices() {
        return software.amazon.jsii.Kernel.get(this, "maxDevices", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of devices that Device Farm can add to your device pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxDevices(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxDevices", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Represents a condition for a device pool.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.devicefarm.*;
     * RuleProperty ruleProperty = RuleProperty.builder()
     *         .attribute("attribute")
     *         .operator("operator")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devicefarm-devicepool-rule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devicefarm-devicepool-rule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_devicefarm.CfnDevicePool.RuleProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code> .
         * <p>
         * The supported operators for each attribute are provided in the following list.
         * <p>
         * <ul>
         * <li><strong>APPIUM_VERSION</strong> - The Appium version for the test.</li>
         * </ul>
         * <p>
         * Supported operators: <code>CONTAINS</code>
         * <p>
         * <ul>
         * <li><strong>ARN</strong> - The Amazon Resource Name (ARN) of the device (for example, <code>arn:aws:devicefarm:us-west-2::device:12345Example</code> .</li>
         * </ul>
         * <p>
         * Supported operators: <code>EQUALS</code> , <code>IN</code> , <code>NOT_IN</code>
         * <p>
         * <ul>
         * <li><strong>AVAILABILITY</strong> - The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</li>
         * </ul>
         * <p>
         * Supported operators: <code>EQUALS</code>
         * <p>
         * <ul>
         * <li><strong>FLEET_TYPE</strong> - The fleet type. Valid values are PUBLIC or PRIVATE.</li>
         * </ul>
         * <p>
         * Supported operators: <code>EQUALS</code>
         * <p>
         * <ul>
         * <li><strong>FORM_FACTOR</strong> - The device form factor. Valid values are PHONE or TABLET.</li>
         * </ul>
         * <p>
         * Supported operators: <code>EQUALS</code> , <code>IN</code> , <code>NOT_IN</code>
         * <p>
         * <ul>
         * <li><strong>INSTANCE_ARN</strong> - The Amazon Resource Name (ARN) of the device instance.</li>
         * </ul>
         * <p>
         * Supported operators: <code>IN</code> , <code>NOT_IN</code>
         * <p>
         * <ul>
         * <li><strong>INSTANCE_LABELS</strong> - The label of the device instance.</li>
         * </ul>
         * <p>
         * Supported operators: <code>CONTAINS</code>
         * <p>
         * <ul>
         * <li><strong>MANUFACTURER</strong> - The device manufacturer (for example, Apple).</li>
         * </ul>
         * <p>
         * Supported operators: <code>EQUALS</code> , <code>IN</code> , <code>NOT_IN</code>
         * <p>
         * <ul>
         * <li><strong>MODEL</strong> - The device model, such as Apple iPad Air 2 or Google Pixel.</li>
         * </ul>
         * <p>
         * Supported operators: <code>CONTAINS</code> , <code>EQUALS</code> , <code>IN</code> , <code>NOT_IN</code>
         * <p>
         * <ul>
         * <li><strong>OS_VERSION</strong> - The operating system version (for example, 10.3.2).</li>
         * </ul>
         * <p>
         * Supported operators: <code>EQUALS</code> , <code>GREATER_THAN</code> , <code>GREATER_THAN_OR_EQUALS</code> , <code>IN</code> , <code>LESS_THAN</code> , <code>LESS_THAN_OR_EQUALS</code> , <code>NOT_IN</code>
         * <p>
         * <ul>
         * <li><strong>PLATFORM</strong> - The device platform. Valid values are ANDROID or IOS.</li>
         * </ul>
         * <p>
         * Supported operators: <code>EQUALS</code> , <code>IN</code> , <code>NOT_IN</code>
         * <p>
         * <ul>
         * <li><strong>REMOTE_ACCESS_ENABLED</strong> - Whether the device is enabled for remote access. Valid values are TRUE or FALSE.</li>
         * </ul>
         * <p>
         * Supported operators: <code>EQUALS</code>
         * <p>
         * <ul>
         * <li><strong>REMOTE_DEBUG_ENABLED</strong> - Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.</li>
         * </ul>
         * <p>
         * Supported operators: <code>EQUALS</code>
         * <p>
         * Because remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a> , this filter is ignored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devicefarm-devicepool-rule.html#cfn-devicefarm-devicepool-rule-attribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devicefarm-devicepool-rule.html#cfn-devicefarm-devicepool-rule-attribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAttribute() {
            return null;
        }

        /**
         * Specifies how Device Farm compares the rule's attribute to the value.
         * <p>
         * For the operators that are supported by each attribute, see the attribute descriptions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devicefarm-devicepool-rule.html#cfn-devicefarm-devicepool-rule-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devicefarm-devicepool-rule.html#cfn-devicefarm-devicepool-rule-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOperator() {
            return null;
        }

        /**
         * The rule's value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devicefarm-devicepool-rule.html#cfn-devicefarm-devicepool-rule-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devicefarm-devicepool-rule.html#cfn-devicefarm-devicepool-rule-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleProperty> {
            java.lang.String attribute;
            java.lang.String operator;
            java.lang.String value;

            /**
             * Sets the value of {@link RuleProperty#getAttribute}
             * @param attribute The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code> .
             *                  The supported operators for each attribute are provided in the following list.
             *                  <p>
             *                  <ul>
             *                  <li><strong>APPIUM_VERSION</strong> - The Appium version for the test.</li>
             *                  </ul>
             *                  <p>
             *                  Supported operators: <code>CONTAINS</code>
             *                  <p>
             *                  <ul>
             *                  <li><strong>ARN</strong> - The Amazon Resource Name (ARN) of the device (for example, <code>arn:aws:devicefarm:us-west-2::device:12345Example</code> .</li>
             *                  </ul>
             *                  <p>
             *                  Supported operators: <code>EQUALS</code> , <code>IN</code> , <code>NOT_IN</code>
             *                  <p>
             *                  <ul>
             *                  <li><strong>AVAILABILITY</strong> - The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.</li>
             *                  </ul>
             *                  <p>
             *                  Supported operators: <code>EQUALS</code>
             *                  <p>
             *                  <ul>
             *                  <li><strong>FLEET_TYPE</strong> - The fleet type. Valid values are PUBLIC or PRIVATE.</li>
             *                  </ul>
             *                  <p>
             *                  Supported operators: <code>EQUALS</code>
             *                  <p>
             *                  <ul>
             *                  <li><strong>FORM_FACTOR</strong> - The device form factor. Valid values are PHONE or TABLET.</li>
             *                  </ul>
             *                  <p>
             *                  Supported operators: <code>EQUALS</code> , <code>IN</code> , <code>NOT_IN</code>
             *                  <p>
             *                  <ul>
             *                  <li><strong>INSTANCE_ARN</strong> - The Amazon Resource Name (ARN) of the device instance.</li>
             *                  </ul>
             *                  <p>
             *                  Supported operators: <code>IN</code> , <code>NOT_IN</code>
             *                  <p>
             *                  <ul>
             *                  <li><strong>INSTANCE_LABELS</strong> - The label of the device instance.</li>
             *                  </ul>
             *                  <p>
             *                  Supported operators: <code>CONTAINS</code>
             *                  <p>
             *                  <ul>
             *                  <li><strong>MANUFACTURER</strong> - The device manufacturer (for example, Apple).</li>
             *                  </ul>
             *                  <p>
             *                  Supported operators: <code>EQUALS</code> , <code>IN</code> , <code>NOT_IN</code>
             *                  <p>
             *                  <ul>
             *                  <li><strong>MODEL</strong> - The device model, such as Apple iPad Air 2 or Google Pixel.</li>
             *                  </ul>
             *                  <p>
             *                  Supported operators: <code>CONTAINS</code> , <code>EQUALS</code> , <code>IN</code> , <code>NOT_IN</code>
             *                  <p>
             *                  <ul>
             *                  <li><strong>OS_VERSION</strong> - The operating system version (for example, 10.3.2).</li>
             *                  </ul>
             *                  <p>
             *                  Supported operators: <code>EQUALS</code> , <code>GREATER_THAN</code> , <code>GREATER_THAN_OR_EQUALS</code> , <code>IN</code> , <code>LESS_THAN</code> , <code>LESS_THAN_OR_EQUALS</code> , <code>NOT_IN</code>
             *                  <p>
             *                  <ul>
             *                  <li><strong>PLATFORM</strong> - The device platform. Valid values are ANDROID or IOS.</li>
             *                  </ul>
             *                  <p>
             *                  Supported operators: <code>EQUALS</code> , <code>IN</code> , <code>NOT_IN</code>
             *                  <p>
             *                  <ul>
             *                  <li><strong>REMOTE_ACCESS_ENABLED</strong> - Whether the device is enabled for remote access. Valid values are TRUE or FALSE.</li>
             *                  </ul>
             *                  <p>
             *                  Supported operators: <code>EQUALS</code>
             *                  <p>
             *                  <ul>
             *                  <li><strong>REMOTE_DEBUG_ENABLED</strong> - Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.</li>
             *                  </ul>
             *                  <p>
             *                  Supported operators: <code>EQUALS</code>
             *                  <p>
             *                  Because remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a> , this filter is ignored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attribute(java.lang.String attribute) {
                this.attribute = attribute;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getOperator}
             * @param operator Specifies how Device Farm compares the rule's attribute to the value.
             *                 For the operators that are supported by each attribute, see the attribute descriptions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getValue}
             * @param value The rule's value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleProperty {
            private final java.lang.String attribute;
            private final java.lang.String operator;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attribute = software.amazon.jsii.Kernel.get(this, "attribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attribute = builder.attribute;
                this.operator = builder.operator;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getAttribute() {
                return this.attribute;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttribute() != null) {
                    data.set("attribute", om.valueToTree(this.getAttribute()));
                }
                if (this.getOperator() != null) {
                    data.set("operator", om.valueToTree(this.getOperator()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_devicefarm.CfnDevicePool.RuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleProperty.Jsii$Proxy that = (RuleProperty.Jsii$Proxy) o;

                if (this.attribute != null ? !this.attribute.equals(that.attribute) : that.attribute != null) return false;
                if (this.operator != null ? !this.operator.equals(that.operator) : that.operator != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attribute != null ? this.attribute.hashCode() : 0;
                result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.devicefarm.CfnDevicePool}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.devicefarm.CfnDevicePool> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.devicefarm.CfnDevicePoolProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.devicefarm.CfnDevicePoolProps.Builder();
        }

        /**
         * The device pool's name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-devicepool.html#cfn-devicefarm-devicepool-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-devicepool.html#cfn-devicefarm-devicepool-name</a>
         * @param name The device pool's name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The ARN of the project for the device pool.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-devicepool.html#cfn-devicefarm-devicepool-projectarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-devicepool.html#cfn-devicefarm-devicepool-projectarn</a>
         * @param projectArn The ARN of the project for the device pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectArn(final java.lang.String projectArn) {
            this.props.projectArn(projectArn);
            return this;
        }

        /**
         * The device pool's rules.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-devicepool.html#cfn-devicefarm-devicepool-rules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-devicepool.html#cfn-devicefarm-devicepool-rules</a>
         * @param rules The device pool's rules. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rules(final software.amazon.awscdk.IResolvable rules) {
            this.props.rules(rules);
            return this;
        }
        /**
         * The device pool's rules.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-devicepool.html#cfn-devicefarm-devicepool-rules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-devicepool.html#cfn-devicefarm-devicepool-rules</a>
         * @param rules The device pool's rules. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rules(final java.util.List<? extends java.lang.Object> rules) {
            this.props.rules(rules);
            return this;
        }

        /**
         * The device pool's description.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-devicepool.html#cfn-devicefarm-devicepool-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-devicepool.html#cfn-devicefarm-devicepool-description</a>
         * @param description The device pool's description. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The number of devices that Device Farm can add to your device pool.
         * <p>
         * Device Farm adds devices that are available and meet the criteria that you assign for the <code>rules</code> parameter. Depending on how many devices meet these constraints, your device pool might contain fewer devices than the value for this parameter.
         * <p>
         * By specifying the maximum number of devices, you can control the costs that you incur by running tests.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-devicepool.html#cfn-devicefarm-devicepool-maxdevices">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-devicepool.html#cfn-devicefarm-devicepool-maxdevices</a>
         * @param maxDevices The number of devices that Device Farm can add to your device pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxDevices(final java.lang.Number maxDevices) {
            this.props.maxDevices(maxDevices);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-devicepool.html#cfn-devicefarm-devicepool-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-devicepool.html#cfn-devicefarm-devicepool-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.devicefarm.CfnDevicePool}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.devicefarm.CfnDevicePool build() {
            return new software.amazon.awscdk.services.devicefarm.CfnDevicePool(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
