package software.amazon.awscdk.services.devicefarm;

/**
 * Properties for defining a <code>CfnInstanceProfile</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.devicefarm.*;
 * CfnInstanceProfileProps cfnInstanceProfileProps = CfnInstanceProfileProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .excludeAppPackagesFromCleanup(List.of("excludeAppPackagesFromCleanup"))
 *         .packageCleanup(false)
 *         .rebootAfterUse(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-instanceprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-instanceprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:30.091Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_devicefarm.CfnInstanceProfileProps")
@software.amazon.jsii.Jsii.Proxy(CfnInstanceProfileProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInstanceProfileProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the instance profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-instanceprofile.html#cfn-devicefarm-instanceprofile-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-instanceprofile.html#cfn-devicefarm-instanceprofile-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The description of the instance profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-instanceprofile.html#cfn-devicefarm-instanceprofile-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-instanceprofile.html#cfn-devicefarm-instanceprofile-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * An array of strings containing the list of app packages that should not be cleaned up from the device after a test run completes.
     * <p>
     * The list of packages is considered only if you set <code>packageCleanup</code> to <code>true</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-instanceprofile.html#cfn-devicefarm-instanceprofile-excludeapppackagesfromcleanup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-instanceprofile.html#cfn-devicefarm-instanceprofile-excludeapppackagesfromcleanup</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludeAppPackagesFromCleanup() {
        return null;
    }

    /**
     * When set to <code>true</code> , Device Farm removes app packages after a test run.
     * <p>
     * The default value is <code>false</code> for private devices.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-instanceprofile.html#cfn-devicefarm-instanceprofile-packagecleanup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-instanceprofile.html#cfn-devicefarm-instanceprofile-packagecleanup</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPackageCleanup() {
        return null;
    }

    /**
     * When set to <code>true</code> , Device Farm reboots the instance after a test run.
     * <p>
     * The default value is <code>true</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-instanceprofile.html#cfn-devicefarm-instanceprofile-rebootafteruse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-instanceprofile.html#cfn-devicefarm-instanceprofile-rebootafteruse</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRebootAfterUse() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-instanceprofile.html#cfn-devicefarm-instanceprofile-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devicefarm-instanceprofile.html#cfn-devicefarm-instanceprofile-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInstanceProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInstanceProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInstanceProfileProps> {
        java.lang.String name;
        java.lang.String description;
        java.util.List<java.lang.String> excludeAppPackagesFromCleanup;
        java.lang.Object packageCleanup;
        java.lang.Object rebootAfterUse;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnInstanceProfileProps#getName}
         * @param name The name of the instance profile. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProfileProps#getDescription}
         * @param description The description of the instance profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProfileProps#getExcludeAppPackagesFromCleanup}
         * @param excludeAppPackagesFromCleanup An array of strings containing the list of app packages that should not be cleaned up from the device after a test run completes.
         *                                      The list of packages is considered only if you set <code>packageCleanup</code> to <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeAppPackagesFromCleanup(java.util.List<java.lang.String> excludeAppPackagesFromCleanup) {
            this.excludeAppPackagesFromCleanup = excludeAppPackagesFromCleanup;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProfileProps#getPackageCleanup}
         * @param packageCleanup When set to <code>true</code> , Device Farm removes app packages after a test run.
         *                       The default value is <code>false</code> for private devices.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packageCleanup(java.lang.Boolean packageCleanup) {
            this.packageCleanup = packageCleanup;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProfileProps#getPackageCleanup}
         * @param packageCleanup When set to <code>true</code> , Device Farm removes app packages after a test run.
         *                       The default value is <code>false</code> for private devices.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packageCleanup(software.amazon.awscdk.IResolvable packageCleanup) {
            this.packageCleanup = packageCleanup;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProfileProps#getRebootAfterUse}
         * @param rebootAfterUse When set to <code>true</code> , Device Farm reboots the instance after a test run.
         *                       The default value is <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rebootAfterUse(java.lang.Boolean rebootAfterUse) {
            this.rebootAfterUse = rebootAfterUse;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProfileProps#getRebootAfterUse}
         * @param rebootAfterUse When set to <code>true</code> , Device Farm reboots the instance after a test run.
         *                       The default value is <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rebootAfterUse(software.amazon.awscdk.IResolvable rebootAfterUse) {
            this.rebootAfterUse = rebootAfterUse;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProfileProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInstanceProfileProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInstanceProfileProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInstanceProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInstanceProfileProps {
        private final java.lang.String name;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> excludeAppPackagesFromCleanup;
        private final java.lang.Object packageCleanup;
        private final java.lang.Object rebootAfterUse;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.excludeAppPackagesFromCleanup = software.amazon.jsii.Kernel.get(this, "excludeAppPackagesFromCleanup", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.packageCleanup = software.amazon.jsii.Kernel.get(this, "packageCleanup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.rebootAfterUse = software.amazon.jsii.Kernel.get(this, "rebootAfterUse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.description = builder.description;
            this.excludeAppPackagesFromCleanup = builder.excludeAppPackagesFromCleanup;
            this.packageCleanup = builder.packageCleanup;
            this.rebootAfterUse = builder.rebootAfterUse;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<java.lang.String> getExcludeAppPackagesFromCleanup() {
            return this.excludeAppPackagesFromCleanup;
        }

        @Override
        public final java.lang.Object getPackageCleanup() {
            return this.packageCleanup;
        }

        @Override
        public final java.lang.Object getRebootAfterUse() {
            return this.rebootAfterUse;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getExcludeAppPackagesFromCleanup() != null) {
                data.set("excludeAppPackagesFromCleanup", om.valueToTree(this.getExcludeAppPackagesFromCleanup()));
            }
            if (this.getPackageCleanup() != null) {
                data.set("packageCleanup", om.valueToTree(this.getPackageCleanup()));
            }
            if (this.getRebootAfterUse() != null) {
                data.set("rebootAfterUse", om.valueToTree(this.getRebootAfterUse()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_devicefarm.CfnInstanceProfileProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInstanceProfileProps.Jsii$Proxy that = (CfnInstanceProfileProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.excludeAppPackagesFromCleanup != null ? !this.excludeAppPackagesFromCleanup.equals(that.excludeAppPackagesFromCleanup) : that.excludeAppPackagesFromCleanup != null) return false;
            if (this.packageCleanup != null ? !this.packageCleanup.equals(that.packageCleanup) : that.packageCleanup != null) return false;
            if (this.rebootAfterUse != null ? !this.rebootAfterUse.equals(that.rebootAfterUse) : that.rebootAfterUse != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.excludeAppPackagesFromCleanup != null ? this.excludeAppPackagesFromCleanup.hashCode() : 0);
            result = 31 * result + (this.packageCleanup != null ? this.packageCleanup.hashCode() : 0);
            result = 31 * result + (this.rebootAfterUse != null ? this.rebootAfterUse.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
