package software.amazon.awscdk.services.dlm;

/**
 * Specifies a lifecycle policy, which is used to automate operations on Amazon EBS resources.
 * <p>
 * The properties are required when you add a lifecycle policy and optional when you update a lifecycle policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dlm.*;
 * Object crossRegionCopyTargets;
 * Object excludeTags;
 * Object excludeVolumeTypes;
 * CfnLifecyclePolicy cfnLifecyclePolicy = CfnLifecyclePolicy.Builder.create(this, "MyCfnLifecyclePolicy")
 *         .copyTags(false)
 *         .createInterval(123)
 *         .crossRegionCopyTargets(crossRegionCopyTargets)
 *         .defaultPolicy("defaultPolicy")
 *         .description("description")
 *         .exclusions(ExclusionsProperty.builder()
 *                 .excludeBootVolumes(false)
 *                 .excludeTags(excludeTags)
 *                 .excludeVolumeTypes(excludeVolumeTypes)
 *                 .build())
 *         .executionRoleArn("executionRoleArn")
 *         .extendDeletion(false)
 *         .policyDetails(PolicyDetailsProperty.builder()
 *                 .actions(List.of(ActionProperty.builder()
 *                         .crossRegionCopy(List.of(CrossRegionCopyActionProperty.builder()
 *                                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                         .encrypted(false)
 *                                         // the properties below are optional
 *                                         .cmkArn("cmkArn")
 *                                         .build())
 *                                 .target("target")
 *                                 // the properties below are optional
 *                                 .retainRule(CrossRegionCopyRetainRuleProperty.builder()
 *                                         .interval(123)
 *                                         .intervalUnit("intervalUnit")
 *                                         .build())
 *                                 .build()))
 *                         .name("name")
 *                         .build()))
 *                 .copyTags(false)
 *                 .createInterval(123)
 *                 .crossRegionCopyTargets(crossRegionCopyTargets)
 *                 .eventSource(EventSourceProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .parameters(EventParametersProperty.builder()
 *                                 .eventType("eventType")
 *                                 .snapshotOwner(List.of("snapshotOwner"))
 *                                 // the properties below are optional
 *                                 .descriptionRegex("descriptionRegex")
 *                                 .build())
 *                         .build())
 *                 .exclusions(ExclusionsProperty.builder()
 *                         .excludeBootVolumes(false)
 *                         .excludeTags(excludeTags)
 *                         .excludeVolumeTypes(excludeVolumeTypes)
 *                         .build())
 *                 .extendDeletion(false)
 *                 .parameters(ParametersProperty.builder()
 *                         .excludeBootVolume(false)
 *                         .excludeDataVolumeTags(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .noReboot(false)
 *                         .build())
 *                 .policyLanguage("policyLanguage")
 *                 .policyType("policyType")
 *                 .resourceLocations(List.of("resourceLocations"))
 *                 .resourceType("resourceType")
 *                 .resourceTypes(List.of("resourceTypes"))
 *                 .retainInterval(123)
 *                 .schedules(List.of(ScheduleProperty.builder()
 *                         .archiveRule(ArchiveRuleProperty.builder()
 *                                 .retainRule(ArchiveRetainRuleProperty.builder()
 *                                         .retentionArchiveTier(RetentionArchiveTierProperty.builder()
 *                                                 .count(123)
 *                                                 .interval(123)
 *                                                 .intervalUnit("intervalUnit")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .copyTags(false)
 *                         .createRule(CreateRuleProperty.builder()
 *                                 .cronExpression("cronExpression")
 *                                 .interval(123)
 *                                 .intervalUnit("intervalUnit")
 *                                 .location("location")
 *                                 .scripts(List.of(ScriptProperty.builder()
 *                                         .executeOperationOnScriptFailure(false)
 *                                         .executionHandler("executionHandler")
 *                                         .executionHandlerService("executionHandlerService")
 *                                         .executionTimeout(123)
 *                                         .maximumRetryCount(123)
 *                                         .stages(List.of("stages"))
 *                                         .build()))
 *                                 .times(List.of("times"))
 *                                 .build())
 *                         .crossRegionCopyRules(List.of(CrossRegionCopyRuleProperty.builder()
 *                                 .encrypted(false)
 *                                 // the properties below are optional
 *                                 .cmkArn("cmkArn")
 *                                 .copyTags(false)
 *                                 .deprecateRule(CrossRegionCopyDeprecateRuleProperty.builder()
 *                                         .interval(123)
 *                                         .intervalUnit("intervalUnit")
 *                                         .build())
 *                                 .retainRule(CrossRegionCopyRetainRuleProperty.builder()
 *                                         .interval(123)
 *                                         .intervalUnit("intervalUnit")
 *                                         .build())
 *                                 .target("target")
 *                                 .targetRegion("targetRegion")
 *                                 .build()))
 *                         .deprecateRule(DeprecateRuleProperty.builder()
 *                                 .count(123)
 *                                 .interval(123)
 *                                 .intervalUnit("intervalUnit")
 *                                 .build())
 *                         .fastRestoreRule(FastRestoreRuleProperty.builder()
 *                                 .availabilityZones(List.of("availabilityZones"))
 *                                 .count(123)
 *                                 .interval(123)
 *                                 .intervalUnit("intervalUnit")
 *                                 .build())
 *                         .name("name")
 *                         .retainRule(RetainRuleProperty.builder()
 *                                 .count(123)
 *                                 .interval(123)
 *                                 .intervalUnit("intervalUnit")
 *                                 .build())
 *                         .shareRules(List.of(ShareRuleProperty.builder()
 *                                 .targetAccounts(List.of("targetAccounts"))
 *                                 .unshareInterval(123)
 *                                 .unshareIntervalUnit("unshareIntervalUnit")
 *                                 .build()))
 *                         .tagsToAdd(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .variableTags(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .build()))
 *                 .targetTags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .retainInterval(123)
 *         .state("state")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:30.128Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy")
public class CfnLifecyclePolicy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnLifecyclePolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLifecyclePolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLifecyclePolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dlm.CfnLifecyclePolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLifecyclePolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * <em>[Default policies only]</em> Indicates whether the policy should copy tags from the source resource to the snapshot or AMI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCopyTags() {
        return software.amazon.jsii.Kernel.get(this, "copyTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * <em>[Default policies only]</em> Indicates whether the policy should copy tags from the source resource to the snapshot or AMI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCopyTags(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "copyTags", value);
    }

    /**
     * <em>[Default policies only]</em> Indicates whether the policy should copy tags from the source resource to the snapshot or AMI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCopyTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "copyTags", value);
    }

    /**
     * <em>[Default policies only]</em> Specifies how often the policy should run and create snapshots or AMIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getCreateInterval() {
        return software.amazon.jsii.Kernel.get(this, "createInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * <em>[Default policies only]</em> Specifies how often the policy should run and create snapshots or AMIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCreateInterval(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "createInterval", value);
    }

    /**
     * <em>[Default policies only]</em> Specifies destination Regions for snapshot or AMI copies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCrossRegionCopyTargets() {
        return software.amazon.jsii.Kernel.get(this, "crossRegionCopyTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * <em>[Default policies only]</em> Specifies destination Regions for snapshot or AMI copies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCrossRegionCopyTargets(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "crossRegionCopyTargets", value);
    }

    /**
     * <em>[Default policies only]</em> Specify the type of default policy to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultPolicy() {
        return software.amazon.jsii.Kernel.get(this, "defaultPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * <em>[Default policies only]</em> Specify the type of default policy to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultPolicy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultPolicy", value);
    }

    /**
     * A description of the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * <em>[Default policies only]</em> Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getExclusions() {
        return software.amazon.jsii.Kernel.get(this, "exclusions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * <em>[Default policies only]</em> Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExclusions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "exclusions", value);
    }

    /**
     * <em>[Default policies only]</em> Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExclusions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.ExclusionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "exclusions", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExecutionRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "executionRoleArn", value);
    }

    /**
     * <em>[Default policies only]</em> Defines the snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getExtendDeletion() {
        return software.amazon.jsii.Kernel.get(this, "extendDeletion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * <em>[Default policies only]</em> Defines the snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExtendDeletion(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "extendDeletion", value);
    }

    /**
     * <em>[Default policies only]</em> Defines the snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExtendDeletion(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "extendDeletion", value);
    }

    /**
     * The configuration details of the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPolicyDetails() {
        return software.amazon.jsii.Kernel.get(this, "policyDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration details of the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "policyDetails", value);
    }

    /**
     * The configuration details of the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.PolicyDetailsProperty value) {
        software.amazon.jsii.Kernel.set(this, "policyDetails", value);
    }

    /**
     * <em>[Default policies only]</em> Specifies how long the policy should retain snapshots or AMIs before deleting them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getRetainInterval() {
        return software.amazon.jsii.Kernel.get(this, "retainInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * <em>[Default policies only]</em> Specifies how long the policy should retain snapshots or AMIs before deleting them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetainInterval(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "retainInterval", value);
    }

    /**
     * The activation state of the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The activation state of the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setState(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "state", value);
    }

    /**
     * The tags to apply to the lifecycle policy during creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags to apply to the lifecycle policy during creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * <em>[Event-based policies only]</em> Specifies an action for an event-based policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * ActionProperty actionProperty = ActionProperty.builder()
     *         .crossRegionCopy(List.of(CrossRegionCopyActionProperty.builder()
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .encrypted(false)
     *                         // the properties below are optional
     *                         .cmkArn("cmkArn")
     *                         .build())
     *                 .target("target")
     *                 // the properties below are optional
     *                 .retainRule(CrossRegionCopyRetainRuleProperty.builder()
     *                         .interval(123)
     *                         .intervalUnit("intervalUnit")
     *                         .build())
     *                 .build()))
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-action.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-action.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The rule for copying shared snapshots across Regions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-action.html#cfn-dlm-lifecyclepolicy-action-crossregioncopy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-action.html#cfn-dlm-lifecyclepolicy-action-crossregioncopy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCrossRegionCopy();

        /**
         * A descriptive name for the action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-action.html#cfn-dlm-lifecyclepolicy-action-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-action.html#cfn-dlm-lifecyclepolicy-action-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionProperty> {
            java.lang.Object crossRegionCopy;
            java.lang.String name;

            /**
             * Sets the value of {@link ActionProperty#getCrossRegionCopy}
             * @param crossRegionCopy The rule for copying shared snapshots across Regions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossRegionCopy(software.amazon.awscdk.IResolvable crossRegionCopy) {
                this.crossRegionCopy = crossRegionCopy;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getCrossRegionCopy}
             * @param crossRegionCopy The rule for copying shared snapshots across Regions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossRegionCopy(java.util.List<? extends java.lang.Object> crossRegionCopy) {
                this.crossRegionCopy = crossRegionCopy;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getName}
             * @param name A descriptive name for the action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionProperty {
            private final java.lang.Object crossRegionCopy;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.crossRegionCopy = software.amazon.jsii.Kernel.get(this, "crossRegionCopy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.crossRegionCopy = java.util.Objects.requireNonNull(builder.crossRegionCopy, "crossRegionCopy is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.Object getCrossRegionCopy() {
                return this.crossRegionCopy;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("crossRegionCopy", om.valueToTree(this.getCrossRegionCopy()));
                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionProperty.Jsii$Proxy that = (ActionProperty.Jsii$Proxy) o;

                if (!crossRegionCopy.equals(that.crossRegionCopy)) return false;
                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.crossRegionCopy.hashCode();
                result = 31 * result + (this.name.hashCode());
                return result;
            }
        }
    }
    /**
     * <em>[Custom snapshot policies only]</em> Specifies information about the archive storage tier retention period.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * ArchiveRetainRuleProperty archiveRetainRuleProperty = ArchiveRetainRuleProperty.builder()
     *         .retentionArchiveTier(RetentionArchiveTierProperty.builder()
     *                 .count(123)
     *                 .interval(123)
     *                 .intervalUnit("intervalUnit")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-archiveretainrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-archiveretainrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ArchiveRetainRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(ArchiveRetainRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArchiveRetainRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about retention period in the Amazon EBS Snapshots Archive.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/snapshot-archive.html">Archive Amazon EBS snapshots</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-archiveretainrule.html#cfn-dlm-lifecyclepolicy-archiveretainrule-retentionarchivetier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-archiveretainrule.html#cfn-dlm-lifecyclepolicy-archiveretainrule-retentionarchivetier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRetentionArchiveTier();

        /**
         * @return a {@link Builder} of {@link ArchiveRetainRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArchiveRetainRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArchiveRetainRuleProperty> {
            java.lang.Object retentionArchiveTier;

            /**
             * Sets the value of {@link ArchiveRetainRuleProperty#getRetentionArchiveTier}
             * @param retentionArchiveTier Information about retention period in the Amazon EBS Snapshots Archive. This parameter is required.
             *                             For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/snapshot-archive.html">Archive Amazon EBS snapshots</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retentionArchiveTier(software.amazon.awscdk.IResolvable retentionArchiveTier) {
                this.retentionArchiveTier = retentionArchiveTier;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveRetainRuleProperty#getRetentionArchiveTier}
             * @param retentionArchiveTier Information about retention period in the Amazon EBS Snapshots Archive. This parameter is required.
             *                             For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/snapshot-archive.html">Archive Amazon EBS snapshots</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retentionArchiveTier(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.RetentionArchiveTierProperty retentionArchiveTier) {
                this.retentionArchiveTier = retentionArchiveTier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArchiveRetainRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArchiveRetainRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArchiveRetainRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArchiveRetainRuleProperty {
            private final java.lang.Object retentionArchiveTier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.retentionArchiveTier = software.amazon.jsii.Kernel.get(this, "retentionArchiveTier", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.retentionArchiveTier = java.util.Objects.requireNonNull(builder.retentionArchiveTier, "retentionArchiveTier is required");
            }

            @Override
            public final java.lang.Object getRetentionArchiveTier() {
                return this.retentionArchiveTier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("retentionArchiveTier", om.valueToTree(this.getRetentionArchiveTier()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ArchiveRetainRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArchiveRetainRuleProperty.Jsii$Proxy that = (ArchiveRetainRuleProperty.Jsii$Proxy) o;

                return this.retentionArchiveTier.equals(that.retentionArchiveTier);
            }

            @Override
            public final int hashCode() {
                int result = this.retentionArchiveTier.hashCode();
                return result;
            }
        }
    }
    /**
     * <em>[Custom snapshot policies only]</em> Specifies a snapshot archiving rule for a schedule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * ArchiveRuleProperty archiveRuleProperty = ArchiveRuleProperty.builder()
     *         .retainRule(ArchiveRetainRuleProperty.builder()
     *                 .retentionArchiveTier(RetentionArchiveTierProperty.builder()
     *                         .count(123)
     *                         .interval(123)
     *                         .intervalUnit("intervalUnit")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-archiverule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-archiverule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ArchiveRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(ArchiveRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArchiveRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about the retention period for the snapshot archiving rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-archiverule.html#cfn-dlm-lifecyclepolicy-archiverule-retainrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-archiverule.html#cfn-dlm-lifecyclepolicy-archiverule-retainrule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRetainRule();

        /**
         * @return a {@link Builder} of {@link ArchiveRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArchiveRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArchiveRuleProperty> {
            java.lang.Object retainRule;

            /**
             * Sets the value of {@link ArchiveRuleProperty#getRetainRule}
             * @param retainRule Information about the retention period for the snapshot archiving rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retainRule(software.amazon.awscdk.IResolvable retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveRuleProperty#getRetainRule}
             * @param retainRule Information about the retention period for the snapshot archiving rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retainRule(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.ArchiveRetainRuleProperty retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArchiveRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArchiveRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArchiveRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArchiveRuleProperty {
            private final java.lang.Object retainRule;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.retainRule = software.amazon.jsii.Kernel.get(this, "retainRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.retainRule = java.util.Objects.requireNonNull(builder.retainRule, "retainRule is required");
            }

            @Override
            public final java.lang.Object getRetainRule() {
                return this.retainRule;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("retainRule", om.valueToTree(this.getRetainRule()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ArchiveRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArchiveRuleProperty.Jsii$Proxy that = (ArchiveRuleProperty.Jsii$Proxy) o;

                return this.retainRule.equals(that.retainRule);
            }

            @Override
            public final int hashCode() {
                int result = this.retainRule.hashCode();
                return result;
            }
        }
    }
    /**
     * <em>[Custom snapshot and AMI policies only]</em> Specifies when the policy should create snapshots or AMIs.
     * <p>
     * <blockquote>
     * <p>
     * <ul>
     * <li>You must specify either <em>CronExpression</em> , or <em>Interval</em> , <em>IntervalUnit</em> , and <em>Times</em> .</li>
     * <li>If you need to specify an <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html">ArchiveRule</a> for the schedule, then you must specify a creation frequency of at least 28 days.</li>
     * </ul>
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * CreateRuleProperty createRuleProperty = CreateRuleProperty.builder()
     *         .cronExpression("cronExpression")
     *         .interval(123)
     *         .intervalUnit("intervalUnit")
     *         .location("location")
     *         .scripts(List.of(ScriptProperty.builder()
     *                 .executeOperationOnScriptFailure(false)
     *                 .executionHandler("executionHandler")
     *                 .executionHandlerService("executionHandlerService")
     *                 .executionTimeout(123)
     *                 .maximumRetryCount(123)
     *                 .stages(List.of("stages"))
     *                 .build()))
     *         .times(List.of("times"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CreateRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(CreateRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CreateRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The schedule, as a Cron expression.
         * <p>
         * The schedule interval must be between 1 hour and 1 year. For more information, see the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-cron-expressions.html">Cron expressions reference</a> in the <em>Amazon EventBridge User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html#cfn-dlm-lifecyclepolicy-createrule-cronexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html#cfn-dlm-lifecyclepolicy-createrule-cronexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCronExpression() {
            return null;
        }

        /**
         * The interval between snapshots.
         * <p>
         * The supported values are 1, 2, 3, 4, 6, 8, 12, and 24.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html#cfn-dlm-lifecyclepolicy-createrule-interval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html#cfn-dlm-lifecyclepolicy-createrule-interval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInterval() {
            return null;
        }

        /**
         * The interval unit.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html#cfn-dlm-lifecyclepolicy-createrule-intervalunit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html#cfn-dlm-lifecyclepolicy-createrule-intervalunit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIntervalUnit() {
            return null;
        }

        /**
         * <em>[Custom snapshot policies only]</em> Specifies the destination for snapshots created by the policy.
         * <p>
         * To create snapshots in the same Region as the source resource, specify <code>CLOUD</code> . To create snapshots on the same Outpost as the source resource, specify <code>OUTPOST_LOCAL</code> . If you omit this parameter, <code>CLOUD</code> is used by default.
         * <p>
         * If the policy targets resources in an AWS Region , then you must create snapshots in the same Region as the source resource. If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost as the source resource, or in the Region of that Outpost.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html#cfn-dlm-lifecyclepolicy-createrule-location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html#cfn-dlm-lifecyclepolicy-createrule-location</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocation() {
            return null;
        }

        /**
         * <em>[Custom snapshot policies that target instances only]</em> Specifies pre and/or post scripts for a snapshot lifecycle policy that targets instances.
         * <p>
         * This is useful for creating application-consistent snapshots, or for performing specific administrative tasks before or after Amazon Data Lifecycle Manager initiates snapshot creation.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/automate-app-consistent-backups.html">Automating application-consistent snapshots with pre and post scripts</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html#cfn-dlm-lifecyclepolicy-createrule-scripts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html#cfn-dlm-lifecyclepolicy-createrule-scripts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScripts() {
            return null;
        }

        /**
         * The time, in UTC, to start the operation. The supported format is hh:mm.
         * <p>
         * The operation occurs within a one-hour window following the specified time. If you do not specify a time, Amazon Data Lifecycle Manager selects a time within the next 24 hours.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html#cfn-dlm-lifecyclepolicy-createrule-times">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html#cfn-dlm-lifecyclepolicy-createrule-times</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTimes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CreateRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CreateRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CreateRuleProperty> {
            java.lang.String cronExpression;
            java.lang.Number interval;
            java.lang.String intervalUnit;
            java.lang.String location;
            java.lang.Object scripts;
            java.util.List<java.lang.String> times;

            /**
             * Sets the value of {@link CreateRuleProperty#getCronExpression}
             * @param cronExpression The schedule, as a Cron expression.
             *                       The schedule interval must be between 1 hour and 1 year. For more information, see the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-cron-expressions.html">Cron expressions reference</a> in the <em>Amazon EventBridge User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cronExpression(java.lang.String cronExpression) {
                this.cronExpression = cronExpression;
                return this;
            }

            /**
             * Sets the value of {@link CreateRuleProperty#getInterval}
             * @param interval The interval between snapshots.
             *                 The supported values are 1, 2, 3, 4, 6, 8, 12, and 24.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.Number interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link CreateRuleProperty#getIntervalUnit}
             * @param intervalUnit The interval unit.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalUnit(java.lang.String intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            /**
             * Sets the value of {@link CreateRuleProperty#getLocation}
             * @param location <em>[Custom snapshot policies only]</em> Specifies the destination for snapshots created by the policy.
             *                 To create snapshots in the same Region as the source resource, specify <code>CLOUD</code> . To create snapshots on the same Outpost as the source resource, specify <code>OUTPOST_LOCAL</code> . If you omit this parameter, <code>CLOUD</code> is used by default.
             *                 <p>
             *                 If the policy targets resources in an AWS Region , then you must create snapshots in the same Region as the source resource. If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost as the source resource, or in the Region of that Outpost.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(java.lang.String location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link CreateRuleProperty#getScripts}
             * @param scripts <em>[Custom snapshot policies that target instances only]</em> Specifies pre and/or post scripts for a snapshot lifecycle policy that targets instances.
             *                This is useful for creating application-consistent snapshots, or for performing specific administrative tasks before or after Amazon Data Lifecycle Manager initiates snapshot creation.
             *                <p>
             *                For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/automate-app-consistent-backups.html">Automating application-consistent snapshots with pre and post scripts</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scripts(software.amazon.awscdk.IResolvable scripts) {
                this.scripts = scripts;
                return this;
            }

            /**
             * Sets the value of {@link CreateRuleProperty#getScripts}
             * @param scripts <em>[Custom snapshot policies that target instances only]</em> Specifies pre and/or post scripts for a snapshot lifecycle policy that targets instances.
             *                This is useful for creating application-consistent snapshots, or for performing specific administrative tasks before or after Amazon Data Lifecycle Manager initiates snapshot creation.
             *                <p>
             *                For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/automate-app-consistent-backups.html">Automating application-consistent snapshots with pre and post scripts</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scripts(java.util.List<? extends java.lang.Object> scripts) {
                this.scripts = scripts;
                return this;
            }

            /**
             * Sets the value of {@link CreateRuleProperty#getTimes}
             * @param times The time, in UTC, to start the operation. The supported format is hh:mm.
             *              The operation occurs within a one-hour window following the specified time. If you do not specify a time, Amazon Data Lifecycle Manager selects a time within the next 24 hours.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder times(java.util.List<java.lang.String> times) {
                this.times = times;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreateRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CreateRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CreateRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreateRuleProperty {
            private final java.lang.String cronExpression;
            private final java.lang.Number interval;
            private final java.lang.String intervalUnit;
            private final java.lang.String location;
            private final java.lang.Object scripts;
            private final java.util.List<java.lang.String> times;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cronExpression = software.amazon.jsii.Kernel.get(this, "cronExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.intervalUnit = software.amazon.jsii.Kernel.get(this, "intervalUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scripts = software.amazon.jsii.Kernel.get(this, "scripts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.times = software.amazon.jsii.Kernel.get(this, "times", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cronExpression = builder.cronExpression;
                this.interval = builder.interval;
                this.intervalUnit = builder.intervalUnit;
                this.location = builder.location;
                this.scripts = builder.scripts;
                this.times = builder.times;
            }

            @Override
            public final java.lang.String getCronExpression() {
                return this.cronExpression;
            }

            @Override
            public final java.lang.Number getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.String getIntervalUnit() {
                return this.intervalUnit;
            }

            @Override
            public final java.lang.String getLocation() {
                return this.location;
            }

            @Override
            public final java.lang.Object getScripts() {
                return this.scripts;
            }

            @Override
            public final java.util.List<java.lang.String> getTimes() {
                return this.times;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCronExpression() != null) {
                    data.set("cronExpression", om.valueToTree(this.getCronExpression()));
                }
                if (this.getInterval() != null) {
                    data.set("interval", om.valueToTree(this.getInterval()));
                }
                if (this.getIntervalUnit() != null) {
                    data.set("intervalUnit", om.valueToTree(this.getIntervalUnit()));
                }
                if (this.getLocation() != null) {
                    data.set("location", om.valueToTree(this.getLocation()));
                }
                if (this.getScripts() != null) {
                    data.set("scripts", om.valueToTree(this.getScripts()));
                }
                if (this.getTimes() != null) {
                    data.set("times", om.valueToTree(this.getTimes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CreateRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CreateRuleProperty.Jsii$Proxy that = (CreateRuleProperty.Jsii$Proxy) o;

                if (this.cronExpression != null ? !this.cronExpression.equals(that.cronExpression) : that.cronExpression != null) return false;
                if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
                if (this.intervalUnit != null ? !this.intervalUnit.equals(that.intervalUnit) : that.intervalUnit != null) return false;
                if (this.location != null ? !this.location.equals(that.location) : that.location != null) return false;
                if (this.scripts != null ? !this.scripts.equals(that.scripts) : that.scripts != null) return false;
                return this.times != null ? this.times.equals(that.times) : that.times == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cronExpression != null ? this.cronExpression.hashCode() : 0;
                result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
                result = 31 * result + (this.intervalUnit != null ? this.intervalUnit.hashCode() : 0);
                result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
                result = 31 * result + (this.scripts != null ? this.scripts.hashCode() : 0);
                result = 31 * result + (this.times != null ? this.times.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <em>[Event-based policies only]</em> Specifies a cross-Region copy action for event-based policies.
     * <p>
     * <blockquote>
     * <p>
     * To specify a cross-Region copy rule for snapshot and AMI policies, use <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_CrossRegionCopyRule.html">CrossRegionCopyRule</a> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * CrossRegionCopyActionProperty crossRegionCopyActionProperty = CrossRegionCopyActionProperty.builder()
     *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                 .encrypted(false)
     *                 // the properties below are optional
     *                 .cmkArn("cmkArn")
     *                 .build())
     *         .target("target")
     *         // the properties below are optional
     *         .retainRule(CrossRegionCopyRetainRuleProperty.builder()
     *                 .interval(123)
     *                 .intervalUnit("intervalUnit")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CrossRegionCopyActionProperty")
    @software.amazon.jsii.Jsii.Proxy(CrossRegionCopyActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CrossRegionCopyActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The encryption settings for the copied snapshot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyaction.html#cfn-dlm-lifecyclepolicy-crossregioncopyaction-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyaction.html#cfn-dlm-lifecyclepolicy-crossregioncopyaction-encryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEncryptionConfiguration();

        /**
         * The target Region.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyaction.html#cfn-dlm-lifecyclepolicy-crossregioncopyaction-target">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyaction.html#cfn-dlm-lifecyclepolicy-crossregioncopyaction-target</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTarget();

        /**
         * Specifies a retention rule for cross-Region snapshot copies created by snapshot or event-based policies, or cross-Region AMI copies created by AMI policies.
         * <p>
         * After the retention period expires, the cross-Region copy is deleted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyaction.html#cfn-dlm-lifecyclepolicy-crossregioncopyaction-retainrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyaction.html#cfn-dlm-lifecyclepolicy-crossregioncopyaction-retainrule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetainRule() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CrossRegionCopyActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CrossRegionCopyActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CrossRegionCopyActionProperty> {
            java.lang.Object encryptionConfiguration;
            java.lang.String target;
            java.lang.Object retainRule;

            /**
             * Sets the value of {@link CrossRegionCopyActionProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration The encryption settings for the copied snapshot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyActionProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration The encryption settings for the copied snapshot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.EncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyActionProperty#getTarget}
             * @param target The target Region. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(java.lang.String target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyActionProperty#getRetainRule}
             * @param retainRule Specifies a retention rule for cross-Region snapshot copies created by snapshot or event-based policies, or cross-Region AMI copies created by AMI policies.
             *                   After the retention period expires, the cross-Region copy is deleted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retainRule(software.amazon.awscdk.IResolvable retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyActionProperty#getRetainRule}
             * @param retainRule Specifies a retention rule for cross-Region snapshot copies created by snapshot or event-based policies, or cross-Region AMI copies created by AMI policies.
             *                   After the retention period expires, the cross-Region copy is deleted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retainRule(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.CrossRegionCopyRetainRuleProperty retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CrossRegionCopyActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CrossRegionCopyActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CrossRegionCopyActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CrossRegionCopyActionProperty {
            private final java.lang.Object encryptionConfiguration;
            private final java.lang.String target;
            private final java.lang.Object retainRule;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.retainRule = software.amazon.jsii.Kernel.get(this, "retainRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionConfiguration = java.util.Objects.requireNonNull(builder.encryptionConfiguration, "encryptionConfiguration is required");
                this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
                this.retainRule = builder.retainRule;
            }

            @Override
            public final java.lang.Object getEncryptionConfiguration() {
                return this.encryptionConfiguration;
            }

            @Override
            public final java.lang.String getTarget() {
                return this.target;
            }

            @Override
            public final java.lang.Object getRetainRule() {
                return this.retainRule;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
                data.set("target", om.valueToTree(this.getTarget()));
                if (this.getRetainRule() != null) {
                    data.set("retainRule", om.valueToTree(this.getRetainRule()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CrossRegionCopyActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CrossRegionCopyActionProperty.Jsii$Proxy that = (CrossRegionCopyActionProperty.Jsii$Proxy) o;

                if (!encryptionConfiguration.equals(that.encryptionConfiguration)) return false;
                if (!target.equals(that.target)) return false;
                return this.retainRule != null ? this.retainRule.equals(that.retainRule) : that.retainRule == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionConfiguration.hashCode();
                result = 31 * result + (this.target.hashCode());
                result = 31 * result + (this.retainRule != null ? this.retainRule.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <em>[Custom AMI policies only]</em> Specifies an AMI deprecation rule for cross-Region AMI copies created by an AMI policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * CrossRegionCopyDeprecateRuleProperty crossRegionCopyDeprecateRuleProperty = CrossRegionCopyDeprecateRuleProperty.builder()
     *         .interval(123)
     *         .intervalUnit("intervalUnit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopydeprecaterule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopydeprecaterule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CrossRegionCopyDeprecateRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(CrossRegionCopyDeprecateRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CrossRegionCopyDeprecateRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The period after which to deprecate the cross-Region AMI copies.
         * <p>
         * The period must be less than or equal to the cross-Region AMI copy retention period, and it can't be greater than 10 years. This is equivalent to 120 months, 520 weeks, or 3650 days.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopydeprecaterule.html#cfn-dlm-lifecyclepolicy-crossregioncopydeprecaterule-interval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopydeprecaterule.html#cfn-dlm-lifecyclepolicy-crossregioncopydeprecaterule-interval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInterval();

        /**
         * The unit of time in which to measure the <em>Interval</em> .
         * <p>
         * For example, to deprecate a cross-Region AMI copy after 3 months, specify <code>Interval=3</code> and <code>IntervalUnit=MONTHS</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopydeprecaterule.html#cfn-dlm-lifecyclepolicy-crossregioncopydeprecaterule-intervalunit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopydeprecaterule.html#cfn-dlm-lifecyclepolicy-crossregioncopydeprecaterule-intervalunit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIntervalUnit();

        /**
         * @return a {@link Builder} of {@link CrossRegionCopyDeprecateRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CrossRegionCopyDeprecateRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CrossRegionCopyDeprecateRuleProperty> {
            java.lang.Number interval;
            java.lang.String intervalUnit;

            /**
             * Sets the value of {@link CrossRegionCopyDeprecateRuleProperty#getInterval}
             * @param interval The period after which to deprecate the cross-Region AMI copies. This parameter is required.
             *                 The period must be less than or equal to the cross-Region AMI copy retention period, and it can't be greater than 10 years. This is equivalent to 120 months, 520 weeks, or 3650 days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.Number interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyDeprecateRuleProperty#getIntervalUnit}
             * @param intervalUnit The unit of time in which to measure the <em>Interval</em> . This parameter is required.
             *                     For example, to deprecate a cross-Region AMI copy after 3 months, specify <code>Interval=3</code> and <code>IntervalUnit=MONTHS</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalUnit(java.lang.String intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CrossRegionCopyDeprecateRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CrossRegionCopyDeprecateRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CrossRegionCopyDeprecateRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CrossRegionCopyDeprecateRuleProperty {
            private final java.lang.Number interval;
            private final java.lang.String intervalUnit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.intervalUnit = software.amazon.jsii.Kernel.get(this, "intervalUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.interval = java.util.Objects.requireNonNull(builder.interval, "interval is required");
                this.intervalUnit = java.util.Objects.requireNonNull(builder.intervalUnit, "intervalUnit is required");
            }

            @Override
            public final java.lang.Number getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.String getIntervalUnit() {
                return this.intervalUnit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("interval", om.valueToTree(this.getInterval()));
                data.set("intervalUnit", om.valueToTree(this.getIntervalUnit()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CrossRegionCopyDeprecateRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CrossRegionCopyDeprecateRuleProperty.Jsii$Proxy that = (CrossRegionCopyDeprecateRuleProperty.Jsii$Proxy) o;

                if (!interval.equals(that.interval)) return false;
                return this.intervalUnit.equals(that.intervalUnit);
            }

            @Override
            public final int hashCode() {
                int result = this.interval.hashCode();
                result = 31 * result + (this.intervalUnit.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies a retention rule for cross-Region snapshot copies created by snapshot or event-based policies, or cross-Region AMI copies created by AMI policies.
     * <p>
     * After the retention period expires, the cross-Region copy is deleted.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * CrossRegionCopyRetainRuleProperty crossRegionCopyRetainRuleProperty = CrossRegionCopyRetainRuleProperty.builder()
     *         .interval(123)
     *         .intervalUnit("intervalUnit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyretainrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyretainrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CrossRegionCopyRetainRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(CrossRegionCopyRetainRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CrossRegionCopyRetainRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The amount of time to retain a cross-Region snapshot or AMI copy.
         * <p>
         * The maximum is 100 years. This is equivalent to 1200 months, 5200 weeks, or 36500 days.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyretainrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyretainrule-interval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyretainrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyretainrule-interval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInterval();

        /**
         * The unit of time for time-based retention.
         * <p>
         * For example, to retain a cross-Region copy for 3 months, specify <code>Interval=3</code> and <code>IntervalUnit=MONTHS</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyretainrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyretainrule-intervalunit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyretainrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyretainrule-intervalunit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIntervalUnit();

        /**
         * @return a {@link Builder} of {@link CrossRegionCopyRetainRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CrossRegionCopyRetainRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CrossRegionCopyRetainRuleProperty> {
            java.lang.Number interval;
            java.lang.String intervalUnit;

            /**
             * Sets the value of {@link CrossRegionCopyRetainRuleProperty#getInterval}
             * @param interval The amount of time to retain a cross-Region snapshot or AMI copy. This parameter is required.
             *                 The maximum is 100 years. This is equivalent to 1200 months, 5200 weeks, or 36500 days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.Number interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRetainRuleProperty#getIntervalUnit}
             * @param intervalUnit The unit of time for time-based retention. This parameter is required.
             *                     For example, to retain a cross-Region copy for 3 months, specify <code>Interval=3</code> and <code>IntervalUnit=MONTHS</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalUnit(java.lang.String intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CrossRegionCopyRetainRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CrossRegionCopyRetainRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CrossRegionCopyRetainRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CrossRegionCopyRetainRuleProperty {
            private final java.lang.Number interval;
            private final java.lang.String intervalUnit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.intervalUnit = software.amazon.jsii.Kernel.get(this, "intervalUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.interval = java.util.Objects.requireNonNull(builder.interval, "interval is required");
                this.intervalUnit = java.util.Objects.requireNonNull(builder.intervalUnit, "intervalUnit is required");
            }

            @Override
            public final java.lang.Number getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.String getIntervalUnit() {
                return this.intervalUnit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("interval", om.valueToTree(this.getInterval()));
                data.set("intervalUnit", om.valueToTree(this.getIntervalUnit()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CrossRegionCopyRetainRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CrossRegionCopyRetainRuleProperty.Jsii$Proxy that = (CrossRegionCopyRetainRuleProperty.Jsii$Proxy) o;

                if (!interval.equals(that.interval)) return false;
                return this.intervalUnit.equals(that.intervalUnit);
            }

            @Override
            public final int hashCode() {
                int result = this.interval.hashCode();
                result = 31 * result + (this.intervalUnit.hashCode());
                return result;
            }
        }
    }
    /**
     * <em>[Custom snapshot and AMI policies only]</em> Specifies a cross-Region copy rule for a snapshot and AMI policies.
     * <p>
     * <blockquote>
     * <p>
     * To specify a cross-Region copy action for event-based polices, use <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_CrossRegionCopyAction.html">CrossRegionCopyAction</a> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * CrossRegionCopyRuleProperty crossRegionCopyRuleProperty = CrossRegionCopyRuleProperty.builder()
     *         .encrypted(false)
     *         // the properties below are optional
     *         .cmkArn("cmkArn")
     *         .copyTags(false)
     *         .deprecateRule(CrossRegionCopyDeprecateRuleProperty.builder()
     *                 .interval(123)
     *                 .intervalUnit("intervalUnit")
     *                 .build())
     *         .retainRule(CrossRegionCopyRetainRuleProperty.builder()
     *                 .interval(123)
     *                 .intervalUnit("intervalUnit")
     *                 .build())
     *         .target("target")
     *         .targetRegion("targetRegion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CrossRegionCopyRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(CrossRegionCopyRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CrossRegionCopyRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter.
         * <p>
         * Copies of encrypted snapshots are encrypted, even if this parameter is false or if encryption by default is not enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-encrypted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-encrypted</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEncrypted();

        /**
         * The Amazon Resource Name (ARN) of the AWS KMS key to use for EBS encryption.
         * <p>
         * If this parameter is not specified, the default KMS key for the account is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-cmkarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-cmkarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCmkArn() {
            return null;
        }

        /**
         * Indicates whether to copy all user-defined tags from the source snapshot or AMI to the cross-Region copy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-copytags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-copytags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCopyTags() {
            return null;
        }

        /**
         * <em>[Custom AMI policies only]</em> The AMI deprecation rule for cross-Region AMI copies created by the rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-deprecaterule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-deprecaterule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeprecateRule() {
            return null;
        }

        /**
         * The retention rule that indicates how long the cross-Region snapshot or AMI copies are to be retained in the destination Region.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-retainrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-retainrule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetainRule() {
            return null;
        }

        /**
         * <blockquote><p>Use this parameter for snapshot policies only. For AMI policies, use <em>TargetRegion</em> instead.<p></blockquote>
         * <p>
         * <em>[Custom snapshot policies only]</em> The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-target">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-target</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTarget() {
            return null;
        }

        /**
         * <blockquote><p>Use this parameter for AMI policies only.<p></blockquote>
         * <p>
         * For snapshot policies, use <em>Target</em> instead. For snapshot policies created before the <em>Target</em> parameter was introduced, this parameter indicates the target Region for snapshot copies.
         * <p>
         * <em>[Custom AMI policies only]</em> The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-targetregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-targetregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetRegion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CrossRegionCopyRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CrossRegionCopyRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CrossRegionCopyRuleProperty> {
            java.lang.Object encrypted;
            java.lang.String cmkArn;
            java.lang.Object copyTags;
            java.lang.Object deprecateRule;
            java.lang.Object retainRule;
            java.lang.String target;
            java.lang.String targetRegion;

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getEncrypted}
             * @param encrypted To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. This parameter is required.
             *                  Copies of encrypted snapshots are encrypted, even if this parameter is false or if encryption by default is not enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(java.lang.Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getEncrypted}
             * @param encrypted To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. This parameter is required.
             *                  Copies of encrypted snapshots are encrypted, even if this parameter is false or if encryption by default is not enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(software.amazon.awscdk.IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getCmkArn}
             * @param cmkArn The Amazon Resource Name (ARN) of the AWS KMS key to use for EBS encryption.
             *               If this parameter is not specified, the default KMS key for the account is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cmkArn(java.lang.String cmkArn) {
                this.cmkArn = cmkArn;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getCopyTags}
             * @param copyTags Indicates whether to copy all user-defined tags from the source snapshot or AMI to the cross-Region copy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTags(java.lang.Boolean copyTags) {
                this.copyTags = copyTags;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getCopyTags}
             * @param copyTags Indicates whether to copy all user-defined tags from the source snapshot or AMI to the cross-Region copy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTags(software.amazon.awscdk.IResolvable copyTags) {
                this.copyTags = copyTags;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getDeprecateRule}
             * @param deprecateRule <em>[Custom AMI policies only]</em> The AMI deprecation rule for cross-Region AMI copies created by the rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deprecateRule(software.amazon.awscdk.IResolvable deprecateRule) {
                this.deprecateRule = deprecateRule;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getDeprecateRule}
             * @param deprecateRule <em>[Custom AMI policies only]</em> The AMI deprecation rule for cross-Region AMI copies created by the rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deprecateRule(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.CrossRegionCopyDeprecateRuleProperty deprecateRule) {
                this.deprecateRule = deprecateRule;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getRetainRule}
             * @param retainRule The retention rule that indicates how long the cross-Region snapshot or AMI copies are to be retained in the destination Region.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retainRule(software.amazon.awscdk.IResolvable retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getRetainRule}
             * @param retainRule The retention rule that indicates how long the cross-Region snapshot or AMI copies are to be retained in the destination Region.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retainRule(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.CrossRegionCopyRetainRuleProperty retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getTarget}
             * @param target <blockquote><p>Use this parameter for snapshot policies only. For AMI policies, use <em>TargetRegion</em> instead.<p></blockquote>
             *               <em>[Custom snapshot policies only]</em> The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(java.lang.String target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link CrossRegionCopyRuleProperty#getTargetRegion}
             * @param targetRegion <blockquote><p>Use this parameter for AMI policies only.<p></blockquote>
             *                     For snapshot policies, use <em>Target</em> instead. For snapshot policies created before the <em>Target</em> parameter was introduced, this parameter indicates the target Region for snapshot copies.
             *                     <p>
             *                     <em>[Custom AMI policies only]</em> The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetRegion(java.lang.String targetRegion) {
                this.targetRegion = targetRegion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CrossRegionCopyRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CrossRegionCopyRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CrossRegionCopyRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CrossRegionCopyRuleProperty {
            private final java.lang.Object encrypted;
            private final java.lang.String cmkArn;
            private final java.lang.Object copyTags;
            private final java.lang.Object deprecateRule;
            private final java.lang.Object retainRule;
            private final java.lang.String target;
            private final java.lang.String targetRegion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cmkArn = software.amazon.jsii.Kernel.get(this, "cmkArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.copyTags = software.amazon.jsii.Kernel.get(this, "copyTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deprecateRule = software.amazon.jsii.Kernel.get(this, "deprecateRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retainRule = software.amazon.jsii.Kernel.get(this, "retainRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetRegion = software.amazon.jsii.Kernel.get(this, "targetRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encrypted = java.util.Objects.requireNonNull(builder.encrypted, "encrypted is required");
                this.cmkArn = builder.cmkArn;
                this.copyTags = builder.copyTags;
                this.deprecateRule = builder.deprecateRule;
                this.retainRule = builder.retainRule;
                this.target = builder.target;
                this.targetRegion = builder.targetRegion;
            }

            @Override
            public final java.lang.Object getEncrypted() {
                return this.encrypted;
            }

            @Override
            public final java.lang.String getCmkArn() {
                return this.cmkArn;
            }

            @Override
            public final java.lang.Object getCopyTags() {
                return this.copyTags;
            }

            @Override
            public final java.lang.Object getDeprecateRule() {
                return this.deprecateRule;
            }

            @Override
            public final java.lang.Object getRetainRule() {
                return this.retainRule;
            }

            @Override
            public final java.lang.String getTarget() {
                return this.target;
            }

            @Override
            public final java.lang.String getTargetRegion() {
                return this.targetRegion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encrypted", om.valueToTree(this.getEncrypted()));
                if (this.getCmkArn() != null) {
                    data.set("cmkArn", om.valueToTree(this.getCmkArn()));
                }
                if (this.getCopyTags() != null) {
                    data.set("copyTags", om.valueToTree(this.getCopyTags()));
                }
                if (this.getDeprecateRule() != null) {
                    data.set("deprecateRule", om.valueToTree(this.getDeprecateRule()));
                }
                if (this.getRetainRule() != null) {
                    data.set("retainRule", om.valueToTree(this.getRetainRule()));
                }
                if (this.getTarget() != null) {
                    data.set("target", om.valueToTree(this.getTarget()));
                }
                if (this.getTargetRegion() != null) {
                    data.set("targetRegion", om.valueToTree(this.getTargetRegion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.CrossRegionCopyRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CrossRegionCopyRuleProperty.Jsii$Proxy that = (CrossRegionCopyRuleProperty.Jsii$Proxy) o;

                if (!encrypted.equals(that.encrypted)) return false;
                if (this.cmkArn != null ? !this.cmkArn.equals(that.cmkArn) : that.cmkArn != null) return false;
                if (this.copyTags != null ? !this.copyTags.equals(that.copyTags) : that.copyTags != null) return false;
                if (this.deprecateRule != null ? !this.deprecateRule.equals(that.deprecateRule) : that.deprecateRule != null) return false;
                if (this.retainRule != null ? !this.retainRule.equals(that.retainRule) : that.retainRule != null) return false;
                if (this.target != null ? !this.target.equals(that.target) : that.target != null) return false;
                return this.targetRegion != null ? this.targetRegion.equals(that.targetRegion) : that.targetRegion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encrypted.hashCode();
                result = 31 * result + (this.cmkArn != null ? this.cmkArn.hashCode() : 0);
                result = 31 * result + (this.copyTags != null ? this.copyTags.hashCode() : 0);
                result = 31 * result + (this.deprecateRule != null ? this.deprecateRule.hashCode() : 0);
                result = 31 * result + (this.retainRule != null ? this.retainRule.hashCode() : 0);
                result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
                result = 31 * result + (this.targetRegion != null ? this.targetRegion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <em>[Custom AMI policies only]</em> Specifies an AMI deprecation rule for AMIs created by an AMI lifecycle policy.
     * <p>
     * For age-based schedules, you must specify <em>Interval</em> and <em>IntervalUnit</em> . For count-based schedules, you must specify <em>Count</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * DeprecateRuleProperty deprecateRuleProperty = DeprecateRuleProperty.builder()
     *         .count(123)
     *         .interval(123)
     *         .intervalUnit("intervalUnit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-deprecaterule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-deprecaterule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.DeprecateRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(DeprecateRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeprecateRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If the schedule has a count-based retention rule, this parameter specifies the number of oldest AMIs to deprecate.
         * <p>
         * The count must be less than or equal to the schedule's retention count, and it can't be greater than 1000.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-deprecaterule.html#cfn-dlm-lifecyclepolicy-deprecaterule-count">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-deprecaterule.html#cfn-dlm-lifecyclepolicy-deprecaterule-count</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCount() {
            return null;
        }

        /**
         * If the schedule has an age-based retention rule, this parameter specifies the period after which to deprecate AMIs created by the schedule.
         * <p>
         * The period must be less than or equal to the schedule's retention period, and it can't be greater than 10 years. This is equivalent to 120 months, 520 weeks, or 3650 days.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-deprecaterule.html#cfn-dlm-lifecyclepolicy-deprecaterule-interval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-deprecaterule.html#cfn-dlm-lifecyclepolicy-deprecaterule-interval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInterval() {
            return null;
        }

        /**
         * The unit of time in which to measure the <em>Interval</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-deprecaterule.html#cfn-dlm-lifecyclepolicy-deprecaterule-intervalunit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-deprecaterule.html#cfn-dlm-lifecyclepolicy-deprecaterule-intervalunit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIntervalUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeprecateRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeprecateRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeprecateRuleProperty> {
            java.lang.Number count;
            java.lang.Number interval;
            java.lang.String intervalUnit;

            /**
             * Sets the value of {@link DeprecateRuleProperty#getCount}
             * @param count If the schedule has a count-based retention rule, this parameter specifies the number of oldest AMIs to deprecate.
             *              The count must be less than or equal to the schedule's retention count, and it can't be greater than 1000.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder count(java.lang.Number count) {
                this.count = count;
                return this;
            }

            /**
             * Sets the value of {@link DeprecateRuleProperty#getInterval}
             * @param interval If the schedule has an age-based retention rule, this parameter specifies the period after which to deprecate AMIs created by the schedule.
             *                 The period must be less than or equal to the schedule's retention period, and it can't be greater than 10 years. This is equivalent to 120 months, 520 weeks, or 3650 days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.Number interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link DeprecateRuleProperty#getIntervalUnit}
             * @param intervalUnit The unit of time in which to measure the <em>Interval</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalUnit(java.lang.String intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeprecateRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeprecateRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeprecateRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeprecateRuleProperty {
            private final java.lang.Number count;
            private final java.lang.Number interval;
            private final java.lang.String intervalUnit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.intervalUnit = software.amazon.jsii.Kernel.get(this, "intervalUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.count = builder.count;
                this.interval = builder.interval;
                this.intervalUnit = builder.intervalUnit;
            }

            @Override
            public final java.lang.Number getCount() {
                return this.count;
            }

            @Override
            public final java.lang.Number getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.String getIntervalUnit() {
                return this.intervalUnit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCount() != null) {
                    data.set("count", om.valueToTree(this.getCount()));
                }
                if (this.getInterval() != null) {
                    data.set("interval", om.valueToTree(this.getInterval()));
                }
                if (this.getIntervalUnit() != null) {
                    data.set("intervalUnit", om.valueToTree(this.getIntervalUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.DeprecateRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeprecateRuleProperty.Jsii$Proxy that = (DeprecateRuleProperty.Jsii$Proxy) o;

                if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
                if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
                return this.intervalUnit != null ? this.intervalUnit.equals(that.intervalUnit) : that.intervalUnit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.count != null ? this.count.hashCode() : 0;
                result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
                result = 31 * result + (this.intervalUnit != null ? this.intervalUnit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <em>[Event-based policies only]</em> Specifies the encryption settings for cross-Region snapshot copies created by event-based policies.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * EncryptionConfigurationProperty encryptionConfigurationProperty = EncryptionConfigurationProperty.builder()
     *         .encrypted(false)
     *         // the properties below are optional
     *         .cmkArn("cmkArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-encryptionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-encryptionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.EncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * To encrypt a copy of an unencrypted snapshot when encryption by default is not enabled, enable encryption using this parameter.
         * <p>
         * Copies of encrypted snapshots are encrypted, even if this parameter is false or when encryption by default is not enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-encryptionconfiguration.html#cfn-dlm-lifecyclepolicy-encryptionconfiguration-encrypted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-encryptionconfiguration.html#cfn-dlm-lifecyclepolicy-encryptionconfiguration-encrypted</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEncrypted();

        /**
         * The Amazon Resource Name (ARN) of the AWS KMS key to use for EBS encryption.
         * <p>
         * If this parameter is not specified, the default KMS key for the account is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-encryptionconfiguration.html#cfn-dlm-lifecyclepolicy-encryptionconfiguration-cmkarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-encryptionconfiguration.html#cfn-dlm-lifecyclepolicy-encryptionconfiguration-cmkarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCmkArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionConfigurationProperty> {
            java.lang.Object encrypted;
            java.lang.String cmkArn;

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getEncrypted}
             * @param encrypted To encrypt a copy of an unencrypted snapshot when encryption by default is not enabled, enable encryption using this parameter. This parameter is required.
             *                  Copies of encrypted snapshots are encrypted, even if this parameter is false or when encryption by default is not enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(java.lang.Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getEncrypted}
             * @param encrypted To encrypt a copy of an unencrypted snapshot when encryption by default is not enabled, enable encryption using this parameter. This parameter is required.
             *                  Copies of encrypted snapshots are encrypted, even if this parameter is false or when encryption by default is not enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(software.amazon.awscdk.IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getCmkArn}
             * @param cmkArn The Amazon Resource Name (ARN) of the AWS KMS key to use for EBS encryption.
             *               If this parameter is not specified, the default KMS key for the account is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cmkArn(java.lang.String cmkArn) {
                this.cmkArn = cmkArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionConfigurationProperty {
            private final java.lang.Object encrypted;
            private final java.lang.String cmkArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cmkArn = software.amazon.jsii.Kernel.get(this, "cmkArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encrypted = java.util.Objects.requireNonNull(builder.encrypted, "encrypted is required");
                this.cmkArn = builder.cmkArn;
            }

            @Override
            public final java.lang.Object getEncrypted() {
                return this.encrypted;
            }

            @Override
            public final java.lang.String getCmkArn() {
                return this.cmkArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encrypted", om.valueToTree(this.getEncrypted()));
                if (this.getCmkArn() != null) {
                    data.set("cmkArn", om.valueToTree(this.getCmkArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.EncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionConfigurationProperty.Jsii$Proxy that = (EncryptionConfigurationProperty.Jsii$Proxy) o;

                if (!encrypted.equals(that.encrypted)) return false;
                return this.cmkArn != null ? this.cmkArn.equals(that.cmkArn) : that.cmkArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encrypted.hashCode();
                result = 31 * result + (this.cmkArn != null ? this.cmkArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <em>[Event-based policies only]</em> Specifies an event that activates an event-based policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * EventParametersProperty eventParametersProperty = EventParametersProperty.builder()
     *         .eventType("eventType")
     *         .snapshotOwner(List.of("snapshotOwner"))
     *         // the properties below are optional
     *         .descriptionRegex("descriptionRegex")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-eventparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-eventparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.EventParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(EventParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of event.
         * <p>
         * Currently, only snapshot sharing events are supported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-eventparameters.html#cfn-dlm-lifecyclepolicy-eventparameters-eventtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-eventparameters.html#cfn-dlm-lifecyclepolicy-eventparameters-eventtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEventType();

        /**
         * The IDs of the AWS accounts that can trigger policy by sharing snapshots with your account.
         * <p>
         * The policy only runs if one of the specified AWS accounts shares a snapshot with your account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-eventparameters.html#cfn-dlm-lifecyclepolicy-eventparameters-snapshotowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-eventparameters.html#cfn-dlm-lifecyclepolicy-eventparameters-snapshotowner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSnapshotOwner();

        /**
         * The snapshot description that can trigger the policy.
         * <p>
         * The description pattern is specified using a regular expression. The policy runs only if a snapshot with a description that matches the specified pattern is shared with your account.
         * <p>
         * For example, specifying <code>^.*Created for policy: policy-1234567890abcdef0.*$</code> configures the policy to run only if snapshots created by policy <code>policy-1234567890abcdef0</code> are shared with your account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-eventparameters.html#cfn-dlm-lifecyclepolicy-eventparameters-descriptionregex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-eventparameters.html#cfn-dlm-lifecyclepolicy-eventparameters-descriptionregex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescriptionRegex() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventParametersProperty> {
            java.lang.String eventType;
            java.util.List<java.lang.String> snapshotOwner;
            java.lang.String descriptionRegex;

            /**
             * Sets the value of {@link EventParametersProperty#getEventType}
             * @param eventType The type of event. This parameter is required.
             *                  Currently, only snapshot sharing events are supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventType(java.lang.String eventType) {
                this.eventType = eventType;
                return this;
            }

            /**
             * Sets the value of {@link EventParametersProperty#getSnapshotOwner}
             * @param snapshotOwner The IDs of the AWS accounts that can trigger policy by sharing snapshots with your account. This parameter is required.
             *                      The policy only runs if one of the specified AWS accounts shares a snapshot with your account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotOwner(java.util.List<java.lang.String> snapshotOwner) {
                this.snapshotOwner = snapshotOwner;
                return this;
            }

            /**
             * Sets the value of {@link EventParametersProperty#getDescriptionRegex}
             * @param descriptionRegex The snapshot description that can trigger the policy.
             *                         The description pattern is specified using a regular expression. The policy runs only if a snapshot with a description that matches the specified pattern is shared with your account.
             *                         <p>
             *                         For example, specifying <code>^.*Created for policy: policy-1234567890abcdef0.*$</code> configures the policy to run only if snapshots created by policy <code>policy-1234567890abcdef0</code> are shared with your account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder descriptionRegex(java.lang.String descriptionRegex) {
                this.descriptionRegex = descriptionRegex;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventParametersProperty {
            private final java.lang.String eventType;
            private final java.util.List<java.lang.String> snapshotOwner;
            private final java.lang.String descriptionRegex;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventType = software.amazon.jsii.Kernel.get(this, "eventType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.snapshotOwner = software.amazon.jsii.Kernel.get(this, "snapshotOwner", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.descriptionRegex = software.amazon.jsii.Kernel.get(this, "descriptionRegex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventType = java.util.Objects.requireNonNull(builder.eventType, "eventType is required");
                this.snapshotOwner = java.util.Objects.requireNonNull(builder.snapshotOwner, "snapshotOwner is required");
                this.descriptionRegex = builder.descriptionRegex;
            }

            @Override
            public final java.lang.String getEventType() {
                return this.eventType;
            }

            @Override
            public final java.util.List<java.lang.String> getSnapshotOwner() {
                return this.snapshotOwner;
            }

            @Override
            public final java.lang.String getDescriptionRegex() {
                return this.descriptionRegex;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("eventType", om.valueToTree(this.getEventType()));
                data.set("snapshotOwner", om.valueToTree(this.getSnapshotOwner()));
                if (this.getDescriptionRegex() != null) {
                    data.set("descriptionRegex", om.valueToTree(this.getDescriptionRegex()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.EventParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventParametersProperty.Jsii$Proxy that = (EventParametersProperty.Jsii$Proxy) o;

                if (!eventType.equals(that.eventType)) return false;
                if (!snapshotOwner.equals(that.snapshotOwner)) return false;
                return this.descriptionRegex != null ? this.descriptionRegex.equals(that.descriptionRegex) : that.descriptionRegex == null;
            }

            @Override
            public final int hashCode() {
                int result = this.eventType.hashCode();
                result = 31 * result + (this.snapshotOwner.hashCode());
                result = 31 * result + (this.descriptionRegex != null ? this.descriptionRegex.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <em>[Event-based policies only]</em> Specifies an event that activates an event-based policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * EventSourceProperty eventSourceProperty = EventSourceProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .parameters(EventParametersProperty.builder()
     *                 .eventType("eventType")
     *                 .snapshotOwner(List.of("snapshotOwner"))
     *                 // the properties below are optional
     *                 .descriptionRegex("descriptionRegex")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-eventsource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-eventsource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.EventSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(EventSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source of the event.
         * <p>
         * Currently only managed CloudWatch Events rules are supported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-eventsource.html#cfn-dlm-lifecyclepolicy-eventsource-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-eventsource.html#cfn-dlm-lifecyclepolicy-eventsource-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Information about the event.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-eventsource.html#cfn-dlm-lifecyclepolicy-eventsource-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-eventsource.html#cfn-dlm-lifecyclepolicy-eventsource-parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventSourceProperty> {
            java.lang.String type;
            java.lang.Object parameters;

            /**
             * Sets the value of {@link EventSourceProperty#getType}
             * @param type The source of the event. This parameter is required.
             *             Currently only managed CloudWatch Events rules are supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getParameters}
             * @param parameters Information about the event.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link EventSourceProperty#getParameters}
             * @param parameters Information about the event.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.EventParametersProperty parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventSourceProperty {
            private final java.lang.String type;
            private final java.lang.Object parameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.parameters = builder.parameters;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.EventSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventSourceProperty.Jsii$Proxy that = (EventSourceProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.parameters != null ? this.parameters.equals(that.parameters) : that.parameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <em>[Default policies only]</em> Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs.
     * <p>
     * The policy will not create snapshots or AMIs for target resources that match any of the specified exclusion parameters.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * Object excludeTags;
     * Object excludeVolumeTypes;
     * ExclusionsProperty exclusionsProperty = ExclusionsProperty.builder()
     *         .excludeBootVolumes(false)
     *         .excludeTags(excludeTags)
     *         .excludeVolumeTypes(excludeVolumeTypes)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-exclusions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-exclusions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ExclusionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ExclusionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExclusionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * <em>[Default policies for EBS snapshots only]</em> Indicates whether to exclude volumes that are attached to instances as the boot volume.
         * <p>
         * If you exclude boot volumes, only volumes attached as data (non-boot) volumes will be backed up by the policy. To exclude boot volumes, specify <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-exclusions.html#cfn-dlm-lifecyclepolicy-exclusions-excludebootvolumes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-exclusions.html#cfn-dlm-lifecyclepolicy-exclusions-excludebootvolumes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeBootVolumes() {
            return null;
        }

        /**
         * <em>[Default policies for EBS-backed AMIs only]</em> Specifies whether to exclude volumes that have specific tags.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-exclusions.html#cfn-dlm-lifecyclepolicy-exclusions-excludetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-exclusions.html#cfn-dlm-lifecyclepolicy-exclusions-excludetags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeTags() {
            return null;
        }

        /**
         * <em>[Default policies for EBS snapshots only]</em> Specifies the volume types to exclude.
         * <p>
         * Volumes of the specified types will not be targeted by the policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-exclusions.html#cfn-dlm-lifecyclepolicy-exclusions-excludevolumetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-exclusions.html#cfn-dlm-lifecyclepolicy-exclusions-excludevolumetypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeVolumeTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExclusionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExclusionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExclusionsProperty> {
            java.lang.Object excludeBootVolumes;
            java.lang.Object excludeTags;
            java.lang.Object excludeVolumeTypes;

            /**
             * Sets the value of {@link ExclusionsProperty#getExcludeBootVolumes}
             * @param excludeBootVolumes <em>[Default policies for EBS snapshots only]</em> Indicates whether to exclude volumes that are attached to instances as the boot volume.
             *                           If you exclude boot volumes, only volumes attached as data (non-boot) volumes will be backed up by the policy. To exclude boot volumes, specify <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeBootVolumes(java.lang.Boolean excludeBootVolumes) {
                this.excludeBootVolumes = excludeBootVolumes;
                return this;
            }

            /**
             * Sets the value of {@link ExclusionsProperty#getExcludeBootVolumes}
             * @param excludeBootVolumes <em>[Default policies for EBS snapshots only]</em> Indicates whether to exclude volumes that are attached to instances as the boot volume.
             *                           If you exclude boot volumes, only volumes attached as data (non-boot) volumes will be backed up by the policy. To exclude boot volumes, specify <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeBootVolumes(software.amazon.awscdk.IResolvable excludeBootVolumes) {
                this.excludeBootVolumes = excludeBootVolumes;
                return this;
            }

            /**
             * Sets the value of {@link ExclusionsProperty#getExcludeTags}
             * @param excludeTags <em>[Default policies for EBS-backed AMIs only]</em> Specifies whether to exclude volumes that have specific tags.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeTags(java.lang.Object excludeTags) {
                this.excludeTags = excludeTags;
                return this;
            }

            /**
             * Sets the value of {@link ExclusionsProperty#getExcludeVolumeTypes}
             * @param excludeVolumeTypes <em>[Default policies for EBS snapshots only]</em> Specifies the volume types to exclude.
             *                           Volumes of the specified types will not be targeted by the policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeVolumeTypes(java.lang.Object excludeVolumeTypes) {
                this.excludeVolumeTypes = excludeVolumeTypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExclusionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExclusionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExclusionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExclusionsProperty {
            private final java.lang.Object excludeBootVolumes;
            private final java.lang.Object excludeTags;
            private final java.lang.Object excludeVolumeTypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.excludeBootVolumes = software.amazon.jsii.Kernel.get(this, "excludeBootVolumes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excludeTags = software.amazon.jsii.Kernel.get(this, "excludeTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excludeVolumeTypes = software.amazon.jsii.Kernel.get(this, "excludeVolumeTypes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.excludeBootVolumes = builder.excludeBootVolumes;
                this.excludeTags = builder.excludeTags;
                this.excludeVolumeTypes = builder.excludeVolumeTypes;
            }

            @Override
            public final java.lang.Object getExcludeBootVolumes() {
                return this.excludeBootVolumes;
            }

            @Override
            public final java.lang.Object getExcludeTags() {
                return this.excludeTags;
            }

            @Override
            public final java.lang.Object getExcludeVolumeTypes() {
                return this.excludeVolumeTypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExcludeBootVolumes() != null) {
                    data.set("excludeBootVolumes", om.valueToTree(this.getExcludeBootVolumes()));
                }
                if (this.getExcludeTags() != null) {
                    data.set("excludeTags", om.valueToTree(this.getExcludeTags()));
                }
                if (this.getExcludeVolumeTypes() != null) {
                    data.set("excludeVolumeTypes", om.valueToTree(this.getExcludeVolumeTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ExclusionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExclusionsProperty.Jsii$Proxy that = (ExclusionsProperty.Jsii$Proxy) o;

                if (this.excludeBootVolumes != null ? !this.excludeBootVolumes.equals(that.excludeBootVolumes) : that.excludeBootVolumes != null) return false;
                if (this.excludeTags != null ? !this.excludeTags.equals(that.excludeTags) : that.excludeTags != null) return false;
                return this.excludeVolumeTypes != null ? this.excludeVolumeTypes.equals(that.excludeVolumeTypes) : that.excludeVolumeTypes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.excludeBootVolumes != null ? this.excludeBootVolumes.hashCode() : 0;
                result = 31 * result + (this.excludeTags != null ? this.excludeTags.hashCode() : 0);
                result = 31 * result + (this.excludeVolumeTypes != null ? this.excludeVolumeTypes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <em>[Custom snapshot policies only]</em> Specifies a rule for enabling fast snapshot restore for snapshots created by snapshot policies.
     * <p>
     * You can enable fast snapshot restore based on either a count or a time interval.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * FastRestoreRuleProperty fastRestoreRuleProperty = FastRestoreRuleProperty.builder()
     *         .availabilityZones(List.of("availabilityZones"))
     *         .count(123)
     *         .interval(123)
     *         .intervalUnit("intervalUnit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-fastrestorerule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-fastrestorerule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.FastRestoreRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(FastRestoreRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FastRestoreRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Availability Zones in which to enable fast snapshot restore.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-fastrestorerule.html#cfn-dlm-lifecyclepolicy-fastrestorerule-availabilityzones">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-fastrestorerule.html#cfn-dlm-lifecyclepolicy-fastrestorerule-availabilityzones</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAvailabilityZones() {
            return null;
        }

        /**
         * The number of snapshots to be enabled with fast snapshot restore.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-fastrestorerule.html#cfn-dlm-lifecyclepolicy-fastrestorerule-count">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-fastrestorerule.html#cfn-dlm-lifecyclepolicy-fastrestorerule-count</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCount() {
            return null;
        }

        /**
         * The amount of time to enable fast snapshot restore.
         * <p>
         * The maximum is 100 years. This is equivalent to 1200 months, 5200 weeks, or 36500 days.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-fastrestorerule.html#cfn-dlm-lifecyclepolicy-fastrestorerule-interval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-fastrestorerule.html#cfn-dlm-lifecyclepolicy-fastrestorerule-interval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInterval() {
            return null;
        }

        /**
         * The unit of time for enabling fast snapshot restore.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-fastrestorerule.html#cfn-dlm-lifecyclepolicy-fastrestorerule-intervalunit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-fastrestorerule.html#cfn-dlm-lifecyclepolicy-fastrestorerule-intervalunit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIntervalUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FastRestoreRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FastRestoreRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FastRestoreRuleProperty> {
            java.util.List<java.lang.String> availabilityZones;
            java.lang.Number count;
            java.lang.Number interval;
            java.lang.String intervalUnit;

            /**
             * Sets the value of {@link FastRestoreRuleProperty#getAvailabilityZones}
             * @param availabilityZones The Availability Zones in which to enable fast snapshot restore.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZones(java.util.List<java.lang.String> availabilityZones) {
                this.availabilityZones = availabilityZones;
                return this;
            }

            /**
             * Sets the value of {@link FastRestoreRuleProperty#getCount}
             * @param count The number of snapshots to be enabled with fast snapshot restore.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder count(java.lang.Number count) {
                this.count = count;
                return this;
            }

            /**
             * Sets the value of {@link FastRestoreRuleProperty#getInterval}
             * @param interval The amount of time to enable fast snapshot restore.
             *                 The maximum is 100 years. This is equivalent to 1200 months, 5200 weeks, or 36500 days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.Number interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link FastRestoreRuleProperty#getIntervalUnit}
             * @param intervalUnit The unit of time for enabling fast snapshot restore.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalUnit(java.lang.String intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FastRestoreRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FastRestoreRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FastRestoreRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FastRestoreRuleProperty {
            private final java.util.List<java.lang.String> availabilityZones;
            private final java.lang.Number count;
            private final java.lang.Number interval;
            private final java.lang.String intervalUnit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZones = software.amazon.jsii.Kernel.get(this, "availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.intervalUnit = software.amazon.jsii.Kernel.get(this, "intervalUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZones = builder.availabilityZones;
                this.count = builder.count;
                this.interval = builder.interval;
                this.intervalUnit = builder.intervalUnit;
            }

            @Override
            public final java.util.List<java.lang.String> getAvailabilityZones() {
                return this.availabilityZones;
            }

            @Override
            public final java.lang.Number getCount() {
                return this.count;
            }

            @Override
            public final java.lang.Number getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.String getIntervalUnit() {
                return this.intervalUnit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZones() != null) {
                    data.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
                }
                if (this.getCount() != null) {
                    data.set("count", om.valueToTree(this.getCount()));
                }
                if (this.getInterval() != null) {
                    data.set("interval", om.valueToTree(this.getInterval()));
                }
                if (this.getIntervalUnit() != null) {
                    data.set("intervalUnit", om.valueToTree(this.getIntervalUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.FastRestoreRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FastRestoreRuleProperty.Jsii$Proxy that = (FastRestoreRuleProperty.Jsii$Proxy) o;

                if (this.availabilityZones != null ? !this.availabilityZones.equals(that.availabilityZones) : that.availabilityZones != null) return false;
                if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
                if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
                return this.intervalUnit != null ? this.intervalUnit.equals(that.intervalUnit) : that.intervalUnit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityZones != null ? this.availabilityZones.hashCode() : 0;
                result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
                result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
                result = 31 * result + (this.intervalUnit != null ? this.intervalUnit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <em>[Custom snapshot and AMI policies only]</em> Specifies optional parameters for snapshot and AMI policies.
     * <p>
     * The set of valid parameters depends on the combination of policy type and target resource type.
     * <p>
     * If you choose to exclude boot volumes and you specify tags that consequently exclude all of the additional data volumes attached to an instance, then Amazon Data Lifecycle Manager will not create any snapshots for the affected instance, and it will emit a <code>SnapshotsCreateFailed</code> Amazon CloudWatch metric. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitor-dlm-cw-metrics.html">Monitor your policies using Amazon CloudWatch</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * ParametersProperty parametersProperty = ParametersProperty.builder()
     *         .excludeBootVolume(false)
     *         .excludeDataVolumeTags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .noReboot(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-parameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-parameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(ParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * <em>[Custom snapshot policies that target instances only]</em> Indicates whether to exclude the root volume from multi-volume snapshot sets.
         * <p>
         * The default is <code>false</code> . If you specify <code>true</code> , then the root volumes attached to targeted instances will be excluded from the multi-volume snapshot sets created by the policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-parameters.html#cfn-dlm-lifecyclepolicy-parameters-excludebootvolume">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-parameters.html#cfn-dlm-lifecyclepolicy-parameters-excludebootvolume</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeBootVolume() {
            return null;
        }

        /**
         * <em>[Custom snapshot policies that target instances only]</em> The tags used to identify data (non-root) volumes to exclude from multi-volume snapshot sets.
         * <p>
         * If you create a snapshot lifecycle policy that targets instances and you specify tags for this parameter, then data volumes with the specified tags that are attached to targeted instances will be excluded from the multi-volume snapshot sets created by the policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-parameters.html#cfn-dlm-lifecyclepolicy-parameters-excludedatavolumetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-parameters.html#cfn-dlm-lifecyclepolicy-parameters-excludedatavolumetags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeDataVolumeTags() {
            return null;
        }

        /**
         * <em>[Custom AMI policies only]</em> Indicates whether targeted instances are rebooted when the lifecycle policy runs.
         * <p>
         * <code>true</code> indicates that targeted instances are not rebooted when the policy runs. <code>false</code> indicates that target instances are rebooted when the policy runs. The default is <code>true</code> (instances are not rebooted).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-parameters.html#cfn-dlm-lifecyclepolicy-parameters-noreboot">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-parameters.html#cfn-dlm-lifecyclepolicy-parameters-noreboot</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoReboot() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParametersProperty> {
            java.lang.Object excludeBootVolume;
            java.lang.Object excludeDataVolumeTags;
            java.lang.Object noReboot;

            /**
             * Sets the value of {@link ParametersProperty#getExcludeBootVolume}
             * @param excludeBootVolume <em>[Custom snapshot policies that target instances only]</em> Indicates whether to exclude the root volume from multi-volume snapshot sets.
             *                          The default is <code>false</code> . If you specify <code>true</code> , then the root volumes attached to targeted instances will be excluded from the multi-volume snapshot sets created by the policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeBootVolume(java.lang.Boolean excludeBootVolume) {
                this.excludeBootVolume = excludeBootVolume;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getExcludeBootVolume}
             * @param excludeBootVolume <em>[Custom snapshot policies that target instances only]</em> Indicates whether to exclude the root volume from multi-volume snapshot sets.
             *                          The default is <code>false</code> . If you specify <code>true</code> , then the root volumes attached to targeted instances will be excluded from the multi-volume snapshot sets created by the policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeBootVolume(software.amazon.awscdk.IResolvable excludeBootVolume) {
                this.excludeBootVolume = excludeBootVolume;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getExcludeDataVolumeTags}
             * @param excludeDataVolumeTags <em>[Custom snapshot policies that target instances only]</em> The tags used to identify data (non-root) volumes to exclude from multi-volume snapshot sets.
             *                              If you create a snapshot lifecycle policy that targets instances and you specify tags for this parameter, then data volumes with the specified tags that are attached to targeted instances will be excluded from the multi-volume snapshot sets created by the policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeDataVolumeTags(software.amazon.awscdk.IResolvable excludeDataVolumeTags) {
                this.excludeDataVolumeTags = excludeDataVolumeTags;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getExcludeDataVolumeTags}
             * @param excludeDataVolumeTags <em>[Custom snapshot policies that target instances only]</em> The tags used to identify data (non-root) volumes to exclude from multi-volume snapshot sets.
             *                              If you create a snapshot lifecycle policy that targets instances and you specify tags for this parameter, then data volumes with the specified tags that are attached to targeted instances will be excluded from the multi-volume snapshot sets created by the policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeDataVolumeTags(java.util.List<? extends java.lang.Object> excludeDataVolumeTags) {
                this.excludeDataVolumeTags = excludeDataVolumeTags;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getNoReboot}
             * @param noReboot <em>[Custom AMI policies only]</em> Indicates whether targeted instances are rebooted when the lifecycle policy runs.
             *                 <code>true</code> indicates that targeted instances are not rebooted when the policy runs. <code>false</code> indicates that target instances are rebooted when the policy runs. The default is <code>true</code> (instances are not rebooted).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noReboot(java.lang.Boolean noReboot) {
                this.noReboot = noReboot;
                return this;
            }

            /**
             * Sets the value of {@link ParametersProperty#getNoReboot}
             * @param noReboot <em>[Custom AMI policies only]</em> Indicates whether targeted instances are rebooted when the lifecycle policy runs.
             *                 <code>true</code> indicates that targeted instances are not rebooted when the policy runs. <code>false</code> indicates that target instances are rebooted when the policy runs. The default is <code>true</code> (instances are not rebooted).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noReboot(software.amazon.awscdk.IResolvable noReboot) {
                this.noReboot = noReboot;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParametersProperty {
            private final java.lang.Object excludeBootVolume;
            private final java.lang.Object excludeDataVolumeTags;
            private final java.lang.Object noReboot;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.excludeBootVolume = software.amazon.jsii.Kernel.get(this, "excludeBootVolume", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excludeDataVolumeTags = software.amazon.jsii.Kernel.get(this, "excludeDataVolumeTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noReboot = software.amazon.jsii.Kernel.get(this, "noReboot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.excludeBootVolume = builder.excludeBootVolume;
                this.excludeDataVolumeTags = builder.excludeDataVolumeTags;
                this.noReboot = builder.noReboot;
            }

            @Override
            public final java.lang.Object getExcludeBootVolume() {
                return this.excludeBootVolume;
            }

            @Override
            public final java.lang.Object getExcludeDataVolumeTags() {
                return this.excludeDataVolumeTags;
            }

            @Override
            public final java.lang.Object getNoReboot() {
                return this.noReboot;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExcludeBootVolume() != null) {
                    data.set("excludeBootVolume", om.valueToTree(this.getExcludeBootVolume()));
                }
                if (this.getExcludeDataVolumeTags() != null) {
                    data.set("excludeDataVolumeTags", om.valueToTree(this.getExcludeDataVolumeTags()));
                }
                if (this.getNoReboot() != null) {
                    data.set("noReboot", om.valueToTree(this.getNoReboot()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParametersProperty.Jsii$Proxy that = (ParametersProperty.Jsii$Proxy) o;

                if (this.excludeBootVolume != null ? !this.excludeBootVolume.equals(that.excludeBootVolume) : that.excludeBootVolume != null) return false;
                if (this.excludeDataVolumeTags != null ? !this.excludeDataVolumeTags.equals(that.excludeDataVolumeTags) : that.excludeDataVolumeTags != null) return false;
                return this.noReboot != null ? this.noReboot.equals(that.noReboot) : that.noReboot == null;
            }

            @Override
            public final int hashCode() {
                int result = this.excludeBootVolume != null ? this.excludeBootVolume.hashCode() : 0;
                result = 31 * result + (this.excludeDataVolumeTags != null ? this.excludeDataVolumeTags.hashCode() : 0);
                result = 31 * result + (this.noReboot != null ? this.noReboot.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration of a lifecycle policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * Object crossRegionCopyTargets;
     * Object excludeTags;
     * Object excludeVolumeTypes;
     * PolicyDetailsProperty policyDetailsProperty = PolicyDetailsProperty.builder()
     *         .actions(List.of(ActionProperty.builder()
     *                 .crossRegionCopy(List.of(CrossRegionCopyActionProperty.builder()
     *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                                 .encrypted(false)
     *                                 // the properties below are optional
     *                                 .cmkArn("cmkArn")
     *                                 .build())
     *                         .target("target")
     *                         // the properties below are optional
     *                         .retainRule(CrossRegionCopyRetainRuleProperty.builder()
     *                                 .interval(123)
     *                                 .intervalUnit("intervalUnit")
     *                                 .build())
     *                         .build()))
     *                 .name("name")
     *                 .build()))
     *         .copyTags(false)
     *         .createInterval(123)
     *         .crossRegionCopyTargets(crossRegionCopyTargets)
     *         .eventSource(EventSourceProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .parameters(EventParametersProperty.builder()
     *                         .eventType("eventType")
     *                         .snapshotOwner(List.of("snapshotOwner"))
     *                         // the properties below are optional
     *                         .descriptionRegex("descriptionRegex")
     *                         .build())
     *                 .build())
     *         .exclusions(ExclusionsProperty.builder()
     *                 .excludeBootVolumes(false)
     *                 .excludeTags(excludeTags)
     *                 .excludeVolumeTypes(excludeVolumeTypes)
     *                 .build())
     *         .extendDeletion(false)
     *         .parameters(ParametersProperty.builder()
     *                 .excludeBootVolume(false)
     *                 .excludeDataVolumeTags(List.of(CfnTag.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .noReboot(false)
     *                 .build())
     *         .policyLanguage("policyLanguage")
     *         .policyType("policyType")
     *         .resourceLocations(List.of("resourceLocations"))
     *         .resourceType("resourceType")
     *         .resourceTypes(List.of("resourceTypes"))
     *         .retainInterval(123)
     *         .schedules(List.of(ScheduleProperty.builder()
     *                 .archiveRule(ArchiveRuleProperty.builder()
     *                         .retainRule(ArchiveRetainRuleProperty.builder()
     *                                 .retentionArchiveTier(RetentionArchiveTierProperty.builder()
     *                                         .count(123)
     *                                         .interval(123)
     *                                         .intervalUnit("intervalUnit")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .copyTags(false)
     *                 .createRule(CreateRuleProperty.builder()
     *                         .cronExpression("cronExpression")
     *                         .interval(123)
     *                         .intervalUnit("intervalUnit")
     *                         .location("location")
     *                         .scripts(List.of(ScriptProperty.builder()
     *                                 .executeOperationOnScriptFailure(false)
     *                                 .executionHandler("executionHandler")
     *                                 .executionHandlerService("executionHandlerService")
     *                                 .executionTimeout(123)
     *                                 .maximumRetryCount(123)
     *                                 .stages(List.of("stages"))
     *                                 .build()))
     *                         .times(List.of("times"))
     *                         .build())
     *                 .crossRegionCopyRules(List.of(CrossRegionCopyRuleProperty.builder()
     *                         .encrypted(false)
     *                         // the properties below are optional
     *                         .cmkArn("cmkArn")
     *                         .copyTags(false)
     *                         .deprecateRule(CrossRegionCopyDeprecateRuleProperty.builder()
     *                                 .interval(123)
     *                                 .intervalUnit("intervalUnit")
     *                                 .build())
     *                         .retainRule(CrossRegionCopyRetainRuleProperty.builder()
     *                                 .interval(123)
     *                                 .intervalUnit("intervalUnit")
     *                                 .build())
     *                         .target("target")
     *                         .targetRegion("targetRegion")
     *                         .build()))
     *                 .deprecateRule(DeprecateRuleProperty.builder()
     *                         .count(123)
     *                         .interval(123)
     *                         .intervalUnit("intervalUnit")
     *                         .build())
     *                 .fastRestoreRule(FastRestoreRuleProperty.builder()
     *                         .availabilityZones(List.of("availabilityZones"))
     *                         .count(123)
     *                         .interval(123)
     *                         .intervalUnit("intervalUnit")
     *                         .build())
     *                 .name("name")
     *                 .retainRule(RetainRuleProperty.builder()
     *                         .count(123)
     *                         .interval(123)
     *                         .intervalUnit("intervalUnit")
     *                         .build())
     *                 .shareRules(List.of(ShareRuleProperty.builder()
     *                         .targetAccounts(List.of("targetAccounts"))
     *                         .unshareInterval(123)
     *                         .unshareIntervalUnit("unshareIntervalUnit")
     *                         .build()))
     *                 .tagsToAdd(List.of(CfnTag.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .variableTags(List.of(CfnTag.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .build()))
     *         .targetTags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.PolicyDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(PolicyDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PolicyDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * <em>[Event-based policies only]</em> The actions to be performed when the event-based policy is activated.
         * <p>
         * You can specify only one action per policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-actions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getActions() {
            return null;
        }

        /**
         * <em>[Default policies only]</em> Indicates whether the policy should copy tags from the source resource to the snapshot or AMI.
         * <p>
         * If you do not specify a value, the default is <code>false</code> .
         * <p>
         * Default: false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-copytags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-copytags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCopyTags() {
            return null;
        }

        /**
         * <em>[Default policies only]</em> Specifies how often the policy should run and create snapshots or AMIs.
         * <p>
         * The creation frequency can range from 1 to 7 days. If you do not specify a value, the default is 1.
         * <p>
         * Default: 1
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-createinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-createinterval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCreateInterval() {
            return null;
        }

        /**
         * <em>[Default policies only]</em> Specifies destination Regions for snapshot or AMI copies.
         * <p>
         * You can specify up to 3 destination Regions. If you do not want to create cross-Region copies, omit this parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-crossregioncopytargets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-crossregioncopytargets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrossRegionCopyTargets() {
            return null;
        }

        /**
         * <em>[Event-based policies only]</em> The event that activates the event-based policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-eventsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-eventsource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEventSource() {
            return null;
        }

        /**
         * <em>[Default policies only]</em> Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs.
         * <p>
         * The policy will not create snapshots or AMIs for target resources that match any of the specified exclusion parameters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-exclusions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-exclusions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExclusions() {
            return null;
        }

        /**
         * <em>[Default policies only]</em> Defines the snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state.
         * <p>
         * By default ( <em>ExtendDeletion=false</em> ):
         * <p>
         * <ul>
         * <li>If a source resource is deleted, Amazon Data Lifecycle Manager will continue to delete previously created snapshots or AMIs, up to but not including the last one, based on the specified retention period. If you want Amazon Data Lifecycle Manager to delete all snapshots or AMIs, including the last one, specify <code>true</code> .</li>
         * <li>If a policy enters the error, disabled, or deleted state, Amazon Data Lifecycle Manager stops deleting snapshots and AMIs. If you want Amazon Data Lifecycle Manager to continue deleting snapshots or AMIs, including the last one, if the policy enters one of these states, specify <code>true</code> .</li>
         * </ul>
         * <p>
         * If you enable extended deletion ( <em>ExtendDeletion=true</em> ), you override both default behaviors simultaneously.
         * <p>
         * If you do not specify a value, the default is <code>false</code> .
         * <p>
         * Default: false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-extenddeletion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-extenddeletion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExtendDeletion() {
            return null;
        }

        /**
         * <em>[Custom snapshot and AMI policies only]</em> A set of optional parameters for snapshot and AMI lifecycle policies.
         * <p>
         * <blockquote>
         * <p>
         * If you are modifying a policy that was created or previously modified using the Amazon Data Lifecycle Manager console, then you must include this parameter and specify either the default values or the new values that you require. You can't omit this parameter or set its values to null.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * The type of policy to create. Specify one of the following:.
         * <p>
         * <ul>
         * <li><code>SIMPLIFIED</code> To create a default policy.</li>
         * <li><code>STANDARD</code> To create a custom policy.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-policylanguage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-policylanguage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPolicyLanguage() {
            return null;
        }

        /**
         * The type of policy.
         * <p>
         * Specify <code>EBS_SNAPSHOT_MANAGEMENT</code> to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify <code>IMAGE_MANAGEMENT</code> to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify <code>EVENT_BASED_POLICY</code> to create an event-based policy that performs specific actions when a defined event occurs in your AWS account .
         * <p>
         * The default is <code>EBS_SNAPSHOT_MANAGEMENT</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-policytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-policytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPolicyType() {
            return null;
        }

        /**
         * <em>[Custom snapshot and AMI policies only]</em> The location of the resources to backup.
         * <p>
         * If the source resources are located in an AWS Region , specify <code>CLOUD</code> . If the source resources are located on an Outpost in your account, specify <code>OUTPOST</code> .
         * <p>
         * If you specify <code>OUTPOST</code> , Amazon Data Lifecycle Manager backs up all resources of the specified type with matching target tags across all of the Outposts in your account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-resourcelocations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-resourcelocations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceLocations() {
            return null;
        }

        /**
         * <em>[Default policies only]</em> Specify the type of default policy to create.
         * <p>
         * <ul>
         * <li>To create a default policy for EBS snapshots, that creates snapshots of all volumes in the Region that do not have recent backups, specify <code>VOLUME</code> .</li>
         * <li>To create a default policy for EBS-backed AMIs, that creates EBS-backed AMIs from all instances in the Region that do not have recent backups, specify <code>INSTANCE</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-resourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-resourcetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceType() {
            return null;
        }

        /**
         * <em>[Custom snapshot policies only]</em> The target resource type for snapshot and AMI lifecycle policies.
         * <p>
         * Use <code>VOLUME</code> to create snapshots of individual volumes or use <code>INSTANCE</code> to create multi-volume snapshots from the volumes for an instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-resourcetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-resourcetypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceTypes() {
            return null;
        }

        /**
         * <em>[Default policies only]</em> Specifies how long the policy should retain snapshots or AMIs before deleting them.
         * <p>
         * The retention period can range from 2 to 14 days, but it must be greater than the creation frequency to ensure that the policy retains at least 1 snapshot or AMI at any given time. If you do not specify a value, the default is 7.
         * <p>
         * Default: 7
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-retaininterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-retaininterval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRetainInterval() {
            return null;
        }

        /**
         * <em>[Custom snapshot and AMI policies only]</em> The schedules of policy-defined actions for snapshot and AMI lifecycle policies.
         * <p>
         * A policy can have up to four schedules—one mandatory schedule and up to three optional schedules.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-schedules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-schedules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSchedules() {
            return null;
        }

        /**
         * <em>[Custom snapshot and AMI policies only]</em> The single tag that identifies targeted resources for this policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-targettags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-targettags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PolicyDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PolicyDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PolicyDetailsProperty> {
            java.lang.Object actions;
            java.lang.Object copyTags;
            java.lang.Number createInterval;
            java.lang.Object crossRegionCopyTargets;
            java.lang.Object eventSource;
            java.lang.Object exclusions;
            java.lang.Object extendDeletion;
            java.lang.Object parameters;
            java.lang.String policyLanguage;
            java.lang.String policyType;
            java.util.List<java.lang.String> resourceLocations;
            java.lang.String resourceType;
            java.util.List<java.lang.String> resourceTypes;
            java.lang.Number retainInterval;
            java.lang.Object schedules;
            java.lang.Object targetTags;

            /**
             * Sets the value of {@link PolicyDetailsProperty#getActions}
             * @param actions <em>[Event-based policies only]</em> The actions to be performed when the event-based policy is activated.
             *                You can specify only one action per policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(software.amazon.awscdk.IResolvable actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getActions}
             * @param actions <em>[Event-based policies only]</em> The actions to be performed when the event-based policy is activated.
             *                You can specify only one action per policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<? extends java.lang.Object> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getCopyTags}
             * @param copyTags <em>[Default policies only]</em> Indicates whether the policy should copy tags from the source resource to the snapshot or AMI.
             *                 If you do not specify a value, the default is <code>false</code> .
             *                 <p>
             *                 Default: false
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTags(java.lang.Boolean copyTags) {
                this.copyTags = copyTags;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getCopyTags}
             * @param copyTags <em>[Default policies only]</em> Indicates whether the policy should copy tags from the source resource to the snapshot or AMI.
             *                 If you do not specify a value, the default is <code>false</code> .
             *                 <p>
             *                 Default: false
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTags(software.amazon.awscdk.IResolvable copyTags) {
                this.copyTags = copyTags;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getCreateInterval}
             * @param createInterval <em>[Default policies only]</em> Specifies how often the policy should run and create snapshots or AMIs.
             *                       The creation frequency can range from 1 to 7 days. If you do not specify a value, the default is 1.
             *                       <p>
             *                       Default: 1
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createInterval(java.lang.Number createInterval) {
                this.createInterval = createInterval;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getCrossRegionCopyTargets}
             * @param crossRegionCopyTargets <em>[Default policies only]</em> Specifies destination Regions for snapshot or AMI copies.
             *                               You can specify up to 3 destination Regions. If you do not want to create cross-Region copies, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossRegionCopyTargets(java.lang.Object crossRegionCopyTargets) {
                this.crossRegionCopyTargets = crossRegionCopyTargets;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getEventSource}
             * @param eventSource <em>[Event-based policies only]</em> The event that activates the event-based policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventSource(software.amazon.awscdk.IResolvable eventSource) {
                this.eventSource = eventSource;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getEventSource}
             * @param eventSource <em>[Event-based policies only]</em> The event that activates the event-based policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventSource(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.EventSourceProperty eventSource) {
                this.eventSource = eventSource;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getExclusions}
             * @param exclusions <em>[Default policies only]</em> Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs.
             *                   The policy will not create snapshots or AMIs for target resources that match any of the specified exclusion parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusions(software.amazon.awscdk.IResolvable exclusions) {
                this.exclusions = exclusions;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getExclusions}
             * @param exclusions <em>[Default policies only]</em> Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs.
             *                   The policy will not create snapshots or AMIs for target resources that match any of the specified exclusion parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusions(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.ExclusionsProperty exclusions) {
                this.exclusions = exclusions;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getExtendDeletion}
             * @param extendDeletion <em>[Default policies only]</em> Defines the snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state.
             *                       By default ( <em>ExtendDeletion=false</em> ):
             *                       <p>
             *                       <ul>
             *                       <li>If a source resource is deleted, Amazon Data Lifecycle Manager will continue to delete previously created snapshots or AMIs, up to but not including the last one, based on the specified retention period. If you want Amazon Data Lifecycle Manager to delete all snapshots or AMIs, including the last one, specify <code>true</code> .</li>
             *                       <li>If a policy enters the error, disabled, or deleted state, Amazon Data Lifecycle Manager stops deleting snapshots and AMIs. If you want Amazon Data Lifecycle Manager to continue deleting snapshots or AMIs, including the last one, if the policy enters one of these states, specify <code>true</code> .</li>
             *                       </ul>
             *                       <p>
             *                       If you enable extended deletion ( <em>ExtendDeletion=true</em> ), you override both default behaviors simultaneously.
             *                       <p>
             *                       If you do not specify a value, the default is <code>false</code> .
             *                       <p>
             *                       Default: false
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extendDeletion(java.lang.Boolean extendDeletion) {
                this.extendDeletion = extendDeletion;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getExtendDeletion}
             * @param extendDeletion <em>[Default policies only]</em> Defines the snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state.
             *                       By default ( <em>ExtendDeletion=false</em> ):
             *                       <p>
             *                       <ul>
             *                       <li>If a source resource is deleted, Amazon Data Lifecycle Manager will continue to delete previously created snapshots or AMIs, up to but not including the last one, based on the specified retention period. If you want Amazon Data Lifecycle Manager to delete all snapshots or AMIs, including the last one, specify <code>true</code> .</li>
             *                       <li>If a policy enters the error, disabled, or deleted state, Amazon Data Lifecycle Manager stops deleting snapshots and AMIs. If you want Amazon Data Lifecycle Manager to continue deleting snapshots or AMIs, including the last one, if the policy enters one of these states, specify <code>true</code> .</li>
             *                       </ul>
             *                       <p>
             *                       If you enable extended deletion ( <em>ExtendDeletion=true</em> ), you override both default behaviors simultaneously.
             *                       <p>
             *                       If you do not specify a value, the default is <code>false</code> .
             *                       <p>
             *                       Default: false
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extendDeletion(software.amazon.awscdk.IResolvable extendDeletion) {
                this.extendDeletion = extendDeletion;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getParameters}
             * @param parameters <em>[Custom snapshot and AMI policies only]</em> A set of optional parameters for snapshot and AMI lifecycle policies.
             *                   <blockquote>
             *                   <p>
             *                   If you are modifying a policy that was created or previously modified using the Amazon Data Lifecycle Manager console, then you must include this parameter and specify either the default values or the new values that you require. You can't omit this parameter or set its values to null.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getParameters}
             * @param parameters <em>[Custom snapshot and AMI policies only]</em> A set of optional parameters for snapshot and AMI lifecycle policies.
             *                   <blockquote>
             *                   <p>
             *                   If you are modifying a policy that was created or previously modified using the Amazon Data Lifecycle Manager console, then you must include this parameter and specify either the default values or the new values that you require. You can't omit this parameter or set its values to null.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.ParametersProperty parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getPolicyLanguage}
             * @param policyLanguage The type of policy to create. Specify one of the following:.
             *                       <ul>
             *                       <li><code>SIMPLIFIED</code> To create a default policy.</li>
             *                       <li><code>STANDARD</code> To create a custom policy.</li>
             *                       </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyLanguage(java.lang.String policyLanguage) {
                this.policyLanguage = policyLanguage;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getPolicyType}
             * @param policyType The type of policy.
             *                   Specify <code>EBS_SNAPSHOT_MANAGEMENT</code> to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify <code>IMAGE_MANAGEMENT</code> to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify <code>EVENT_BASED_POLICY</code> to create an event-based policy that performs specific actions when a defined event occurs in your AWS account .
             *                   <p>
             *                   The default is <code>EBS_SNAPSHOT_MANAGEMENT</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyType(java.lang.String policyType) {
                this.policyType = policyType;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getResourceLocations}
             * @param resourceLocations <em>[Custom snapshot and AMI policies only]</em> The location of the resources to backup.
             *                          If the source resources are located in an AWS Region , specify <code>CLOUD</code> . If the source resources are located on an Outpost in your account, specify <code>OUTPOST</code> .
             *                          <p>
             *                          If you specify <code>OUTPOST</code> , Amazon Data Lifecycle Manager backs up all resources of the specified type with matching target tags across all of the Outposts in your account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceLocations(java.util.List<java.lang.String> resourceLocations) {
                this.resourceLocations = resourceLocations;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getResourceType}
             * @param resourceType <em>[Default policies only]</em> Specify the type of default policy to create.
             *                     <ul>
             *                     <li>To create a default policy for EBS snapshots, that creates snapshots of all volumes in the Region that do not have recent backups, specify <code>VOLUME</code> .</li>
             *                     <li>To create a default policy for EBS-backed AMIs, that creates EBS-backed AMIs from all instances in the Region that do not have recent backups, specify <code>INSTANCE</code> .</li>
             *                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getResourceTypes}
             * @param resourceTypes <em>[Custom snapshot policies only]</em> The target resource type for snapshot and AMI lifecycle policies.
             *                      Use <code>VOLUME</code> to create snapshots of individual volumes or use <code>INSTANCE</code> to create multi-volume snapshots from the volumes for an instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTypes(java.util.List<java.lang.String> resourceTypes) {
                this.resourceTypes = resourceTypes;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getRetainInterval}
             * @param retainInterval <em>[Default policies only]</em> Specifies how long the policy should retain snapshots or AMIs before deleting them.
             *                       The retention period can range from 2 to 14 days, but it must be greater than the creation frequency to ensure that the policy retains at least 1 snapshot or AMI at any given time. If you do not specify a value, the default is 7.
             *                       <p>
             *                       Default: 7
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retainInterval(java.lang.Number retainInterval) {
                this.retainInterval = retainInterval;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getSchedules}
             * @param schedules <em>[Custom snapshot and AMI policies only]</em> The schedules of policy-defined actions for snapshot and AMI lifecycle policies.
             *                  A policy can have up to four schedules—one mandatory schedule and up to three optional schedules.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedules(software.amazon.awscdk.IResolvable schedules) {
                this.schedules = schedules;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getSchedules}
             * @param schedules <em>[Custom snapshot and AMI policies only]</em> The schedules of policy-defined actions for snapshot and AMI lifecycle policies.
             *                  A policy can have up to four schedules—one mandatory schedule and up to three optional schedules.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedules(java.util.List<? extends java.lang.Object> schedules) {
                this.schedules = schedules;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getTargetTags}
             * @param targetTags <em>[Custom snapshot and AMI policies only]</em> The single tag that identifies targeted resources for this policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetTags(software.amazon.awscdk.IResolvable targetTags) {
                this.targetTags = targetTags;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailsProperty#getTargetTags}
             * @param targetTags <em>[Custom snapshot and AMI policies only]</em> The single tag that identifies targeted resources for this policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetTags(java.util.List<? extends java.lang.Object> targetTags) {
                this.targetTags = targetTags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PolicyDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PolicyDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PolicyDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyDetailsProperty {
            private final java.lang.Object actions;
            private final java.lang.Object copyTags;
            private final java.lang.Number createInterval;
            private final java.lang.Object crossRegionCopyTargets;
            private final java.lang.Object eventSource;
            private final java.lang.Object exclusions;
            private final java.lang.Object extendDeletion;
            private final java.lang.Object parameters;
            private final java.lang.String policyLanguage;
            private final java.lang.String policyType;
            private final java.util.List<java.lang.String> resourceLocations;
            private final java.lang.String resourceType;
            private final java.util.List<java.lang.String> resourceTypes;
            private final java.lang.Number retainInterval;
            private final java.lang.Object schedules;
            private final java.lang.Object targetTags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.copyTags = software.amazon.jsii.Kernel.get(this, "copyTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.createInterval = software.amazon.jsii.Kernel.get(this, "createInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.crossRegionCopyTargets = software.amazon.jsii.Kernel.get(this, "crossRegionCopyTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eventSource = software.amazon.jsii.Kernel.get(this, "eventSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.exclusions = software.amazon.jsii.Kernel.get(this, "exclusions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.extendDeletion = software.amazon.jsii.Kernel.get(this, "extendDeletion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.policyLanguage = software.amazon.jsii.Kernel.get(this, "policyLanguage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.policyType = software.amazon.jsii.Kernel.get(this, "policyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceLocations = software.amazon.jsii.Kernel.get(this, "resourceLocations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceTypes = software.amazon.jsii.Kernel.get(this, "resourceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.retainInterval = software.amazon.jsii.Kernel.get(this, "retainInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.schedules = software.amazon.jsii.Kernel.get(this, "schedules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.targetTags = software.amazon.jsii.Kernel.get(this, "targetTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = builder.actions;
                this.copyTags = builder.copyTags;
                this.createInterval = builder.createInterval;
                this.crossRegionCopyTargets = builder.crossRegionCopyTargets;
                this.eventSource = builder.eventSource;
                this.exclusions = builder.exclusions;
                this.extendDeletion = builder.extendDeletion;
                this.parameters = builder.parameters;
                this.policyLanguage = builder.policyLanguage;
                this.policyType = builder.policyType;
                this.resourceLocations = builder.resourceLocations;
                this.resourceType = builder.resourceType;
                this.resourceTypes = builder.resourceTypes;
                this.retainInterval = builder.retainInterval;
                this.schedules = builder.schedules;
                this.targetTags = builder.targetTags;
            }

            @Override
            public final java.lang.Object getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.Object getCopyTags() {
                return this.copyTags;
            }

            @Override
            public final java.lang.Number getCreateInterval() {
                return this.createInterval;
            }

            @Override
            public final java.lang.Object getCrossRegionCopyTargets() {
                return this.crossRegionCopyTargets;
            }

            @Override
            public final java.lang.Object getEventSource() {
                return this.eventSource;
            }

            @Override
            public final java.lang.Object getExclusions() {
                return this.exclusions;
            }

            @Override
            public final java.lang.Object getExtendDeletion() {
                return this.extendDeletion;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            public final java.lang.String getPolicyLanguage() {
                return this.policyLanguage;
            }

            @Override
            public final java.lang.String getPolicyType() {
                return this.policyType;
            }

            @Override
            public final java.util.List<java.lang.String> getResourceLocations() {
                return this.resourceLocations;
            }

            @Override
            public final java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public final java.util.List<java.lang.String> getResourceTypes() {
                return this.resourceTypes;
            }

            @Override
            public final java.lang.Number getRetainInterval() {
                return this.retainInterval;
            }

            @Override
            public final java.lang.Object getSchedules() {
                return this.schedules;
            }

            @Override
            public final java.lang.Object getTargetTags() {
                return this.targetTags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getActions() != null) {
                    data.set("actions", om.valueToTree(this.getActions()));
                }
                if (this.getCopyTags() != null) {
                    data.set("copyTags", om.valueToTree(this.getCopyTags()));
                }
                if (this.getCreateInterval() != null) {
                    data.set("createInterval", om.valueToTree(this.getCreateInterval()));
                }
                if (this.getCrossRegionCopyTargets() != null) {
                    data.set("crossRegionCopyTargets", om.valueToTree(this.getCrossRegionCopyTargets()));
                }
                if (this.getEventSource() != null) {
                    data.set("eventSource", om.valueToTree(this.getEventSource()));
                }
                if (this.getExclusions() != null) {
                    data.set("exclusions", om.valueToTree(this.getExclusions()));
                }
                if (this.getExtendDeletion() != null) {
                    data.set("extendDeletion", om.valueToTree(this.getExtendDeletion()));
                }
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }
                if (this.getPolicyLanguage() != null) {
                    data.set("policyLanguage", om.valueToTree(this.getPolicyLanguage()));
                }
                if (this.getPolicyType() != null) {
                    data.set("policyType", om.valueToTree(this.getPolicyType()));
                }
                if (this.getResourceLocations() != null) {
                    data.set("resourceLocations", om.valueToTree(this.getResourceLocations()));
                }
                if (this.getResourceType() != null) {
                    data.set("resourceType", om.valueToTree(this.getResourceType()));
                }
                if (this.getResourceTypes() != null) {
                    data.set("resourceTypes", om.valueToTree(this.getResourceTypes()));
                }
                if (this.getRetainInterval() != null) {
                    data.set("retainInterval", om.valueToTree(this.getRetainInterval()));
                }
                if (this.getSchedules() != null) {
                    data.set("schedules", om.valueToTree(this.getSchedules()));
                }
                if (this.getTargetTags() != null) {
                    data.set("targetTags", om.valueToTree(this.getTargetTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.PolicyDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PolicyDetailsProperty.Jsii$Proxy that = (PolicyDetailsProperty.Jsii$Proxy) o;

                if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) return false;
                if (this.copyTags != null ? !this.copyTags.equals(that.copyTags) : that.copyTags != null) return false;
                if (this.createInterval != null ? !this.createInterval.equals(that.createInterval) : that.createInterval != null) return false;
                if (this.crossRegionCopyTargets != null ? !this.crossRegionCopyTargets.equals(that.crossRegionCopyTargets) : that.crossRegionCopyTargets != null) return false;
                if (this.eventSource != null ? !this.eventSource.equals(that.eventSource) : that.eventSource != null) return false;
                if (this.exclusions != null ? !this.exclusions.equals(that.exclusions) : that.exclusions != null) return false;
                if (this.extendDeletion != null ? !this.extendDeletion.equals(that.extendDeletion) : that.extendDeletion != null) return false;
                if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
                if (this.policyLanguage != null ? !this.policyLanguage.equals(that.policyLanguage) : that.policyLanguage != null) return false;
                if (this.policyType != null ? !this.policyType.equals(that.policyType) : that.policyType != null) return false;
                if (this.resourceLocations != null ? !this.resourceLocations.equals(that.resourceLocations) : that.resourceLocations != null) return false;
                if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
                if (this.resourceTypes != null ? !this.resourceTypes.equals(that.resourceTypes) : that.resourceTypes != null) return false;
                if (this.retainInterval != null ? !this.retainInterval.equals(that.retainInterval) : that.retainInterval != null) return false;
                if (this.schedules != null ? !this.schedules.equals(that.schedules) : that.schedules != null) return false;
                return this.targetTags != null ? this.targetTags.equals(that.targetTags) : that.targetTags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actions != null ? this.actions.hashCode() : 0;
                result = 31 * result + (this.copyTags != null ? this.copyTags.hashCode() : 0);
                result = 31 * result + (this.createInterval != null ? this.createInterval.hashCode() : 0);
                result = 31 * result + (this.crossRegionCopyTargets != null ? this.crossRegionCopyTargets.hashCode() : 0);
                result = 31 * result + (this.eventSource != null ? this.eventSource.hashCode() : 0);
                result = 31 * result + (this.exclusions != null ? this.exclusions.hashCode() : 0);
                result = 31 * result + (this.extendDeletion != null ? this.extendDeletion.hashCode() : 0);
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                result = 31 * result + (this.policyLanguage != null ? this.policyLanguage.hashCode() : 0);
                result = 31 * result + (this.policyType != null ? this.policyType.hashCode() : 0);
                result = 31 * result + (this.resourceLocations != null ? this.resourceLocations.hashCode() : 0);
                result = 31 * result + (this.resourceType != null ? this.resourceType.hashCode() : 0);
                result = 31 * result + (this.resourceTypes != null ? this.resourceTypes.hashCode() : 0);
                result = 31 * result + (this.retainInterval != null ? this.retainInterval.hashCode() : 0);
                result = 31 * result + (this.schedules != null ? this.schedules.hashCode() : 0);
                result = 31 * result + (this.targetTags != null ? this.targetTags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <em>[Custom snapshot and AMI policies only]</em> Specifies a retention rule for snapshots created by snapshot policies, or for AMIs created by AMI policies.
     * <p>
     * <blockquote>
     * <p>
     * For snapshot policies that have an <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html">ArchiveRule</a> , this retention rule applies to standard tier retention. When the retention threshold is met, snapshots are moved from the standard to the archive tier.
     * <p>
     * For snapshot policies that do not have an <em>ArchiveRule</em> , snapshots are permanently deleted when this retention threshold is met.
     * <p>
     * </blockquote>
     * <p>
     * You can retain snapshots based on either a count or a time interval.
     * <p>
     * <ul>
     * <li><em>Count-based retention</em></li>
     * </ul>
     * <p>
     * You must specify <em>Count</em> . If you specify an <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html">ArchiveRule</a> for the schedule, then you can specify a retention count of <code>0</code> to archive snapshots immediately after creation. If you specify a <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_FastRestoreRule.html">FastRestoreRule</a> , <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_ShareRule.html">ShareRule</a> , or a <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_CrossRegionCopyRule.html">CrossRegionCopyRule</a> , then you must specify a retention count of <code>1</code> or more.
     * <p>
     * <ul>
     * <li><em>Age-based retention</em></li>
     * </ul>
     * <p>
     * You must specify <em>Interval</em> and <em>IntervalUnit</em> . If you specify an <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html">ArchiveRule</a> for the schedule, then you can specify a retention interval of <code>0</code> days to archive snapshots immediately after creation. If you specify a <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_FastRestoreRule.html">FastRestoreRule</a> , <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_ShareRule.html">ShareRule</a> , or a <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_CrossRegionCopyRule.html">CrossRegionCopyRule</a> , then you must specify a retention interval of <code>1</code> day or more.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * RetainRuleProperty retainRuleProperty = RetainRuleProperty.builder()
     *         .count(123)
     *         .interval(123)
     *         .intervalUnit("intervalUnit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retainrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retainrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.RetainRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(RetainRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetainRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of snapshots to retain for each volume, up to a maximum of 1000.
         * <p>
         * For example if you want to retain a maximum of three snapshots, specify <code>3</code> . When the fourth snapshot is created, the oldest retained snapshot is deleted, or it is moved to the archive tier if you have specified an <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html">ArchiveRule</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retainrule.html#cfn-dlm-lifecyclepolicy-retainrule-count">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retainrule.html#cfn-dlm-lifecyclepolicy-retainrule-count</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCount() {
            return null;
        }

        /**
         * The amount of time to retain each snapshot.
         * <p>
         * The maximum is 100 years. This is equivalent to 1200 months, 5200 weeks, or 36500 days.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retainrule.html#cfn-dlm-lifecyclepolicy-retainrule-interval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retainrule.html#cfn-dlm-lifecyclepolicy-retainrule-interval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInterval() {
            return null;
        }

        /**
         * The unit of time for time-based retention.
         * <p>
         * For example, to retain snapshots for 3 months, specify <code>Interval=3</code> and <code>IntervalUnit=MONTHS</code> . Once the snapshot has been retained for 3 months, it is deleted, or it is moved to the archive tier if you have specified an <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html">ArchiveRule</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retainrule.html#cfn-dlm-lifecyclepolicy-retainrule-intervalunit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retainrule.html#cfn-dlm-lifecyclepolicy-retainrule-intervalunit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIntervalUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RetainRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetainRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetainRuleProperty> {
            java.lang.Number count;
            java.lang.Number interval;
            java.lang.String intervalUnit;

            /**
             * Sets the value of {@link RetainRuleProperty#getCount}
             * @param count The number of snapshots to retain for each volume, up to a maximum of 1000.
             *              For example if you want to retain a maximum of three snapshots, specify <code>3</code> . When the fourth snapshot is created, the oldest retained snapshot is deleted, or it is moved to the archive tier if you have specified an <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html">ArchiveRule</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder count(java.lang.Number count) {
                this.count = count;
                return this;
            }

            /**
             * Sets the value of {@link RetainRuleProperty#getInterval}
             * @param interval The amount of time to retain each snapshot.
             *                 The maximum is 100 years. This is equivalent to 1200 months, 5200 weeks, or 36500 days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.Number interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link RetainRuleProperty#getIntervalUnit}
             * @param intervalUnit The unit of time for time-based retention.
             *                     For example, to retain snapshots for 3 months, specify <code>Interval=3</code> and <code>IntervalUnit=MONTHS</code> . Once the snapshot has been retained for 3 months, it is deleted, or it is moved to the archive tier if you have specified an <a href="https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html">ArchiveRule</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalUnit(java.lang.String intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetainRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetainRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetainRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetainRuleProperty {
            private final java.lang.Number count;
            private final java.lang.Number interval;
            private final java.lang.String intervalUnit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.intervalUnit = software.amazon.jsii.Kernel.get(this, "intervalUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.count = builder.count;
                this.interval = builder.interval;
                this.intervalUnit = builder.intervalUnit;
            }

            @Override
            public final java.lang.Number getCount() {
                return this.count;
            }

            @Override
            public final java.lang.Number getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.String getIntervalUnit() {
                return this.intervalUnit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCount() != null) {
                    data.set("count", om.valueToTree(this.getCount()));
                }
                if (this.getInterval() != null) {
                    data.set("interval", om.valueToTree(this.getInterval()));
                }
                if (this.getIntervalUnit() != null) {
                    data.set("intervalUnit", om.valueToTree(this.getIntervalUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.RetainRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetainRuleProperty.Jsii$Proxy that = (RetainRuleProperty.Jsii$Proxy) o;

                if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
                if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
                return this.intervalUnit != null ? this.intervalUnit.equals(that.intervalUnit) : that.intervalUnit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.count != null ? this.count.hashCode() : 0;
                result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
                result = 31 * result + (this.intervalUnit != null ? this.intervalUnit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <em>[Custom snapshot policies only]</em> Describes the retention rule for archived snapshots.
     * <p>
     * Once the archive retention threshold is met, the snapshots are permanently deleted from the archive tier.
     * <p>
     * <blockquote>
     * <p>
     * The archive retention rule must retain snapshots in the archive tier for a minimum of 90 days.
     * <p>
     * </blockquote>
     * <p>
     * For <em>count-based schedules</em> , you must specify <em>Count</em> . For <em>age-based schedules</em> , you must specify <em>Interval</em> and <em>IntervalUnit</em> .
     * <p>
     * For more information about using snapshot archiving, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-ami-policy.html#dlm-archive">Considerations for snapshot lifecycle policies</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * RetentionArchiveTierProperty retentionArchiveTierProperty = RetentionArchiveTierProperty.builder()
     *         .count(123)
     *         .interval(123)
     *         .intervalUnit("intervalUnit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retentionarchivetier.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retentionarchivetier.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.RetentionArchiveTierProperty")
    @software.amazon.jsii.Jsii.Proxy(RetentionArchiveTierProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetentionArchiveTierProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of snapshots to retain in the archive storage tier for each volume.
         * <p>
         * The count must ensure that each snapshot remains in the archive tier for at least 90 days. For example, if the schedule creates snapshots every 30 days, you must specify a count of 3 or more to ensure that each snapshot is archived for at least 90 days.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retentionarchivetier.html#cfn-dlm-lifecyclepolicy-retentionarchivetier-count">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retentionarchivetier.html#cfn-dlm-lifecyclepolicy-retentionarchivetier-count</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCount() {
            return null;
        }

        /**
         * Specifies the period of time to retain snapshots in the archive tier.
         * <p>
         * After this period expires, the snapshot is permanently deleted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retentionarchivetier.html#cfn-dlm-lifecyclepolicy-retentionarchivetier-interval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retentionarchivetier.html#cfn-dlm-lifecyclepolicy-retentionarchivetier-interval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInterval() {
            return null;
        }

        /**
         * The unit of time in which to measure the <em>Interval</em> .
         * <p>
         * For example, to retain a snapshots in the archive tier for 6 months, specify <code>Interval=6</code> and <code>IntervalUnit=MONTHS</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retentionarchivetier.html#cfn-dlm-lifecyclepolicy-retentionarchivetier-intervalunit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retentionarchivetier.html#cfn-dlm-lifecyclepolicy-retentionarchivetier-intervalunit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIntervalUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RetentionArchiveTierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetentionArchiveTierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetentionArchiveTierProperty> {
            java.lang.Number count;
            java.lang.Number interval;
            java.lang.String intervalUnit;

            /**
             * Sets the value of {@link RetentionArchiveTierProperty#getCount}
             * @param count The maximum number of snapshots to retain in the archive storage tier for each volume.
             *              The count must ensure that each snapshot remains in the archive tier for at least 90 days. For example, if the schedule creates snapshots every 30 days, you must specify a count of 3 or more to ensure that each snapshot is archived for at least 90 days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder count(java.lang.Number count) {
                this.count = count;
                return this;
            }

            /**
             * Sets the value of {@link RetentionArchiveTierProperty#getInterval}
             * @param interval Specifies the period of time to retain snapshots in the archive tier.
             *                 After this period expires, the snapshot is permanently deleted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.Number interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link RetentionArchiveTierProperty#getIntervalUnit}
             * @param intervalUnit The unit of time in which to measure the <em>Interval</em> .
             *                     For example, to retain a snapshots in the archive tier for 6 months, specify <code>Interval=6</code> and <code>IntervalUnit=MONTHS</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalUnit(java.lang.String intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetentionArchiveTierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetentionArchiveTierProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetentionArchiveTierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetentionArchiveTierProperty {
            private final java.lang.Number count;
            private final java.lang.Number interval;
            private final java.lang.String intervalUnit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.intervalUnit = software.amazon.jsii.Kernel.get(this, "intervalUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.count = builder.count;
                this.interval = builder.interval;
                this.intervalUnit = builder.intervalUnit;
            }

            @Override
            public final java.lang.Number getCount() {
                return this.count;
            }

            @Override
            public final java.lang.Number getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.String getIntervalUnit() {
                return this.intervalUnit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCount() != null) {
                    data.set("count", om.valueToTree(this.getCount()));
                }
                if (this.getInterval() != null) {
                    data.set("interval", om.valueToTree(this.getInterval()));
                }
                if (this.getIntervalUnit() != null) {
                    data.set("intervalUnit", om.valueToTree(this.getIntervalUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.RetentionArchiveTierProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetentionArchiveTierProperty.Jsii$Proxy that = (RetentionArchiveTierProperty.Jsii$Proxy) o;

                if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
                if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
                return this.intervalUnit != null ? this.intervalUnit.equals(that.intervalUnit) : that.intervalUnit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.count != null ? this.count.hashCode() : 0;
                result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
                result = 31 * result + (this.intervalUnit != null ? this.intervalUnit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <em>[Custom snapshot and AMI policies only]</em> Specifies a schedule for a snapshot or AMI lifecycle policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * ScheduleProperty scheduleProperty = ScheduleProperty.builder()
     *         .archiveRule(ArchiveRuleProperty.builder()
     *                 .retainRule(ArchiveRetainRuleProperty.builder()
     *                         .retentionArchiveTier(RetentionArchiveTierProperty.builder()
     *                                 .count(123)
     *                                 .interval(123)
     *                                 .intervalUnit("intervalUnit")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .copyTags(false)
     *         .createRule(CreateRuleProperty.builder()
     *                 .cronExpression("cronExpression")
     *                 .interval(123)
     *                 .intervalUnit("intervalUnit")
     *                 .location("location")
     *                 .scripts(List.of(ScriptProperty.builder()
     *                         .executeOperationOnScriptFailure(false)
     *                         .executionHandler("executionHandler")
     *                         .executionHandlerService("executionHandlerService")
     *                         .executionTimeout(123)
     *                         .maximumRetryCount(123)
     *                         .stages(List.of("stages"))
     *                         .build()))
     *                 .times(List.of("times"))
     *                 .build())
     *         .crossRegionCopyRules(List.of(CrossRegionCopyRuleProperty.builder()
     *                 .encrypted(false)
     *                 // the properties below are optional
     *                 .cmkArn("cmkArn")
     *                 .copyTags(false)
     *                 .deprecateRule(CrossRegionCopyDeprecateRuleProperty.builder()
     *                         .interval(123)
     *                         .intervalUnit("intervalUnit")
     *                         .build())
     *                 .retainRule(CrossRegionCopyRetainRuleProperty.builder()
     *                         .interval(123)
     *                         .intervalUnit("intervalUnit")
     *                         .build())
     *                 .target("target")
     *                 .targetRegion("targetRegion")
     *                 .build()))
     *         .deprecateRule(DeprecateRuleProperty.builder()
     *                 .count(123)
     *                 .interval(123)
     *                 .intervalUnit("intervalUnit")
     *                 .build())
     *         .fastRestoreRule(FastRestoreRuleProperty.builder()
     *                 .availabilityZones(List.of("availabilityZones"))
     *                 .count(123)
     *                 .interval(123)
     *                 .intervalUnit("intervalUnit")
     *                 .build())
     *         .name("name")
     *         .retainRule(RetainRuleProperty.builder()
     *                 .count(123)
     *                 .interval(123)
     *                 .intervalUnit("intervalUnit")
     *                 .build())
     *         .shareRules(List.of(ShareRuleProperty.builder()
     *                 .targetAccounts(List.of("targetAccounts"))
     *                 .unshareInterval(123)
     *                 .unshareIntervalUnit("unshareIntervalUnit")
     *                 .build()))
     *         .tagsToAdd(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .variableTags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ScheduleProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * <em>[Custom snapshot policies that target volumes only]</em> The snapshot archiving rule for the schedule.
         * <p>
         * When you specify an archiving rule, snapshots are automatically moved from the standard tier to the archive tier once the schedule's retention threshold is met. Snapshots are then retained in the archive tier for the archive retention period that you specify.
         * <p>
         * For more information about using snapshot archiving, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-ami-policy.html#dlm-archive">Considerations for snapshot lifecycle policies</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-archiverule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-archiverule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getArchiveRule() {
            return null;
        }

        /**
         * Copy all user-defined tags on a source volume to snapshots of the volume created by this policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-copytags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-copytags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCopyTags() {
            return null;
        }

        /**
         * The creation rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-createrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-createrule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCreateRule() {
            return null;
        }

        /**
         * Specifies a rule for copying snapshots or AMIs across regions.
         * <p>
         * <blockquote>
         * <p>
         * You can't specify cross-Region copy rules for policies that create snapshots on an Outpost. If the policy creates snapshots in a Region, then snapshots can be copied to up to three Regions or Outposts.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-crossregioncopyrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-crossregioncopyrules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrossRegionCopyRules() {
            return null;
        }

        /**
         * <em>[Custom AMI policies only]</em> The AMI deprecation rule for the schedule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-deprecaterule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-deprecaterule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeprecateRule() {
            return null;
        }

        /**
         * <em>[Custom snapshot policies only]</em> The rule for enabling fast snapshot restore.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-fastrestorerule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-fastrestorerule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFastRestoreRule() {
            return null;
        }

        /**
         * The name of the schedule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The retention rule for snapshots or AMIs created by the policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-retainrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-retainrule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetainRule() {
            return null;
        }

        /**
         * <em>[Custom snapshot policies only]</em> The rule for sharing snapshots with other AWS accounts .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-sharerules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-sharerules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getShareRules() {
            return null;
        }

        /**
         * The tags to apply to policy-created resources.
         * <p>
         * These user-defined tags are in addition to the AWS -added lifecycle tags.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-tagstoadd">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-tagstoadd</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagsToAdd() {
            return null;
        }

        /**
         * <em>[AMI policies and snapshot policies that target instances only]</em> A collection of key/value pairs with values determined dynamically when the policy is executed.
         * <p>
         * Keys may be any valid Amazon EC2 tag key. Values must be in one of the two following formats: <code>$(instance-id)</code> or <code>$(timestamp)</code> . Variable tags are only valid for EBS Snapshot Management – Instance policies.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-variabletags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-variabletags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVariableTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduleProperty> {
            java.lang.Object archiveRule;
            java.lang.Object copyTags;
            java.lang.Object createRule;
            java.lang.Object crossRegionCopyRules;
            java.lang.Object deprecateRule;
            java.lang.Object fastRestoreRule;
            java.lang.String name;
            java.lang.Object retainRule;
            java.lang.Object shareRules;
            java.lang.Object tagsToAdd;
            java.lang.Object variableTags;

            /**
             * Sets the value of {@link ScheduleProperty#getArchiveRule}
             * @param archiveRule <em>[Custom snapshot policies that target volumes only]</em> The snapshot archiving rule for the schedule.
             *                    When you specify an archiving rule, snapshots are automatically moved from the standard tier to the archive tier once the schedule's retention threshold is met. Snapshots are then retained in the archive tier for the archive retention period that you specify.
             *                    <p>
             *                    For more information about using snapshot archiving, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-ami-policy.html#dlm-archive">Considerations for snapshot lifecycle policies</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder archiveRule(software.amazon.awscdk.IResolvable archiveRule) {
                this.archiveRule = archiveRule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getArchiveRule}
             * @param archiveRule <em>[Custom snapshot policies that target volumes only]</em> The snapshot archiving rule for the schedule.
             *                    When you specify an archiving rule, snapshots are automatically moved from the standard tier to the archive tier once the schedule's retention threshold is met. Snapshots are then retained in the archive tier for the archive retention period that you specify.
             *                    <p>
             *                    For more information about using snapshot archiving, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-ami-policy.html#dlm-archive">Considerations for snapshot lifecycle policies</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder archiveRule(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.ArchiveRuleProperty archiveRule) {
                this.archiveRule = archiveRule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getCopyTags}
             * @param copyTags Copy all user-defined tags on a source volume to snapshots of the volume created by this policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTags(java.lang.Boolean copyTags) {
                this.copyTags = copyTags;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getCopyTags}
             * @param copyTags Copy all user-defined tags on a source volume to snapshots of the volume created by this policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTags(software.amazon.awscdk.IResolvable copyTags) {
                this.copyTags = copyTags;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getCreateRule}
             * @param createRule The creation rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createRule(software.amazon.awscdk.IResolvable createRule) {
                this.createRule = createRule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getCreateRule}
             * @param createRule The creation rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createRule(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.CreateRuleProperty createRule) {
                this.createRule = createRule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getCrossRegionCopyRules}
             * @param crossRegionCopyRules Specifies a rule for copying snapshots or AMIs across regions.
             *                             <blockquote>
             *                             <p>
             *                             You can't specify cross-Region copy rules for policies that create snapshots on an Outpost. If the policy creates snapshots in a Region, then snapshots can be copied to up to three Regions or Outposts.
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossRegionCopyRules(software.amazon.awscdk.IResolvable crossRegionCopyRules) {
                this.crossRegionCopyRules = crossRegionCopyRules;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getCrossRegionCopyRules}
             * @param crossRegionCopyRules Specifies a rule for copying snapshots or AMIs across regions.
             *                             <blockquote>
             *                             <p>
             *                             You can't specify cross-Region copy rules for policies that create snapshots on an Outpost. If the policy creates snapshots in a Region, then snapshots can be copied to up to three Regions or Outposts.
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossRegionCopyRules(java.util.List<? extends java.lang.Object> crossRegionCopyRules) {
                this.crossRegionCopyRules = crossRegionCopyRules;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getDeprecateRule}
             * @param deprecateRule <em>[Custom AMI policies only]</em> The AMI deprecation rule for the schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deprecateRule(software.amazon.awscdk.IResolvable deprecateRule) {
                this.deprecateRule = deprecateRule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getDeprecateRule}
             * @param deprecateRule <em>[Custom AMI policies only]</em> The AMI deprecation rule for the schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deprecateRule(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.DeprecateRuleProperty deprecateRule) {
                this.deprecateRule = deprecateRule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getFastRestoreRule}
             * @param fastRestoreRule <em>[Custom snapshot policies only]</em> The rule for enabling fast snapshot restore.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fastRestoreRule(software.amazon.awscdk.IResolvable fastRestoreRule) {
                this.fastRestoreRule = fastRestoreRule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getFastRestoreRule}
             * @param fastRestoreRule <em>[Custom snapshot policies only]</em> The rule for enabling fast snapshot restore.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fastRestoreRule(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.FastRestoreRuleProperty fastRestoreRule) {
                this.fastRestoreRule = fastRestoreRule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getName}
             * @param name The name of the schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getRetainRule}
             * @param retainRule The retention rule for snapshots or AMIs created by the policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retainRule(software.amazon.awscdk.IResolvable retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getRetainRule}
             * @param retainRule The retention rule for snapshots or AMIs created by the policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retainRule(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.RetainRuleProperty retainRule) {
                this.retainRule = retainRule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getShareRules}
             * @param shareRules <em>[Custom snapshot policies only]</em> The rule for sharing snapshots with other AWS accounts .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shareRules(software.amazon.awscdk.IResolvable shareRules) {
                this.shareRules = shareRules;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getShareRules}
             * @param shareRules <em>[Custom snapshot policies only]</em> The rule for sharing snapshots with other AWS accounts .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shareRules(java.util.List<? extends java.lang.Object> shareRules) {
                this.shareRules = shareRules;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getTagsToAdd}
             * @param tagsToAdd The tags to apply to policy-created resources.
             *                  These user-defined tags are in addition to the AWS -added lifecycle tags.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagsToAdd(software.amazon.awscdk.IResolvable tagsToAdd) {
                this.tagsToAdd = tagsToAdd;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getTagsToAdd}
             * @param tagsToAdd The tags to apply to policy-created resources.
             *                  These user-defined tags are in addition to the AWS -added lifecycle tags.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagsToAdd(java.util.List<? extends java.lang.Object> tagsToAdd) {
                this.tagsToAdd = tagsToAdd;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getVariableTags}
             * @param variableTags <em>[AMI policies and snapshot policies that target instances only]</em> A collection of key/value pairs with values determined dynamically when the policy is executed.
             *                     Keys may be any valid Amazon EC2 tag key. Values must be in one of the two following formats: <code>$(instance-id)</code> or <code>$(timestamp)</code> . Variable tags are only valid for EBS Snapshot Management – Instance policies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variableTags(software.amazon.awscdk.IResolvable variableTags) {
                this.variableTags = variableTags;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getVariableTags}
             * @param variableTags <em>[AMI policies and snapshot policies that target instances only]</em> A collection of key/value pairs with values determined dynamically when the policy is executed.
             *                     Keys may be any valid Amazon EC2 tag key. Values must be in one of the two following formats: <code>$(instance-id)</code> or <code>$(timestamp)</code> . Variable tags are only valid for EBS Snapshot Management – Instance policies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variableTags(java.util.List<? extends java.lang.Object> variableTags) {
                this.variableTags = variableTags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleProperty {
            private final java.lang.Object archiveRule;
            private final java.lang.Object copyTags;
            private final java.lang.Object createRule;
            private final java.lang.Object crossRegionCopyRules;
            private final java.lang.Object deprecateRule;
            private final java.lang.Object fastRestoreRule;
            private final java.lang.String name;
            private final java.lang.Object retainRule;
            private final java.lang.Object shareRules;
            private final java.lang.Object tagsToAdd;
            private final java.lang.Object variableTags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.archiveRule = software.amazon.jsii.Kernel.get(this, "archiveRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.copyTags = software.amazon.jsii.Kernel.get(this, "copyTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.createRule = software.amazon.jsii.Kernel.get(this, "createRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.crossRegionCopyRules = software.amazon.jsii.Kernel.get(this, "crossRegionCopyRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deprecateRule = software.amazon.jsii.Kernel.get(this, "deprecateRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fastRestoreRule = software.amazon.jsii.Kernel.get(this, "fastRestoreRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.retainRule = software.amazon.jsii.Kernel.get(this, "retainRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.shareRules = software.amazon.jsii.Kernel.get(this, "shareRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tagsToAdd = software.amazon.jsii.Kernel.get(this, "tagsToAdd", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.variableTags = software.amazon.jsii.Kernel.get(this, "variableTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.archiveRule = builder.archiveRule;
                this.copyTags = builder.copyTags;
                this.createRule = builder.createRule;
                this.crossRegionCopyRules = builder.crossRegionCopyRules;
                this.deprecateRule = builder.deprecateRule;
                this.fastRestoreRule = builder.fastRestoreRule;
                this.name = builder.name;
                this.retainRule = builder.retainRule;
                this.shareRules = builder.shareRules;
                this.tagsToAdd = builder.tagsToAdd;
                this.variableTags = builder.variableTags;
            }

            @Override
            public final java.lang.Object getArchiveRule() {
                return this.archiveRule;
            }

            @Override
            public final java.lang.Object getCopyTags() {
                return this.copyTags;
            }

            @Override
            public final java.lang.Object getCreateRule() {
                return this.createRule;
            }

            @Override
            public final java.lang.Object getCrossRegionCopyRules() {
                return this.crossRegionCopyRules;
            }

            @Override
            public final java.lang.Object getDeprecateRule() {
                return this.deprecateRule;
            }

            @Override
            public final java.lang.Object getFastRestoreRule() {
                return this.fastRestoreRule;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getRetainRule() {
                return this.retainRule;
            }

            @Override
            public final java.lang.Object getShareRules() {
                return this.shareRules;
            }

            @Override
            public final java.lang.Object getTagsToAdd() {
                return this.tagsToAdd;
            }

            @Override
            public final java.lang.Object getVariableTags() {
                return this.variableTags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArchiveRule() != null) {
                    data.set("archiveRule", om.valueToTree(this.getArchiveRule()));
                }
                if (this.getCopyTags() != null) {
                    data.set("copyTags", om.valueToTree(this.getCopyTags()));
                }
                if (this.getCreateRule() != null) {
                    data.set("createRule", om.valueToTree(this.getCreateRule()));
                }
                if (this.getCrossRegionCopyRules() != null) {
                    data.set("crossRegionCopyRules", om.valueToTree(this.getCrossRegionCopyRules()));
                }
                if (this.getDeprecateRule() != null) {
                    data.set("deprecateRule", om.valueToTree(this.getDeprecateRule()));
                }
                if (this.getFastRestoreRule() != null) {
                    data.set("fastRestoreRule", om.valueToTree(this.getFastRestoreRule()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getRetainRule() != null) {
                    data.set("retainRule", om.valueToTree(this.getRetainRule()));
                }
                if (this.getShareRules() != null) {
                    data.set("shareRules", om.valueToTree(this.getShareRules()));
                }
                if (this.getTagsToAdd() != null) {
                    data.set("tagsToAdd", om.valueToTree(this.getTagsToAdd()));
                }
                if (this.getVariableTags() != null) {
                    data.set("variableTags", om.valueToTree(this.getVariableTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ScheduleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleProperty.Jsii$Proxy that = (ScheduleProperty.Jsii$Proxy) o;

                if (this.archiveRule != null ? !this.archiveRule.equals(that.archiveRule) : that.archiveRule != null) return false;
                if (this.copyTags != null ? !this.copyTags.equals(that.copyTags) : that.copyTags != null) return false;
                if (this.createRule != null ? !this.createRule.equals(that.createRule) : that.createRule != null) return false;
                if (this.crossRegionCopyRules != null ? !this.crossRegionCopyRules.equals(that.crossRegionCopyRules) : that.crossRegionCopyRules != null) return false;
                if (this.deprecateRule != null ? !this.deprecateRule.equals(that.deprecateRule) : that.deprecateRule != null) return false;
                if (this.fastRestoreRule != null ? !this.fastRestoreRule.equals(that.fastRestoreRule) : that.fastRestoreRule != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.retainRule != null ? !this.retainRule.equals(that.retainRule) : that.retainRule != null) return false;
                if (this.shareRules != null ? !this.shareRules.equals(that.shareRules) : that.shareRules != null) return false;
                if (this.tagsToAdd != null ? !this.tagsToAdd.equals(that.tagsToAdd) : that.tagsToAdd != null) return false;
                return this.variableTags != null ? this.variableTags.equals(that.variableTags) : that.variableTags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.archiveRule != null ? this.archiveRule.hashCode() : 0;
                result = 31 * result + (this.copyTags != null ? this.copyTags.hashCode() : 0);
                result = 31 * result + (this.createRule != null ? this.createRule.hashCode() : 0);
                result = 31 * result + (this.crossRegionCopyRules != null ? this.crossRegionCopyRules.hashCode() : 0);
                result = 31 * result + (this.deprecateRule != null ? this.deprecateRule.hashCode() : 0);
                result = 31 * result + (this.fastRestoreRule != null ? this.fastRestoreRule.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.retainRule != null ? this.retainRule.hashCode() : 0);
                result = 31 * result + (this.shareRules != null ? this.shareRules.hashCode() : 0);
                result = 31 * result + (this.tagsToAdd != null ? this.tagsToAdd.hashCode() : 0);
                result = 31 * result + (this.variableTags != null ? this.variableTags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <em>[Custom snapshot policies that target instances only]</em> Information about pre and/or post scripts for a snapshot lifecycle policy that targets instances.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/automate-app-consistent-backups.html">Automating application-consistent snapshots with pre and post scripts</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * ScriptProperty scriptProperty = ScriptProperty.builder()
     *         .executeOperationOnScriptFailure(false)
     *         .executionHandler("executionHandler")
     *         .executionHandlerService("executionHandlerService")
     *         .executionTimeout(123)
     *         .maximumRetryCount(123)
     *         .stages(List.of("stages"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-script.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-script.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ScriptProperty")
    @software.amazon.jsii.Jsii.Proxy(ScriptProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScriptProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether Amazon Data Lifecycle Manager should default to crash-consistent snapshots if the pre script fails.
         * <p>
         * <ul>
         * <li>To default to crash consistent snapshot if the pre script fails, specify <code>true</code> .</li>
         * <li>To skip the instance for snapshot creation if the pre script fails, specify <code>false</code> .</li>
         * </ul>
         * <p>
         * This parameter is supported only if you run a pre script. If you run a post script only, omit this parameter.
         * <p>
         * Default: true
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-script.html#cfn-dlm-lifecyclepolicy-script-executeoperationonscriptfailure">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-script.html#cfn-dlm-lifecyclepolicy-script-executeoperationonscriptfailure</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExecuteOperationOnScriptFailure() {
            return null;
        }

        /**
         * The SSM document that includes the pre and/or post scripts to run.
         * <p>
         * <ul>
         * <li>If you are automating VSS backups, specify <code>AWS_VSS_BACKUP</code> . In this case, Amazon Data Lifecycle Manager automatically uses the <code>AWSEC2-CreateVssSnapshot</code> SSM document.</li>
         * <li>If you are automating application-consistent snapshots for SAP HANA workloads, specify <code>AWSSystemsManagerSAP-CreateDLMSnapshotForSAPHANA</code> .</li>
         * <li>If you are using a custom SSM document that you own, specify either the name or ARN of the SSM document. If you are using a custom SSM document that is shared with you, specify the ARN of the SSM document.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-script.html#cfn-dlm-lifecyclepolicy-script-executionhandler">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-script.html#cfn-dlm-lifecyclepolicy-script-executionhandler</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExecutionHandler() {
            return null;
        }

        /**
         * Indicates the service used to execute the pre and/or post scripts.
         * <p>
         * <ul>
         * <li>If you are using custom SSM documents or automating application-consistent snapshots of SAP HANA workloads, specify <code>AWS_SYSTEMS_MANAGER</code> .</li>
         * <li>If you are automating VSS Backups, omit this parameter.</li>
         * </ul>
         * <p>
         * Default: AWS_SYSTEMS_MANAGER
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-script.html#cfn-dlm-lifecyclepolicy-script-executionhandlerservice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-script.html#cfn-dlm-lifecyclepolicy-script-executionhandlerservice</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExecutionHandlerService() {
            return null;
        }

        /**
         * Specifies a timeout period, in seconds, after which Amazon Data Lifecycle Manager fails the script run attempt if it has not completed.
         * <p>
         * If a script does not complete within its timeout period, Amazon Data Lifecycle Manager fails the attempt. The timeout period applies to the pre and post scripts individually.
         * <p>
         * If you are automating VSS Backups, omit this parameter.
         * <p>
         * Default: 10
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-script.html#cfn-dlm-lifecyclepolicy-script-executiontimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-script.html#cfn-dlm-lifecyclepolicy-script-executiontimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getExecutionTimeout() {
            return null;
        }

        /**
         * Specifies the number of times Amazon Data Lifecycle Manager should retry scripts that fail.
         * <p>
         * <ul>
         * <li>If the pre script fails, Amazon Data Lifecycle Manager retries the entire snapshot creation process, including running the pre and post scripts.</li>
         * <li>If the post script fails, Amazon Data Lifecycle Manager retries the post script only; in this case, the pre script will have completed and the snapshot might have been created.</li>
         * </ul>
         * <p>
         * If you do not want Amazon Data Lifecycle Manager to retry failed scripts, specify <code>0</code> .
         * <p>
         * Default: 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-script.html#cfn-dlm-lifecyclepolicy-script-maximumretrycount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-script.html#cfn-dlm-lifecyclepolicy-script-maximumretrycount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumRetryCount() {
            return null;
        }

        /**
         * Indicate which scripts Amazon Data Lifecycle Manager should run on target instances.
         * <p>
         * Pre scripts run before Amazon Data Lifecycle Manager initiates snapshot creation. Post scripts run after Amazon Data Lifecycle Manager initiates snapshot creation.
         * <p>
         * <ul>
         * <li>To run a pre script only, specify <code>PRE</code> . In this case, Amazon Data Lifecycle Manager calls the SSM document with the <code>pre-script</code> parameter before initiating snapshot creation.</li>
         * <li>To run a post script only, specify <code>POST</code> . In this case, Amazon Data Lifecycle Manager calls the SSM document with the <code>post-script</code> parameter after initiating snapshot creation.</li>
         * <li>To run both pre and post scripts, specify both <code>PRE</code> and <code>POST</code> . In this case, Amazon Data Lifecycle Manager calls the SSM document with the <code>pre-script</code> parameter before initiating snapshot creation, and then it calls the SSM document again with the <code>post-script</code> parameter after initiating snapshot creation.</li>
         * </ul>
         * <p>
         * If you are automating VSS Backups, omit this parameter.
         * <p>
         * Default: PRE and POST
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-script.html#cfn-dlm-lifecyclepolicy-script-stages">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-script.html#cfn-dlm-lifecyclepolicy-script-stages</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStages() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScriptProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScriptProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScriptProperty> {
            java.lang.Object executeOperationOnScriptFailure;
            java.lang.String executionHandler;
            java.lang.String executionHandlerService;
            java.lang.Number executionTimeout;
            java.lang.Number maximumRetryCount;
            java.util.List<java.lang.String> stages;

            /**
             * Sets the value of {@link ScriptProperty#getExecuteOperationOnScriptFailure}
             * @param executeOperationOnScriptFailure Indicates whether Amazon Data Lifecycle Manager should default to crash-consistent snapshots if the pre script fails.
             *                                        <ul>
             *                                        <li>To default to crash consistent snapshot if the pre script fails, specify <code>true</code> .</li>
             *                                        <li>To skip the instance for snapshot creation if the pre script fails, specify <code>false</code> .</li>
             *                                        </ul>
             *                                        <p>
             *                                        This parameter is supported only if you run a pre script. If you run a post script only, omit this parameter.
             *                                        <p>
             *                                        Default: true
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executeOperationOnScriptFailure(java.lang.Boolean executeOperationOnScriptFailure) {
                this.executeOperationOnScriptFailure = executeOperationOnScriptFailure;
                return this;
            }

            /**
             * Sets the value of {@link ScriptProperty#getExecuteOperationOnScriptFailure}
             * @param executeOperationOnScriptFailure Indicates whether Amazon Data Lifecycle Manager should default to crash-consistent snapshots if the pre script fails.
             *                                        <ul>
             *                                        <li>To default to crash consistent snapshot if the pre script fails, specify <code>true</code> .</li>
             *                                        <li>To skip the instance for snapshot creation if the pre script fails, specify <code>false</code> .</li>
             *                                        </ul>
             *                                        <p>
             *                                        This parameter is supported only if you run a pre script. If you run a post script only, omit this parameter.
             *                                        <p>
             *                                        Default: true
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executeOperationOnScriptFailure(software.amazon.awscdk.IResolvable executeOperationOnScriptFailure) {
                this.executeOperationOnScriptFailure = executeOperationOnScriptFailure;
                return this;
            }

            /**
             * Sets the value of {@link ScriptProperty#getExecutionHandler}
             * @param executionHandler The SSM document that includes the pre and/or post scripts to run.
             *                         <ul>
             *                         <li>If you are automating VSS backups, specify <code>AWS_VSS_BACKUP</code> . In this case, Amazon Data Lifecycle Manager automatically uses the <code>AWSEC2-CreateVssSnapshot</code> SSM document.</li>
             *                         <li>If you are automating application-consistent snapshots for SAP HANA workloads, specify <code>AWSSystemsManagerSAP-CreateDLMSnapshotForSAPHANA</code> .</li>
             *                         <li>If you are using a custom SSM document that you own, specify either the name or ARN of the SSM document. If you are using a custom SSM document that is shared with you, specify the ARN of the SSM document.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionHandler(java.lang.String executionHandler) {
                this.executionHandler = executionHandler;
                return this;
            }

            /**
             * Sets the value of {@link ScriptProperty#getExecutionHandlerService}
             * @param executionHandlerService Indicates the service used to execute the pre and/or post scripts.
             *                                <ul>
             *                                <li>If you are using custom SSM documents or automating application-consistent snapshots of SAP HANA workloads, specify <code>AWS_SYSTEMS_MANAGER</code> .</li>
             *                                <li>If you are automating VSS Backups, omit this parameter.</li>
             *                                </ul>
             *                                <p>
             *                                Default: AWS_SYSTEMS_MANAGER
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionHandlerService(java.lang.String executionHandlerService) {
                this.executionHandlerService = executionHandlerService;
                return this;
            }

            /**
             * Sets the value of {@link ScriptProperty#getExecutionTimeout}
             * @param executionTimeout Specifies a timeout period, in seconds, after which Amazon Data Lifecycle Manager fails the script run attempt if it has not completed.
             *                         If a script does not complete within its timeout period, Amazon Data Lifecycle Manager fails the attempt. The timeout period applies to the pre and post scripts individually.
             *                         <p>
             *                         If you are automating VSS Backups, omit this parameter.
             *                         <p>
             *                         Default: 10
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionTimeout(java.lang.Number executionTimeout) {
                this.executionTimeout = executionTimeout;
                return this;
            }

            /**
             * Sets the value of {@link ScriptProperty#getMaximumRetryCount}
             * @param maximumRetryCount Specifies the number of times Amazon Data Lifecycle Manager should retry scripts that fail.
             *                          <ul>
             *                          <li>If the pre script fails, Amazon Data Lifecycle Manager retries the entire snapshot creation process, including running the pre and post scripts.</li>
             *                          <li>If the post script fails, Amazon Data Lifecycle Manager retries the post script only; in this case, the pre script will have completed and the snapshot might have been created.</li>
             *                          </ul>
             *                          <p>
             *                          If you do not want Amazon Data Lifecycle Manager to retry failed scripts, specify <code>0</code> .
             *                          <p>
             *                          Default: 0
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumRetryCount(java.lang.Number maximumRetryCount) {
                this.maximumRetryCount = maximumRetryCount;
                return this;
            }

            /**
             * Sets the value of {@link ScriptProperty#getStages}
             * @param stages Indicate which scripts Amazon Data Lifecycle Manager should run on target instances.
             *               Pre scripts run before Amazon Data Lifecycle Manager initiates snapshot creation. Post scripts run after Amazon Data Lifecycle Manager initiates snapshot creation.
             *               <p>
             *               <ul>
             *               <li>To run a pre script only, specify <code>PRE</code> . In this case, Amazon Data Lifecycle Manager calls the SSM document with the <code>pre-script</code> parameter before initiating snapshot creation.</li>
             *               <li>To run a post script only, specify <code>POST</code> . In this case, Amazon Data Lifecycle Manager calls the SSM document with the <code>post-script</code> parameter after initiating snapshot creation.</li>
             *               <li>To run both pre and post scripts, specify both <code>PRE</code> and <code>POST</code> . In this case, Amazon Data Lifecycle Manager calls the SSM document with the <code>pre-script</code> parameter before initiating snapshot creation, and then it calls the SSM document again with the <code>post-script</code> parameter after initiating snapshot creation.</li>
             *               </ul>
             *               <p>
             *               If you are automating VSS Backups, omit this parameter.
             *               <p>
             *               Default: PRE and POST
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stages(java.util.List<java.lang.String> stages) {
                this.stages = stages;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScriptProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScriptProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScriptProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScriptProperty {
            private final java.lang.Object executeOperationOnScriptFailure;
            private final java.lang.String executionHandler;
            private final java.lang.String executionHandlerService;
            private final java.lang.Number executionTimeout;
            private final java.lang.Number maximumRetryCount;
            private final java.util.List<java.lang.String> stages;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.executeOperationOnScriptFailure = software.amazon.jsii.Kernel.get(this, "executeOperationOnScriptFailure", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.executionHandler = software.amazon.jsii.Kernel.get(this, "executionHandler", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.executionHandlerService = software.amazon.jsii.Kernel.get(this, "executionHandlerService", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.executionTimeout = software.amazon.jsii.Kernel.get(this, "executionTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumRetryCount = software.amazon.jsii.Kernel.get(this, "maximumRetryCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stages = software.amazon.jsii.Kernel.get(this, "stages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.executeOperationOnScriptFailure = builder.executeOperationOnScriptFailure;
                this.executionHandler = builder.executionHandler;
                this.executionHandlerService = builder.executionHandlerService;
                this.executionTimeout = builder.executionTimeout;
                this.maximumRetryCount = builder.maximumRetryCount;
                this.stages = builder.stages;
            }

            @Override
            public final java.lang.Object getExecuteOperationOnScriptFailure() {
                return this.executeOperationOnScriptFailure;
            }

            @Override
            public final java.lang.String getExecutionHandler() {
                return this.executionHandler;
            }

            @Override
            public final java.lang.String getExecutionHandlerService() {
                return this.executionHandlerService;
            }

            @Override
            public final java.lang.Number getExecutionTimeout() {
                return this.executionTimeout;
            }

            @Override
            public final java.lang.Number getMaximumRetryCount() {
                return this.maximumRetryCount;
            }

            @Override
            public final java.util.List<java.lang.String> getStages() {
                return this.stages;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExecuteOperationOnScriptFailure() != null) {
                    data.set("executeOperationOnScriptFailure", om.valueToTree(this.getExecuteOperationOnScriptFailure()));
                }
                if (this.getExecutionHandler() != null) {
                    data.set("executionHandler", om.valueToTree(this.getExecutionHandler()));
                }
                if (this.getExecutionHandlerService() != null) {
                    data.set("executionHandlerService", om.valueToTree(this.getExecutionHandlerService()));
                }
                if (this.getExecutionTimeout() != null) {
                    data.set("executionTimeout", om.valueToTree(this.getExecutionTimeout()));
                }
                if (this.getMaximumRetryCount() != null) {
                    data.set("maximumRetryCount", om.valueToTree(this.getMaximumRetryCount()));
                }
                if (this.getStages() != null) {
                    data.set("stages", om.valueToTree(this.getStages()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ScriptProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScriptProperty.Jsii$Proxy that = (ScriptProperty.Jsii$Proxy) o;

                if (this.executeOperationOnScriptFailure != null ? !this.executeOperationOnScriptFailure.equals(that.executeOperationOnScriptFailure) : that.executeOperationOnScriptFailure != null) return false;
                if (this.executionHandler != null ? !this.executionHandler.equals(that.executionHandler) : that.executionHandler != null) return false;
                if (this.executionHandlerService != null ? !this.executionHandlerService.equals(that.executionHandlerService) : that.executionHandlerService != null) return false;
                if (this.executionTimeout != null ? !this.executionTimeout.equals(that.executionTimeout) : that.executionTimeout != null) return false;
                if (this.maximumRetryCount != null ? !this.maximumRetryCount.equals(that.maximumRetryCount) : that.maximumRetryCount != null) return false;
                return this.stages != null ? this.stages.equals(that.stages) : that.stages == null;
            }

            @Override
            public final int hashCode() {
                int result = this.executeOperationOnScriptFailure != null ? this.executeOperationOnScriptFailure.hashCode() : 0;
                result = 31 * result + (this.executionHandler != null ? this.executionHandler.hashCode() : 0);
                result = 31 * result + (this.executionHandlerService != null ? this.executionHandlerService.hashCode() : 0);
                result = 31 * result + (this.executionTimeout != null ? this.executionTimeout.hashCode() : 0);
                result = 31 * result + (this.maximumRetryCount != null ? this.maximumRetryCount.hashCode() : 0);
                result = 31 * result + (this.stages != null ? this.stages.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <em>[Custom snapshot policies only]</em> Specifies a rule for sharing snapshots across AWS accounts .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dlm.*;
     * ShareRuleProperty shareRuleProperty = ShareRuleProperty.builder()
     *         .targetAccounts(List.of("targetAccounts"))
     *         .unshareInterval(123)
     *         .unshareIntervalUnit("unshareIntervalUnit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-sharerule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-sharerule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ShareRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(ShareRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ShareRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IDs of the AWS accounts with which to share the snapshots.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-sharerule.html#cfn-dlm-lifecyclepolicy-sharerule-targetaccounts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-sharerule.html#cfn-dlm-lifecyclepolicy-sharerule-targetaccounts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTargetAccounts() {
            return null;
        }

        /**
         * The period after which snapshots that are shared with other AWS accounts are automatically unshared.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-sharerule.html#cfn-dlm-lifecyclepolicy-sharerule-unshareinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-sharerule.html#cfn-dlm-lifecyclepolicy-sharerule-unshareinterval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getUnshareInterval() {
            return null;
        }

        /**
         * The unit of time for the automatic unsharing interval.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-sharerule.html#cfn-dlm-lifecyclepolicy-sharerule-unshareintervalunit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-sharerule.html#cfn-dlm-lifecyclepolicy-sharerule-unshareintervalunit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnshareIntervalUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ShareRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ShareRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ShareRuleProperty> {
            java.util.List<java.lang.String> targetAccounts;
            java.lang.Number unshareInterval;
            java.lang.String unshareIntervalUnit;

            /**
             * Sets the value of {@link ShareRuleProperty#getTargetAccounts}
             * @param targetAccounts The IDs of the AWS accounts with which to share the snapshots.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetAccounts(java.util.List<java.lang.String> targetAccounts) {
                this.targetAccounts = targetAccounts;
                return this;
            }

            /**
             * Sets the value of {@link ShareRuleProperty#getUnshareInterval}
             * @param unshareInterval The period after which snapshots that are shared with other AWS accounts are automatically unshared.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unshareInterval(java.lang.Number unshareInterval) {
                this.unshareInterval = unshareInterval;
                return this;
            }

            /**
             * Sets the value of {@link ShareRuleProperty#getUnshareIntervalUnit}
             * @param unshareIntervalUnit The unit of time for the automatic unsharing interval.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unshareIntervalUnit(java.lang.String unshareIntervalUnit) {
                this.unshareIntervalUnit = unshareIntervalUnit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ShareRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ShareRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ShareRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ShareRuleProperty {
            private final java.util.List<java.lang.String> targetAccounts;
            private final java.lang.Number unshareInterval;
            private final java.lang.String unshareIntervalUnit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetAccounts = software.amazon.jsii.Kernel.get(this, "targetAccounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.unshareInterval = software.amazon.jsii.Kernel.get(this, "unshareInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unshareIntervalUnit = software.amazon.jsii.Kernel.get(this, "unshareIntervalUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetAccounts = builder.targetAccounts;
                this.unshareInterval = builder.unshareInterval;
                this.unshareIntervalUnit = builder.unshareIntervalUnit;
            }

            @Override
            public final java.util.List<java.lang.String> getTargetAccounts() {
                return this.targetAccounts;
            }

            @Override
            public final java.lang.Number getUnshareInterval() {
                return this.unshareInterval;
            }

            @Override
            public final java.lang.String getUnshareIntervalUnit() {
                return this.unshareIntervalUnit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTargetAccounts() != null) {
                    data.set("targetAccounts", om.valueToTree(this.getTargetAccounts()));
                }
                if (this.getUnshareInterval() != null) {
                    data.set("unshareInterval", om.valueToTree(this.getUnshareInterval()));
                }
                if (this.getUnshareIntervalUnit() != null) {
                    data.set("unshareIntervalUnit", om.valueToTree(this.getUnshareIntervalUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicy.ShareRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ShareRuleProperty.Jsii$Proxy that = (ShareRuleProperty.Jsii$Proxy) o;

                if (this.targetAccounts != null ? !this.targetAccounts.equals(that.targetAccounts) : that.targetAccounts != null) return false;
                if (this.unshareInterval != null ? !this.unshareInterval.equals(that.unshareInterval) : that.unshareInterval != null) return false;
                return this.unshareIntervalUnit != null ? this.unshareIntervalUnit.equals(that.unshareIntervalUnit) : that.unshareIntervalUnit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetAccounts != null ? this.targetAccounts.hashCode() : 0;
                result = 31 * result + (this.unshareInterval != null ? this.unshareInterval.hashCode() : 0);
                result = 31 * result + (this.unshareIntervalUnit != null ? this.unshareIntervalUnit.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.dlm.CfnLifecyclePolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.dlm.CfnLifecyclePolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.dlm.CfnLifecyclePolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * <em>[Default policies only]</em> Indicates whether the policy should copy tags from the source resource to the snapshot or AMI.
         * <p>
         * If you do not specify a value, the default is <code>false</code> .
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-copytags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-copytags</a>
         * @param copyTags <em>[Default policies only]</em> Indicates whether the policy should copy tags from the source resource to the snapshot or AMI. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTags(final java.lang.Boolean copyTags) {
            this.props().copyTags(copyTags);
            return this;
        }
        /**
         * <em>[Default policies only]</em> Indicates whether the policy should copy tags from the source resource to the snapshot or AMI.
         * <p>
         * If you do not specify a value, the default is <code>false</code> .
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-copytags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-copytags</a>
         * @param copyTags <em>[Default policies only]</em> Indicates whether the policy should copy tags from the source resource to the snapshot or AMI. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTags(final software.amazon.awscdk.IResolvable copyTags) {
            this.props().copyTags(copyTags);
            return this;
        }

        /**
         * <em>[Default policies only]</em> Specifies how often the policy should run and create snapshots or AMIs.
         * <p>
         * The creation frequency can range from 1 to 7 days. If you do not specify a value, the default is 1.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-createinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-createinterval</a>
         * @param createInterval <em>[Default policies only]</em> Specifies how often the policy should run and create snapshots or AMIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createInterval(final java.lang.Number createInterval) {
            this.props().createInterval(createInterval);
            return this;
        }

        /**
         * <em>[Default policies only]</em> Specifies destination Regions for snapshot or AMI copies.
         * <p>
         * You can specify up to 3 destination Regions. If you do not want to create cross-Region copies, omit this parameter.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-crossregioncopytargets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-crossregioncopytargets</a>
         * @param crossRegionCopyTargets <em>[Default policies only]</em> Specifies destination Regions for snapshot or AMI copies. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossRegionCopyTargets(final java.lang.Object crossRegionCopyTargets) {
            this.props().crossRegionCopyTargets(crossRegionCopyTargets);
            return this;
        }

        /**
         * <em>[Default policies only]</em> Specify the type of default policy to create.
         * <p>
         * <ul>
         * <li>To create a default policy for EBS snapshots, that creates snapshots of all volumes in the Region that do not have recent backups, specify <code>VOLUME</code> .</li>
         * <li>To create a default policy for EBS-backed AMIs, that creates EBS-backed AMIs from all instances in the Region that do not have recent backups, specify <code>INSTANCE</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-defaultpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-defaultpolicy</a>
         * @param defaultPolicy <em>[Default policies only]</em> Specify the type of default policy to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultPolicy(final java.lang.String defaultPolicy) {
            this.props().defaultPolicy(defaultPolicy);
            return this;
        }

        /**
         * A description of the lifecycle policy.
         * <p>
         * The characters ^[0-9A-Za-z _-]+$ are supported.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-description</a>
         * @param description A description of the lifecycle policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * <em>[Default policies only]</em> Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs.
         * <p>
         * The policy will not create snapshots or AMIs for target resources that match any of the specified exclusion parameters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-exclusions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-exclusions</a>
         * @param exclusions <em>[Default policies only]</em> Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclusions(final software.amazon.awscdk.IResolvable exclusions) {
            this.props().exclusions(exclusions);
            return this;
        }
        /**
         * <em>[Default policies only]</em> Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs.
         * <p>
         * The policy will not create snapshots or AMIs for target resources that match any of the specified exclusion parameters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-exclusions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-exclusions</a>
         * @param exclusions <em>[Default policies only]</em> Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclusions(final software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.ExclusionsProperty exclusions) {
            this.props().exclusions(exclusions);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-executionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-executionrolearn</a>
         * @param executionRoleArn The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(final java.lang.String executionRoleArn) {
            this.props().executionRoleArn(executionRoleArn);
            return this;
        }

        /**
         * <em>[Default policies only]</em> Defines the snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state.
         * <p>
         * By default ( <em>ExtendDeletion=false</em> ):
         * <p>
         * <ul>
         * <li>If a source resource is deleted, Amazon Data Lifecycle Manager will continue to delete previously created snapshots or AMIs, up to but not including the last one, based on the specified retention period. If you want Amazon Data Lifecycle Manager to delete all snapshots or AMIs, including the last one, specify <code>true</code> .</li>
         * <li>If a policy enters the error, disabled, or deleted state, Amazon Data Lifecycle Manager stops deleting snapshots and AMIs. If you want Amazon Data Lifecycle Manager to continue deleting snapshots or AMIs, including the last one, if the policy enters one of these states, specify <code>true</code> .</li>
         * </ul>
         * <p>
         * If you enable extended deletion ( <em>ExtendDeletion=true</em> ), you override both default behaviors simultaneously.
         * <p>
         * If you do not specify a value, the default is <code>false</code> .
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-extenddeletion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-extenddeletion</a>
         * @param extendDeletion <em>[Default policies only]</em> Defines the snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extendDeletion(final java.lang.Boolean extendDeletion) {
            this.props().extendDeletion(extendDeletion);
            return this;
        }
        /**
         * <em>[Default policies only]</em> Defines the snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state.
         * <p>
         * By default ( <em>ExtendDeletion=false</em> ):
         * <p>
         * <ul>
         * <li>If a source resource is deleted, Amazon Data Lifecycle Manager will continue to delete previously created snapshots or AMIs, up to but not including the last one, based on the specified retention period. If you want Amazon Data Lifecycle Manager to delete all snapshots or AMIs, including the last one, specify <code>true</code> .</li>
         * <li>If a policy enters the error, disabled, or deleted state, Amazon Data Lifecycle Manager stops deleting snapshots and AMIs. If you want Amazon Data Lifecycle Manager to continue deleting snapshots or AMIs, including the last one, if the policy enters one of these states, specify <code>true</code> .</li>
         * </ul>
         * <p>
         * If you enable extended deletion ( <em>ExtendDeletion=true</em> ), you override both default behaviors simultaneously.
         * <p>
         * If you do not specify a value, the default is <code>false</code> .
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-extenddeletion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-extenddeletion</a>
         * @param extendDeletion <em>[Default policies only]</em> Defines the snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extendDeletion(final software.amazon.awscdk.IResolvable extendDeletion) {
            this.props().extendDeletion(extendDeletion);
            return this;
        }

        /**
         * The configuration details of the lifecycle policy.
         * <p>
         * <blockquote>
         * <p>
         * If you create a default policy, you can specify the request parameters either in the request body, or in the PolicyDetails request structure, but not both.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-policydetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-policydetails</a>
         * @param policyDetails The configuration details of the lifecycle policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDetails(final software.amazon.awscdk.IResolvable policyDetails) {
            this.props().policyDetails(policyDetails);
            return this;
        }
        /**
         * The configuration details of the lifecycle policy.
         * <p>
         * <blockquote>
         * <p>
         * If you create a default policy, you can specify the request parameters either in the request body, or in the PolicyDetails request structure, but not both.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-policydetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-policydetails</a>
         * @param policyDetails The configuration details of the lifecycle policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDetails(final software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.PolicyDetailsProperty policyDetails) {
            this.props().policyDetails(policyDetails);
            return this;
        }

        /**
         * <em>[Default policies only]</em> Specifies how long the policy should retain snapshots or AMIs before deleting them.
         * <p>
         * The retention period can range from 2 to 14 days, but it must be greater than the creation frequency to ensure that the policy retains at least 1 snapshot or AMI at any given time. If you do not specify a value, the default is 7.
         * <p>
         * Default: 7
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-retaininterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-retaininterval</a>
         * @param retainInterval <em>[Default policies only]</em> Specifies how long the policy should retain snapshots or AMIs before deleting them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainInterval(final java.lang.Number retainInterval) {
            this.props().retainInterval(retainInterval);
            return this;
        }

        /**
         * The activation state of the lifecycle policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-state</a>
         * @param state The activation state of the lifecycle policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(final java.lang.String state) {
            this.props().state(state);
            return this;
        }

        /**
         * The tags to apply to the lifecycle policy during creation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-tags</a>
         * @param tags The tags to apply to the lifecycle policy during creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.dlm.CfnLifecyclePolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.dlm.CfnLifecyclePolicy build() {
            return new software.amazon.awscdk.services.dlm.CfnLifecyclePolicy(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.dlm.CfnLifecyclePolicyProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.dlm.CfnLifecyclePolicyProps.Builder();
            }
            return this.props;
        }
    }
}
