package software.amazon.awscdk.services.dynamodb;

/**
 * DynamoDB's table class.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * TableV2 table = TableV2.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *         .contributorInsights(true)
 *         .tableClass(TableClass.STANDARD_INFREQUENT_ACCESS)
 *         .pointInTimeRecovery(true)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.TableClasses.html">https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.TableClasses.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:30.405Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.TableClass")
public enum TableClass {
    /**
     * Default table class for DynamoDB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
    /**
     * Table class for DynamoDB that reduces storage costs compared to existing DynamoDB standard tables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD_INFREQUENT_ACCESS,
}
