package software.amazon.awscdk.services.ecs;

/**
 * The base class for Ec2Service and FargateService services.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ecs.*;
 * IBaseService service = BaseService.fromServiceArnWithCluster(this, "EcsService", "arn:aws:ecs:us-east-1:123456789012:service/myClusterName/myServiceName");
 * Pipeline pipeline = new Pipeline(this, "MyPipeline");
 * Artifact buildOutput = new Artifact();
 * // add source and build stages to the pipeline as usual...
 * IStage deployStage = pipeline.addStage(StageOptions.builder()
 *         .stageName("Deploy")
 *         .actions(List.of(
 *             EcsDeployAction.Builder.create()
 *                     .actionName("DeployAction")
 *                     .service(service)
 *                     .input(buildOutput)
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:31.245Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.BaseService")
public abstract class BaseService extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ecs.IBaseService, software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget, software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget, software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget {

    protected BaseService(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BaseService(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the BaseService class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     * @param additionalProps This parameter is required.
     * @param taskDefinition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected BaseService(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.BaseServiceProps props, final @org.jetbrains.annotations.NotNull java.lang.Object additionalProps, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required"), additionalProps, java.util.Objects.requireNonNull(taskDefinition, "taskDefinition is required") });
    }

    /**
     * Import an existing ECS/Fargate Service using the service cluster format.
     * <p>
     * The format is the "new" format "arn:aws:ecs:region:aws_account_id:service/cluster-name/service-name".
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids</a>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param serviceArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.IBaseService fromServiceArnWithCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String serviceArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.BaseService.class, "fromServiceArnWithCluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.IBaseService.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(serviceArn, "serviceArn is required") });
    }

    /**
     * Adds a volume to the Service.
     * <p>
     * @param volume This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ServiceManagedVolume volume) {
        software.amazon.jsii.Kernel.call(this, "addVolume", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(volume, "volume is required") });
    }

    /**
     * Associates this service with a CloudMap service.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void associateCloudMapService(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.AssociateCloudMapServiceOptions options) {
        software.amazon.jsii.Kernel.call(this, "associateCloudMapService", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * This method is called to attach this service to an Application Load Balancer.
     * <p>
     * Don't call this function directly. Instead, call <code>listener.addTargets()</code>
     * to add this service to a load balancer.
     * <p>
     * @param targetGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToApplicationTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup targetGroup) {
        return software.amazon.jsii.Kernel.call(this, "attachToApplicationTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class), new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }

    /**
     * Registers the service as a target of a Classic Load Balancer (CLB).
     * <p>
     * Don't call this. Call <code>loadBalancer.addTarget()</code> instead.
     * <p>
     * @param loadBalancer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void attachToClassicLB(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer loadBalancer) {
        software.amazon.jsii.Kernel.call(this, "attachToClassicLB", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required") });
    }

    /**
     * This method is called to attach this service to a Network Load Balancer.
     * <p>
     * Don't call this function directly. Instead, call <code>listener.addTargets()</code>
     * to add this service to a load balancer.
     * <p>
     * @param targetGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToNetworkTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup targetGroup) {
        return software.amazon.jsii.Kernel.call(this, "attachToNetworkTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class), new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }

    /**
     * An attribute representing the minimum and maximum task count for an AutoScalingGroup.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ScalableTaskCount autoScaleTaskCount(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.EnableScalingProps props) {
        return software.amazon.jsii.Kernel.call(this, "autoScaleTaskCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ScalableTaskCount.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * This method is called to create a networkConfiguration.
     * <p>
     * @param vpc This parameter is required.
     * @param assignPublicIp
     * @param vpcSubnets
     * @param securityGroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void configureAwsVpcNetworkingWithSecurityGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc vpc, final @org.jetbrains.annotations.Nullable java.lang.Boolean assignPublicIp, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets, final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
        software.amazon.jsii.Kernel.call(this, "configureAwsVpcNetworkingWithSecurityGroups", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp, vpcSubnets, securityGroups });
    }

    /**
     * This method is called to create a networkConfiguration.
     * <p>
     * @param vpc This parameter is required.
     * @param assignPublicIp
     * @param vpcSubnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void configureAwsVpcNetworkingWithSecurityGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc vpc, final @org.jetbrains.annotations.Nullable java.lang.Boolean assignPublicIp, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
        software.amazon.jsii.Kernel.call(this, "configureAwsVpcNetworkingWithSecurityGroups", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp, vpcSubnets });
    }

    /**
     * This method is called to create a networkConfiguration.
     * <p>
     * @param vpc This parameter is required.
     * @param assignPublicIp
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void configureAwsVpcNetworkingWithSecurityGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc vpc, final @org.jetbrains.annotations.Nullable java.lang.Boolean assignPublicIp) {
        software.amazon.jsii.Kernel.call(this, "configureAwsVpcNetworkingWithSecurityGroups", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp });
    }

    /**
     * This method is called to create a networkConfiguration.
     * <p>
     * @param vpc This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void configureAwsVpcNetworkingWithSecurityGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc vpc) {
        software.amazon.jsii.Kernel.call(this, "configureAwsVpcNetworkingWithSecurityGroups", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(vpc, "vpc is required") });
    }

    /**
     * Enable CloudMap service discovery for the service.
     * <p>
     * @return The created CloudMap service
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.Service enableCloudMap(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.CloudMapOptions options) {
        return software.amazon.jsii.Kernel.call(this, "enableCloudMap", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.Service.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Enable Deployment Alarms which take advantage of arbitrary alarms and configure them after service initialization.
     * <p>
     * If you have already enabled deployment alarms, this function can be used to tell ECS about additional alarms that
     * should interrupt a deployment.
     * <p>
     * New alarms specified in subsequent calls of this function will be appended to the existing list of alarms.
     * <p>
     * The same Alarm Behavior must be used on all deployment alarms. If you specify different AlarmBehavior values in
     * multiple calls to this function, or the Alarm Behavior used here doesn't match the one used in the service
     * constructor, an error will be thrown.
     * <p>
     * If the alarm's metric references the service, you cannot pass <code>Alarm.alarmName</code> here. That will cause a circular
     * dependency between the service and its deployment alarm. See this package's README for options to alarm on service
     * metrics, and avoid this circular dependency.
     * <p>
     * @param alarmNames This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void enableDeploymentAlarms(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> alarmNames, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.DeploymentAlarmOptions options) {
        software.amazon.jsii.Kernel.call(this, "enableDeploymentAlarms", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(alarmNames, "alarmNames is required"), options });
    }

    /**
     * Enable Deployment Alarms which take advantage of arbitrary alarms and configure them after service initialization.
     * <p>
     * If you have already enabled deployment alarms, this function can be used to tell ECS about additional alarms that
     * should interrupt a deployment.
     * <p>
     * New alarms specified in subsequent calls of this function will be appended to the existing list of alarms.
     * <p>
     * The same Alarm Behavior must be used on all deployment alarms. If you specify different AlarmBehavior values in
     * multiple calls to this function, or the Alarm Behavior used here doesn't match the one used in the service
     * constructor, an error will be thrown.
     * <p>
     * If the alarm's metric references the service, you cannot pass <code>Alarm.alarmName</code> here. That will cause a circular
     * dependency between the service and its deployment alarm. See this package's README for options to alarm on service
     * metrics, and avoid this circular dependency.
     * <p>
     * @param alarmNames This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void enableDeploymentAlarms(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> alarmNames) {
        software.amazon.jsii.Kernel.call(this, "enableDeploymentAlarms", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(alarmNames, "alarmNames is required") });
    }

    /**
     * Enable Service Connect on this service.
     * <p>
     * @param config
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void enableServiceConnect(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ServiceConnectProps config) {
        software.amazon.jsii.Kernel.call(this, "enableServiceConnect", software.amazon.jsii.NativeType.VOID, new Object[] { config });
    }

    /**
     * Enable Service Connect on this service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void enableServiceConnect() {
        software.amazon.jsii.Kernel.call(this, "enableServiceConnect", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Return a load balancing target for a specific container and port.
     * <p>
     * Use this function to create a load balancer target if you want to load balance to
     * another container than the first essential container or the first mapped port on
     * the container.
     * <p>
     * Use the return value of this function where you would normally use a load balancer
     * target, instead of the <code>Service</code> object itself.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * ApplicationListener listener;
     * BaseService service;
     * listener.addTargets("ECS", AddApplicationTargetsProps.builder()
     *         .port(80)
     *         .targets(List.of(service.loadBalancerTarget(LoadBalancerTargetOptions.builder()
     *                 .containerName("MyContainer")
     *                 .containerPort(1234)
     *                 .build())))
     *         .build());
     * </pre></blockquote>
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.IEcsLoadBalancerTarget loadBalancerTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LoadBalancerTargetOptions options) {
        return software.amazon.jsii.Kernel.call(this, "loadBalancerTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.IEcsLoadBalancerTarget.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * This method returns the specified CloudWatch metric name for this service.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * This method returns the specified CloudWatch metric name for this service.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * This method returns the CloudWatch metric for this service's CPU utilization.
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCpuUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricCpuUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * This method returns the CloudWatch metric for this service's CPU utilization.
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCpuUtilization() {
        return software.amazon.jsii.Kernel.call(this, "metricCpuUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * This method returns the CloudWatch metric for this service's memory utilization.
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMemoryUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricMemoryUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * This method returns the CloudWatch metric for this service's memory utilization.
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMemoryUtilization() {
        return software.amazon.jsii.Kernel.call(this, "metricMemoryUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Use this function to create all load balancer targets to be registered in this service, add them to target groups, and attach target groups to listeners accordingly.
     * <p>
     * Alternatively, you can use <code>listener.addTargets()</code> to create targets and add them to target groups.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * ApplicationListener listener;
     * BaseService service;
     * service.registerLoadBalancerTargets(EcsTarget.builder()
     *         .containerName("web")
     *         .containerPort(80)
     *         .newTargetGroupId("ECS")
     *         .listener(ListenerConfig.applicationListener(listener, AddApplicationTargetsProps.builder()
     *                 .protocol(ApplicationProtocol.HTTPS)
     *                 .build()))
     *         .build());
     * </pre></blockquote>
     * <p>
     * @param targets This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void registerLoadBalancerTargets(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EcsTarget... targets) {
        software.amazon.jsii.Kernel.call(this, "registerLoadBalancerTargets", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(targets).toArray(Object[]::new));
    }

    /**
     * The cluster that hosts the service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ICluster getCluster() {
        return software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ICluster.class));
    }

    /**
     * The security groups which manage the allowed network traffic for the service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceArn() {
        return software.amazon.jsii.Kernel.get(this, "serviceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceName() {
        return software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The task definition to use for tasks in the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinition getTaskDefinition() {
        return software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.TaskDefinition.class));
    }

    /**
     * The CloudMap service created for this service, if any.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.IService getCloudMapService() {
        return software.amazon.jsii.Kernel.get(this, "cloudMapService", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.IService.class));
    }

    /**
     * A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the container name (as it appears in a container definition), and the container port to access from the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.CfnService.LoadBalancerProperty> getLoadBalancers() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "loadBalancers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CfnService.LoadBalancerProperty.class))));
    }

    /**
     * A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the container name (as it appears in a container definition), and the container port to access from the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setLoadBalancers(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.CfnService.LoadBalancerProperty> value) {
        software.amazon.jsii.Kernel.set(this, "loadBalancers", java.util.Objects.requireNonNull(value, "loadBalancers is required"));
    }

    /**
     * The details of the service discovery registries to assign to this service.
     * <p>
     * For more information, see Service Discovery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.CfnService.ServiceRegistryProperty> getServiceRegistries() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "serviceRegistries", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CfnService.ServiceRegistryProperty.class))));
    }

    /**
     * The details of the service discovery registries to assign to this service.
     * <p>
     * For more information, see Service Discovery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setServiceRegistries(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.CfnService.ServiceRegistryProperty> value) {
        software.amazon.jsii.Kernel.set(this, "serviceRegistries", java.util.Objects.requireNonNull(value, "serviceRegistries is required"));
    }

    /**
     * The details of the AWS Cloud Map service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.Service getCloudmapService() {
        return software.amazon.jsii.Kernel.get(this, "cloudmapService", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.Service.class));
    }

    /**
     * The details of the AWS Cloud Map service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setCloudmapService(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.Service value) {
        software.amazon.jsii.Kernel.set(this, "cloudmapService", value);
    }

    /**
     * The deployment alarms property - this will be rendered directly and lazily as the CfnService.alarms property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnService.DeploymentAlarmsProperty getDeploymentAlarms() {
        return software.amazon.jsii.Kernel.get(this, "deploymentAlarms", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CfnService.DeploymentAlarmsProperty.class));
    }

    /**
     * The deployment alarms property - this will be rendered directly and lazily as the CfnService.alarms property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setDeploymentAlarms(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnService.DeploymentAlarmsProperty value) {
        software.amazon.jsii.Kernel.set(this, "deploymentAlarms", value);
    }

    /**
     * A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the container name (as it appears in a container definition), and the container port to access from the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnService.NetworkConfigurationProperty getNetworkConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CfnService.NetworkConfigurationProperty.class));
    }

    /**
     * A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the container name (as it appears in a container definition), and the container port to access from the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnService.NetworkConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "networkConfiguration", value);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ecs.BaseService implements software.amazon.awscdk.services.ecs.IBaseService.Jsii$Default, software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget.Jsii$Default, software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget.Jsii$Default, software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget.Jsii$Default, software.amazon.awscdk.IResource.Jsii$Default, software.constructs.IConstruct.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
