package software.amazon.awscdk.services.ecs;

/**
 * The configuration to use when creating a log driver.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * LogDriverConfig logDriverConfig = LogDriverConfig.builder()
 *         .logDriver("logDriver")
 *         // the properties below are optional
 *         .options(Map.of(
 *                 "optionsKey", "options"))
 *         .secretOptions(List.of(SecretProperty.builder()
 *                 .name("name")
 *                 .valueFrom("valueFrom")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:31.481Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.LogDriverConfig")
@software.amazon.jsii.Jsii.Proxy(LogDriverConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LogDriverConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The log driver to use for the container.
     * <p>
     * The valid values listed for this parameter are log drivers
     * that the Amazon ECS container agent can communicate with by default.
     * <p>
     * For tasks using the Fargate launch type, the supported log drivers are awslogs, splunk, and awsfirelens.
     * For tasks using the EC2 launch type, the supported log drivers are awslogs, fluentd, gelf, json-file, journald,
     * logentries,syslog, splunk, and awsfirelens.
     * <p>
     * For more information about using the awslogs log driver, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html">Using the awslogs Log Driver</a>
     * in the Amazon Elastic Container Service Developer Guide.
     * <p>
     * For more information about using the awsfirelens log driver, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom Log Routing</a>
     * in the Amazon Elastic Container Service Developer Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLogDriver();

    /**
     * The configuration options to send to the log driver.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getOptions() {
        return null;
    }

    /**
     * The secrets to pass to the log configuration.
     * <p>
     * Default: - No secret options provided.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.CfnTaskDefinition.SecretProperty> getSecretOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LogDriverConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LogDriverConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LogDriverConfig> {
        java.lang.String logDriver;
        java.util.Map<java.lang.String, java.lang.String> options;
        java.util.List<software.amazon.awscdk.services.ecs.CfnTaskDefinition.SecretProperty> secretOptions;

        /**
         * Sets the value of {@link LogDriverConfig#getLogDriver}
         * @param logDriver The log driver to use for the container. This parameter is required.
         *                  The valid values listed for this parameter are log drivers
         *                  that the Amazon ECS container agent can communicate with by default.
         *                  <p>
         *                  For tasks using the Fargate launch type, the supported log drivers are awslogs, splunk, and awsfirelens.
         *                  For tasks using the EC2 launch type, the supported log drivers are awslogs, fluentd, gelf, json-file, journald,
         *                  logentries,syslog, splunk, and awsfirelens.
         *                  <p>
         *                  For more information about using the awslogs log driver, see
         *                  <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html">Using the awslogs Log Driver</a>
         *                  in the Amazon Elastic Container Service Developer Guide.
         *                  <p>
         *                  For more information about using the awsfirelens log driver, see
         *                  <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom Log Routing</a>
         *                  in the Amazon Elastic Container Service Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDriver(java.lang.String logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        /**
         * Sets the value of {@link LogDriverConfig#getOptions}
         * @param options The configuration options to send to the log driver.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(java.util.Map<java.lang.String, java.lang.String> options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link LogDriverConfig#getSecretOptions}
         * @param secretOptions The secrets to pass to the log configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder secretOptions(java.util.List<? extends software.amazon.awscdk.services.ecs.CfnTaskDefinition.SecretProperty> secretOptions) {
            this.secretOptions = (java.util.List<software.amazon.awscdk.services.ecs.CfnTaskDefinition.SecretProperty>)secretOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogDriverConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LogDriverConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LogDriverConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogDriverConfig {
        private final java.lang.String logDriver;
        private final java.util.Map<java.lang.String, java.lang.String> options;
        private final java.util.List<software.amazon.awscdk.services.ecs.CfnTaskDefinition.SecretProperty> secretOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.logDriver = software.amazon.jsii.Kernel.get(this, "logDriver", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.secretOptions = software.amazon.jsii.Kernel.get(this, "secretOptions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CfnTaskDefinition.SecretProperty.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.logDriver = java.util.Objects.requireNonNull(builder.logDriver, "logDriver is required");
            this.options = builder.options;
            this.secretOptions = (java.util.List<software.amazon.awscdk.services.ecs.CfnTaskDefinition.SecretProperty>)builder.secretOptions;
        }

        @Override
        public final java.lang.String getLogDriver() {
            return this.logDriver;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getOptions() {
            return this.options;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.CfnTaskDefinition.SecretProperty> getSecretOptions() {
            return this.secretOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("logDriver", om.valueToTree(this.getLogDriver()));
            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }
            if (this.getSecretOptions() != null) {
                data.set("secretOptions", om.valueToTree(this.getSecretOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.LogDriverConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LogDriverConfig.Jsii$Proxy that = (LogDriverConfig.Jsii$Proxy) o;

            if (!logDriver.equals(that.logDriver)) return false;
            if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
            return this.secretOptions != null ? this.secretOptions.equals(that.secretOptions) : that.secretOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.logDriver.hashCode();
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.secretOptions != null ? this.secretOptions.hashCode() : 0);
            return result;
        }
    }
}
