package software.amazon.awscdk.services.efs;

/**
 * Represents the AccessPoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AccessPoint.fromAccessPointAttributes(this, "ap", AccessPointAttributes.builder()
 *         .accessPointId("fsap-1293c4d9832fo0912")
 *         .fileSystem(FileSystem.fromFileSystemAttributes(this, "efs", FileSystemAttributes.builder()
 *                 .fileSystemId("fs-099d3e2f")
 *                 .securityGroup(SecurityGroup.fromSecurityGroupId(this, "sg", "sg-51530134"))
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:31.641Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.AccessPoint")
public class AccessPoint extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.efs.IAccessPoint {

    protected AccessPoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AccessPoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AccessPoint(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.AccessPointProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing Access Point by attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.IAccessPoint fromAccessPointAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.AccessPointAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.efs.AccessPoint.class, "fromAccessPointAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.IAccessPoint.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Import an existing Access Point by id.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param accessPointId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.IAccessPoint fromAccessPointId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String accessPointId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.efs.AccessPoint.class, "fromAccessPointId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.IAccessPoint.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(accessPointId, "accessPointId is required") });
    }

    /**
     * The ARN of the Access Point.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAccessPointArn() {
        return software.amazon.jsii.Kernel.get(this, "accessPointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the Access Point.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAccessPointId() {
        return software.amazon.jsii.Kernel.get(this, "accessPointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The file system of the access point.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.IFileSystem getFileSystem() {
        return software.amazon.jsii.Kernel.get(this, "fileSystem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.IFileSystem.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.efs.AccessPoint}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.efs.AccessPoint> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.efs.AccessPointProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.efs.AccessPointProps.Builder();
        }

        /**
         * Specifies the POSIX IDs and permissions to apply when creating the access point's root directory.
         * <p>
         * If the
         * root directory specified by <code>path</code> does not exist, EFS creates the root directory and applies the
         * permissions specified here. If the specified <code>path</code> does not exist, you must specify <code>createAcl</code>.
         * <p>
         * Default: - None. The directory specified by `path` must exist.
         * <p>
         * @return {@code this}
         * @param createAcl Specifies the POSIX IDs and permissions to apply when creating the access point's root directory. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createAcl(final software.amazon.awscdk.services.efs.Acl createAcl) {
            this.props.createAcl(createAcl);
            return this;
        }

        /**
         * Specifies the path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system.
         * <p>
         * Default: '/'
         * <p>
         * @return {@code this}
         * @param path Specifies the path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(final java.lang.String path) {
            this.props.path(path);
            return this;
        }

        /**
         * The full POSIX identity, including the user ID, group ID, and any secondary group IDs, on the access point that is used for all file system operations performed by NFS clients using the access point.
         * <p>
         * Specify this to enforce a user identity using an access point.
         * <p>
         * Default: - user identity not enforced
         * <p>
         * @return {@code this}
         * @see <a href=" - [Enforcing a User Identity Using an Access Point](https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html)"> - [Enforcing a User Identity Using an Access Point](https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html)</a>
         * @param posixUser The full POSIX identity, including the user ID, group ID, and any secondary group IDs, on the access point that is used for all file system operations performed by NFS clients using the access point. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder posixUser(final software.amazon.awscdk.services.efs.PosixUser posixUser) {
            this.props.posixUser(posixUser);
            return this;
        }

        /**
         * The efs filesystem.
         * <p>
         * @return {@code this}
         * @param fileSystem The efs filesystem. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystem(final software.amazon.awscdk.services.efs.IFileSystem fileSystem) {
            this.props.fileSystem(fileSystem);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.efs.AccessPoint}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.efs.AccessPoint build() {
            return new software.amazon.awscdk.services.efs.AccessPoint(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
