package software.amazon.awscdk.services.efs;

/**
 * Properties for defining a <code>CfnAccessPoint</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.efs.*;
 * CfnAccessPointProps cfnAccessPointProps = CfnAccessPointProps.builder()
 *         .fileSystemId("fileSystemId")
 *         // the properties below are optional
 *         .accessPointTags(List.of(AccessPointTagProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .clientToken("clientToken")
 *         .posixUser(PosixUserProperty.builder()
 *                 .gid("gid")
 *                 .uid("uid")
 *                 // the properties below are optional
 *                 .secondaryGids(List.of("secondaryGids"))
 *                 .build())
 *         .rootDirectory(RootDirectoryProperty.builder()
 *                 .creationInfo(CreationInfoProperty.builder()
 *                         .ownerGid("ownerGid")
 *                         .ownerUid("ownerUid")
 *                         .permissions("permissions")
 *                         .build())
 *                 .path("path")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:31.647Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.CfnAccessPointProps")
@software.amazon.jsii.Jsii.Proxy(CfnAccessPointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAccessPointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the EFS file system that the access point applies to.
     * <p>
     * Accepts only the ID format for input when specifying a file system, for example <code>fs-0123456789abcedf2</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-filesystemid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-filesystemid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId();

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-accesspointtags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-accesspointtags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.efs.CfnAccessPoint.AccessPointTagProperty> getAccessPointTags() {
        return null;
    }

    /**
     * The opaque string specified in the request to ensure idempotent creation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-clienttoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-clienttoken</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClientToken() {
        return null;
    }

    /**
     * The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point that is used for all file operations by NFS clients using the access point.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-posixuser">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-posixuser</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPosixUser() {
        return null;
    }

    /**
     * The directory on the EFS file system that the access point exposes as the root directory to NFS clients using the access point.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-rootdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-rootdirectory</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRootDirectory() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAccessPointProps> {
        java.lang.String fileSystemId;
        java.util.List<software.amazon.awscdk.services.efs.CfnAccessPoint.AccessPointTagProperty> accessPointTags;
        java.lang.String clientToken;
        java.lang.Object posixUser;
        java.lang.Object rootDirectory;

        /**
         * Sets the value of {@link CfnAccessPointProps#getFileSystemId}
         * @param fileSystemId The ID of the EFS file system that the access point applies to. This parameter is required.
         *                     Accepts only the ID format for input when specifying a file system, for example <code>fs-0123456789abcedf2</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemId(java.lang.String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getAccessPointTags}
         * @param accessPointTags An array of key-value pairs to apply to this resource.
         *                        For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder accessPointTags(java.util.List<? extends software.amazon.awscdk.services.efs.CfnAccessPoint.AccessPointTagProperty> accessPointTags) {
            this.accessPointTags = (java.util.List<software.amazon.awscdk.services.efs.CfnAccessPoint.AccessPointTagProperty>)accessPointTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getClientToken}
         * @param clientToken The opaque string specified in the request to ensure idempotent creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientToken(java.lang.String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getPosixUser}
         * @param posixUser The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point that is used for all file operations by NFS clients using the access point.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder posixUser(software.amazon.awscdk.IResolvable posixUser) {
            this.posixUser = posixUser;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getPosixUser}
         * @param posixUser The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point that is used for all file operations by NFS clients using the access point.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder posixUser(software.amazon.awscdk.services.efs.CfnAccessPoint.PosixUserProperty posixUser) {
            this.posixUser = posixUser;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getRootDirectory}
         * @param rootDirectory The directory on the EFS file system that the access point exposes as the root directory to NFS clients using the access point.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rootDirectory(software.amazon.awscdk.IResolvable rootDirectory) {
            this.rootDirectory = rootDirectory;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getRootDirectory}
         * @param rootDirectory The directory on the EFS file system that the access point exposes as the root directory to NFS clients using the access point.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rootDirectory(software.amazon.awscdk.services.efs.CfnAccessPoint.RootDirectoryProperty rootDirectory) {
            this.rootDirectory = rootDirectory;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAccessPointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAccessPointProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAccessPointProps {
        private final java.lang.String fileSystemId;
        private final java.util.List<software.amazon.awscdk.services.efs.CfnAccessPoint.AccessPointTagProperty> accessPointTags;
        private final java.lang.String clientToken;
        private final java.lang.Object posixUser;
        private final java.lang.Object rootDirectory;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fileSystemId = software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessPointTags = software.amazon.jsii.Kernel.get(this, "accessPointTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.CfnAccessPoint.AccessPointTagProperty.class)));
            this.clientToken = software.amazon.jsii.Kernel.get(this, "clientToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.posixUser = software.amazon.jsii.Kernel.get(this, "posixUser", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.rootDirectory = software.amazon.jsii.Kernel.get(this, "rootDirectory", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fileSystemId = java.util.Objects.requireNonNull(builder.fileSystemId, "fileSystemId is required");
            this.accessPointTags = (java.util.List<software.amazon.awscdk.services.efs.CfnAccessPoint.AccessPointTagProperty>)builder.accessPointTags;
            this.clientToken = builder.clientToken;
            this.posixUser = builder.posixUser;
            this.rootDirectory = builder.rootDirectory;
        }

        @Override
        public final java.lang.String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.efs.CfnAccessPoint.AccessPointTagProperty> getAccessPointTags() {
            return this.accessPointTags;
        }

        @Override
        public final java.lang.String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final java.lang.Object getPosixUser() {
            return this.posixUser;
        }

        @Override
        public final java.lang.Object getRootDirectory() {
            return this.rootDirectory;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("fileSystemId", om.valueToTree(this.getFileSystemId()));
            if (this.getAccessPointTags() != null) {
                data.set("accessPointTags", om.valueToTree(this.getAccessPointTags()));
            }
            if (this.getClientToken() != null) {
                data.set("clientToken", om.valueToTree(this.getClientToken()));
            }
            if (this.getPosixUser() != null) {
                data.set("posixUser", om.valueToTree(this.getPosixUser()));
            }
            if (this.getRootDirectory() != null) {
                data.set("rootDirectory", om.valueToTree(this.getRootDirectory()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.CfnAccessPointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAccessPointProps.Jsii$Proxy that = (CfnAccessPointProps.Jsii$Proxy) o;

            if (!fileSystemId.equals(that.fileSystemId)) return false;
            if (this.accessPointTags != null ? !this.accessPointTags.equals(that.accessPointTags) : that.accessPointTags != null) return false;
            if (this.clientToken != null ? !this.clientToken.equals(that.clientToken) : that.clientToken != null) return false;
            if (this.posixUser != null ? !this.posixUser.equals(that.posixUser) : that.posixUser != null) return false;
            return this.rootDirectory != null ? this.rootDirectory.equals(that.rootDirectory) : that.rootDirectory == null;
        }

        @Override
        public final int hashCode() {
            int result = this.fileSystemId.hashCode();
            result = 31 * result + (this.accessPointTags != null ? this.accessPointTags.hashCode() : 0);
            result = 31 * result + (this.clientToken != null ? this.clientToken.hashCode() : 0);
            result = 31 * result + (this.posixUser != null ? this.posixUser.hashCode() : 0);
            result = 31 * result + (this.rootDirectory != null ? this.rootDirectory.hashCode() : 0);
            return result;
        }
    }
}
