package software.amazon.awscdk.services.efs;

/**
 * EFS Throughput mode.
 * <p>
 * @see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:31.679Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.ThroughputMode")
public enum ThroughputMode {
    /**
     * This mode scales as the size of the file system in the standard storage class grows.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BURSTING,
    /**
     * This mode can instantly provision the throughput of the file system (in MiB/s) independent of the amount of data stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PROVISIONED,
    /**
     * This mode scales the throughput automatically regardless of file system size.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ELASTIC,
}
