package software.amazon.awscdk.services.eks;

/**
 * Represents the authentication mode for an Amazon EKS cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.cdk.lambdalayer.kubectl.v30.KubectlV30Layer;
 * Vpc vpc;
 * Cluster.Builder.create(this, "Cluster")
 *         .vpc(vpc)
 *         .version(KubernetesVersion.V1_30)
 *         .kubectlLayer(new KubectlV30Layer(this, "KubectlLayer"))
 *         .authenticationMode(AuthenticationMode.API_AND_CONFIG_MAP)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:31.721Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.AuthenticationMode")
public enum AuthenticationMode {
    /**
     * Authenticates using a Kubernetes ConfigMap.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CONFIG_MAP,
    /**
     * Authenticates using both the Kubernetes API server and a ConfigMap.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    API_AND_CONFIG_MAP,
    /**
     * Authenticates using the Kubernetes API server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    API,
}
