package software.amazon.awscdk.services.eks;

/**
 * Properties for defining a <code>CfnAddon</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.*;
 * CfnAddonProps cfnAddonProps = CfnAddonProps.builder()
 *         .addonName("addonName")
 *         .clusterName("clusterName")
 *         // the properties below are optional
 *         .addonVersion("addonVersion")
 *         .configurationValues("configurationValues")
 *         .podIdentityAssociations(List.of(PodIdentityAssociationProperty.builder()
 *                 .roleArn("roleArn")
 *                 .serviceAccount("serviceAccount")
 *                 .build()))
 *         .preserveOnDelete(false)
 *         .resolveConflicts("resolveConflicts")
 *         .serviceAccountRoleArn("serviceAccountRoleArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-addon.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-addon.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:31.732Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnAddonProps")
@software.amazon.jsii.Jsii.Proxy(CfnAddonProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAddonProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the add-on.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-addon.html#cfn-eks-addon-addonname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-addon.html#cfn-eks-addon-addonname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAddonName();

    /**
     * The name of your cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-addon.html#cfn-eks-addon-clustername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-addon.html#cfn-eks-addon-clustername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

    /**
     * The version of the add-on.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-addon.html#cfn-eks-addon-addonversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-addon.html#cfn-eks-addon-addonversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAddonVersion() {
        return null;
    }

    /**
     * The configuration values that you provided.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-addon.html#cfn-eks-addon-configurationvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-addon.html#cfn-eks-addon-configurationvalues</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConfigurationValues() {
        return null;
    }

    /**
     * An array of Pod Identity Assocations owned by the Addon.
     * <p>
     * Each EKS Pod Identity association maps a role to a service account in a namespace in the cluster.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html">Attach an IAM Role to an Amazon EKS add-on using Pod Identity</a> in the EKS User Guide.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-addon.html#cfn-eks-addon-podidentityassociations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-addon.html#cfn-eks-addon-podidentityassociations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPodIdentityAssociations() {
        return null;
    }

    /**
     * Specifying this option preserves the add-on software on your cluster but Amazon EKS stops managing any settings for the add-on.
     * <p>
     * If an IAM account is associated with the add-on, it isn't removed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-addon.html#cfn-eks-addon-preserveondelete">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-addon.html#cfn-eks-addon-preserveondelete</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPreserveOnDelete() {
        return null;
    }

    /**
     * How to resolve field value conflicts for an Amazon EKS add-on.
     * <p>
     * Conflicts are handled based on the value you choose:
     * <p>
     * <ul>
     * <li><em>None</em> – If the self-managed version of the add-on is installed on your cluster, Amazon EKS doesn't change the value. Creation of the add-on might fail.</li>
     * <li><em>Overwrite</em> – If the self-managed version of the add-on is installed on your cluster and the Amazon EKS default value is different than the existing value, Amazon EKS changes the value to the Amazon EKS default value.</li>
     * <li><em>Preserve</em> – This is similar to the NONE option. If the self-managed version of the add-on is installed on your cluster Amazon EKS doesn't change the add-on resource properties. Creation of the add-on might fail if conflicts are detected. This option works differently during the update operation. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html">UpdateAddon</a> .</li>
     * </ul>
     * <p>
     * If you don't currently have the self-managed version of the add-on installed on your cluster, the Amazon EKS add-on is installed. Amazon EKS sets all values to default values, regardless of the option that you specify.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-addon.html#cfn-eks-addon-resolveconflicts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-addon.html#cfn-eks-addon-resolveconflicts</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResolveConflicts() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account.
     * <p>
     * The role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM role</a> in the <em>Amazon EKS User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html">Enabling IAM roles for service accounts on your cluster</a> in the <em>Amazon EKS User Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-addon.html#cfn-eks-addon-serviceaccountrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-addon.html#cfn-eks-addon-serviceaccountrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccountRoleArn() {
        return null;
    }

    /**
     * The metadata that you apply to the add-on to assist with categorization and organization.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define. Add-on tags do not propagate to any other resources associated with the cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-addon.html#cfn-eks-addon-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-addon.html#cfn-eks-addon-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAddonProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAddonProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAddonProps> {
        java.lang.String addonName;
        java.lang.String clusterName;
        java.lang.String addonVersion;
        java.lang.String configurationValues;
        java.lang.Object podIdentityAssociations;
        java.lang.Object preserveOnDelete;
        java.lang.String resolveConflicts;
        java.lang.String serviceAccountRoleArn;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnAddonProps#getAddonName}
         * @param addonName The name of the add-on. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addonName(java.lang.String addonName) {
            this.addonName = addonName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAddonProps#getClusterName}
         * @param clusterName The name of your cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAddonProps#getAddonVersion}
         * @param addonVersion The version of the add-on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addonVersion(java.lang.String addonVersion) {
            this.addonVersion = addonVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnAddonProps#getConfigurationValues}
         * @param configurationValues The configuration values that you provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationValues(java.lang.String configurationValues) {
            this.configurationValues = configurationValues;
            return this;
        }

        /**
         * Sets the value of {@link CfnAddonProps#getPodIdentityAssociations}
         * @param podIdentityAssociations An array of Pod Identity Assocations owned by the Addon.
         *                                Each EKS Pod Identity association maps a role to a service account in a namespace in the cluster.
         *                                <p>
         *                                For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html">Attach an IAM Role to an Amazon EKS add-on using Pod Identity</a> in the EKS User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder podIdentityAssociations(software.amazon.awscdk.IResolvable podIdentityAssociations) {
            this.podIdentityAssociations = podIdentityAssociations;
            return this;
        }

        /**
         * Sets the value of {@link CfnAddonProps#getPodIdentityAssociations}
         * @param podIdentityAssociations An array of Pod Identity Assocations owned by the Addon.
         *                                Each EKS Pod Identity association maps a role to a service account in a namespace in the cluster.
         *                                <p>
         *                                For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html">Attach an IAM Role to an Amazon EKS add-on using Pod Identity</a> in the EKS User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder podIdentityAssociations(java.util.List<? extends java.lang.Object> podIdentityAssociations) {
            this.podIdentityAssociations = podIdentityAssociations;
            return this;
        }

        /**
         * Sets the value of {@link CfnAddonProps#getPreserveOnDelete}
         * @param preserveOnDelete Specifying this option preserves the add-on software on your cluster but Amazon EKS stops managing any settings for the add-on.
         *                         If an IAM account is associated with the add-on, it isn't removed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preserveOnDelete(java.lang.Boolean preserveOnDelete) {
            this.preserveOnDelete = preserveOnDelete;
            return this;
        }

        /**
         * Sets the value of {@link CfnAddonProps#getPreserveOnDelete}
         * @param preserveOnDelete Specifying this option preserves the add-on software on your cluster but Amazon EKS stops managing any settings for the add-on.
         *                         If an IAM account is associated with the add-on, it isn't removed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preserveOnDelete(software.amazon.awscdk.IResolvable preserveOnDelete) {
            this.preserveOnDelete = preserveOnDelete;
            return this;
        }

        /**
         * Sets the value of {@link CfnAddonProps#getResolveConflicts}
         * @param resolveConflicts How to resolve field value conflicts for an Amazon EKS add-on.
         *                         Conflicts are handled based on the value you choose:
         *                         <p>
         *                         <ul>
         *                         <li><em>None</em> – If the self-managed version of the add-on is installed on your cluster, Amazon EKS doesn't change the value. Creation of the add-on might fail.</li>
         *                         <li><em>Overwrite</em> – If the self-managed version of the add-on is installed on your cluster and the Amazon EKS default value is different than the existing value, Amazon EKS changes the value to the Amazon EKS default value.</li>
         *                         <li><em>Preserve</em> – This is similar to the NONE option. If the self-managed version of the add-on is installed on your cluster Amazon EKS doesn't change the add-on resource properties. Creation of the add-on might fail if conflicts are detected. This option works differently during the update operation. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html">UpdateAddon</a> .</li>
         *                         </ul>
         *                         <p>
         *                         If you don't currently have the self-managed version of the add-on installed on your cluster, the Amazon EKS add-on is installed. Amazon EKS sets all values to default values, regardless of the option that you specify.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resolveConflicts(java.lang.String resolveConflicts) {
            this.resolveConflicts = resolveConflicts;
            return this;
        }

        /**
         * Sets the value of {@link CfnAddonProps#getServiceAccountRoleArn}
         * @param serviceAccountRoleArn The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account.
         *                              The role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM role</a> in the <em>Amazon EKS User Guide</em> .
         *                              <p>
         *                              <blockquote>
         *                              <p>
         *                              To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html">Enabling IAM roles for service accounts on your cluster</a> in the <em>Amazon EKS User Guide</em> .
         *                              <p>
         *                              </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccountRoleArn(java.lang.String serviceAccountRoleArn) {
            this.serviceAccountRoleArn = serviceAccountRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnAddonProps#getTags}
         * @param tags The metadata that you apply to the add-on to assist with categorization and organization.
         *             Each tag consists of a key and an optional value, both of which you define. Add-on tags do not propagate to any other resources associated with the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAddonProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAddonProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAddonProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAddonProps {
        private final java.lang.String addonName;
        private final java.lang.String clusterName;
        private final java.lang.String addonVersion;
        private final java.lang.String configurationValues;
        private final java.lang.Object podIdentityAssociations;
        private final java.lang.Object preserveOnDelete;
        private final java.lang.String resolveConflicts;
        private final java.lang.String serviceAccountRoleArn;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.addonName = software.amazon.jsii.Kernel.get(this, "addonName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.addonVersion = software.amazon.jsii.Kernel.get(this, "addonVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configurationValues = software.amazon.jsii.Kernel.get(this, "configurationValues", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.podIdentityAssociations = software.amazon.jsii.Kernel.get(this, "podIdentityAssociations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.preserveOnDelete = software.amazon.jsii.Kernel.get(this, "preserveOnDelete", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resolveConflicts = software.amazon.jsii.Kernel.get(this, "resolveConflicts", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceAccountRoleArn = software.amazon.jsii.Kernel.get(this, "serviceAccountRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.addonName = java.util.Objects.requireNonNull(builder.addonName, "addonName is required");
            this.clusterName = java.util.Objects.requireNonNull(builder.clusterName, "clusterName is required");
            this.addonVersion = builder.addonVersion;
            this.configurationValues = builder.configurationValues;
            this.podIdentityAssociations = builder.podIdentityAssociations;
            this.preserveOnDelete = builder.preserveOnDelete;
            this.resolveConflicts = builder.resolveConflicts;
            this.serviceAccountRoleArn = builder.serviceAccountRoleArn;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAddonName() {
            return this.addonName;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final java.lang.String getAddonVersion() {
            return this.addonVersion;
        }

        @Override
        public final java.lang.String getConfigurationValues() {
            return this.configurationValues;
        }

        @Override
        public final java.lang.Object getPodIdentityAssociations() {
            return this.podIdentityAssociations;
        }

        @Override
        public final java.lang.Object getPreserveOnDelete() {
            return this.preserveOnDelete;
        }

        @Override
        public final java.lang.String getResolveConflicts() {
            return this.resolveConflicts;
        }

        @Override
        public final java.lang.String getServiceAccountRoleArn() {
            return this.serviceAccountRoleArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("addonName", om.valueToTree(this.getAddonName()));
            data.set("clusterName", om.valueToTree(this.getClusterName()));
            if (this.getAddonVersion() != null) {
                data.set("addonVersion", om.valueToTree(this.getAddonVersion()));
            }
            if (this.getConfigurationValues() != null) {
                data.set("configurationValues", om.valueToTree(this.getConfigurationValues()));
            }
            if (this.getPodIdentityAssociations() != null) {
                data.set("podIdentityAssociations", om.valueToTree(this.getPodIdentityAssociations()));
            }
            if (this.getPreserveOnDelete() != null) {
                data.set("preserveOnDelete", om.valueToTree(this.getPreserveOnDelete()));
            }
            if (this.getResolveConflicts() != null) {
                data.set("resolveConflicts", om.valueToTree(this.getResolveConflicts()));
            }
            if (this.getServiceAccountRoleArn() != null) {
                data.set("serviceAccountRoleArn", om.valueToTree(this.getServiceAccountRoleArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnAddonProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAddonProps.Jsii$Proxy that = (CfnAddonProps.Jsii$Proxy) o;

            if (!addonName.equals(that.addonName)) return false;
            if (!clusterName.equals(that.clusterName)) return false;
            if (this.addonVersion != null ? !this.addonVersion.equals(that.addonVersion) : that.addonVersion != null) return false;
            if (this.configurationValues != null ? !this.configurationValues.equals(that.configurationValues) : that.configurationValues != null) return false;
            if (this.podIdentityAssociations != null ? !this.podIdentityAssociations.equals(that.podIdentityAssociations) : that.podIdentityAssociations != null) return false;
            if (this.preserveOnDelete != null ? !this.preserveOnDelete.equals(that.preserveOnDelete) : that.preserveOnDelete != null) return false;
            if (this.resolveConflicts != null ? !this.resolveConflicts.equals(that.resolveConflicts) : that.resolveConflicts != null) return false;
            if (this.serviceAccountRoleArn != null ? !this.serviceAccountRoleArn.equals(that.serviceAccountRoleArn) : that.serviceAccountRoleArn != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.addonName.hashCode();
            result = 31 * result + (this.clusterName.hashCode());
            result = 31 * result + (this.addonVersion != null ? this.addonVersion.hashCode() : 0);
            result = 31 * result + (this.configurationValues != null ? this.configurationValues.hashCode() : 0);
            result = 31 * result + (this.podIdentityAssociations != null ? this.podIdentityAssociations.hashCode() : 0);
            result = 31 * result + (this.preserveOnDelete != null ? this.preserveOnDelete.hashCode() : 0);
            result = 31 * result + (this.resolveConflicts != null ? this.resolveConflicts.hashCode() : 0);
            result = 31 * result + (this.serviceAccountRoleArn != null ? this.serviceAccountRoleArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
