package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Backend protocol for network load balancers and health checks.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.certificatemanager.Certificate;
 * import software.amazon.awscdk.services.ec2.InstanceType;
 * import software.amazon.awscdk.services.ecs.Cluster;
 * import software.amazon.awscdk.services.ecs.ContainerImage;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.Protocol;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy;
 * import software.amazon.awscdk.services.route53.PublicHostedZone;
 * Vpc vpc = Vpc.Builder.create(this, "Vpc").maxAzs(1).build();
 * ApplicationMultipleTargetGroupsFargateService loadBalancedFargateService = ApplicationMultipleTargetGroupsFargateService.Builder.create(this, "myService")
 *         .cluster(Cluster.Builder.create(this, "EcsCluster").vpc(vpc).build())
 *         .memoryLimitMiB(256)
 *         .taskImageOptions(ApplicationLoadBalancedTaskImageProps.builder()
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .build())
 *         .enableExecuteCommand(true)
 *         .loadBalancers(List.of(ApplicationLoadBalancerProps.builder()
 *                 .name("lb")
 *                 .idleTimeout(Duration.seconds(400))
 *                 .domainName("api.example.com")
 *                 .domainZone(PublicHostedZone.Builder.create(this, "HostedZone").zoneName("example.com").build())
 *                 .listeners(List.of(ApplicationListenerProps.builder()
 *                         .name("listener")
 *                         .protocol(ApplicationProtocol.HTTPS)
 *                         .certificate(Certificate.fromCertificateArn(this, "Cert", "helloworld"))
 *                         .sslPolicy(SslPolicy.TLS12_EXT)
 *                         .build()))
 *                 .build(), ApplicationLoadBalancerProps.builder()
 *                 .name("lb2")
 *                 .idleTimeout(Duration.seconds(120))
 *                 .domainName("frontend.com")
 *                 .domainZone(PublicHostedZone.Builder.create(this, "HostedZone").zoneName("frontend.com").build())
 *                 .listeners(List.of(ApplicationListenerProps.builder()
 *                         .name("listener2")
 *                         .protocol(ApplicationProtocol.HTTPS)
 *                         .certificate(Certificate.fromCertificateArn(this, "Cert2", "helloworld"))
 *                         .sslPolicy(SslPolicy.TLS12_EXT)
 *                         .build()))
 *                 .build()))
 *         .targetGroups(List.of(ApplicationTargetProps.builder()
 *                 .containerPort(80)
 *                 .listener("listener")
 *                 .build(), ApplicationTargetProps.builder()
 *                 .containerPort(90)
 *                 .pathPattern("a/b/c")
 *                 .priority(10)
 *                 .listener("listener")
 *                 .build(), ApplicationTargetProps.builder()
 *                 .containerPort(443)
 *                 .listener("listener2")
 *                 .build(), ApplicationTargetProps.builder()
 *                 .containerPort(80)
 *                 .pathPattern("a/b/c")
 *                 .priority(10)
 *                 .listener("listener2")
 *                 .build()))
 *         .build();
 * loadBalancedFargateService.targetGroups[0].configureHealthCheck(HealthCheck.builder()
 *         .port("8050")
 *         .protocol(Protocol.HTTP)
 *         .healthyThresholdCount(2)
 *         .unhealthyThresholdCount(2)
 *         .timeout(Duration.seconds(10))
 *         .interval(Duration.seconds(30))
 *         .healthyHttpCodes("200")
 *         .build());
 * loadBalancedFargateService.targetGroups[1].configureHealthCheck(HealthCheck.builder()
 *         .port("8050")
 *         .protocol(Protocol.HTTP)
 *         .healthyThresholdCount(2)
 *         .unhealthyThresholdCount(2)
 *         .timeout(Duration.seconds(10))
 *         .interval(Duration.seconds(30))
 *         .healthyHttpCodes("200")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:32.100Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.Protocol")
public enum Protocol {
    /**
     * HTTP (ALB health checks and NLB health checks).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP,
    /**
     * HTTPS (ALB health checks and NLB health checks).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTPS,
    /**
     * TCP (NLB, NLB health checks).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TCP,
    /**
     * TLS (NLB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS,
    /**
     * UDP (NLB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    UDP,
    /**
     * Listen to both TCP and UDP on the same port (NLB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TCP_UDP,
}
