package software.amazon.awscdk.services.events.targets;

/**
 * Customize the Batch Job Event Target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.batch.*;
 * import software.amazon.awscdk.services.ecs.ContainerImage;
 * Vpc vpc;
 * FargateComputeEnvironment computeEnvironment = FargateComputeEnvironment.Builder.create(this, "ComputeEnv")
 *         .vpc(vpc)
 *         .build();
 * JobQueue jobQueue = JobQueue.Builder.create(this, "JobQueue")
 *         .priority(1)
 *         .computeEnvironments(List.of(OrderedComputeEnvironment.builder()
 *                 .computeEnvironment(computeEnvironment)
 *                 .order(1)
 *                 .build()))
 *         .build();
 * EcsJobDefinition jobDefinition = EcsJobDefinition.Builder.create(this, "MyJob")
 *         .container(EcsEc2ContainerDefinition.Builder.create(this, "Container")
 *                 .image(ContainerImage.fromRegistry("test-repo"))
 *                 .memory(Size.mebibytes(2048))
 *                 .cpu(256)
 *                 .build())
 *         .build();
 * Queue queue = new Queue(this, "Queue");
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.rate(Duration.hours(1)))
 *         .build();
 * rule.addTarget(BatchJob.Builder.create(jobQueue.getJobQueueArn(), jobQueue, jobDefinition.getJobDefinitionArn(), jobDefinition)
 *         .deadLetterQueue(queue)
 *         .event(RuleTargetInput.fromObject(Map.of("SomeParam", "SomeValue")))
 *         .retryAttempts(2)
 *         .maxEventAge(Duration.hours(2))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:32.418Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.BatchJobProps")
@software.amazon.jsii.Jsii.Proxy(BatchJobProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BatchJobProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.events.targets.TargetBaseProps {

    /**
     * The number of times to attempt to retry, if the job fails.
     * <p>
     * Valid values are 1–10.
     * <p>
     * Default: no retryStrategy is set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAttempts() {
        return null;
    }

    /**
     * The event to send to the Lambda.
     * <p>
     * This will be the payload sent to the Lambda Function.
     * <p>
     * Default: the entire EventBridge event
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.RuleTargetInput getEvent() {
        return null;
    }

    /**
     * The name of the submitted job.
     * <p>
     * Default: - Automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getJobName() {
        return null;
    }

    /**
     * The size of the array, if this is an array batch job.
     * <p>
     * Valid values are integers between 2 and 10,000.
     * <p>
     * Default: no arrayProperties are set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSize() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BatchJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BatchJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BatchJobProps> {
        java.lang.Number attempts;
        software.amazon.awscdk.services.events.RuleTargetInput event;
        java.lang.String jobName;
        java.lang.Number size;
        software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        software.amazon.awscdk.Duration maxEventAge;
        java.lang.Number retryAttempts;

        /**
         * Sets the value of {@link BatchJobProps#getAttempts}
         * @param attempts The number of times to attempt to retry, if the job fails.
         *                 Valid values are 1–10.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attempts(java.lang.Number attempts) {
            this.attempts = attempts;
            return this;
        }

        /**
         * Sets the value of {@link BatchJobProps#getEvent}
         * @param event The event to send to the Lambda.
         *              This will be the payload sent to the Lambda Function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder event(software.amazon.awscdk.services.events.RuleTargetInput event) {
            this.event = event;
            return this;
        }

        /**
         * Sets the value of {@link BatchJobProps#getJobName}
         * @param jobName The name of the submitted job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobName(java.lang.String jobName) {
            this.jobName = jobName;
            return this;
        }

        /**
         * Sets the value of {@link BatchJobProps#getSize}
         * @param size The size of the array, if this is an array batch job.
         *             Valid values are integers between 2 and 10,000.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder size(java.lang.Number size) {
            this.size = size;
            return this;
        }

        /**
         * Sets the value of {@link BatchJobProps#getDeadLetterQueue}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue. Check out the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations">considerations for using a dead-letter queue</a>.
         *                        The events not successfully delivered are automatically retried for a specified period of time,
         *                        depending on the retry policy of the target.
         *                        If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        /**
         * Sets the value of {@link BatchJobProps#getMaxEventAge}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing.
         *                    Minimum value of 60.
         *                    Maximum value of 86400.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(software.amazon.awscdk.Duration maxEventAge) {
            this.maxEventAge = maxEventAge;
            return this;
        }

        /**
         * Sets the value of {@link BatchJobProps#getRetryAttempts}
         * @param retryAttempts The maximum number of times to retry when the function returns an error.
         *                      Minimum value of 0.
         *                      Maximum value of 185.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BatchJobProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BatchJobProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BatchJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BatchJobProps {
        private final java.lang.Number attempts;
        private final software.amazon.awscdk.services.events.RuleTargetInput event;
        private final java.lang.String jobName;
        private final java.lang.Number size;
        private final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private final software.amazon.awscdk.Duration maxEventAge;
        private final java.lang.Number retryAttempts;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.attempts = software.amazon.jsii.Kernel.get(this, "attempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.event = software.amazon.jsii.Kernel.get(this, "event", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetInput.class));
            this.jobName = software.amazon.jsii.Kernel.get(this, "jobName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.deadLetterQueue = software.amazon.jsii.Kernel.get(this, "deadLetterQueue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
            this.maxEventAge = software.amazon.jsii.Kernel.get(this, "maxEventAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.retryAttempts = software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.attempts = builder.attempts;
            this.event = builder.event;
            this.jobName = builder.jobName;
            this.size = builder.size;
            this.deadLetterQueue = builder.deadLetterQueue;
            this.maxEventAge = builder.maxEventAge;
            this.retryAttempts = builder.retryAttempts;
        }

        @Override
        public final java.lang.Number getAttempts() {
            return this.attempts;
        }

        @Override
        public final software.amazon.awscdk.services.events.RuleTargetInput getEvent() {
            return this.event;
        }

        @Override
        public final java.lang.String getJobName() {
            return this.jobName;
        }

        @Override
        public final java.lang.Number getSize() {
            return this.size;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
            return this.deadLetterQueue;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxEventAge() {
            return this.maxEventAge;
        }

        @Override
        public final java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAttempts() != null) {
                data.set("attempts", om.valueToTree(this.getAttempts()));
            }
            if (this.getEvent() != null) {
                data.set("event", om.valueToTree(this.getEvent()));
            }
            if (this.getJobName() != null) {
                data.set("jobName", om.valueToTree(this.getJobName()));
            }
            if (this.getSize() != null) {
                data.set("size", om.valueToTree(this.getSize()));
            }
            if (this.getDeadLetterQueue() != null) {
                data.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
            }
            if (this.getMaxEventAge() != null) {
                data.set("maxEventAge", om.valueToTree(this.getMaxEventAge()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events_targets.BatchJobProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BatchJobProps.Jsii$Proxy that = (BatchJobProps.Jsii$Proxy) o;

            if (this.attempts != null ? !this.attempts.equals(that.attempts) : that.attempts != null) return false;
            if (this.event != null ? !this.event.equals(that.event) : that.event != null) return false;
            if (this.jobName != null ? !this.jobName.equals(that.jobName) : that.jobName != null) return false;
            if (this.size != null ? !this.size.equals(that.size) : that.size != null) return false;
            if (this.deadLetterQueue != null ? !this.deadLetterQueue.equals(that.deadLetterQueue) : that.deadLetterQueue != null) return false;
            if (this.maxEventAge != null ? !this.maxEventAge.equals(that.maxEventAge) : that.maxEventAge != null) return false;
            return this.retryAttempts != null ? this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts == null;
        }

        @Override
        public final int hashCode() {
            int result = this.attempts != null ? this.attempts.hashCode() : 0;
            result = 31 * result + (this.event != null ? this.event.hashCode() : 0);
            result = 31 * result + (this.jobName != null ? this.jobName.hashCode() : 0);
            result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
            result = 31 * result + (this.deadLetterQueue != null ? this.deadLetterQueue.hashCode() : 0);
            result = 31 * result + (this.maxEventAge != null ? this.maxEventAge.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            return result;
        }
    }
}
