package software.amazon.awscdk.services.events.targets;

/**
 * Start a task on an ECS cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.ec2.*;
 * ICluster cluster;
 * TaskDefinition taskDefinition;
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.rate(Duration.hours(1)))
 *         .build();
 * rule.addTarget(
 * EcsTask.Builder.create()
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .assignPublicIp(true)
 *         .subnetSelection(SubnetSelection.builder().subnetType(SubnetType.PUBLIC).build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:32.422Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.EcsTask")
public class EcsTask extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IRuleTarget {

    protected EcsTask(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcsTask(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EcsTask(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.targets.EcsTaskProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Allows using tasks as target of EventBridge events.
     * <p>
     * @param _rule This parameter is required.
     * @param _id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule _rule, final @org.jetbrains.annotations.Nullable java.lang.String _id) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required"), _id });
    }

    /**
     * Allows using tasks as target of EventBridge events.
     * <p>
     * @param _rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule _rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required") });
    }

    /**
     * The security groups associated with the task.
     * <p>
     * Only applicable with awsvpc network mode.
     * <p>
     * Default: - A new security group is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)(software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.targets.EcsTask}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.targets.EcsTask> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.events.targets.EcsTaskProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.events.targets.EcsTaskProps.Builder();
        }

        /**
         * The SQS queue to be used as deadLetterQueue. Check out the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations">considerations for using a dead-letter queue</a>.
         * <p>
         * The events not successfully delivered are automatically retried for a specified period of time,
         * depending on the retry policy of the target.
         * If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * <p>
         * Default: - no dead-letter queue
         * <p>
         * @return {@code this}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue. Check out the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations">considerations for using a dead-letter queue</a>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * The maximum age of a request that Lambda sends to a function for processing.
         * <p>
         * Minimum value of 60.
         * Maximum value of 86400.
         * <p>
         * Default: Duration.hours(24)
         * <p>
         * @return {@code this}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(final software.amazon.awscdk.Duration maxEventAge) {
            this.props.maxEventAge(maxEventAge);
            return this;
        }

        /**
         * The maximum number of times to retry when the function returns an error.
         * <p>
         * Minimum value of 0.
         * Maximum value of 185.
         * <p>
         * Default: 185
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the function returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        /**
         * Cluster where service will be deployed.
         * <p>
         * @return {@code this}
         * @param cluster Cluster where service will be deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * Task Definition of the task that should be started.
         * <p>
         * @return {@code this}
         * @param taskDefinition Task Definition of the task that should be started. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(final software.amazon.awscdk.services.ecs.ITaskDefinition taskDefinition) {
            this.props.taskDefinition(taskDefinition);
            return this;
        }

        /**
         * Specifies whether the task's elastic network interface receives a public IP address.
         * <p>
         * You can specify true only when LaunchType is set to FARGATE.
         * <p>
         * Default: - true if the subnet type is PUBLIC, otherwise false
         * <p>
         * @return {@code this}
         * @param assignPublicIp Specifies whether the task's elastic network interface receives a public IP address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignPublicIp(final java.lang.Boolean assignPublicIp) {
            this.props.assignPublicIp(assignPublicIp);
            return this;
        }

        /**
         * Container setting overrides.
         * <p>
         * Key is the name of the container to override, value is the
         * values you want to override.
         * <p>
         * @return {@code this}
         * @param containerOverrides Container setting overrides. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerOverrides(final java.util.List<? extends software.amazon.awscdk.services.events.targets.ContainerOverride> containerOverrides) {
            this.props.containerOverrides(containerOverrides);
            return this;
        }

        /**
         * Whether or not to enable the execute command functionality for the containers in this task.
         * <p>
         * If true, this enables execute command functionality on all containers in the task.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param enableExecuteCommand Whether or not to enable the execute command functionality for the containers in this task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableExecuteCommand(final java.lang.Boolean enableExecuteCommand) {
            this.props.enableExecuteCommand(enableExecuteCommand);
            return this;
        }

        /**
         * Specifies the launch type on which your task is running.
         * <p>
         * The launch type that you specify here
         * must match one of the launch type (compatibilities) of the target task.
         * <p>
         * Default: - 'EC2' if `isEc2Compatible` for the `taskDefinition` is true, otherwise 'FARGATE'
         * <p>
         * @return {@code this}
         * @param launchType Specifies the launch type on which your task is running. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchType(final software.amazon.awscdk.services.ecs.LaunchType launchType) {
            this.props.launchType(launchType);
            return this;
        }

        /**
         * The platform version on which to run your task.
         * <p>
         * Unless you have specific compatibility requirements, you don't need to specify this.
         * <p>
         * Default: - ECS will set the Fargate platform version to 'LATEST'
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html</a>
         * @param platformVersion The platform version on which to run your task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformVersion(final software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion) {
            this.props.platformVersion(platformVersion);
            return this;
        }

        /**
         * Specifies whether to propagate the tags from the task definition to the task.
         * <p>
         * If no value is specified, the tags are not propagated.
         * <p>
         * Default: - Tags will not be propagated
         * <p>
         * @return {@code this}
         * @param propagateTags Specifies whether to propagate the tags from the task definition to the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        /**
         * Existing IAM role to run the ECS task.
         * <p>
         * Default: A new IAM role is created
         * <p>
         * @return {@code this}
         * @param role Existing IAM role to run the ECS task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * Existing security groups to use for the task's ENIs.
         * <p>
         * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
         * <p>
         * Default: A new security group is created
         * <p>
         * @return {@code this}
         * @param securityGroups Existing security groups to use for the task's ENIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * In what subnets to place the task's ENIs.
         * <p>
         * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
         * <p>
         * Default: Private subnets
         * <p>
         * @return {@code this}
         * @param subnetSelection In what subnets to place the task's ENIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        /**
         * The metadata that you apply to the task to help you categorize and organize them.
         * <p>
         * Each tag consists of a key and an optional value, both of which you define.
         * <p>
         * Default: - No additional tags are applied to the task
         * <p>
         * @return {@code this}
         * @param tags The metadata that you apply to the task to help you categorize and organize them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.services.events.targets.Tag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * How many tasks should be started when this event is triggered.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param taskCount How many tasks should be started when this event is triggered. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskCount(final java.lang.Number taskCount) {
            this.props.taskCount(taskCount);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.events.targets.EcsTask}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.events.targets.EcsTask build() {
            return new software.amazon.awscdk.services.events.targets.EcsTask(
                this.props.build()
            );
        }
    }
}
