package software.amazon.awscdk.services.events.targets;

/**
 * Schedule an Amazon Redshift Query to be run, using the Redshift Data API.
 * <p>
 * If you would like Amazon Redshift to identify the Event Bridge rule, and present it in the Amazon Redshift console, append a <code>QS2-</code> prefix to both <code>statementName</code> and <code>ruleName</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.redshiftserverless.*;
 * CfnWorkgroup workgroup;
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.rate(Duration.hours(1)))
 *         .build();
 * Queue dlq = new Queue(this, "DeadLetterQueue");
 * rule.addTarget(RedshiftQuery.Builder.create(workgroup.getAttrWorkgroupWorkgroupArn())
 *         .database("dev")
 *         .deadLetterQueue(dlq)
 *         .sql(List.of("SELECT * FROM foo", "SELECT * FROM baz"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:32.444Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.RedshiftQuery")
public class RedshiftQuery extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IRuleTarget {

    protected RedshiftQuery(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RedshiftQuery(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param clusterArn The ARN of the Amazon Redshift cluster. This parameter is required.
     * @param props The properties of the Redshift Query event. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RedshiftQuery(final @org.jetbrains.annotations.NotNull java.lang.String clusterArn, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.targets.RedshiftQueryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(clusterArn, "clusterArn is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns the rule target specification.
     * <p>
     * NOTE: Do not use the various <code>inputXxx</code> options. They can be set in a call to <code>addTarget</code>.
     * <p>
     * @param rule This parameter is required.
     * @param _id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule rule, final @org.jetbrains.annotations.Nullable java.lang.String _id) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required"), _id });
    }

    /**
     * Returns the rule target specification.
     * <p>
     * NOTE: Do not use the various <code>inputXxx</code> options. They can be set in a call to <code>addTarget</code>.
     * <p>
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.targets.RedshiftQuery}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.targets.RedshiftQuery> {
        /**
         * @return a new instance of {@link Builder}.
         * @param clusterArn The ARN of the Amazon Redshift cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String clusterArn) {
            return new Builder(clusterArn);
        }

        private final java.lang.String clusterArn;
        private final software.amazon.awscdk.services.events.targets.RedshiftQueryProps.Builder props;

        private Builder(final java.lang.String clusterArn) {
            this.clusterArn = clusterArn;
            this.props = new software.amazon.awscdk.services.events.targets.RedshiftQueryProps.Builder();
        }

        /**
         * The Amazon Redshift database to run the query against.
         * <p>
         * @return {@code this}
         * @param database The Amazon Redshift database to run the query against. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder database(final java.lang.String database) {
            this.props.database(database);
            return this;
        }

        /**
         * The SQL queries to be executed.
         * <p>
         * Each query is run sequentially within a single transaction; the next query in the array will only execute after the previous one has successfully completed.
         * <p>
         * <ul>
         * <li>When multiple sql queries are included, this will use the <code>batchExecuteStatement</code> API. Therefore, if any statement fails, the entire transaction is rolled back.</li>
         * <li>If a single SQL statement is to be executed, this will use the <code>executeStatement</code> API.</li>
         * </ul>
         * <p>
         * Default: - No SQL query is specified
         * <p>
         * @return {@code this}
         * @param sql The SQL queries to be executed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sql(final java.util.List<java.lang.String> sql) {
            this.props.sql(sql);
            return this;
        }

        /**
         * The Amazon Redshift database user to run the query as.
         * <p>
         * This is required when authenticating via temporary credentials.
         * <p>
         * Default: - No Database user is specified
         * <p>
         * @return {@code this}
         * @param dbUser The Amazon Redshift database user to run the query as. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbUser(final java.lang.String dbUser) {
            this.props.dbUser(dbUser);
            return this;
        }

        /**
         * The queue to be used as dead letter queue.
         * <p>
         * Default: - No dead letter queue is specified
         * <p>
         * @return {@code this}
         * @param deadLetterQueue The queue to be used as dead letter queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * The input to the state machine execution.
         * <p>
         * Default: - the entire EventBridge event
         * <p>
         * @return {@code this}
         * @param input The input to the state machine execution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(final software.amazon.awscdk.services.events.RuleTargetInput input) {
            this.props.input(input);
            return this;
        }

        /**
         * The IAM role to be used to execute the SQL statement.
         * <p>
         * Default: - a new role will be created.
         * <p>
         * @return {@code this}
         * @param role The IAM role to be used to execute the SQL statement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * The secret containing the password for the database user.
         * <p>
         * This is required when authenticating via Secrets Manager.
         * If the full secret ARN is not specified, this will instead use the secret name.
         * <p>
         * Default: - No secret is specified
         * <p>
         * @return {@code this}
         * @param secret The secret containing the password for the database user. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secret(final software.amazon.awscdk.services.secretsmanager.ISecret secret) {
            this.props.secret(secret);
            return this;
        }

        /**
         * Should an event be sent back to Event Bridge when the SQL statement is executed.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param sendEventBridgeEvent Should an event be sent back to Event Bridge when the SQL statement is executed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sendEventBridgeEvent(final java.lang.Boolean sendEventBridgeEvent) {
            this.props.sendEventBridgeEvent(sendEventBridgeEvent);
            return this;
        }

        /**
         * The name of the SQL statement.
         * <p>
         * You can name the SQL statement for identitfication purposes. If you would like Amazon Redshift to identify the Event Bridge rule, and present it in the Amazon Redshift console, append a <code>QS2-</code> prefix to the statement name.
         * <p>
         * Default: - No statement name is specified
         * <p>
         * @return {@code this}
         * @param statementName The name of the SQL statement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statementName(final java.lang.String statementName) {
            this.props.statementName(statementName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.events.targets.RedshiftQuery}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.events.targets.RedshiftQuery build() {
            return new software.amazon.awscdk.services.events.targets.RedshiftQuery(
                this.clusterArn,
                this.props.build()
            );
        }
    }
}
