package software.amazon.awscdk.services.events.targets;

/**
 * Configuration properties of an Amazon Redshift Query event.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.redshiftserverless.*;
 * CfnWorkgroup workgroup;
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.rate(Duration.hours(1)))
 *         .build();
 * Queue dlq = new Queue(this, "DeadLetterQueue");
 * rule.addTarget(RedshiftQuery.Builder.create(workgroup.getAttrWorkgroupWorkgroupArn())
 *         .database("dev")
 *         .deadLetterQueue(dlq)
 *         .sql(List.of("SELECT * FROM foo", "SELECT * FROM baz"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:32.445Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.RedshiftQueryProps")
@software.amazon.jsii.Jsii.Proxy(RedshiftQueryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RedshiftQueryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Redshift database to run the query against.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDatabase();

    /**
     * The SQL queries to be executed.
     * <p>
     * Each query is run sequentially within a single transaction; the next query in the array will only execute after the previous one has successfully completed.
     * <p>
     * <ul>
     * <li>When multiple sql queries are included, this will use the <code>batchExecuteStatement</code> API. Therefore, if any statement fails, the entire transaction is rolled back.</li>
     * <li>If a single SQL statement is to be executed, this will use the <code>executeStatement</code> API.</li>
     * </ul>
     * <p>
     * Default: - No SQL query is specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSql();

    /**
     * The Amazon Redshift database user to run the query as.
     * <p>
     * This is required when authenticating via temporary credentials.
     * <p>
     * Default: - No Database user is specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbUser() {
        return null;
    }

    /**
     * The queue to be used as dead letter queue.
     * <p>
     * Default: - No dead letter queue is specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
        return null;
    }

    /**
     * The input to the state machine execution.
     * <p>
     * Default: - the entire EventBridge event
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.RuleTargetInput getInput() {
        return null;
    }

    /**
     * The IAM role to be used to execute the SQL statement.
     * <p>
     * Default: - a new role will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * The secret containing the password for the database user.
     * <p>
     * This is required when authenticating via Secrets Manager.
     * If the full secret ARN is not specified, this will instead use the secret name.
     * <p>
     * Default: - No secret is specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
        return null;
    }

    /**
     * Should an event be sent back to Event Bridge when the SQL statement is executed.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSendEventBridgeEvent() {
        return null;
    }

    /**
     * The name of the SQL statement.
     * <p>
     * You can name the SQL statement for identitfication purposes. If you would like Amazon Redshift to identify the Event Bridge rule, and present it in the Amazon Redshift console, append a <code>QS2-</code> prefix to the statement name.
     * <p>
     * Default: - No statement name is specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatementName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RedshiftQueryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RedshiftQueryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RedshiftQueryProps> {
        java.lang.String database;
        java.util.List<java.lang.String> sql;
        java.lang.String dbUser;
        software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        software.amazon.awscdk.services.events.RuleTargetInput input;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.services.secretsmanager.ISecret secret;
        java.lang.Boolean sendEventBridgeEvent;
        java.lang.String statementName;

        /**
         * Sets the value of {@link RedshiftQueryProps#getDatabase}
         * @param database The Amazon Redshift database to run the query against. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder database(java.lang.String database) {
            this.database = database;
            return this;
        }

        /**
         * Sets the value of {@link RedshiftQueryProps#getSql}
         * @param sql The SQL queries to be executed. This parameter is required.
         *            Each query is run sequentially within a single transaction; the next query in the array will only execute after the previous one has successfully completed.
         *            <p>
         *            <ul>
         *            <li>When multiple sql queries are included, this will use the <code>batchExecuteStatement</code> API. Therefore, if any statement fails, the entire transaction is rolled back.</li>
         *            <li>If a single SQL statement is to be executed, this will use the <code>executeStatement</code> API.</li>
         *            </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sql(java.util.List<java.lang.String> sql) {
            this.sql = sql;
            return this;
        }

        /**
         * Sets the value of {@link RedshiftQueryProps#getDbUser}
         * @param dbUser The Amazon Redshift database user to run the query as.
         *               This is required when authenticating via temporary credentials.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbUser(java.lang.String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        /**
         * Sets the value of {@link RedshiftQueryProps#getDeadLetterQueue}
         * @param deadLetterQueue The queue to be used as dead letter queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        /**
         * Sets the value of {@link RedshiftQueryProps#getInput}
         * @param input The input to the state machine execution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(software.amazon.awscdk.services.events.RuleTargetInput input) {
            this.input = input;
            return this;
        }

        /**
         * Sets the value of {@link RedshiftQueryProps#getRole}
         * @param role The IAM role to be used to execute the SQL statement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link RedshiftQueryProps#getSecret}
         * @param secret The secret containing the password for the database user.
         *               This is required when authenticating via Secrets Manager.
         *               If the full secret ARN is not specified, this will instead use the secret name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secret(software.amazon.awscdk.services.secretsmanager.ISecret secret) {
            this.secret = secret;
            return this;
        }

        /**
         * Sets the value of {@link RedshiftQueryProps#getSendEventBridgeEvent}
         * @param sendEventBridgeEvent Should an event be sent back to Event Bridge when the SQL statement is executed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sendEventBridgeEvent(java.lang.Boolean sendEventBridgeEvent) {
            this.sendEventBridgeEvent = sendEventBridgeEvent;
            return this;
        }

        /**
         * Sets the value of {@link RedshiftQueryProps#getStatementName}
         * @param statementName The name of the SQL statement.
         *                      You can name the SQL statement for identitfication purposes. If you would like Amazon Redshift to identify the Event Bridge rule, and present it in the Amazon Redshift console, append a <code>QS2-</code> prefix to the statement name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statementName(java.lang.String statementName) {
            this.statementName = statementName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RedshiftQueryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RedshiftQueryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RedshiftQueryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftQueryProps {
        private final java.lang.String database;
        private final java.util.List<java.lang.String> sql;
        private final java.lang.String dbUser;
        private final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private final software.amazon.awscdk.services.events.RuleTargetInput input;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.secretsmanager.ISecret secret;
        private final java.lang.Boolean sendEventBridgeEvent;
        private final java.lang.String statementName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sql = software.amazon.jsii.Kernel.get(this, "sql", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.dbUser = software.amazon.jsii.Kernel.get(this, "dbUser", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deadLetterQueue = software.amazon.jsii.Kernel.get(this, "deadLetterQueue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
            this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetInput.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.secret = software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
            this.sendEventBridgeEvent = software.amazon.jsii.Kernel.get(this, "sendEventBridgeEvent", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.statementName = software.amazon.jsii.Kernel.get(this, "statementName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.database = java.util.Objects.requireNonNull(builder.database, "database is required");
            this.sql = java.util.Objects.requireNonNull(builder.sql, "sql is required");
            this.dbUser = builder.dbUser;
            this.deadLetterQueue = builder.deadLetterQueue;
            this.input = builder.input;
            this.role = builder.role;
            this.secret = builder.secret;
            this.sendEventBridgeEvent = builder.sendEventBridgeEvent;
            this.statementName = builder.statementName;
        }

        @Override
        public final java.lang.String getDatabase() {
            return this.database;
        }

        @Override
        public final java.util.List<java.lang.String> getSql() {
            return this.sql;
        }

        @Override
        public final java.lang.String getDbUser() {
            return this.dbUser;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
            return this.deadLetterQueue;
        }

        @Override
        public final software.amazon.awscdk.services.events.RuleTargetInput getInput() {
            return this.input;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
            return this.secret;
        }

        @Override
        public final java.lang.Boolean getSendEventBridgeEvent() {
            return this.sendEventBridgeEvent;
        }

        @Override
        public final java.lang.String getStatementName() {
            return this.statementName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("database", om.valueToTree(this.getDatabase()));
            data.set("sql", om.valueToTree(this.getSql()));
            if (this.getDbUser() != null) {
                data.set("dbUser", om.valueToTree(this.getDbUser()));
            }
            if (this.getDeadLetterQueue() != null) {
                data.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
            }
            if (this.getInput() != null) {
                data.set("input", om.valueToTree(this.getInput()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecret() != null) {
                data.set("secret", om.valueToTree(this.getSecret()));
            }
            if (this.getSendEventBridgeEvent() != null) {
                data.set("sendEventBridgeEvent", om.valueToTree(this.getSendEventBridgeEvent()));
            }
            if (this.getStatementName() != null) {
                data.set("statementName", om.valueToTree(this.getStatementName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events_targets.RedshiftQueryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RedshiftQueryProps.Jsii$Proxy that = (RedshiftQueryProps.Jsii$Proxy) o;

            if (!database.equals(that.database)) return false;
            if (!sql.equals(that.sql)) return false;
            if (this.dbUser != null ? !this.dbUser.equals(that.dbUser) : that.dbUser != null) return false;
            if (this.deadLetterQueue != null ? !this.deadLetterQueue.equals(that.deadLetterQueue) : that.deadLetterQueue != null) return false;
            if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.secret != null ? !this.secret.equals(that.secret) : that.secret != null) return false;
            if (this.sendEventBridgeEvent != null ? !this.sendEventBridgeEvent.equals(that.sendEventBridgeEvent) : that.sendEventBridgeEvent != null) return false;
            return this.statementName != null ? this.statementName.equals(that.statementName) : that.statementName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.database.hashCode();
            result = 31 * result + (this.sql.hashCode());
            result = 31 * result + (this.dbUser != null ? this.dbUser.hashCode() : 0);
            result = 31 * result + (this.deadLetterQueue != null ? this.deadLetterQueue.hashCode() : 0);
            result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.secret != null ? this.secret.hashCode() : 0);
            result = 31 * result + (this.sendEventBridgeEvent != null ? this.sendEventBridgeEvent.hashCode() : 0);
            result = 31 * result + (this.statementName != null ? this.statementName.hashCode() : 0);
            return result;
        }
    }
}
