package software.amazon.awscdk.services.gamelift;

/**
 * <em>This data type is used with the Amazon GameLift containers feature, which is currently in public preview.</em>.
 * <p>
 * The properties that describe a container group resource. Container group definition properties can't be updated. To change a property, create a new container group definition.
 * <p>
 * <em>Used with:</em> <code>CreateContainerGroupDefinition</code>
 * <p>
 * <em>Returned by:</em> <code>DescribeContainerGroupDefinition</code> , <code>ListContainerGroupDefinitions</code>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.gamelift.*;
 * CfnContainerGroupDefinition cfnContainerGroupDefinition = CfnContainerGroupDefinition.Builder.create(this, "MyCfnContainerGroupDefinition")
 *         .containerDefinitions(List.of(ContainerDefinitionProperty.builder()
 *                 .containerName("containerName")
 *                 .imageUri("imageUri")
 *                 // the properties below are optional
 *                 .command(List.of("command"))
 *                 .cpu(123)
 *                 .dependsOn(List.of(ContainerDependencyProperty.builder()
 *                         .condition("condition")
 *                         .containerName("containerName")
 *                         .build()))
 *                 .entryPoint(List.of("entryPoint"))
 *                 .environment(List.of(ContainerEnvironmentProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .essential(false)
 *                 .healthCheck(ContainerHealthCheckProperty.builder()
 *                         .command(List.of("command"))
 *                         // the properties below are optional
 *                         .interval(123)
 *                         .retries(123)
 *                         .startPeriod(123)
 *                         .timeout(123)
 *                         .build())
 *                 .memoryLimits(MemoryLimitsProperty.builder()
 *                         .hardLimit(123)
 *                         .softLimit(123)
 *                         .build())
 *                 .portConfiguration(PortConfigurationProperty.builder()
 *                         .containerPortRanges(List.of(ContainerPortRangeProperty.builder()
 *                                 .fromPort(123)
 *                                 .protocol("protocol")
 *                                 .toPort(123)
 *                                 .build()))
 *                         .build())
 *                 .resolvedImageDigest("resolvedImageDigest")
 *                 .workingDirectory("workingDirectory")
 *                 .build()))
 *         .name("name")
 *         .operatingSystem("operatingSystem")
 *         .totalCpuLimit(123)
 *         .totalMemoryLimit(123)
 *         // the properties below are optional
 *         .schedulingStrategy("schedulingStrategy")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:32.656Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition")
public class CfnContainerGroupDefinition extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnContainerGroupDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnContainerGroupDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnContainerGroupDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name ( <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a> ) that is assigned to an Amazon GameLift <code>ContainerGroupDefinition</code> resource. It uniquely identifies the resource across all AWS Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::containergroupdefinition/[container group definition name]</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrContainerGroupDefinitionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrContainerGroupDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A time stamp indicating when this data object was created.
     * <p>
     * Format is a number expressed in Unix time as milliseconds (for example <code>"1469498468.057"</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The set of container definitions that are included in the container group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getContainerDefinitions() {
        return software.amazon.jsii.Kernel.get(this, "containerDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The set of container definitions that are included in the container group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerDefinitions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "containerDefinitions", java.util.Objects.requireNonNull(value, "containerDefinitions is required"));
    }

    /**
     * The set of container definitions that are included in the container group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerDefinitions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition.ContainerDefinitionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition.ContainerDefinitionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "containerDefinitions", java.util.Objects.requireNonNull(value, "containerDefinitions is required"));
    }

    /**
     * A descriptive identifier for the container group definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A descriptive identifier for the container group definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The platform required for all containers in the container group definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOperatingSystem() {
        return software.amazon.jsii.Kernel.get(this, "operatingSystem", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The platform required for all containers in the container group definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOperatingSystem(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "operatingSystem", java.util.Objects.requireNonNull(value, "operatingSystem is required"));
    }

    /**
     * The amount of CPU units on a fleet instance to allocate for the container group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getTotalCpuLimit() {
        return software.amazon.jsii.Kernel.get(this, "totalCpuLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The amount of CPU units on a fleet instance to allocate for the container group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTotalCpuLimit(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "totalCpuLimit", java.util.Objects.requireNonNull(value, "totalCpuLimit is required"));
    }

    /**
     * The amount of memory (in MiB) on a fleet instance to allocate for the container group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getTotalMemoryLimit() {
        return software.amazon.jsii.Kernel.get(this, "totalMemoryLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The amount of memory (in MiB) on a fleet instance to allocate for the container group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTotalMemoryLimit(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "totalMemoryLimit", java.util.Objects.requireNonNull(value, "totalMemoryLimit is required"));
    }

    /**
     * The method for deploying the container group across fleet instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSchedulingStrategy() {
        return software.amazon.jsii.Kernel.get(this, "schedulingStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The method for deploying the container group across fleet instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedulingStrategy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "schedulingStrategy", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * <em>This data type is used with the Amazon GameLift containers feature, which is currently in public preview.</em>.
     * <p>
     * Describes a container in a container fleet, the resources available to the container, and the commands that are run when the container starts. Container properties can't be updated. To change a property, create a new container group definition. See also <code>ContainerDefinitionInput</code> .
     * <p>
     * <em>Part of:</em> <code>ContainerGroupDefinition</code>
     * <p>
     * <em>Returned by:</em> <code>DescribeContainerGroupDefinition</code> , <code>ListContainerGroupDefinitions</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * ContainerDefinitionProperty containerDefinitionProperty = ContainerDefinitionProperty.builder()
     *         .containerName("containerName")
     *         .imageUri("imageUri")
     *         // the properties below are optional
     *         .command(List.of("command"))
     *         .cpu(123)
     *         .dependsOn(List.of(ContainerDependencyProperty.builder()
     *                 .condition("condition")
     *                 .containerName("containerName")
     *                 .build()))
     *         .entryPoint(List.of("entryPoint"))
     *         .environment(List.of(ContainerEnvironmentProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .essential(false)
     *         .healthCheck(ContainerHealthCheckProperty.builder()
     *                 .command(List.of("command"))
     *                 // the properties below are optional
     *                 .interval(123)
     *                 .retries(123)
     *                 .startPeriod(123)
     *                 .timeout(123)
     *                 .build())
     *         .memoryLimits(MemoryLimitsProperty.builder()
     *                 .hardLimit(123)
     *                 .softLimit(123)
     *                 .build())
     *         .portConfiguration(PortConfigurationProperty.builder()
     *                 .containerPortRanges(List.of(ContainerPortRangeProperty.builder()
     *                         .fromPort(123)
     *                         .protocol("protocol")
     *                         .toPort(123)
     *                         .build()))
     *                 .build())
     *         .resolvedImageDigest("resolvedImageDigest")
     *         .workingDirectory("workingDirectory")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.ContainerDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The container definition identifier.
         * <p>
         * Container names are unique within a container group definition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-containername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-containername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContainerName();

        /**
         * The URI to the image that $short;
         * <p>
         * copied and deployed to a container fleet. For a more specific identifier, see <code>ResolvedImageDigest</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-imageuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-imageuri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImageUri();

        /**
         * A command that's passed to the container on startup.
         * <p>
         * Each argument for the command is an additional string in the array. See the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html#ECS-Type-ContainerDefinition-command">ContainerDefinition::command</a> parameter in the <em>Amazon Elastic Container Service API reference.</em>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-command">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-command</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return null;
        }

        /**
         * The number of CPU units that are reserved for the container.
         * <p>
         * Note: 1 vCPU unit equals 1024 CPU units. If no resources are reserved, the container shares the total CPU limit for the container group.
         * <p>
         * <em>Related data type:</em> <code>ContainerGroupDefinition$TotalCpuLimit</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-cpu">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-cpu</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCpu() {
            return null;
        }

        /**
         * Indicates that the container relies on the status of other containers in the same container group during its startup and shutdown sequences.
         * <p>
         * A container might have dependencies on multiple containers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-dependson">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-dependson</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDependsOn() {
            return null;
        }

        /**
         * The entry point that's passed to the container on startup.
         * <p>
         * If there are multiple arguments, each argument is an additional string in the array. See the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html#ECS-Type-ContainerDefinition-entryPoint">ContainerDefinition::entryPoint</a> parameter in the <em>Amazon Elastic Container Service API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-entrypoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-entrypoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEntryPoint() {
            return null;
        }

        /**
         * A set of environment variables that's passed to the container on startup.
         * <p>
         * See the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html#ECS-Type-ContainerDefinition-environment">ContainerDefinition::environment</a> parameter in the <em>Amazon Elastic Container Service API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-environment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-environment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
            return null;
        }

        /**
         * Indicates whether the container is vital to the container group.
         * <p>
         * If an essential container fails, the entire container group is restarted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-essential">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-essential</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEssential() {
            return null;
        }

        /**
         * A configuration for a non-terminal health check.
         * <p>
         * A container, which automatically restarts if it stops functioning, also restarts if it fails this health check. If an essential container in the daemon group fails a health check, the entire container group is restarted. The essential container in the replica group doesn't use this health check mechanism, because the Amazon GameLift Agent automatically handles the task.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-healthcheck">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-healthcheck</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHealthCheck() {
            return null;
        }

        /**
         * The amount of memory that Amazon GameLift makes available to the container.
         * <p>
         * If memory limits aren't set for an individual container, the container shares the container group's total memory allocation.
         * <p>
         * <em>Related data type:</em> <code>ContainerGroupDefinition$TotalMemoryLimit</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-memorylimits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-memorylimits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMemoryLimits() {
            return null;
        }

        /**
         * Defines the ports that are available to assign to processes in the container.
         * <p>
         * For example, a game server process requires a container port to allow game clients to connect to it. Container ports aren't directly accessed by inbound traffic. Amazon GameLift maps these container ports to externally accessible connection ports, which are assigned as needed from the container fleet's <code>ConnectionPortRange</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-portconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-portconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPortConfiguration() {
            return null;
        }

        /**
         * A unique and immutable identifier for the container image that is deployed to a container fleet.
         * <p>
         * The digest is a SHA 256 hash of the container image manifest.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-resolvedimagedigest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-resolvedimagedigest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResolvedImageDigest() {
            return null;
        }

        /**
         * The directory in the container where commands are run.
         * <p>
         * See the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html#ECS-Type-ContainerDefinition-workingDirectory">ContainerDefinition::workingDirectory</a> parameter in the <em>Amazon Elastic Container Service API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-workingdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinition-workingdirectory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWorkingDirectory() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContainerDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerDefinitionProperty> {
            java.lang.String containerName;
            java.lang.String imageUri;
            java.util.List<java.lang.String> command;
            java.lang.Number cpu;
            java.lang.Object dependsOn;
            java.util.List<java.lang.String> entryPoint;
            java.lang.Object environment;
            java.lang.Object essential;
            java.lang.Object healthCheck;
            java.lang.Object memoryLimits;
            java.lang.Object portConfiguration;
            java.lang.String resolvedImageDigest;
            java.lang.String workingDirectory;

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getContainerName}
             * @param containerName The container definition identifier. This parameter is required.
             *                      Container names are unique within a container group definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerName(java.lang.String containerName) {
                this.containerName = containerName;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getImageUri}
             * @param imageUri The URI to the image that $short;. This parameter is required.
             *                 copied and deployed to a container fleet. For a more specific identifier, see <code>ResolvedImageDigest</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageUri(java.lang.String imageUri) {
                this.imageUri = imageUri;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getCommand}
             * @param command A command that's passed to the container on startup.
             *                Each argument for the command is an additional string in the array. See the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html#ECS-Type-ContainerDefinition-command">ContainerDefinition::command</a> parameter in the <em>Amazon Elastic Container Service API reference.</em>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder command(java.util.List<java.lang.String> command) {
                this.command = command;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getCpu}
             * @param cpu The number of CPU units that are reserved for the container.
             *            Note: 1 vCPU unit equals 1024 CPU units. If no resources are reserved, the container shares the total CPU limit for the container group.
             *            <p>
             *            <em>Related data type:</em> <code>ContainerGroupDefinition$TotalCpuLimit</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpu(java.lang.Number cpu) {
                this.cpu = cpu;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getDependsOn}
             * @param dependsOn Indicates that the container relies on the status of other containers in the same container group during its startup and shutdown sequences.
             *                  A container might have dependencies on multiple containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependsOn(software.amazon.awscdk.IResolvable dependsOn) {
                this.dependsOn = dependsOn;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getDependsOn}
             * @param dependsOn Indicates that the container relies on the status of other containers in the same container group during its startup and shutdown sequences.
             *                  A container might have dependencies on multiple containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependsOn(java.util.List<? extends java.lang.Object> dependsOn) {
                this.dependsOn = dependsOn;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getEntryPoint}
             * @param entryPoint The entry point that's passed to the container on startup.
             *                   If there are multiple arguments, each argument is an additional string in the array. See the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html#ECS-Type-ContainerDefinition-entryPoint">ContainerDefinition::entryPoint</a> parameter in the <em>Amazon Elastic Container Service API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entryPoint(java.util.List<java.lang.String> entryPoint) {
                this.entryPoint = entryPoint;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getEnvironment}
             * @param environment A set of environment variables that's passed to the container on startup.
             *                    See the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html#ECS-Type-ContainerDefinition-environment">ContainerDefinition::environment</a> parameter in the <em>Amazon Elastic Container Service API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(software.amazon.awscdk.IResolvable environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getEnvironment}
             * @param environment A set of environment variables that's passed to the container on startup.
             *                    See the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html#ECS-Type-ContainerDefinition-environment">ContainerDefinition::environment</a> parameter in the <em>Amazon Elastic Container Service API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(java.util.List<? extends java.lang.Object> environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getEssential}
             * @param essential Indicates whether the container is vital to the container group.
             *                  If an essential container fails, the entire container group is restarted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder essential(java.lang.Boolean essential) {
                this.essential = essential;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getEssential}
             * @param essential Indicates whether the container is vital to the container group.
             *                  If an essential container fails, the entire container group is restarted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder essential(software.amazon.awscdk.IResolvable essential) {
                this.essential = essential;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getHealthCheck}
             * @param healthCheck A configuration for a non-terminal health check.
             *                    A container, which automatically restarts if it stops functioning, also restarts if it fails this health check. If an essential container in the daemon group fails a health check, the entire container group is restarted. The essential container in the replica group doesn't use this health check mechanism, because the Amazon GameLift Agent automatically handles the task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthCheck(software.amazon.awscdk.IResolvable healthCheck) {
                this.healthCheck = healthCheck;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getHealthCheck}
             * @param healthCheck A configuration for a non-terminal health check.
             *                    A container, which automatically restarts if it stops functioning, also restarts if it fails this health check. If an essential container in the daemon group fails a health check, the entire container group is restarted. The essential container in the replica group doesn't use this health check mechanism, because the Amazon GameLift Agent automatically handles the task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthCheck(software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition.ContainerHealthCheckProperty healthCheck) {
                this.healthCheck = healthCheck;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getMemoryLimits}
             * @param memoryLimits The amount of memory that Amazon GameLift makes available to the container.
             *                     If memory limits aren't set for an individual container, the container shares the container group's total memory allocation.
             *                     <p>
             *                     <em>Related data type:</em> <code>ContainerGroupDefinition$TotalMemoryLimit</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryLimits(software.amazon.awscdk.IResolvable memoryLimits) {
                this.memoryLimits = memoryLimits;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getMemoryLimits}
             * @param memoryLimits The amount of memory that Amazon GameLift makes available to the container.
             *                     If memory limits aren't set for an individual container, the container shares the container group's total memory allocation.
             *                     <p>
             *                     <em>Related data type:</em> <code>ContainerGroupDefinition$TotalMemoryLimit</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryLimits(software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition.MemoryLimitsProperty memoryLimits) {
                this.memoryLimits = memoryLimits;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getPortConfiguration}
             * @param portConfiguration Defines the ports that are available to assign to processes in the container.
             *                          For example, a game server process requires a container port to allow game clients to connect to it. Container ports aren't directly accessed by inbound traffic. Amazon GameLift maps these container ports to externally accessible connection ports, which are assigned as needed from the container fleet's <code>ConnectionPortRange</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portConfiguration(software.amazon.awscdk.IResolvable portConfiguration) {
                this.portConfiguration = portConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getPortConfiguration}
             * @param portConfiguration Defines the ports that are available to assign to processes in the container.
             *                          For example, a game server process requires a container port to allow game clients to connect to it. Container ports aren't directly accessed by inbound traffic. Amazon GameLift maps these container ports to externally accessible connection ports, which are assigned as needed from the container fleet's <code>ConnectionPortRange</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portConfiguration(software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition.PortConfigurationProperty portConfiguration) {
                this.portConfiguration = portConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getResolvedImageDigest}
             * @param resolvedImageDigest A unique and immutable identifier for the container image that is deployed to a container fleet.
             *                            The digest is a SHA 256 hash of the container image manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resolvedImageDigest(java.lang.String resolvedImageDigest) {
                this.resolvedImageDigest = resolvedImageDigest;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDefinitionProperty#getWorkingDirectory}
             * @param workingDirectory The directory in the container where commands are run.
             *                         See the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html#ECS-Type-ContainerDefinition-workingDirectory">ContainerDefinition::workingDirectory</a> parameter in the <em>Amazon Elastic Container Service API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workingDirectory(java.lang.String workingDirectory) {
                this.workingDirectory = workingDirectory;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContainerDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerDefinitionProperty {
            private final java.lang.String containerName;
            private final java.lang.String imageUri;
            private final java.util.List<java.lang.String> command;
            private final java.lang.Number cpu;
            private final java.lang.Object dependsOn;
            private final java.util.List<java.lang.String> entryPoint;
            private final java.lang.Object environment;
            private final java.lang.Object essential;
            private final java.lang.Object healthCheck;
            private final java.lang.Object memoryLimits;
            private final java.lang.Object portConfiguration;
            private final java.lang.String resolvedImageDigest;
            private final java.lang.String workingDirectory;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerName = software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageUri = software.amazon.jsii.Kernel.get(this, "imageUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.entryPoint = software.amazon.jsii.Kernel.get(this, "entryPoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.essential = software.amazon.jsii.Kernel.get(this, "essential", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.healthCheck = software.amazon.jsii.Kernel.get(this, "healthCheck", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.memoryLimits = software.amazon.jsii.Kernel.get(this, "memoryLimits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.portConfiguration = software.amazon.jsii.Kernel.get(this, "portConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resolvedImageDigest = software.amazon.jsii.Kernel.get(this, "resolvedImageDigest", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.workingDirectory = software.amazon.jsii.Kernel.get(this, "workingDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerName = java.util.Objects.requireNonNull(builder.containerName, "containerName is required");
                this.imageUri = java.util.Objects.requireNonNull(builder.imageUri, "imageUri is required");
                this.command = builder.command;
                this.cpu = builder.cpu;
                this.dependsOn = builder.dependsOn;
                this.entryPoint = builder.entryPoint;
                this.environment = builder.environment;
                this.essential = builder.essential;
                this.healthCheck = builder.healthCheck;
                this.memoryLimits = builder.memoryLimits;
                this.portConfiguration = builder.portConfiguration;
                this.resolvedImageDigest = builder.resolvedImageDigest;
                this.workingDirectory = builder.workingDirectory;
            }

            @Override
            public final java.lang.String getContainerName() {
                return this.containerName;
            }

            @Override
            public final java.lang.String getImageUri() {
                return this.imageUri;
            }

            @Override
            public final java.util.List<java.lang.String> getCommand() {
                return this.command;
            }

            @Override
            public final java.lang.Number getCpu() {
                return this.cpu;
            }

            @Override
            public final java.lang.Object getDependsOn() {
                return this.dependsOn;
            }

            @Override
            public final java.util.List<java.lang.String> getEntryPoint() {
                return this.entryPoint;
            }

            @Override
            public final java.lang.Object getEnvironment() {
                return this.environment;
            }

            @Override
            public final java.lang.Object getEssential() {
                return this.essential;
            }

            @Override
            public final java.lang.Object getHealthCheck() {
                return this.healthCheck;
            }

            @Override
            public final java.lang.Object getMemoryLimits() {
                return this.memoryLimits;
            }

            @Override
            public final java.lang.Object getPortConfiguration() {
                return this.portConfiguration;
            }

            @Override
            public final java.lang.String getResolvedImageDigest() {
                return this.resolvedImageDigest;
            }

            @Override
            public final java.lang.String getWorkingDirectory() {
                return this.workingDirectory;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("containerName", om.valueToTree(this.getContainerName()));
                data.set("imageUri", om.valueToTree(this.getImageUri()));
                if (this.getCommand() != null) {
                    data.set("command", om.valueToTree(this.getCommand()));
                }
                if (this.getCpu() != null) {
                    data.set("cpu", om.valueToTree(this.getCpu()));
                }
                if (this.getDependsOn() != null) {
                    data.set("dependsOn", om.valueToTree(this.getDependsOn()));
                }
                if (this.getEntryPoint() != null) {
                    data.set("entryPoint", om.valueToTree(this.getEntryPoint()));
                }
                if (this.getEnvironment() != null) {
                    data.set("environment", om.valueToTree(this.getEnvironment()));
                }
                if (this.getEssential() != null) {
                    data.set("essential", om.valueToTree(this.getEssential()));
                }
                if (this.getHealthCheck() != null) {
                    data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
                }
                if (this.getMemoryLimits() != null) {
                    data.set("memoryLimits", om.valueToTree(this.getMemoryLimits()));
                }
                if (this.getPortConfiguration() != null) {
                    data.set("portConfiguration", om.valueToTree(this.getPortConfiguration()));
                }
                if (this.getResolvedImageDigest() != null) {
                    data.set("resolvedImageDigest", om.valueToTree(this.getResolvedImageDigest()));
                }
                if (this.getWorkingDirectory() != null) {
                    data.set("workingDirectory", om.valueToTree(this.getWorkingDirectory()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.ContainerDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerDefinitionProperty.Jsii$Proxy that = (ContainerDefinitionProperty.Jsii$Proxy) o;

                if (!containerName.equals(that.containerName)) return false;
                if (!imageUri.equals(that.imageUri)) return false;
                if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
                if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
                if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
                if (this.entryPoint != null ? !this.entryPoint.equals(that.entryPoint) : that.entryPoint != null) return false;
                if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
                if (this.essential != null ? !this.essential.equals(that.essential) : that.essential != null) return false;
                if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
                if (this.memoryLimits != null ? !this.memoryLimits.equals(that.memoryLimits) : that.memoryLimits != null) return false;
                if (this.portConfiguration != null ? !this.portConfiguration.equals(that.portConfiguration) : that.portConfiguration != null) return false;
                if (this.resolvedImageDigest != null ? !this.resolvedImageDigest.equals(that.resolvedImageDigest) : that.resolvedImageDigest != null) return false;
                return this.workingDirectory != null ? this.workingDirectory.equals(that.workingDirectory) : that.workingDirectory == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerName.hashCode();
                result = 31 * result + (this.imageUri.hashCode());
                result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
                result = 31 * result + (this.cpu != null ? this.cpu.hashCode() : 0);
                result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
                result = 31 * result + (this.entryPoint != null ? this.entryPoint.hashCode() : 0);
                result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
                result = 31 * result + (this.essential != null ? this.essential.hashCode() : 0);
                result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
                result = 31 * result + (this.memoryLimits != null ? this.memoryLimits.hashCode() : 0);
                result = 31 * result + (this.portConfiguration != null ? this.portConfiguration.hashCode() : 0);
                result = 31 * result + (this.resolvedImageDigest != null ? this.resolvedImageDigest.hashCode() : 0);
                result = 31 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <em>This data type is used with the Amazon GameLift containers feature, which is currently in public preview.</em>.
     * <p>
     * A container's dependency on another container in the same container group. The dependency impacts how the dependent container is able to start or shut down based the status of the other container.
     * <p>
     * For example, ContainerA is configured with the following dependency: a <code>START</code> dependency on ContainerB. This means that ContainerA can't start until ContainerB has started. It also means that ContainerA must shut down before ContainerB.
     * <p>
     * <em>Part of:</em> <code>ContainerDefinition</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * ContainerDependencyProperty containerDependencyProperty = ContainerDependencyProperty.builder()
     *         .condition("condition")
     *         .containerName("containerName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdependency.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdependency.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.ContainerDependencyProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerDependencyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerDependencyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The condition that the dependency container must reach before the dependent container can start. Valid conditions include:.
         * <p>
         * <ul>
         * <li>START - The dependency container must have started.</li>
         * <li>COMPLETE - The dependency container has run to completion (exits). Use this condition with nonessential containers, such as those that run a script and then exit. The dependency container can't be an essential container.</li>
         * <li>SUCCESS - The dependency container has run to completion and exited with a zero status. The dependency container can't be an essential container.</li>
         * <li>HEALTHY - The dependency container has passed its Docker health check. Use this condition with dependency containers that have health checks configured. This condition is confirmed at container group startup only.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdependency.html#cfn-gamelift-containergroupdefinition-containerdependency-condition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdependency.html#cfn-gamelift-containergroupdefinition-containerdependency-condition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCondition();

        /**
         * A descriptive label for the container definition that this container depends on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdependency.html#cfn-gamelift-containergroupdefinition-containerdependency-containername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerdependency.html#cfn-gamelift-containergroupdefinition-containerdependency-containername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContainerName();

        /**
         * @return a {@link Builder} of {@link ContainerDependencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerDependencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerDependencyProperty> {
            java.lang.String condition;
            java.lang.String containerName;

            /**
             * Sets the value of {@link ContainerDependencyProperty#getCondition}
             * @param condition The condition that the dependency container must reach before the dependent container can start. Valid conditions include:. This parameter is required.
             *                  <ul>
             *                  <li>START - The dependency container must have started.</li>
             *                  <li>COMPLETE - The dependency container has run to completion (exits). Use this condition with nonessential containers, such as those that run a script and then exit. The dependency container can't be an essential container.</li>
             *                  <li>SUCCESS - The dependency container has run to completion and exited with a zero status. The dependency container can't be an essential container.</li>
             *                  <li>HEALTHY - The dependency container has passed its Docker health check. Use this condition with dependency containers that have health checks configured. This condition is confirmed at container group startup only.</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(java.lang.String condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link ContainerDependencyProperty#getContainerName}
             * @param containerName A descriptive label for the container definition that this container depends on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerName(java.lang.String containerName) {
                this.containerName = containerName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerDependencyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerDependencyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContainerDependencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerDependencyProperty {
            private final java.lang.String condition;
            private final java.lang.String containerName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.containerName = software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.condition = java.util.Objects.requireNonNull(builder.condition, "condition is required");
                this.containerName = java.util.Objects.requireNonNull(builder.containerName, "containerName is required");
            }

            @Override
            public final java.lang.String getCondition() {
                return this.condition;
            }

            @Override
            public final java.lang.String getContainerName() {
                return this.containerName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("condition", om.valueToTree(this.getCondition()));
                data.set("containerName", om.valueToTree(this.getContainerName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.ContainerDependencyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerDependencyProperty.Jsii$Proxy that = (ContainerDependencyProperty.Jsii$Proxy) o;

                if (!condition.equals(that.condition)) return false;
                return this.containerName.equals(that.containerName);
            }

            @Override
            public final int hashCode() {
                int result = this.condition.hashCode();
                result = 31 * result + (this.containerName.hashCode());
                return result;
            }
        }
    }
    /**
     * <em>This data type is used with the Amazon GameLift containers feature, which is currently in public preview.</em>.
     * <p>
     * An environment variable to set inside a container, in the form of a key-value pair.
     * <p>
     * <em>Related data type:</em> <code>ContainerDefinition$Environment</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * ContainerEnvironmentProperty containerEnvironmentProperty = ContainerEnvironmentProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerenvironment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerenvironment.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.ContainerEnvironmentProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerEnvironmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerEnvironmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The environment variable name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerenvironment.html#cfn-gamelift-containergroupdefinition-containerenvironment-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerenvironment.html#cfn-gamelift-containergroupdefinition-containerenvironment-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The environment variable value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerenvironment.html#cfn-gamelift-containergroupdefinition-containerenvironment-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerenvironment.html#cfn-gamelift-containergroupdefinition-containerenvironment-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link ContainerEnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerEnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerEnvironmentProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link ContainerEnvironmentProperty#getName}
             * @param name The environment variable name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ContainerEnvironmentProperty#getValue}
             * @param value The environment variable value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerEnvironmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerEnvironmentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContainerEnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerEnvironmentProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.ContainerEnvironmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerEnvironmentProperty.Jsii$Proxy that = (ContainerEnvironmentProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Instructions on when and how to check the health of a container in a container fleet.
     * <p>
     * When health check properties are set in a container definition, they override any Docker health checks in the container image. For more information on container health checks, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_HealthCheck.html#ECS-Type-HealthCheck-command">HealthCheck command</a> in the <em>Amazon Elastic Container Service API</em> .
     * <p>
     * The following example instructions tell the container to wait 100 seconds after launch before counting failed health checks, then initiate the health check command every 60 seconds. After issuing the health check command, wait 10 seconds for it to succeed. If it fails, retry the command 3 times before considering the container to be unhealthy.
     * <p>
     * <code>{"Command": [ "CMD-SHELL", "ps cax | grep "processmanager" || exit 1" ], "Interval": 300, "Timeout": 30, "Retries": 5, "StartPeriod": 100 }</code>
     * <p>
     * <em>Part of:</em> <code>ContainerDefinition$HealthCheck</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * ContainerHealthCheckProperty containerHealthCheckProperty = ContainerHealthCheckProperty.builder()
     *         .command(List.of("command"))
     *         // the properties below are optional
     *         .interval(123)
     *         .retries(123)
     *         .startPeriod(123)
     *         .timeout(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.ContainerHealthCheckProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerHealthCheckProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerHealthCheckProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A string array that specifies the command that the container runs to determine if it's healthy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html#cfn-gamelift-containergroupdefinition-containerhealthcheck-command">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html#cfn-gamelift-containergroupdefinition-containerhealthcheck-command</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCommand();

        /**
         * The time period (in seconds) between each health check.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html#cfn-gamelift-containergroupdefinition-containerhealthcheck-interval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html#cfn-gamelift-containergroupdefinition-containerhealthcheck-interval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInterval() {
            return null;
        }

        /**
         * The number of times to retry a failed health check before the container is considered unhealthy.
         * <p>
         * The first run of the command does not count as a retry.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html#cfn-gamelift-containergroupdefinition-containerhealthcheck-retries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html#cfn-gamelift-containergroupdefinition-containerhealthcheck-retries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRetries() {
            return null;
        }

        /**
         * The optional grace period (in seconds) to give a container time to bootstrap before the first failed health check counts toward the number of retries.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html#cfn-gamelift-containergroupdefinition-containerhealthcheck-startperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html#cfn-gamelift-containergroupdefinition-containerhealthcheck-startperiod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStartPeriod() {
            return null;
        }

        /**
         * The time period (in seconds) to wait for a health check to succeed before a failed health check is counted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html#cfn-gamelift-containergroupdefinition-containerhealthcheck-timeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerhealthcheck.html#cfn-gamelift-containergroupdefinition-containerhealthcheck-timeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContainerHealthCheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerHealthCheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerHealthCheckProperty> {
            java.util.List<java.lang.String> command;
            java.lang.Number interval;
            java.lang.Number retries;
            java.lang.Number startPeriod;
            java.lang.Number timeout;

            /**
             * Sets the value of {@link ContainerHealthCheckProperty#getCommand}
             * @param command A string array that specifies the command that the container runs to determine if it's healthy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder command(java.util.List<java.lang.String> command) {
                this.command = command;
                return this;
            }

            /**
             * Sets the value of {@link ContainerHealthCheckProperty#getInterval}
             * @param interval The time period (in seconds) between each health check.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interval(java.lang.Number interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of {@link ContainerHealthCheckProperty#getRetries}
             * @param retries The number of times to retry a failed health check before the container is considered unhealthy.
             *                The first run of the command does not count as a retry.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retries(java.lang.Number retries) {
                this.retries = retries;
                return this;
            }

            /**
             * Sets the value of {@link ContainerHealthCheckProperty#getStartPeriod}
             * @param startPeriod The optional grace period (in seconds) to give a container time to bootstrap before the first failed health check counts toward the number of retries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startPeriod(java.lang.Number startPeriod) {
                this.startPeriod = startPeriod;
                return this;
            }

            /**
             * Sets the value of {@link ContainerHealthCheckProperty#getTimeout}
             * @param timeout The time period (in seconds) to wait for a health check to succeed before a failed health check is counted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeout(java.lang.Number timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerHealthCheckProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerHealthCheckProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContainerHealthCheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerHealthCheckProperty {
            private final java.util.List<java.lang.String> command;
            private final java.lang.Number interval;
            private final java.lang.Number retries;
            private final java.lang.Number startPeriod;
            private final java.lang.Number timeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.retries = software.amazon.jsii.Kernel.get(this, "retries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.startPeriod = software.amazon.jsii.Kernel.get(this, "startPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.command = java.util.Objects.requireNonNull(builder.command, "command is required");
                this.interval = builder.interval;
                this.retries = builder.retries;
                this.startPeriod = builder.startPeriod;
                this.timeout = builder.timeout;
            }

            @Override
            public final java.util.List<java.lang.String> getCommand() {
                return this.command;
            }

            @Override
            public final java.lang.Number getInterval() {
                return this.interval;
            }

            @Override
            public final java.lang.Number getRetries() {
                return this.retries;
            }

            @Override
            public final java.lang.Number getStartPeriod() {
                return this.startPeriod;
            }

            @Override
            public final java.lang.Number getTimeout() {
                return this.timeout;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("command", om.valueToTree(this.getCommand()));
                if (this.getInterval() != null) {
                    data.set("interval", om.valueToTree(this.getInterval()));
                }
                if (this.getRetries() != null) {
                    data.set("retries", om.valueToTree(this.getRetries()));
                }
                if (this.getStartPeriod() != null) {
                    data.set("startPeriod", om.valueToTree(this.getStartPeriod()));
                }
                if (this.getTimeout() != null) {
                    data.set("timeout", om.valueToTree(this.getTimeout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.ContainerHealthCheckProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerHealthCheckProperty.Jsii$Proxy that = (ContainerHealthCheckProperty.Jsii$Proxy) o;

                if (!command.equals(that.command)) return false;
                if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
                if (this.retries != null ? !this.retries.equals(that.retries) : that.retries != null) return false;
                if (this.startPeriod != null ? !this.startPeriod.equals(that.startPeriod) : that.startPeriod != null) return false;
                return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
            }

            @Override
            public final int hashCode() {
                int result = this.command.hashCode();
                result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
                result = 31 * result + (this.retries != null ? this.retries.hashCode() : 0);
                result = 31 * result + (this.startPeriod != null ? this.startPeriod.hashCode() : 0);
                result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <em>This data type is used with the Amazon GameLift containers feature, which is currently in public preview.</em>.
     * <p>
     * A set of one or more port numbers that can be opened on the container.
     * <p>
     * <em>Part of:</em> <code>ContainerPortConfiguration</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * ContainerPortRangeProperty containerPortRangeProperty = ContainerPortRangeProperty.builder()
     *         .fromPort(123)
     *         .protocol("protocol")
     *         .toPort(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerportrange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerportrange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.ContainerPortRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerPortRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerPortRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A starting value for the range of allowed port numbers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerportrange.html#cfn-gamelift-containergroupdefinition-containerportrange-fromport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerportrange.html#cfn-gamelift-containergroupdefinition-containerportrange-fromport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getFromPort();

        /**
         * The network protocol that these ports support.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerportrange.html#cfn-gamelift-containergroupdefinition-containerportrange-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerportrange.html#cfn-gamelift-containergroupdefinition-containerportrange-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProtocol();

        /**
         * An ending value for the range of allowed port numbers.
         * <p>
         * Port numbers are end-inclusive. This value must be equal to or greater than <code>FromPort</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerportrange.html#cfn-gamelift-containergroupdefinition-containerportrange-toport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-containerportrange.html#cfn-gamelift-containergroupdefinition-containerportrange-toport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getToPort();

        /**
         * @return a {@link Builder} of {@link ContainerPortRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerPortRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerPortRangeProperty> {
            java.lang.Number fromPort;
            java.lang.String protocol;
            java.lang.Number toPort;

            /**
             * Sets the value of {@link ContainerPortRangeProperty#getFromPort}
             * @param fromPort A starting value for the range of allowed port numbers. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fromPort(java.lang.Number fromPort) {
                this.fromPort = fromPort;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPortRangeProperty#getProtocol}
             * @param protocol The network protocol that these ports support. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPortRangeProperty#getToPort}
             * @param toPort An ending value for the range of allowed port numbers. This parameter is required.
             *               Port numbers are end-inclusive. This value must be equal to or greater than <code>FromPort</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder toPort(java.lang.Number toPort) {
                this.toPort = toPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerPortRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerPortRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContainerPortRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerPortRangeProperty {
            private final java.lang.Number fromPort;
            private final java.lang.String protocol;
            private final java.lang.Number toPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fromPort = software.amazon.jsii.Kernel.get(this, "fromPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.toPort = software.amazon.jsii.Kernel.get(this, "toPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fromPort = java.util.Objects.requireNonNull(builder.fromPort, "fromPort is required");
                this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
                this.toPort = java.util.Objects.requireNonNull(builder.toPort, "toPort is required");
            }

            @Override
            public final java.lang.Number getFromPort() {
                return this.fromPort;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.Number getToPort() {
                return this.toPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fromPort", om.valueToTree(this.getFromPort()));
                data.set("protocol", om.valueToTree(this.getProtocol()));
                data.set("toPort", om.valueToTree(this.getToPort()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.ContainerPortRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerPortRangeProperty.Jsii$Proxy that = (ContainerPortRangeProperty.Jsii$Proxy) o;

                if (!fromPort.equals(that.fromPort)) return false;
                if (!protocol.equals(that.protocol)) return false;
                return this.toPort.equals(that.toPort);
            }

            @Override
            public final int hashCode() {
                int result = this.fromPort.hashCode();
                result = 31 * result + (this.protocol.hashCode());
                result = 31 * result + (this.toPort.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies how much memory is available to the container.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * MemoryLimitsProperty memoryLimitsProperty = MemoryLimitsProperty.builder()
     *         .hardLimit(123)
     *         .softLimit(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-memorylimits.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-memorylimits.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.MemoryLimitsProperty")
    @software.amazon.jsii.Jsii.Proxy(MemoryLimitsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemoryLimitsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The hard limit of memory to reserve for the container.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-memorylimits.html#cfn-gamelift-containergroupdefinition-memorylimits-hardlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-memorylimits.html#cfn-gamelift-containergroupdefinition-memorylimits-hardlimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHardLimit() {
            return null;
        }

        /**
         * The amount of memory that is reserved for the container.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-memorylimits.html#cfn-gamelift-containergroupdefinition-memorylimits-softlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-memorylimits.html#cfn-gamelift-containergroupdefinition-memorylimits-softlimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSoftLimit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MemoryLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemoryLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemoryLimitsProperty> {
            java.lang.Number hardLimit;
            java.lang.Number softLimit;

            /**
             * Sets the value of {@link MemoryLimitsProperty#getHardLimit}
             * @param hardLimit The hard limit of memory to reserve for the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hardLimit(java.lang.Number hardLimit) {
                this.hardLimit = hardLimit;
                return this;
            }

            /**
             * Sets the value of {@link MemoryLimitsProperty#getSoftLimit}
             * @param softLimit The amount of memory that is reserved for the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder softLimit(java.lang.Number softLimit) {
                this.softLimit = softLimit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemoryLimitsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemoryLimitsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemoryLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemoryLimitsProperty {
            private final java.lang.Number hardLimit;
            private final java.lang.Number softLimit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hardLimit = software.amazon.jsii.Kernel.get(this, "hardLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.softLimit = software.amazon.jsii.Kernel.get(this, "softLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hardLimit = builder.hardLimit;
                this.softLimit = builder.softLimit;
            }

            @Override
            public final java.lang.Number getHardLimit() {
                return this.hardLimit;
            }

            @Override
            public final java.lang.Number getSoftLimit() {
                return this.softLimit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHardLimit() != null) {
                    data.set("hardLimit", om.valueToTree(this.getHardLimit()));
                }
                if (this.getSoftLimit() != null) {
                    data.set("softLimit", om.valueToTree(this.getSoftLimit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.MemoryLimitsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemoryLimitsProperty.Jsii$Proxy that = (MemoryLimitsProperty.Jsii$Proxy) o;

                if (this.hardLimit != null ? !this.hardLimit.equals(that.hardLimit) : that.hardLimit != null) return false;
                return this.softLimit != null ? this.softLimit.equals(that.softLimit) : that.softLimit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hardLimit != null ? this.hardLimit.hashCode() : 0;
                result = 31 * result + (this.softLimit != null ? this.softLimit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the ports on a container.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * PortConfigurationProperty portConfigurationProperty = PortConfigurationProperty.builder()
     *         .containerPortRanges(List.of(ContainerPortRangeProperty.builder()
     *                 .fromPort(123)
     *                 .protocol("protocol")
     *                 .toPort(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-portconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-portconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.PortConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PortConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PortConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies one or more ranges of ports on a container.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-portconfiguration.html#cfn-gamelift-containergroupdefinition-portconfiguration-containerportranges">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-containergroupdefinition-portconfiguration.html#cfn-gamelift-containergroupdefinition-portconfiguration-containerportranges</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getContainerPortRanges();

        /**
         * @return a {@link Builder} of {@link PortConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PortConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PortConfigurationProperty> {
            java.lang.Object containerPortRanges;

            /**
             * Sets the value of {@link PortConfigurationProperty#getContainerPortRanges}
             * @param containerPortRanges Specifies one or more ranges of ports on a container. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPortRanges(software.amazon.awscdk.IResolvable containerPortRanges) {
                this.containerPortRanges = containerPortRanges;
                return this;
            }

            /**
             * Sets the value of {@link PortConfigurationProperty#getContainerPortRanges}
             * @param containerPortRanges Specifies one or more ranges of ports on a container. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPortRanges(java.util.List<? extends java.lang.Object> containerPortRanges) {
                this.containerPortRanges = containerPortRanges;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PortConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PortConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PortConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PortConfigurationProperty {
            private final java.lang.Object containerPortRanges;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerPortRanges = software.amazon.jsii.Kernel.get(this, "containerPortRanges", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerPortRanges = java.util.Objects.requireNonNull(builder.containerPortRanges, "containerPortRanges is required");
            }

            @Override
            public final java.lang.Object getContainerPortRanges() {
                return this.containerPortRanges;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("containerPortRanges", om.valueToTree(this.getContainerPortRanges()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinition.PortConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PortConfigurationProperty.Jsii$Proxy that = (PortConfigurationProperty.Jsii$Proxy) o;

                return this.containerPortRanges.equals(that.containerPortRanges);
            }

            @Override
            public final int hashCode() {
                int result = this.containerPortRanges.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinitionProps.Builder();
        }

        /**
         * The set of container definitions that are included in the container group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinitions</a>
         * @param containerDefinitions The set of container definitions that are included in the container group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerDefinitions(final software.amazon.awscdk.IResolvable containerDefinitions) {
            this.props.containerDefinitions(containerDefinitions);
            return this;
        }
        /**
         * The set of container definitions that are included in the container group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinitions</a>
         * @param containerDefinitions The set of container definitions that are included in the container group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerDefinitions(final java.util.List<? extends java.lang.Object> containerDefinitions) {
            this.props.containerDefinitions(containerDefinitions);
            return this;
        }

        /**
         * A descriptive identifier for the container group definition.
         * <p>
         * The name value is unique in an AWS Region.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-name</a>
         * @param name A descriptive identifier for the container group definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The platform required for all containers in the container group definition.
         * <p>
         * <blockquote>
         * <p>
         * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the <a href="https://docs.aws.amazon.com/https://aws.amazon.com/amazon-linux-2/faqs/">Amazon Linux 2 FAQs</a> . For game servers that are hosted on AL2 and use Amazon GameLift server SDK 4.x., first update the game server build to server SDK 5.x, and then deploy to AL2023 instances. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html">Migrate to Amazon GameLift server SDK version 5.</a>
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-operatingsystem">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-operatingsystem</a>
         * @param operatingSystem The platform required for all containers in the container group definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operatingSystem(final java.lang.String operatingSystem) {
            this.props.operatingSystem(operatingSystem);
            return this;
        }

        /**
         * The amount of CPU units on a fleet instance to allocate for the container group.
         * <p>
         * All containers in the group share these resources. This property is an integer value in CPU units (1 vCPU is equal to 1024 CPU units).
         * <p>
         * You can set additional limits for each <code>ContainerDefinition</code> in the group. If individual containers have limits, this value must be equal to or greater than the sum of all container-specific CPU limits in the group.
         * <p>
         * For more details on memory allocation, see the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-design-fleet">Container fleet design guide</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-totalcpulimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-totalcpulimit</a>
         * @param totalCpuLimit The amount of CPU units on a fleet instance to allocate for the container group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder totalCpuLimit(final java.lang.Number totalCpuLimit) {
            this.props.totalCpuLimit(totalCpuLimit);
            return this;
        }

        /**
         * The amount of memory (in MiB) on a fleet instance to allocate for the container group.
         * <p>
         * All containers in the group share these resources.
         * <p>
         * You can set additional limits for each <code>ContainerDefinition</code> in the group. If individual containers have limits, this value must meet the following requirements:
         * <p>
         * <ul>
         * <li>Equal to or greater than the sum of all container-specific soft memory limits in the group.</li>
         * <li>Equal to or greater than any container-specific hard limits in the group.</li>
         * </ul>
         * <p>
         * For more details on memory allocation, see the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-design-fleet">Container fleet design guide</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-totalmemorylimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-totalmemorylimit</a>
         * @param totalMemoryLimit The amount of memory (in MiB) on a fleet instance to allocate for the container group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder totalMemoryLimit(final java.lang.Number totalMemoryLimit) {
            this.props.totalMemoryLimit(totalMemoryLimit);
            return this;
        }

        /**
         * The method for deploying the container group across fleet instances.
         * <p>
         * A replica container group might have multiple copies on each fleet instance. A daemon container group maintains only one copy per fleet instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-schedulingstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-schedulingstrategy</a>
         * @param schedulingStrategy The method for deploying the container group across fleet instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulingStrategy(final java.lang.String schedulingStrategy) {
            this.props.schedulingStrategy(schedulingStrategy);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition build() {
            return new software.amazon.awscdk.services.gamelift.CfnContainerGroupDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
