package software.amazon.awscdk.services.gamelift;

/**
 * Properties for defining a <code>CfnContainerGroupDefinition</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.gamelift.*;
 * CfnContainerGroupDefinitionProps cfnContainerGroupDefinitionProps = CfnContainerGroupDefinitionProps.builder()
 *         .containerDefinitions(List.of(ContainerDefinitionProperty.builder()
 *                 .containerName("containerName")
 *                 .imageUri("imageUri")
 *                 // the properties below are optional
 *                 .command(List.of("command"))
 *                 .cpu(123)
 *                 .dependsOn(List.of(ContainerDependencyProperty.builder()
 *                         .condition("condition")
 *                         .containerName("containerName")
 *                         .build()))
 *                 .entryPoint(List.of("entryPoint"))
 *                 .environment(List.of(ContainerEnvironmentProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .essential(false)
 *                 .healthCheck(ContainerHealthCheckProperty.builder()
 *                         .command(List.of("command"))
 *                         // the properties below are optional
 *                         .interval(123)
 *                         .retries(123)
 *                         .startPeriod(123)
 *                         .timeout(123)
 *                         .build())
 *                 .memoryLimits(MemoryLimitsProperty.builder()
 *                         .hardLimit(123)
 *                         .softLimit(123)
 *                         .build())
 *                 .portConfiguration(PortConfigurationProperty.builder()
 *                         .containerPortRanges(List.of(ContainerPortRangeProperty.builder()
 *                                 .fromPort(123)
 *                                 .protocol("protocol")
 *                                 .toPort(123)
 *                                 .build()))
 *                         .build())
 *                 .resolvedImageDigest("resolvedImageDigest")
 *                 .workingDirectory("workingDirectory")
 *                 .build()))
 *         .name("name")
 *         .operatingSystem("operatingSystem")
 *         .totalCpuLimit(123)
 *         .totalMemoryLimit(123)
 *         // the properties below are optional
 *         .schedulingStrategy("schedulingStrategy")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:32.661Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(CfnContainerGroupDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnContainerGroupDefinitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The set of container definitions that are included in the container group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-containerdefinitions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getContainerDefinitions();

    /**
     * A descriptive identifier for the container group definition.
     * <p>
     * The name value is unique in an AWS Region.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The platform required for all containers in the container group definition.
     * <p>
     * <blockquote>
     * <p>
     * Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the <a href="https://docs.aws.amazon.com/https://aws.amazon.com/amazon-linux-2/faqs/">Amazon Linux 2 FAQs</a> . For game servers that are hosted on AL2 and use Amazon GameLift server SDK 4.x., first update the game server build to server SDK 5.x, and then deploy to AL2023 instances. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html">Migrate to Amazon GameLift server SDK version 5.</a>
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-operatingsystem">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-operatingsystem</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOperatingSystem();

    /**
     * The amount of CPU units on a fleet instance to allocate for the container group.
     * <p>
     * All containers in the group share these resources. This property is an integer value in CPU units (1 vCPU is equal to 1024 CPU units).
     * <p>
     * You can set additional limits for each <code>ContainerDefinition</code> in the group. If individual containers have limits, this value must be equal to or greater than the sum of all container-specific CPU limits in the group.
     * <p>
     * For more details on memory allocation, see the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-design-fleet">Container fleet design guide</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-totalcpulimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-totalcpulimit</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getTotalCpuLimit();

    /**
     * The amount of memory (in MiB) on a fleet instance to allocate for the container group.
     * <p>
     * All containers in the group share these resources.
     * <p>
     * You can set additional limits for each <code>ContainerDefinition</code> in the group. If individual containers have limits, this value must meet the following requirements:
     * <p>
     * <ul>
     * <li>Equal to or greater than the sum of all container-specific soft memory limits in the group.</li>
     * <li>Equal to or greater than any container-specific hard limits in the group.</li>
     * </ul>
     * <p>
     * For more details on memory allocation, see the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-design-fleet">Container fleet design guide</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-totalmemorylimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-totalmemorylimit</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getTotalMemoryLimit();

    /**
     * The method for deploying the container group across fleet instances.
     * <p>
     * A replica container group might have multiple copies on each fleet instance. A daemon container group maintains only one copy per fleet instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-schedulingstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-schedulingstrategy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSchedulingStrategy() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containergroupdefinition.html#cfn-gamelift-containergroupdefinition-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnContainerGroupDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnContainerGroupDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnContainerGroupDefinitionProps> {
        java.lang.Object containerDefinitions;
        java.lang.String name;
        java.lang.String operatingSystem;
        java.lang.Number totalCpuLimit;
        java.lang.Number totalMemoryLimit;
        java.lang.String schedulingStrategy;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnContainerGroupDefinitionProps#getContainerDefinitions}
         * @param containerDefinitions The set of container definitions that are included in the container group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerDefinitions(software.amazon.awscdk.IResolvable containerDefinitions) {
            this.containerDefinitions = containerDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerGroupDefinitionProps#getContainerDefinitions}
         * @param containerDefinitions The set of container definitions that are included in the container group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerDefinitions(java.util.List<? extends java.lang.Object> containerDefinitions) {
            this.containerDefinitions = containerDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerGroupDefinitionProps#getName}
         * @param name A descriptive identifier for the container group definition. This parameter is required.
         *             The name value is unique in an AWS Region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerGroupDefinitionProps#getOperatingSystem}
         * @param operatingSystem The platform required for all containers in the container group definition. This parameter is required.
         *                        <blockquote>
         *                        <p>
         *                        Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details in the <a href="https://docs.aws.amazon.com/https://aws.amazon.com/amazon-linux-2/faqs/">Amazon Linux 2 FAQs</a> . For game servers that are hosted on AL2 and use Amazon GameLift server SDK 4.x., first update the game server build to server SDK 5.x, and then deploy to AL2023 instances. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html">Migrate to Amazon GameLift server SDK version 5.</a>
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operatingSystem(java.lang.String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerGroupDefinitionProps#getTotalCpuLimit}
         * @param totalCpuLimit The amount of CPU units on a fleet instance to allocate for the container group. This parameter is required.
         *                      All containers in the group share these resources. This property is an integer value in CPU units (1 vCPU is equal to 1024 CPU units).
         *                      <p>
         *                      You can set additional limits for each <code>ContainerDefinition</code> in the group. If individual containers have limits, this value must be equal to or greater than the sum of all container-specific CPU limits in the group.
         *                      <p>
         *                      For more details on memory allocation, see the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-design-fleet">Container fleet design guide</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder totalCpuLimit(java.lang.Number totalCpuLimit) {
            this.totalCpuLimit = totalCpuLimit;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerGroupDefinitionProps#getTotalMemoryLimit}
         * @param totalMemoryLimit The amount of memory (in MiB) on a fleet instance to allocate for the container group. This parameter is required.
         *                         All containers in the group share these resources.
         *                         <p>
         *                         You can set additional limits for each <code>ContainerDefinition</code> in the group. If individual containers have limits, this value must meet the following requirements:
         *                         <p>
         *                         <ul>
         *                         <li>Equal to or greater than the sum of all container-specific soft memory limits in the group.</li>
         *                         <li>Equal to or greater than any container-specific hard limits in the group.</li>
         *                         </ul>
         *                         <p>
         *                         For more details on memory allocation, see the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-design-fleet">Container fleet design guide</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder totalMemoryLimit(java.lang.Number totalMemoryLimit) {
            this.totalMemoryLimit = totalMemoryLimit;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerGroupDefinitionProps#getSchedulingStrategy}
         * @param schedulingStrategy The method for deploying the container group across fleet instances.
         *                           A replica container group might have multiple copies on each fleet instance. A daemon container group maintains only one copy per fleet instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulingStrategy(java.lang.String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerGroupDefinitionProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnContainerGroupDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnContainerGroupDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnContainerGroupDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnContainerGroupDefinitionProps {
        private final java.lang.Object containerDefinitions;
        private final java.lang.String name;
        private final java.lang.String operatingSystem;
        private final java.lang.Number totalCpuLimit;
        private final java.lang.Number totalMemoryLimit;
        private final java.lang.String schedulingStrategy;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.containerDefinitions = software.amazon.jsii.Kernel.get(this, "containerDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.operatingSystem = software.amazon.jsii.Kernel.get(this, "operatingSystem", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.totalCpuLimit = software.amazon.jsii.Kernel.get(this, "totalCpuLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.totalMemoryLimit = software.amazon.jsii.Kernel.get(this, "totalMemoryLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.schedulingStrategy = software.amazon.jsii.Kernel.get(this, "schedulingStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.containerDefinitions = java.util.Objects.requireNonNull(builder.containerDefinitions, "containerDefinitions is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.operatingSystem = java.util.Objects.requireNonNull(builder.operatingSystem, "operatingSystem is required");
            this.totalCpuLimit = java.util.Objects.requireNonNull(builder.totalCpuLimit, "totalCpuLimit is required");
            this.totalMemoryLimit = java.util.Objects.requireNonNull(builder.totalMemoryLimit, "totalMemoryLimit is required");
            this.schedulingStrategy = builder.schedulingStrategy;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getContainerDefinitions() {
            return this.containerDefinitions;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getOperatingSystem() {
            return this.operatingSystem;
        }

        @Override
        public final java.lang.Number getTotalCpuLimit() {
            return this.totalCpuLimit;
        }

        @Override
        public final java.lang.Number getTotalMemoryLimit() {
            return this.totalMemoryLimit;
        }

        @Override
        public final java.lang.String getSchedulingStrategy() {
            return this.schedulingStrategy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("containerDefinitions", om.valueToTree(this.getContainerDefinitions()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("operatingSystem", om.valueToTree(this.getOperatingSystem()));
            data.set("totalCpuLimit", om.valueToTree(this.getTotalCpuLimit()));
            data.set("totalMemoryLimit", om.valueToTree(this.getTotalMemoryLimit()));
            if (this.getSchedulingStrategy() != null) {
                data.set("schedulingStrategy", om.valueToTree(this.getSchedulingStrategy()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerGroupDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnContainerGroupDefinitionProps.Jsii$Proxy that = (CfnContainerGroupDefinitionProps.Jsii$Proxy) o;

            if (!containerDefinitions.equals(that.containerDefinitions)) return false;
            if (!name.equals(that.name)) return false;
            if (!operatingSystem.equals(that.operatingSystem)) return false;
            if (!totalCpuLimit.equals(that.totalCpuLimit)) return false;
            if (!totalMemoryLimit.equals(that.totalMemoryLimit)) return false;
            if (this.schedulingStrategy != null ? !this.schedulingStrategy.equals(that.schedulingStrategy) : that.schedulingStrategy != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.containerDefinitions.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.operatingSystem.hashCode());
            result = 31 * result + (this.totalCpuLimit.hashCode());
            result = 31 * result + (this.totalMemoryLimit.hashCode());
            result = 31 * result + (this.schedulingStrategy != null ? this.schedulingStrategy.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
