package software.amazon.awscdk.services.groundstation;

/**
 * Properties for defining a <code>CfnConfig</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.groundstation.*;
 * CfnConfigProps cfnConfigProps = CfnConfigProps.builder()
 *         .configData(ConfigDataProperty.builder()
 *                 .antennaDownlinkConfig(AntennaDownlinkConfigProperty.builder()
 *                         .spectrumConfig(SpectrumConfigProperty.builder()
 *                                 .bandwidth(FrequencyBandwidthProperty.builder()
 *                                         .units("units")
 *                                         .value(123)
 *                                         .build())
 *                                 .centerFrequency(FrequencyProperty.builder()
 *                                         .units("units")
 *                                         .value(123)
 *                                         .build())
 *                                 .polarization("polarization")
 *                                 .build())
 *                         .build())
 *                 .antennaDownlinkDemodDecodeConfig(AntennaDownlinkDemodDecodeConfigProperty.builder()
 *                         .decodeConfig(DecodeConfigProperty.builder()
 *                                 .unvalidatedJson("unvalidatedJson")
 *                                 .build())
 *                         .demodulationConfig(DemodulationConfigProperty.builder()
 *                                 .unvalidatedJson("unvalidatedJson")
 *                                 .build())
 *                         .spectrumConfig(SpectrumConfigProperty.builder()
 *                                 .bandwidth(FrequencyBandwidthProperty.builder()
 *                                         .units("units")
 *                                         .value(123)
 *                                         .build())
 *                                 .centerFrequency(FrequencyProperty.builder()
 *                                         .units("units")
 *                                         .value(123)
 *                                         .build())
 *                                 .polarization("polarization")
 *                                 .build())
 *                         .build())
 *                 .antennaUplinkConfig(AntennaUplinkConfigProperty.builder()
 *                         .spectrumConfig(UplinkSpectrumConfigProperty.builder()
 *                                 .centerFrequency(FrequencyProperty.builder()
 *                                         .units("units")
 *                                         .value(123)
 *                                         .build())
 *                                 .polarization("polarization")
 *                                 .build())
 *                         .targetEirp(EirpProperty.builder()
 *                                 .units("units")
 *                                 .value(123)
 *                                 .build())
 *                         .transmitDisabled(false)
 *                         .build())
 *                 .dataflowEndpointConfig(DataflowEndpointConfigProperty.builder()
 *                         .dataflowEndpointName("dataflowEndpointName")
 *                         .dataflowEndpointRegion("dataflowEndpointRegion")
 *                         .build())
 *                 .s3RecordingConfig(S3RecordingConfigProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         .prefix("prefix")
 *                         .roleArn("roleArn")
 *                         .build())
 *                 .trackingConfig(TrackingConfigProperty.builder()
 *                         .autotrack("autotrack")
 *                         .build())
 *                 .uplinkEchoConfig(UplinkEchoConfigProperty.builder()
 *                         .antennaUplinkConfigArn("antennaUplinkConfigArn")
 *                         .enabled(false)
 *                         .build())
 *                 .build())
 *         .name("name")
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:33.001Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_groundstation.CfnConfigProps")
@software.amazon.jsii.Jsii.Proxy(CfnConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Object containing the parameters of a config.
     * <p>
     * Only one subtype may be specified per config. See the subtype definitions for a description of each config subtype.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html#cfn-groundstation-config-configdata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html#cfn-groundstation-config-configdata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConfigData();

    /**
     * The name of the config object.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html#cfn-groundstation-config-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html#cfn-groundstation-config-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Tags assigned to a resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html#cfn-groundstation-config-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html#cfn-groundstation-config-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConfigProps> {
        java.lang.Object configData;
        java.lang.String name;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnConfigProps#getConfigData}
         * @param configData Object containing the parameters of a config. This parameter is required.
         *                   Only one subtype may be specified per config. See the subtype definitions for a description of each config subtype.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configData(software.amazon.awscdk.IResolvable configData) {
            this.configData = configData;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigProps#getConfigData}
         * @param configData Object containing the parameters of a config. This parameter is required.
         *                   Only one subtype may be specified per config. See the subtype definitions for a description of each config subtype.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configData(software.amazon.awscdk.services.groundstation.CfnConfig.ConfigDataProperty configData) {
            this.configData = configData;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigProps#getName}
         * @param name The name of the config object. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigProps#getTags}
         * @param tags Tags assigned to a resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConfigProps {
        private final java.lang.Object configData;
        private final java.lang.String name;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configData = software.amazon.jsii.Kernel.get(this, "configData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configData = java.util.Objects.requireNonNull(builder.configData, "configData is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getConfigData() {
            return this.configData;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("configData", om.valueToTree(this.getConfigData()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_groundstation.CfnConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConfigProps.Jsii$Proxy that = (CfnConfigProps.Jsii$Proxy) o;

            if (!configData.equals(that.configData)) return false;
            if (!name.equals(that.name)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configData.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
