package software.amazon.awscdk.services.guardduty;

/**
 * Properties for defining a <code>CfnMalwareProtectionPlan</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.guardduty.*;
 * CfnMalwareProtectionPlanProps cfnMalwareProtectionPlanProps = CfnMalwareProtectionPlanProps.builder()
 *         .protectedResource(CFNProtectedResourceProperty.builder()
 *                 .s3Bucket(S3BucketProperty.builder()
 *                         .bucketName("bucketName")
 *                         .objectPrefixes(List.of("objectPrefixes"))
 *                         .build())
 *                 .build())
 *         .role("role")
 *         // the properties below are optional
 *         .actions(CFNActionsProperty.builder()
 *                 .tagging(CFNTaggingProperty.builder()
 *                         .status("status")
 *                         .build())
 *                 .build())
 *         .tags(List.of(TagItemProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-malwareprotectionplan.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-malwareprotectionplan.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:33.038Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_guardduty.CfnMalwareProtectionPlanProps")
@software.amazon.jsii.Jsii.Proxy(CfnMalwareProtectionPlanProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMalwareProtectionPlanProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Information about the protected resource.
     * <p>
     * Presently, <code>S3Bucket</code> is the only supported protected resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-malwareprotectionplan.html#cfn-guardduty-malwareprotectionplan-protectedresource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-malwareprotectionplan.html#cfn-guardduty-malwareprotectionplan-protectedresource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getProtectedResource();

    /**
     * Amazon Resource Name (ARN) of the IAM role that includes the permissions required to scan and (optionally) add tags to the associated protected resource.
     * <p>
     * To find the ARN of your IAM role, go to the IAM console, and select the role name for details.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-malwareprotectionplan.html#cfn-guardduty-malwareprotectionplan-role">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-malwareprotectionplan.html#cfn-guardduty-malwareprotectionplan-role</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRole();

    /**
     * Specifies the action that is to be applied to the Malware Protection plan resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-malwareprotectionplan.html#cfn-guardduty-malwareprotectionplan-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-malwareprotectionplan.html#cfn-guardduty-malwareprotectionplan-actions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getActions() {
        return null;
    }

    /**
     * The tags to be added to the created Malware Protection plan resource.
     * <p>
     * Each tag consists of a key and an optional value, both of which you need to specify.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-malwareprotectionplan.html#cfn-guardduty-malwareprotectionplan-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-malwareprotectionplan.html#cfn-guardduty-malwareprotectionplan-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.guardduty.CfnMalwareProtectionPlan.TagItemProperty> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMalwareProtectionPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMalwareProtectionPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMalwareProtectionPlanProps> {
        java.lang.Object protectedResource;
        java.lang.String role;
        java.lang.Object actions;
        java.util.List<software.amazon.awscdk.services.guardduty.CfnMalwareProtectionPlan.TagItemProperty> tags;

        /**
         * Sets the value of {@link CfnMalwareProtectionPlanProps#getProtectedResource}
         * @param protectedResource Information about the protected resource. This parameter is required.
         *                          Presently, <code>S3Bucket</code> is the only supported protected resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protectedResource(software.amazon.awscdk.IResolvable protectedResource) {
            this.protectedResource = protectedResource;
            return this;
        }

        /**
         * Sets the value of {@link CfnMalwareProtectionPlanProps#getProtectedResource}
         * @param protectedResource Information about the protected resource. This parameter is required.
         *                          Presently, <code>S3Bucket</code> is the only supported protected resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protectedResource(software.amazon.awscdk.services.guardduty.CfnMalwareProtectionPlan.CFNProtectedResourceProperty protectedResource) {
            this.protectedResource = protectedResource;
            return this;
        }

        /**
         * Sets the value of {@link CfnMalwareProtectionPlanProps#getRole}
         * @param role Amazon Resource Name (ARN) of the IAM role that includes the permissions required to scan and (optionally) add tags to the associated protected resource. This parameter is required.
         *             To find the ARN of your IAM role, go to the IAM console, and select the role name for details.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(java.lang.String role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CfnMalwareProtectionPlanProps#getActions}
         * @param actions Specifies the action that is to be applied to the Malware Protection plan resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(software.amazon.awscdk.IResolvable actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnMalwareProtectionPlanProps#getActions}
         * @param actions Specifies the action that is to be applied to the Malware Protection plan resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(software.amazon.awscdk.services.guardduty.CfnMalwareProtectionPlan.CFNActionsProperty actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnMalwareProtectionPlanProps#getTags}
         * @param tags The tags to be added to the created Malware Protection plan resource.
         *             Each tag consists of a key and an optional value, both of which you need to specify.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.services.guardduty.CfnMalwareProtectionPlan.TagItemProperty> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.services.guardduty.CfnMalwareProtectionPlan.TagItemProperty>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMalwareProtectionPlanProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMalwareProtectionPlanProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMalwareProtectionPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMalwareProtectionPlanProps {
        private final java.lang.Object protectedResource;
        private final java.lang.String role;
        private final java.lang.Object actions;
        private final java.util.List<software.amazon.awscdk.services.guardduty.CfnMalwareProtectionPlan.TagItemProperty> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.protectedResource = software.amazon.jsii.Kernel.get(this, "protectedResource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.guardduty.CfnMalwareProtectionPlan.TagItemProperty.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.protectedResource = java.util.Objects.requireNonNull(builder.protectedResource, "protectedResource is required");
            this.role = java.util.Objects.requireNonNull(builder.role, "role is required");
            this.actions = builder.actions;
            this.tags = (java.util.List<software.amazon.awscdk.services.guardduty.CfnMalwareProtectionPlan.TagItemProperty>)builder.tags;
        }

        @Override
        public final java.lang.Object getProtectedResource() {
            return this.protectedResource;
        }

        @Override
        public final java.lang.String getRole() {
            return this.role;
        }

        @Override
        public final java.lang.Object getActions() {
            return this.actions;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.guardduty.CfnMalwareProtectionPlan.TagItemProperty> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("protectedResource", om.valueToTree(this.getProtectedResource()));
            data.set("role", om.valueToTree(this.getRole()));
            if (this.getActions() != null) {
                data.set("actions", om.valueToTree(this.getActions()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_guardduty.CfnMalwareProtectionPlanProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMalwareProtectionPlanProps.Jsii$Proxy that = (CfnMalwareProtectionPlanProps.Jsii$Proxy) o;

            if (!protectedResource.equals(that.protectedResource)) return false;
            if (!role.equals(that.role)) return false;
            if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.protectedResource.hashCode();
            result = 31 * result + (this.role.hashCode());
            result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
