package software.amazon.awscdk.services.iotcoredeviceadvisor;

/**
 * Properties for defining a <code>CfnSuiteDefinition</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotcoredeviceadvisor.*;
 * Object suiteDefinitionConfiguration;
 * CfnSuiteDefinitionProps cfnSuiteDefinitionProps = CfnSuiteDefinitionProps.builder()
 *         .suiteDefinitionConfiguration(suiteDefinitionConfiguration)
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotcoredeviceadvisor-suitedefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotcoredeviceadvisor-suitedefinition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:33.492Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotcoredeviceadvisor.CfnSuiteDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(CfnSuiteDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSuiteDefinitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The configuration of the Suite Definition. Listed below are the required elements of the <code>SuiteDefinitionConfiguration</code> .
     * <p>
     * <ul>
     * <li><em><strong>devicePermissionRoleArn</strong></em> - The device permission arn.</li>
     * </ul>
     * <p>
     * This is a required element.
     * <p>
     * <em>Type:</em> String
     * <p>
     * <ul>
     * <li><em><strong>devices</strong></em> - The list of configured devices under test. For more information on devices under test, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_DeviceUnderTest.html">DeviceUnderTest</a></li>
     * </ul>
     * <p>
     * Not a required element.
     * <p>
     * <em>Type:</em> List of devices under test
     * <p>
     * <ul>
     * <li><em><strong>intendedForQualification</strong></em> - The tests intended for qualification in a suite.</li>
     * </ul>
     * <p>
     * Not a required element.
     * <p>
     * <em>Type:</em> Boolean
     * <p>
     * <ul>
     * <li><em><strong>rootGroup</strong></em> - The test suite root group. For more information on creating and using root groups see the <a href="https://docs.aws.amazon.com/iot/latest/developerguide/device-advisor-workflow.html">Device Advisor workflow</a> .</li>
     * </ul>
     * <p>
     * This is a required element.
     * <p>
     * <em>Type:</em> String
     * <p>
     * <ul>
     * <li><em><strong>suiteDefinitionName</strong></em> - The Suite Definition Configuration name.</li>
     * </ul>
     * <p>
     * This is a required element.
     * <p>
     * <em>Type:</em> String
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotcoredeviceadvisor-suitedefinition.html#cfn-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotcoredeviceadvisor-suitedefinition.html#cfn-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSuiteDefinitionConfiguration();

    /**
     * Metadata that can be used to manage the the Suite Definition.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotcoredeviceadvisor-suitedefinition.html#cfn-iotcoredeviceadvisor-suitedefinition-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotcoredeviceadvisor-suitedefinition.html#cfn-iotcoredeviceadvisor-suitedefinition-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSuiteDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSuiteDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSuiteDefinitionProps> {
        java.lang.Object suiteDefinitionConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnSuiteDefinitionProps#getSuiteDefinitionConfiguration}
         * @param suiteDefinitionConfiguration The configuration of the Suite Definition. Listed below are the required elements of the <code>SuiteDefinitionConfiguration</code> . This parameter is required.
         *                                     <ul>
         *                                     <li><em><strong>devicePermissionRoleArn</strong></em> - The device permission arn.</li>
         *                                     </ul>
         *                                     <p>
         *                                     This is a required element.
         *                                     <p>
         *                                     <em>Type:</em> String
         *                                     <p>
         *                                     <ul>
         *                                     <li><em><strong>devices</strong></em> - The list of configured devices under test. For more information on devices under test, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_DeviceUnderTest.html">DeviceUnderTest</a></li>
         *                                     </ul>
         *                                     <p>
         *                                     Not a required element.
         *                                     <p>
         *                                     <em>Type:</em> List of devices under test
         *                                     <p>
         *                                     <ul>
         *                                     <li><em><strong>intendedForQualification</strong></em> - The tests intended for qualification in a suite.</li>
         *                                     </ul>
         *                                     <p>
         *                                     Not a required element.
         *                                     <p>
         *                                     <em>Type:</em> Boolean
         *                                     <p>
         *                                     <ul>
         *                                     <li><em><strong>rootGroup</strong></em> - The test suite root group. For more information on creating and using root groups see the <a href="https://docs.aws.amazon.com/iot/latest/developerguide/device-advisor-workflow.html">Device Advisor workflow</a> .</li>
         *                                     </ul>
         *                                     <p>
         *                                     This is a required element.
         *                                     <p>
         *                                     <em>Type:</em> String
         *                                     <p>
         *                                     <ul>
         *                                     <li><em><strong>suiteDefinitionName</strong></em> - The Suite Definition Configuration name.</li>
         *                                     </ul>
         *                                     <p>
         *                                     This is a required element.
         *                                     <p>
         *                                     <em>Type:</em> String
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suiteDefinitionConfiguration(java.lang.Object suiteDefinitionConfiguration) {
            this.suiteDefinitionConfiguration = suiteDefinitionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnSuiteDefinitionProps#getTags}
         * @param tags Metadata that can be used to manage the the Suite Definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSuiteDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSuiteDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSuiteDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSuiteDefinitionProps {
        private final java.lang.Object suiteDefinitionConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.suiteDefinitionConfiguration = software.amazon.jsii.Kernel.get(this, "suiteDefinitionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.suiteDefinitionConfiguration = java.util.Objects.requireNonNull(builder.suiteDefinitionConfiguration, "suiteDefinitionConfiguration is required");
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getSuiteDefinitionConfiguration() {
            return this.suiteDefinitionConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("suiteDefinitionConfiguration", om.valueToTree(this.getSuiteDefinitionConfiguration()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotcoredeviceadvisor.CfnSuiteDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSuiteDefinitionProps.Jsii$Proxy that = (CfnSuiteDefinitionProps.Jsii$Proxy) o;

            if (!suiteDefinitionConfiguration.equals(that.suiteDefinitionConfiguration)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.suiteDefinitionConfiguration.hashCode();
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
