package software.amazon.awscdk.services.lambda;

/**
 * This field takes in 2 values either Text or JSON.
 * <p>
 * By setting this value to Text,
 * will result in the current structure of logs format, whereas, by setting this value to JSON,
 * Lambda will print the logs as Structured JSON Logs, with the corresponding timestamp and log level
 * of each event. Selecting ‘JSON’ format will only allow customer’s to have different log level
 * Application log level and the System log level.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.ILogGroup;
 * ILogGroup logGroup;
 * Function.Builder.create(this, "Lambda")
 *         .code(new InlineCode("foo"))
 *         .handler("index.handler")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .loggingFormat(LoggingFormat.JSON)
 *         .systemLogLevelV2(SystemLogLevel.INFO)
 *         .applicationLogLevelV2(ApplicationLogLevel.INFO)
 *         .logGroup(logGroup)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:34.332Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.LoggingFormat")
public enum LoggingFormat {
    /**
     * Lambda Logs text format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TEXT,
    /**
     * Lambda structured logging in Json format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    JSON,
}
