package software.amazon.awscdk.services.logs;

/**
 * The method used to distribute log data to the destination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.destinations.*;
 * import software.amazon.awscdk.services.kinesis.*;
 * Stream stream;
 * LogGroup logGroup;
 * SubscriptionFilter.Builder.create(this, "Subscription")
 *         .logGroup(logGroup)
 *         .destination(new KinesisDestination(stream))
 *         .filterPattern(FilterPattern.allTerms("ERROR", "MainThread"))
 *         .filterName("ErrorInMainThread")
 *         .distribution(Distribution.RANDOM)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:34.671Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.Distribution")
public enum Distribution {
    /**
     * Log events from the same log stream are kept together and sent to the same destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BY_LOG_STREAM,
    /**
     * Log events are distributed across the log destinations randomly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RANDOM,
}
