package software.amazon.awscdk.services.logs;

/**
 * A collection of static methods to generate appropriate ILogPatterns.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.destinations.*;
 * Function fn;
 * LogGroup logGroup;
 * SubscriptionFilter.Builder.create(this, "Subscription")
 *         .logGroup(logGroup)
 *         .destination(new LambdaDestination(fn))
 *         .filterPattern(FilterPattern.allTerms("ERROR", "MainThread"))
 *         .filterName("ErrorInMainThread")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:34.671Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.FilterPattern")
public class FilterPattern extends software.amazon.jsii.JsiiObject {

    protected FilterPattern(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FilterPattern(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FilterPattern() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * A JSON log pattern that matches if all given JSON log patterns match.
     * <p>
     * @param patterns This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.JsonPattern all(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.JsonPattern... patterns) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.FilterPattern.class, "all", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.JsonPattern.class), java.util.Arrays.<Object>stream(patterns).toArray(Object[]::new));
    }

    /**
     * A log pattern that matches all events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.IFilterPattern allEvents() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.FilterPattern.class, "allEvents", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.IFilterPattern.class));
    }

    /**
     * A log pattern that matches if all the strings given appear in the event.
     * <p>
     * @param terms The words to search for. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.IFilterPattern allTerms(final @org.jetbrains.annotations.NotNull java.lang.String... terms) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.FilterPattern.class, "allTerms", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.IFilterPattern.class), java.util.Arrays.<Object>stream(terms).toArray(Object[]::new));
    }

    /**
     * A JSON log pattern that matches if any of the given JSON log patterns match.
     * <p>
     * @param patterns This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.JsonPattern any(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.JsonPattern... patterns) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.FilterPattern.class, "any", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.JsonPattern.class), java.util.Arrays.<Object>stream(patterns).toArray(Object[]::new));
    }

    /**
     * A log pattern that matches if any of the strings given appear in the event.
     * <p>
     * @param terms The words to search for. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.IFilterPattern anyTerm(final @org.jetbrains.annotations.NotNull java.lang.String... terms) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.FilterPattern.class, "anyTerm", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.IFilterPattern.class), java.util.Arrays.<Object>stream(terms).toArray(Object[]::new));
    }

    /**
     * A log pattern that matches if any of the given term groups matches the event.
     * <p>
     * A term group matches an event if all the terms in it appear in the event string.
     * <p>
     * @param termGroups A list of term groups to search for. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.IFilterPattern anyTermGroup(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String>... termGroups) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.FilterPattern.class, "anyTermGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.IFilterPattern.class), java.util.Arrays.<Object>stream(termGroups).toArray(Object[]::new));
    }

    /**
     * A JSON log pattern that matches if the field exists and equals the boolean value.
     * <p>
     * @param jsonField Field inside JSON. This parameter is required.
     * @param value The value to match. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.JsonPattern booleanValue(final @org.jetbrains.annotations.NotNull java.lang.String jsonField, final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.FilterPattern.class, "booleanValue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.JsonPattern.class), new Object[] { java.util.Objects.requireNonNull(jsonField, "jsonField is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * A JSON log patter that matches if the field exists.
     * <p>
     * This is a readable convenience wrapper over 'field = *'
     * <p>
     * @param jsonField Field inside JSON. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.JsonPattern exists(final @org.jetbrains.annotations.NotNull java.lang.String jsonField) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.FilterPattern.class, "exists", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.JsonPattern.class), new Object[] { java.util.Objects.requireNonNull(jsonField, "jsonField is required") });
    }

    /**
     * A JSON log pattern that matches if the field exists and has the special value 'null'.
     * <p>
     * @param jsonField Field inside JSON. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.JsonPattern isNull(final @org.jetbrains.annotations.NotNull java.lang.String jsonField) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.FilterPattern.class, "isNull", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.JsonPattern.class), new Object[] { java.util.Objects.requireNonNull(jsonField, "jsonField is required") });
    }

    /**
     * Use the given string as log pattern.
     * <p>
     * See https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html
     * for information on writing log patterns.
     * <p>
     * @param logPatternString The pattern string to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.IFilterPattern literal(final @org.jetbrains.annotations.NotNull java.lang.String logPatternString) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.FilterPattern.class, "literal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.IFilterPattern.class), new Object[] { java.util.Objects.requireNonNull(logPatternString, "logPatternString is required") });
    }

    /**
     * A JSON log pattern that matches if the field does not exist.
     * <p>
     * @param jsonField Field inside JSON. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.JsonPattern notExists(final @org.jetbrains.annotations.NotNull java.lang.String jsonField) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.FilterPattern.class, "notExists", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.JsonPattern.class), new Object[] { java.util.Objects.requireNonNull(jsonField, "jsonField is required") });
    }

    /**
     * A JSON log pattern that compares numerical values.
     * <p>
     * This pattern only matches if the event is a JSON event, and the indicated field inside
     * compares with the value in the indicated way.
     * <p>
     * Use '$' to indicate the root of the JSON structure. The comparison operator can only
     * compare equality or inequality. The '*' wildcard may appear in the value may at the
     * start or at the end.
     * <p>
     * For more information, see:
     * <p>
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html
     * <p>
     * @param jsonField Field inside JSON. This parameter is required.
     * @param comparison Comparison to carry out. This parameter is required.
     * @param value The numerical value to compare to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.JsonPattern numberValue(final @org.jetbrains.annotations.NotNull java.lang.String jsonField, final @org.jetbrains.annotations.NotNull java.lang.String comparison, final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.FilterPattern.class, "numberValue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.JsonPattern.class), new Object[] { java.util.Objects.requireNonNull(jsonField, "jsonField is required"), java.util.Objects.requireNonNull(comparison, "comparison is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * A space delimited log pattern matcher.
     * <p>
     * The log event is divided into space-delimited columns (optionally
     * enclosed by "" or [] to capture spaces into column values), and names
     * are given to each column.
     * <p>
     * '...' may be specified once to match any number of columns.
     * <p>
     * Afterwards, conditions may be added to individual columns.
     * <p>
     * @param columns The columns in the space-delimited log stream. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.SpaceDelimitedTextPattern spaceDelimited(final @org.jetbrains.annotations.NotNull java.lang.String... columns) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.FilterPattern.class, "spaceDelimited", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.SpaceDelimitedTextPattern.class), java.util.Arrays.<Object>stream(columns).toArray(Object[]::new));
    }

    /**
     * A JSON log pattern that compares string values.
     * <p>
     * This pattern only matches if the event is a JSON event, and the indicated field inside
     * compares with the string value.
     * <p>
     * Use '$' to indicate the root of the JSON structure. The comparison operator can only
     * compare equality or inequality. The '*' wildcard may appear in the value may at the
     * start or at the end.
     * <p>
     * For more information, see:
     * <p>
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html
     * <p>
     * @param jsonField Field inside JSON. This parameter is required.
     * @param comparison Comparison to carry out. This parameter is required.
     * @param value The string value to compare to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.JsonPattern stringValue(final @org.jetbrains.annotations.NotNull java.lang.String jsonField, final @org.jetbrains.annotations.NotNull java.lang.String comparison, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.FilterPattern.class, "stringValue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.JsonPattern.class), new Object[] { java.util.Objects.requireNonNull(jsonField, "jsonField is required"), java.util.Objects.requireNonNull(comparison, "comparison is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }
}
