package software.amazon.awscdk.services.managedblockchain;

/**
 * Creates a member within a Managed Blockchain network.
 * <p>
 * Applies only to Hyperledger Fabric.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.managedblockchain.*;
 * CfnMember cfnMember = CfnMember.Builder.create(this, "MyCfnMember")
 *         .memberConfiguration(MemberConfigurationProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .memberFrameworkConfiguration(MemberFrameworkConfigurationProperty.builder()
 *                         .memberFabricConfiguration(MemberFabricConfigurationProperty.builder()
 *                                 .adminPassword("adminPassword")
 *                                 .adminUsername("adminUsername")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .invitationId("invitationId")
 *         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                 .framework("framework")
 *                 .frameworkVersion("frameworkVersion")
 *                 .name("name")
 *                 .votingPolicy(VotingPolicyProperty.builder()
 *                         .approvalThresholdPolicy(ApprovalThresholdPolicyProperty.builder()
 *                                 .proposalDurationInHours(123)
 *                                 .thresholdComparator("thresholdComparator")
 *                                 .thresholdPercentage(123)
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .description("description")
 *                 .networkFrameworkConfiguration(NetworkFrameworkConfigurationProperty.builder()
 *                         .networkFabricConfiguration(NetworkFabricConfigurationProperty.builder()
 *                                 .edition("edition")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .networkId("networkId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:34.740Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_managedblockchain.CfnMember")
public class CfnMember extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnMember(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMember(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.managedblockchain.CfnMember.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMember(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.managedblockchain.CfnMemberProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The unique identifier of the member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMemberId() {
        return software.amazon.jsii.Kernel.get(this, "attrMemberId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the network to which the member belongs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrNetworkId() {
        return software.amazon.jsii.Kernel.get(this, "attrNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Configuration properties of the member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getMemberConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "memberConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration properties of the member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMemberConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "memberConfiguration", java.util.Objects.requireNonNull(value, "memberConfiguration is required"));
    }

    /**
     * Configuration properties of the member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMemberConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.managedblockchain.CfnMember.MemberConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "memberConfiguration", java.util.Objects.requireNonNull(value, "memberConfiguration is required"));
    }

    /**
     * The unique identifier of the invitation to join the network sent to the account that creates the member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInvitationId() {
        return software.amazon.jsii.Kernel.get(this, "invitationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the invitation to join the network sent to the account that creates the member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInvitationId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "invitationId", value);
    }

    /**
     * Configuration properties of the network to which the member belongs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration properties of the network to which the member belongs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "networkConfiguration", value);
    }

    /**
     * Configuration properties of the network to which the member belongs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.managedblockchain.CfnMember.NetworkConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "networkConfiguration", value);
    }

    /**
     * The unique identifier of the network to which the member belongs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNetworkId() {
        return software.amazon.jsii.Kernel.get(this, "networkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the network to which the member belongs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "networkId", value);
    }
    /**
     * A policy type that defines the voting rules for the network.
     * <p>
     * The rules decide if a proposal is approved. Approval may be based on criteria such as the percentage of <code>YES</code> votes and the duration of the proposal. The policy applies to all proposals and is specified when the network is created.
     * <p>
     * Applies only to Hyperledger Fabric.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.managedblockchain.*;
     * ApprovalThresholdPolicyProperty approvalThresholdPolicyProperty = ApprovalThresholdPolicyProperty.builder()
     *         .proposalDurationInHours(123)
     *         .thresholdComparator("thresholdComparator")
     *         .thresholdPercentage(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_managedblockchain.CfnMember.ApprovalThresholdPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ApprovalThresholdPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApprovalThresholdPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The duration from the time that a proposal is created until it expires.
         * <p>
         * If members cast neither the required number of <code>YES</code> votes to approve the proposal nor the number of <code>NO</code> votes required to reject it before the duration expires, the proposal is <code>EXPIRED</code> and <code>ProposalActions</code> aren't carried out.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html#cfn-managedblockchain-member-approvalthresholdpolicy-proposaldurationinhours">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html#cfn-managedblockchain-member-approvalthresholdpolicy-proposaldurationinhours</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getProposalDurationInHours() {
            return null;
        }

        /**
         * Determines whether the vote percentage must be greater than the <code>ThresholdPercentage</code> or must be greater than or equal to the <code>ThresholdPercentage</code> to be approved.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html#cfn-managedblockchain-member-approvalthresholdpolicy-thresholdcomparator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html#cfn-managedblockchain-member-approvalthresholdpolicy-thresholdcomparator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getThresholdComparator() {
            return null;
        }

        /**
         * The percentage of votes among all members that must be <code>YES</code> for a proposal to be approved.
         * <p>
         * For example, a <code>ThresholdPercentage</code> value of <code>50</code> indicates 50%. The <code>ThresholdComparator</code> determines the precise comparison. If a <code>ThresholdPercentage</code> value of <code>50</code> is specified on a network with 10 members, along with a <code>ThresholdComparator</code> value of <code>GREATER_THAN</code> , this indicates that 6 <code>YES</code> votes are required for the proposal to be approved.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html#cfn-managedblockchain-member-approvalthresholdpolicy-thresholdpercentage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html#cfn-managedblockchain-member-approvalthresholdpolicy-thresholdpercentage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThresholdPercentage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApprovalThresholdPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApprovalThresholdPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApprovalThresholdPolicyProperty> {
            java.lang.Number proposalDurationInHours;
            java.lang.String thresholdComparator;
            java.lang.Number thresholdPercentage;

            /**
             * Sets the value of {@link ApprovalThresholdPolicyProperty#getProposalDurationInHours}
             * @param proposalDurationInHours The duration from the time that a proposal is created until it expires.
             *                                If members cast neither the required number of <code>YES</code> votes to approve the proposal nor the number of <code>NO</code> votes required to reject it before the duration expires, the proposal is <code>EXPIRED</code> and <code>ProposalActions</code> aren't carried out.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder proposalDurationInHours(java.lang.Number proposalDurationInHours) {
                this.proposalDurationInHours = proposalDurationInHours;
                return this;
            }

            /**
             * Sets the value of {@link ApprovalThresholdPolicyProperty#getThresholdComparator}
             * @param thresholdComparator Determines whether the vote percentage must be greater than the <code>ThresholdPercentage</code> or must be greater than or equal to the <code>ThresholdPercentage</code> to be approved.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thresholdComparator(java.lang.String thresholdComparator) {
                this.thresholdComparator = thresholdComparator;
                return this;
            }

            /**
             * Sets the value of {@link ApprovalThresholdPolicyProperty#getThresholdPercentage}
             * @param thresholdPercentage The percentage of votes among all members that must be <code>YES</code> for a proposal to be approved.
             *                            For example, a <code>ThresholdPercentage</code> value of <code>50</code> indicates 50%. The <code>ThresholdComparator</code> determines the precise comparison. If a <code>ThresholdPercentage</code> value of <code>50</code> is specified on a network with 10 members, along with a <code>ThresholdComparator</code> value of <code>GREATER_THAN</code> , this indicates that 6 <code>YES</code> votes are required for the proposal to be approved.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thresholdPercentage(java.lang.Number thresholdPercentage) {
                this.thresholdPercentage = thresholdPercentage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApprovalThresholdPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApprovalThresholdPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApprovalThresholdPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApprovalThresholdPolicyProperty {
            private final java.lang.Number proposalDurationInHours;
            private final java.lang.String thresholdComparator;
            private final java.lang.Number thresholdPercentage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.proposalDurationInHours = software.amazon.jsii.Kernel.get(this, "proposalDurationInHours", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.thresholdComparator = software.amazon.jsii.Kernel.get(this, "thresholdComparator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.thresholdPercentage = software.amazon.jsii.Kernel.get(this, "thresholdPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.proposalDurationInHours = builder.proposalDurationInHours;
                this.thresholdComparator = builder.thresholdComparator;
                this.thresholdPercentage = builder.thresholdPercentage;
            }

            @Override
            public final java.lang.Number getProposalDurationInHours() {
                return this.proposalDurationInHours;
            }

            @Override
            public final java.lang.String getThresholdComparator() {
                return this.thresholdComparator;
            }

            @Override
            public final java.lang.Number getThresholdPercentage() {
                return this.thresholdPercentage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getProposalDurationInHours() != null) {
                    data.set("proposalDurationInHours", om.valueToTree(this.getProposalDurationInHours()));
                }
                if (this.getThresholdComparator() != null) {
                    data.set("thresholdComparator", om.valueToTree(this.getThresholdComparator()));
                }
                if (this.getThresholdPercentage() != null) {
                    data.set("thresholdPercentage", om.valueToTree(this.getThresholdPercentage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_managedblockchain.CfnMember.ApprovalThresholdPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApprovalThresholdPolicyProperty.Jsii$Proxy that = (ApprovalThresholdPolicyProperty.Jsii$Proxy) o;

                if (this.proposalDurationInHours != null ? !this.proposalDurationInHours.equals(that.proposalDurationInHours) : that.proposalDurationInHours != null) return false;
                if (this.thresholdComparator != null ? !this.thresholdComparator.equals(that.thresholdComparator) : that.thresholdComparator != null) return false;
                return this.thresholdPercentage != null ? this.thresholdPercentage.equals(that.thresholdPercentage) : that.thresholdPercentage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.proposalDurationInHours != null ? this.proposalDurationInHours.hashCode() : 0;
                result = 31 * result + (this.thresholdComparator != null ? this.thresholdComparator.hashCode() : 0);
                result = 31 * result + (this.thresholdPercentage != null ? this.thresholdPercentage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration properties of the member.
     * <p>
     * Applies only to Hyperledger Fabric.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.managedblockchain.*;
     * MemberConfigurationProperty memberConfigurationProperty = MemberConfigurationProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .description("description")
     *         .memberFrameworkConfiguration(MemberFrameworkConfigurationProperty.builder()
     *                 .memberFabricConfiguration(MemberFabricConfigurationProperty.builder()
     *                         .adminPassword("adminPassword")
     *                         .adminUsername("adminUsername")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_managedblockchain.CfnMember.MemberConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MemberConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemberConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the member.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html#cfn-managedblockchain-member-memberconfiguration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html#cfn-managedblockchain-member-memberconfiguration-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * An optional description of the member.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html#cfn-managedblockchain-member-memberconfiguration-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html#cfn-managedblockchain-member-memberconfiguration-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Configuration properties of the blockchain framework relevant to the member.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html#cfn-managedblockchain-member-memberconfiguration-memberframeworkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html#cfn-managedblockchain-member-memberconfiguration-memberframeworkconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMemberFrameworkConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MemberConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemberConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemberConfigurationProperty> {
            java.lang.String name;
            java.lang.String description;
            java.lang.Object memberFrameworkConfiguration;

            /**
             * Sets the value of {@link MemberConfigurationProperty#getName}
             * @param name The name of the member. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link MemberConfigurationProperty#getDescription}
             * @param description An optional description of the member.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link MemberConfigurationProperty#getMemberFrameworkConfiguration}
             * @param memberFrameworkConfiguration Configuration properties of the blockchain framework relevant to the member.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memberFrameworkConfiguration(software.amazon.awscdk.IResolvable memberFrameworkConfiguration) {
                this.memberFrameworkConfiguration = memberFrameworkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MemberConfigurationProperty#getMemberFrameworkConfiguration}
             * @param memberFrameworkConfiguration Configuration properties of the blockchain framework relevant to the member.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memberFrameworkConfiguration(software.amazon.awscdk.services.managedblockchain.CfnMember.MemberFrameworkConfigurationProperty memberFrameworkConfiguration) {
                this.memberFrameworkConfiguration = memberFrameworkConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemberConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemberConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemberConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemberConfigurationProperty {
            private final java.lang.String name;
            private final java.lang.String description;
            private final java.lang.Object memberFrameworkConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.memberFrameworkConfiguration = software.amazon.jsii.Kernel.get(this, "memberFrameworkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.description = builder.description;
                this.memberFrameworkConfiguration = builder.memberFrameworkConfiguration;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getMemberFrameworkConfiguration() {
                return this.memberFrameworkConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getMemberFrameworkConfiguration() != null) {
                    data.set("memberFrameworkConfiguration", om.valueToTree(this.getMemberFrameworkConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_managedblockchain.CfnMember.MemberConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemberConfigurationProperty.Jsii$Proxy that = (MemberConfigurationProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                return this.memberFrameworkConfiguration != null ? this.memberFrameworkConfiguration.equals(that.memberFrameworkConfiguration) : that.memberFrameworkConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.memberFrameworkConfiguration != null ? this.memberFrameworkConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration properties for Hyperledger Fabric for a member in a Managed Blockchain network that is using the Hyperledger Fabric framework.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.managedblockchain.*;
     * MemberFabricConfigurationProperty memberFabricConfigurationProperty = MemberFabricConfigurationProperty.builder()
     *         .adminPassword("adminPassword")
     *         .adminUsername("adminUsername")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberfabricconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberfabricconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_managedblockchain.CfnMember.MemberFabricConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MemberFabricConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemberFabricConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The password for the member's initial administrative user.
         * <p>
         * The <code>AdminPassword</code> must be at least 8 characters long and no more than 32 characters. It must contain at least one uppercase letter, one lowercase letter, and one digit. It cannot have a single quotation mark (‘), a double quotation marks (“), a forward slash(/), a backward slash(),
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberfabricconfiguration.html#cfn-managedblockchain-member-memberfabricconfiguration-adminpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberfabricconfiguration.html#cfn-managedblockchain-member-memberfabricconfiguration-adminpassword</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAdminPassword();

        /**
         * The user name for the member's initial administrative user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberfabricconfiguration.html#cfn-managedblockchain-member-memberfabricconfiguration-adminusername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberfabricconfiguration.html#cfn-managedblockchain-member-memberfabricconfiguration-adminusername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAdminUsername();

        /**
         * @return a {@link Builder} of {@link MemberFabricConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemberFabricConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemberFabricConfigurationProperty> {
            java.lang.String adminPassword;
            java.lang.String adminUsername;

            /**
             * Sets the value of {@link MemberFabricConfigurationProperty#getAdminPassword}
             * @param adminPassword The password for the member's initial administrative user. This parameter is required.
             *                      The <code>AdminPassword</code> must be at least 8 characters long and no more than 32 characters. It must contain at least one uppercase letter, one lowercase letter, and one digit. It cannot have a single quotation mark (‘), a double quotation marks (“), a forward slash(/), a backward slash(),
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adminPassword(java.lang.String adminPassword) {
                this.adminPassword = adminPassword;
                return this;
            }

            /**
             * Sets the value of {@link MemberFabricConfigurationProperty#getAdminUsername}
             * @param adminUsername The user name for the member's initial administrative user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adminUsername(java.lang.String adminUsername) {
                this.adminUsername = adminUsername;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemberFabricConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemberFabricConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemberFabricConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemberFabricConfigurationProperty {
            private final java.lang.String adminPassword;
            private final java.lang.String adminUsername;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.adminPassword = software.amazon.jsii.Kernel.get(this, "adminPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.adminUsername = software.amazon.jsii.Kernel.get(this, "adminUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.adminPassword = java.util.Objects.requireNonNull(builder.adminPassword, "adminPassword is required");
                this.adminUsername = java.util.Objects.requireNonNull(builder.adminUsername, "adminUsername is required");
            }

            @Override
            public final java.lang.String getAdminPassword() {
                return this.adminPassword;
            }

            @Override
            public final java.lang.String getAdminUsername() {
                return this.adminUsername;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("adminPassword", om.valueToTree(this.getAdminPassword()));
                data.set("adminUsername", om.valueToTree(this.getAdminUsername()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_managedblockchain.CfnMember.MemberFabricConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemberFabricConfigurationProperty.Jsii$Proxy that = (MemberFabricConfigurationProperty.Jsii$Proxy) o;

                if (!adminPassword.equals(that.adminPassword)) return false;
                return this.adminUsername.equals(that.adminUsername);
            }

            @Override
            public final int hashCode() {
                int result = this.adminPassword.hashCode();
                result = 31 * result + (this.adminUsername.hashCode());
                return result;
            }
        }
    }
    /**
     * Configuration properties relevant to a member for the blockchain framework that the Managed Blockchain network uses.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.managedblockchain.*;
     * MemberFrameworkConfigurationProperty memberFrameworkConfigurationProperty = MemberFrameworkConfigurationProperty.builder()
     *         .memberFabricConfiguration(MemberFabricConfigurationProperty.builder()
     *                 .adminPassword("adminPassword")
     *                 .adminUsername("adminUsername")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberframeworkconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberframeworkconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_managedblockchain.CfnMember.MemberFrameworkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MemberFrameworkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemberFrameworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration properties for Hyperledger Fabric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberframeworkconfiguration.html#cfn-managedblockchain-member-memberframeworkconfiguration-memberfabricconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberframeworkconfiguration.html#cfn-managedblockchain-member-memberframeworkconfiguration-memberfabricconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMemberFabricConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MemberFrameworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemberFrameworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemberFrameworkConfigurationProperty> {
            java.lang.Object memberFabricConfiguration;

            /**
             * Sets the value of {@link MemberFrameworkConfigurationProperty#getMemberFabricConfiguration}
             * @param memberFabricConfiguration Configuration properties for Hyperledger Fabric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memberFabricConfiguration(software.amazon.awscdk.IResolvable memberFabricConfiguration) {
                this.memberFabricConfiguration = memberFabricConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MemberFrameworkConfigurationProperty#getMemberFabricConfiguration}
             * @param memberFabricConfiguration Configuration properties for Hyperledger Fabric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memberFabricConfiguration(software.amazon.awscdk.services.managedblockchain.CfnMember.MemberFabricConfigurationProperty memberFabricConfiguration) {
                this.memberFabricConfiguration = memberFabricConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemberFrameworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemberFrameworkConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemberFrameworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemberFrameworkConfigurationProperty {
            private final java.lang.Object memberFabricConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.memberFabricConfiguration = software.amazon.jsii.Kernel.get(this, "memberFabricConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.memberFabricConfiguration = builder.memberFabricConfiguration;
            }

            @Override
            public final java.lang.Object getMemberFabricConfiguration() {
                return this.memberFabricConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMemberFabricConfiguration() != null) {
                    data.set("memberFabricConfiguration", om.valueToTree(this.getMemberFabricConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_managedblockchain.CfnMember.MemberFrameworkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemberFrameworkConfigurationProperty.Jsii$Proxy that = (MemberFrameworkConfigurationProperty.Jsii$Proxy) o;

                return this.memberFabricConfiguration != null ? this.memberFabricConfiguration.equals(that.memberFabricConfiguration) : that.memberFabricConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.memberFabricConfiguration != null ? this.memberFabricConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Configuration properties of the network to which the member belongs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.managedblockchain.*;
     * NetworkConfigurationProperty networkConfigurationProperty = NetworkConfigurationProperty.builder()
     *         .framework("framework")
     *         .frameworkVersion("frameworkVersion")
     *         .name("name")
     *         .votingPolicy(VotingPolicyProperty.builder()
     *                 .approvalThresholdPolicy(ApprovalThresholdPolicyProperty.builder()
     *                         .proposalDurationInHours(123)
     *                         .thresholdComparator("thresholdComparator")
     *                         .thresholdPercentage(123)
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .description("description")
     *         .networkFrameworkConfiguration(NetworkFrameworkConfigurationProperty.builder()
     *                 .networkFabricConfiguration(NetworkFabricConfigurationProperty.builder()
     *                         .edition("edition")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_managedblockchain.CfnMember.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The blockchain framework that the network uses.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-framework">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-framework</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFramework();

        /**
         * The version of the blockchain framework that the network uses.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-frameworkversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-frameworkversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFrameworkVersion();

        /**
         * The name of the network.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The voting rules that the network uses to decide if a proposal is accepted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-votingpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-votingpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVotingPolicy();

        /**
         * Attributes of the blockchain framework for the network.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Configuration properties relevant to the network for the blockchain framework that the network uses.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-networkframeworkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-networkframeworkconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkFrameworkConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            java.lang.String framework;
            java.lang.String frameworkVersion;
            java.lang.String name;
            java.lang.Object votingPolicy;
            java.lang.String description;
            java.lang.Object networkFrameworkConfiguration;

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getFramework}
             * @param framework The blockchain framework that the network uses. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder framework(java.lang.String framework) {
                this.framework = framework;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getFrameworkVersion}
             * @param frameworkVersion The version of the blockchain framework that the network uses. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frameworkVersion(java.lang.String frameworkVersion) {
                this.frameworkVersion = frameworkVersion;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getName}
             * @param name The name of the network. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getVotingPolicy}
             * @param votingPolicy The voting rules that the network uses to decide if a proposal is accepted. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder votingPolicy(software.amazon.awscdk.IResolvable votingPolicy) {
                this.votingPolicy = votingPolicy;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getVotingPolicy}
             * @param votingPolicy The voting rules that the network uses to decide if a proposal is accepted. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder votingPolicy(software.amazon.awscdk.services.managedblockchain.CfnMember.VotingPolicyProperty votingPolicy) {
                this.votingPolicy = votingPolicy;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getDescription}
             * @param description Attributes of the blockchain framework for the network.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getNetworkFrameworkConfiguration}
             * @param networkFrameworkConfiguration Configuration properties relevant to the network for the blockchain framework that the network uses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkFrameworkConfiguration(software.amazon.awscdk.IResolvable networkFrameworkConfiguration) {
                this.networkFrameworkConfiguration = networkFrameworkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getNetworkFrameworkConfiguration}
             * @param networkFrameworkConfiguration Configuration properties relevant to the network for the blockchain framework that the network uses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkFrameworkConfiguration(software.amazon.awscdk.services.managedblockchain.CfnMember.NetworkFrameworkConfigurationProperty networkFrameworkConfiguration) {
                this.networkFrameworkConfiguration = networkFrameworkConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkConfigurationProperty {
            private final java.lang.String framework;
            private final java.lang.String frameworkVersion;
            private final java.lang.String name;
            private final java.lang.Object votingPolicy;
            private final java.lang.String description;
            private final java.lang.Object networkFrameworkConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.framework = software.amazon.jsii.Kernel.get(this, "framework", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.frameworkVersion = software.amazon.jsii.Kernel.get(this, "frameworkVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.votingPolicy = software.amazon.jsii.Kernel.get(this, "votingPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.networkFrameworkConfiguration = software.amazon.jsii.Kernel.get(this, "networkFrameworkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.framework = java.util.Objects.requireNonNull(builder.framework, "framework is required");
                this.frameworkVersion = java.util.Objects.requireNonNull(builder.frameworkVersion, "frameworkVersion is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.votingPolicy = java.util.Objects.requireNonNull(builder.votingPolicy, "votingPolicy is required");
                this.description = builder.description;
                this.networkFrameworkConfiguration = builder.networkFrameworkConfiguration;
            }

            @Override
            public final java.lang.String getFramework() {
                return this.framework;
            }

            @Override
            public final java.lang.String getFrameworkVersion() {
                return this.frameworkVersion;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getVotingPolicy() {
                return this.votingPolicy;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getNetworkFrameworkConfiguration() {
                return this.networkFrameworkConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("framework", om.valueToTree(this.getFramework()));
                data.set("frameworkVersion", om.valueToTree(this.getFrameworkVersion()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("votingPolicy", om.valueToTree(this.getVotingPolicy()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getNetworkFrameworkConfiguration() != null) {
                    data.set("networkFrameworkConfiguration", om.valueToTree(this.getNetworkFrameworkConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_managedblockchain.CfnMember.NetworkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkConfigurationProperty.Jsii$Proxy that = (NetworkConfigurationProperty.Jsii$Proxy) o;

                if (!framework.equals(that.framework)) return false;
                if (!frameworkVersion.equals(that.frameworkVersion)) return false;
                if (!name.equals(that.name)) return false;
                if (!votingPolicy.equals(that.votingPolicy)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                return this.networkFrameworkConfiguration != null ? this.networkFrameworkConfiguration.equals(that.networkFrameworkConfiguration) : that.networkFrameworkConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.framework.hashCode();
                result = 31 * result + (this.frameworkVersion.hashCode());
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.votingPolicy.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.networkFrameworkConfiguration != null ? this.networkFrameworkConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Hyperledger Fabric configuration properties for the network.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.managedblockchain.*;
     * NetworkFabricConfigurationProperty networkFabricConfigurationProperty = NetworkFabricConfigurationProperty.builder()
     *         .edition("edition")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkfabricconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkfabricconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_managedblockchain.CfnMember.NetworkFabricConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkFabricConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkFabricConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The edition of Amazon Managed Blockchain that the network uses.
         * <p>
         * Valid values are <code>standard</code> and <code>starter</code> . For more information, see <a href="https://docs.aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkfabricconfiguration.html#cfn-managedblockchain-member-networkfabricconfiguration-edition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkfabricconfiguration.html#cfn-managedblockchain-member-networkfabricconfiguration-edition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEdition();

        /**
         * @return a {@link Builder} of {@link NetworkFabricConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkFabricConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkFabricConfigurationProperty> {
            java.lang.String edition;

            /**
             * Sets the value of {@link NetworkFabricConfigurationProperty#getEdition}
             * @param edition The edition of Amazon Managed Blockchain that the network uses. This parameter is required.
             *                Valid values are <code>standard</code> and <code>starter</code> . For more information, see <a href="https://docs.aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder edition(java.lang.String edition) {
                this.edition = edition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkFabricConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkFabricConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkFabricConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkFabricConfigurationProperty {
            private final java.lang.String edition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.edition = software.amazon.jsii.Kernel.get(this, "edition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.edition = java.util.Objects.requireNonNull(builder.edition, "edition is required");
            }

            @Override
            public final java.lang.String getEdition() {
                return this.edition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("edition", om.valueToTree(this.getEdition()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_managedblockchain.CfnMember.NetworkFabricConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkFabricConfigurationProperty.Jsii$Proxy that = (NetworkFabricConfigurationProperty.Jsii$Proxy) o;

                return this.edition.equals(that.edition);
            }

            @Override
            public final int hashCode() {
                int result = this.edition.hashCode();
                return result;
            }
        }
    }
    /**
     * Configuration properties relevant to the network for the blockchain framework that the network uses.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.managedblockchain.*;
     * NetworkFrameworkConfigurationProperty networkFrameworkConfigurationProperty = NetworkFrameworkConfigurationProperty.builder()
     *         .networkFabricConfiguration(NetworkFabricConfigurationProperty.builder()
     *                 .edition("edition")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkframeworkconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkframeworkconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_managedblockchain.CfnMember.NetworkFrameworkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkFrameworkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkFrameworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration properties for Hyperledger Fabric for a member in a Managed Blockchain network that is using the Hyperledger Fabric framework.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkframeworkconfiguration.html#cfn-managedblockchain-member-networkframeworkconfiguration-networkfabricconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkframeworkconfiguration.html#cfn-managedblockchain-member-networkframeworkconfiguration-networkfabricconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkFabricConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkFrameworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkFrameworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkFrameworkConfigurationProperty> {
            java.lang.Object networkFabricConfiguration;

            /**
             * Sets the value of {@link NetworkFrameworkConfigurationProperty#getNetworkFabricConfiguration}
             * @param networkFabricConfiguration Configuration properties for Hyperledger Fabric for a member in a Managed Blockchain network that is using the Hyperledger Fabric framework.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkFabricConfiguration(software.amazon.awscdk.IResolvable networkFabricConfiguration) {
                this.networkFabricConfiguration = networkFabricConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NetworkFrameworkConfigurationProperty#getNetworkFabricConfiguration}
             * @param networkFabricConfiguration Configuration properties for Hyperledger Fabric for a member in a Managed Blockchain network that is using the Hyperledger Fabric framework.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkFabricConfiguration(software.amazon.awscdk.services.managedblockchain.CfnMember.NetworkFabricConfigurationProperty networkFabricConfiguration) {
                this.networkFabricConfiguration = networkFabricConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkFrameworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkFrameworkConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkFrameworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkFrameworkConfigurationProperty {
            private final java.lang.Object networkFabricConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.networkFabricConfiguration = software.amazon.jsii.Kernel.get(this, "networkFabricConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.networkFabricConfiguration = builder.networkFabricConfiguration;
            }

            @Override
            public final java.lang.Object getNetworkFabricConfiguration() {
                return this.networkFabricConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNetworkFabricConfiguration() != null) {
                    data.set("networkFabricConfiguration", om.valueToTree(this.getNetworkFabricConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_managedblockchain.CfnMember.NetworkFrameworkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkFrameworkConfigurationProperty.Jsii$Proxy that = (NetworkFrameworkConfigurationProperty.Jsii$Proxy) o;

                return this.networkFabricConfiguration != null ? this.networkFabricConfiguration.equals(that.networkFabricConfiguration) : that.networkFabricConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.networkFabricConfiguration != null ? this.networkFabricConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The voting rules for the network to decide if a proposal is accepted.
     * <p>
     * Applies only to Hyperledger Fabric.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.managedblockchain.*;
     * VotingPolicyProperty votingPolicyProperty = VotingPolicyProperty.builder()
     *         .approvalThresholdPolicy(ApprovalThresholdPolicyProperty.builder()
     *                 .proposalDurationInHours(123)
     *                 .thresholdComparator("thresholdComparator")
     *                 .thresholdPercentage(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-votingpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-votingpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_managedblockchain.CfnMember.VotingPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(VotingPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VotingPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the rules for the network for voting on proposals, such as the percentage of <code>YES</code> votes required for the proposal to be approved and the duration of the proposal.
         * <p>
         * The policy applies to all proposals and is specified when the network is created.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-votingpolicy.html#cfn-managedblockchain-member-votingpolicy-approvalthresholdpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-votingpolicy.html#cfn-managedblockchain-member-votingpolicy-approvalthresholdpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getApprovalThresholdPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VotingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VotingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VotingPolicyProperty> {
            java.lang.Object approvalThresholdPolicy;

            /**
             * Sets the value of {@link VotingPolicyProperty#getApprovalThresholdPolicy}
             * @param approvalThresholdPolicy Defines the rules for the network for voting on proposals, such as the percentage of <code>YES</code> votes required for the proposal to be approved and the duration of the proposal.
             *                                The policy applies to all proposals and is specified when the network is created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder approvalThresholdPolicy(software.amazon.awscdk.IResolvable approvalThresholdPolicy) {
                this.approvalThresholdPolicy = approvalThresholdPolicy;
                return this;
            }

            /**
             * Sets the value of {@link VotingPolicyProperty#getApprovalThresholdPolicy}
             * @param approvalThresholdPolicy Defines the rules for the network for voting on proposals, such as the percentage of <code>YES</code> votes required for the proposal to be approved and the duration of the proposal.
             *                                The policy applies to all proposals and is specified when the network is created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder approvalThresholdPolicy(software.amazon.awscdk.services.managedblockchain.CfnMember.ApprovalThresholdPolicyProperty approvalThresholdPolicy) {
                this.approvalThresholdPolicy = approvalThresholdPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VotingPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VotingPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VotingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VotingPolicyProperty {
            private final java.lang.Object approvalThresholdPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.approvalThresholdPolicy = software.amazon.jsii.Kernel.get(this, "approvalThresholdPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.approvalThresholdPolicy = builder.approvalThresholdPolicy;
            }

            @Override
            public final java.lang.Object getApprovalThresholdPolicy() {
                return this.approvalThresholdPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApprovalThresholdPolicy() != null) {
                    data.set("approvalThresholdPolicy", om.valueToTree(this.getApprovalThresholdPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_managedblockchain.CfnMember.VotingPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VotingPolicyProperty.Jsii$Proxy that = (VotingPolicyProperty.Jsii$Proxy) o;

                return this.approvalThresholdPolicy != null ? this.approvalThresholdPolicy.equals(that.approvalThresholdPolicy) : that.approvalThresholdPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.approvalThresholdPolicy != null ? this.approvalThresholdPolicy.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.managedblockchain.CfnMember}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.managedblockchain.CfnMember> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.managedblockchain.CfnMemberProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.managedblockchain.CfnMemberProps.Builder();
        }

        /**
         * Configuration properties of the member.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-memberconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-memberconfiguration</a>
         * @param memberConfiguration Configuration properties of the member. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memberConfiguration(final software.amazon.awscdk.IResolvable memberConfiguration) {
            this.props.memberConfiguration(memberConfiguration);
            return this;
        }
        /**
         * Configuration properties of the member.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-memberconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-memberconfiguration</a>
         * @param memberConfiguration Configuration properties of the member. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memberConfiguration(final software.amazon.awscdk.services.managedblockchain.CfnMember.MemberConfigurationProperty memberConfiguration) {
            this.props.memberConfiguration(memberConfiguration);
            return this;
        }

        /**
         * The unique identifier of the invitation to join the network sent to the account that creates the member.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-invitationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-invitationid</a>
         * @param invitationId The unique identifier of the invitation to join the network sent to the account that creates the member. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invitationId(final java.lang.String invitationId) {
            this.props.invitationId(invitationId);
            return this;
        }

        /**
         * Configuration properties of the network to which the member belongs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkconfiguration</a>
         * @param networkConfiguration Configuration properties of the network to which the member belongs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(final software.amazon.awscdk.IResolvable networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }
        /**
         * Configuration properties of the network to which the member belongs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkconfiguration</a>
         * @param networkConfiguration Configuration properties of the network to which the member belongs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(final software.amazon.awscdk.services.managedblockchain.CfnMember.NetworkConfigurationProperty networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }

        /**
         * The unique identifier of the network to which the member belongs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkid</a>
         * @param networkId The unique identifier of the network to which the member belongs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkId(final java.lang.String networkId) {
            this.props.networkId(networkId);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.managedblockchain.CfnMember}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.managedblockchain.CfnMember build() {
            return new software.amazon.awscdk.services.managedblockchain.CfnMember(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
