package software.amazon.awscdk.services.networkmanager;

/**
 * Properties for defining a <code>CfnTransitGatewayRegistration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkmanager.*;
 * CfnTransitGatewayRegistrationProps cfnTransitGatewayRegistrationProps = CfnTransitGatewayRegistrationProps.builder()
 *         .globalNetworkId("globalNetworkId")
 *         .transitGatewayArn("transitGatewayArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayregistration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayregistration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:35.331Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkmanager.CfnTransitGatewayRegistrationProps")
@software.amazon.jsii.Jsii.Proxy(CfnTransitGatewayRegistrationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTransitGatewayRegistrationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the global network.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayregistration.html#cfn-networkmanager-transitgatewayregistration-globalnetworkid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayregistration.html#cfn-networkmanager-transitgatewayregistration-globalnetworkid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGlobalNetworkId();

    /**
     * The Amazon Resource Name (ARN) of the transit gateway.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayregistration.html#cfn-networkmanager-transitgatewayregistration-transitgatewayarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayregistration.html#cfn-networkmanager-transitgatewayregistration-transitgatewayarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTransitGatewayArn();

    /**
     * @return a {@link Builder} of {@link CfnTransitGatewayRegistrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTransitGatewayRegistrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTransitGatewayRegistrationProps> {
        java.lang.String globalNetworkId;
        java.lang.String transitGatewayArn;

        /**
         * Sets the value of {@link CfnTransitGatewayRegistrationProps#getGlobalNetworkId}
         * @param globalNetworkId The ID of the global network. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalNetworkId(java.lang.String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayRegistrationProps#getTransitGatewayArn}
         * @param transitGatewayArn The Amazon Resource Name (ARN) of the transit gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayArn(java.lang.String transitGatewayArn) {
            this.transitGatewayArn = transitGatewayArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTransitGatewayRegistrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTransitGatewayRegistrationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTransitGatewayRegistrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTransitGatewayRegistrationProps {
        private final java.lang.String globalNetworkId;
        private final java.lang.String transitGatewayArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.globalNetworkId = software.amazon.jsii.Kernel.get(this, "globalNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transitGatewayArn = software.amazon.jsii.Kernel.get(this, "transitGatewayArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.globalNetworkId = java.util.Objects.requireNonNull(builder.globalNetworkId, "globalNetworkId is required");
            this.transitGatewayArn = java.util.Objects.requireNonNull(builder.transitGatewayArn, "transitGatewayArn is required");
        }

        @Override
        public final java.lang.String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        @Override
        public final java.lang.String getTransitGatewayArn() {
            return this.transitGatewayArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("globalNetworkId", om.valueToTree(this.getGlobalNetworkId()));
            data.set("transitGatewayArn", om.valueToTree(this.getTransitGatewayArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkmanager.CfnTransitGatewayRegistrationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTransitGatewayRegistrationProps.Jsii$Proxy that = (CfnTransitGatewayRegistrationProps.Jsii$Proxy) o;

            if (!globalNetworkId.equals(that.globalNetworkId)) return false;
            return this.transitGatewayArn.equals(that.transitGatewayArn);
        }

        @Override
        public final int hashCode() {
            int result = this.globalNetworkId.hashCode();
            result = 31 * result + (this.transitGatewayArn.hashCode());
            return result;
        }
    }
}
