package software.amazon.awscdk.services.opensearchservice;

/**
 * Properties for defining a <code>CfnDomain</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.opensearchservice.*;
 * Object accessPolicies;
 * CfnDomainProps cfnDomainProps = CfnDomainProps.builder()
 *         .accessPolicies(accessPolicies)
 *         .advancedOptions(Map.of(
 *                 "advancedOptionsKey", "advancedOptions"))
 *         .advancedSecurityOptions(AdvancedSecurityOptionsInputProperty.builder()
 *                 .anonymousAuthDisableDate("anonymousAuthDisableDate")
 *                 .anonymousAuthEnabled(false)
 *                 .enabled(false)
 *                 .internalUserDatabaseEnabled(false)
 *                 .jwtOptions(JWTOptionsProperty.builder()
 *                         .enabled(false)
 *                         .publicKey("publicKey")
 *                         .rolesKey("rolesKey")
 *                         .subjectKey("subjectKey")
 *                         .build())
 *                 .masterUserOptions(MasterUserOptionsProperty.builder()
 *                         .masterUserArn("masterUserArn")
 *                         .masterUserName("masterUserName")
 *                         .masterUserPassword("masterUserPassword")
 *                         .build())
 *                 .samlOptions(SAMLOptionsProperty.builder()
 *                         .enabled(false)
 *                         .idp(IdpProperty.builder()
 *                                 .entityId("entityId")
 *                                 .metadataContent("metadataContent")
 *                                 .build())
 *                         .masterBackendRole("masterBackendRole")
 *                         .masterUserName("masterUserName")
 *                         .rolesKey("rolesKey")
 *                         .sessionTimeoutMinutes(123)
 *                         .subjectKey("subjectKey")
 *                         .build())
 *                 .build())
 *         .clusterConfig(ClusterConfigProperty.builder()
 *                 .coldStorageOptions(ColdStorageOptionsProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .dedicatedMasterCount(123)
 *                 .dedicatedMasterEnabled(false)
 *                 .dedicatedMasterType("dedicatedMasterType")
 *                 .instanceCount(123)
 *                 .instanceType("instanceType")
 *                 .multiAzWithStandbyEnabled(false)
 *                 .warmCount(123)
 *                 .warmEnabled(false)
 *                 .warmType("warmType")
 *                 .zoneAwarenessConfig(ZoneAwarenessConfigProperty.builder()
 *                         .availabilityZoneCount(123)
 *                         .build())
 *                 .zoneAwarenessEnabled(false)
 *                 .build())
 *         .cognitoOptions(CognitoOptionsProperty.builder()
 *                 .enabled(false)
 *                 .identityPoolId("identityPoolId")
 *                 .roleArn("roleArn")
 *                 .userPoolId("userPoolId")
 *                 .build())
 *         .domainArn("domainArn")
 *         .domainEndpointOptions(DomainEndpointOptionsProperty.builder()
 *                 .customEndpoint("customEndpoint")
 *                 .customEndpointCertificateArn("customEndpointCertificateArn")
 *                 .customEndpointEnabled(false)
 *                 .enforceHttps(false)
 *                 .tlsSecurityPolicy("tlsSecurityPolicy")
 *                 .build())
 *         .domainName("domainName")
 *         .ebsOptions(EBSOptionsProperty.builder()
 *                 .ebsEnabled(false)
 *                 .iops(123)
 *                 .throughput(123)
 *                 .volumeSize(123)
 *                 .volumeType("volumeType")
 *                 .build())
 *         .encryptionAtRestOptions(EncryptionAtRestOptionsProperty.builder()
 *                 .enabled(false)
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .engineVersion("engineVersion")
 *         .ipAddressType("ipAddressType")
 *         .logPublishingOptions(Map.of(
 *                 "logPublishingOptionsKey", LogPublishingOptionProperty.builder()
 *                         .cloudWatchLogsLogGroupArn("cloudWatchLogsLogGroupArn")
 *                         .enabled(false)
 *                         .build()))
 *         .nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsProperty.builder()
 *                 .enabled(false)
 *                 .build())
 *         .offPeakWindowOptions(OffPeakWindowOptionsProperty.builder()
 *                 .enabled(false)
 *                 .offPeakWindow(OffPeakWindowProperty.builder()
 *                         .windowStartTime(WindowStartTimeProperty.builder()
 *                                 .hours(123)
 *                                 .minutes(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .skipShardMigrationWait(false)
 *         .snapshotOptions(SnapshotOptionsProperty.builder()
 *                 .automatedSnapshotStartHour(123)
 *                 .build())
 *         .softwareUpdateOptions(SoftwareUpdateOptionsProperty.builder()
 *                 .autoSoftwareUpdateEnabled(false)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcOptions(VPCOptionsProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:35.449Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomainProps")
@software.amazon.jsii.Jsii.Proxy(CfnDomainProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDomainProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An AWS Identity and Access Management ( IAM ) policy document that specifies who can access the OpenSearch Service domain and their permissions.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html#ac-creating">Configuring access policies</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-accesspolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-accesspolicies</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccessPolicies() {
        return null;
    }

    /**
     * Additional options to specify for the OpenSearch Service domain.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_CreateDomain.html#API_CreateDomain_RequestBody">AdvancedOptions</a> in the OpenSearch Service API reference.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-advancedoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-advancedoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedOptions() {
        return null;
    }

    /**
     * Specifies options for fine-grained access control and SAML authentication.
     * <p>
     * If you specify advanced security options, you must also enable node-to-node encryption ( <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodetonodeencryptionoptions.html">NodeToNodeEncryptionOptions</a> ) and encryption at rest ( <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-encryptionatrestoptions.html">EncryptionAtRestOptions</a> ). You must also enable <code>EnforceHTTPS</code> within <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-domainendpointoptions.html">DomainEndpointOptions</a> , which requires HTTPS for all traffic to the domain.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-advancedsecurityoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-advancedsecurityoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedSecurityOptions() {
        return null;
    }

    /**
     * Container for the cluster configuration of a domain.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-clusterconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-clusterconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getClusterConfig() {
        return null;
    }

    /**
     * Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-cognitooptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-cognitooptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCognitoOptions() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-domainarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-domainarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainArn() {
        return null;
    }

    /**
     * Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-domainendpointoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-domainendpointoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDomainEndpointOptions() {
        return null;
    }

    /**
     * A name for the OpenSearch Service domain.
     * <p>
     * The name must have a minimum length of 3 and a maximum length of 28. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the domain name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * Required when creating a new domain.
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-domainname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
        return null;
    }

    /**
     * The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/limits.html#ebsresource">EBS volume size limits</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-ebsoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-ebsoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptions() {
        return null;
    }

    /**
     * Whether the domain should encrypt data at rest, and if so, the AWS KMS key to use.
     * <p>
     * See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/encryption-at-rest.html">Encryption of data at rest for Amazon OpenSearch Service</a> .
     * <p>
     * If no encryption at rest options were initially specified in the template, updating this property by adding it causes no interruption. However, if you change this property after it's already been set within a template, the domain is deleted and recreated in order to modify the property.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-encryptionatrestoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-encryptionatrestoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionAtRestOptions() {
        return null;
    }

    /**
     * The version of OpenSearch to use.
     * <p>
     * The value must be in the format <code>OpenSearch_X.Y</code> or <code>Elasticsearch_X.Y</code> . If not specified, the latest version of OpenSearch is used. For information about the versions that OpenSearch Service supports, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/what-is.html#choosing-version">Supported versions of OpenSearch and Elasticsearch</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * If you set the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-upgradeopensearchdomain">EnableVersionUpgrade</a> update policy to <code>true</code> , you can update <code>EngineVersion</code> without interruption. When <code>EnableVersionUpgrade</code> is set to <code>false</code> , or is not specified, updating <code>EngineVersion</code> results in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-engineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-engineversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return null;
    }

    /**
     * Choose either dual stack or IPv4 as your IP address type.
     * <p>
     * Dual stack allows you to share domain resources across IPv4 and IPv6 address types, and is the recommended option. If you set your IP address type to dual stack, you can't change your address type later.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-ipaddresstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-ipaddresstype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpAddressType() {
        return null;
    }

    /**
     * An object with one or more of the following keys: <code>SEARCH_SLOW_LOGS</code> , <code>ES_APPLICATION_LOGS</code> , <code>INDEX_SLOW_LOGS</code> , <code>AUDIT_LOGS</code> , depending on the types of logs you want to publish.
     * <p>
     * Each key needs a valid <code>LogPublishingOption</code> value. For the full syntax, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#aws-resource-opensearchservice-domain--examples">examples</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-logpublishingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-logpublishingoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLogPublishingOptions() {
        return null;
    }

    /**
     * Specifies whether node-to-node encryption is enabled.
     * <p>
     * See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ntn.html">Node-to-node encryption for Amazon OpenSearch Service</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-nodetonodeencryptionoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-nodetonodeencryptionoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNodeToNodeEncryptionOptions() {
        return null;
    }

    /**
     * Options for a domain's off-peak window, during which OpenSearch Service can perform mandatory configuration changes on the domain.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-offpeakwindowoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-offpeakwindowoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOffPeakWindowOptions() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-skipshardmigrationwait">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-skipshardmigrationwait</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSkipShardMigrationWait() {
        return null;
    }

    /**
     * <em>DEPRECATED</em> .
     * <p>
     * The automated snapshot configuration for the OpenSearch Service domain indexes.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-snapshotoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-snapshotoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSnapshotOptions() {
        return null;
    }

    /**
     * Service software update options for the domain.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-softwareupdateoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-softwareupdateoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSoftwareUpdateOptions() {
        return null;
    }

    /**
     * An arbitrary set of tags (key–value pairs) to associate with the OpenSearch Service domain.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The virtual private cloud (VPC) configuration for the OpenSearch Service domain.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your Amazon OpenSearch Service domains within a VPC</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * If you remove this entity altogether, along with its associated properties, it causes a replacement. You might encounter this scenario if you're updating your security configuration from a VPC to a public endpoint.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-vpcoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-vpcoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpcOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDomainProps> {
        java.lang.Object accessPolicies;
        java.lang.Object advancedOptions;
        java.lang.Object advancedSecurityOptions;
        java.lang.Object clusterConfig;
        java.lang.Object cognitoOptions;
        java.lang.String domainArn;
        java.lang.Object domainEndpointOptions;
        java.lang.String domainName;
        java.lang.Object ebsOptions;
        java.lang.Object encryptionAtRestOptions;
        java.lang.String engineVersion;
        java.lang.String ipAddressType;
        java.lang.Object logPublishingOptions;
        java.lang.Object nodeToNodeEncryptionOptions;
        java.lang.Object offPeakWindowOptions;
        java.lang.Object skipShardMigrationWait;
        java.lang.Object snapshotOptions;
        java.lang.Object softwareUpdateOptions;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object vpcOptions;

        /**
         * Sets the value of {@link CfnDomainProps#getAccessPolicies}
         * @param accessPolicies An AWS Identity and Access Management ( IAM ) policy document that specifies who can access the OpenSearch Service domain and their permissions.
         *                       For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html#ac-creating">Configuring access policies</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPolicies(java.lang.Object accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getAdvancedOptions}
         * @param advancedOptions Additional options to specify for the OpenSearch Service domain.
         *                        For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_CreateDomain.html#API_CreateDomain_RequestBody">AdvancedOptions</a> in the OpenSearch Service API reference.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedOptions(software.amazon.awscdk.IResolvable advancedOptions) {
            this.advancedOptions = advancedOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getAdvancedOptions}
         * @param advancedOptions Additional options to specify for the OpenSearch Service domain.
         *                        For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_CreateDomain.html#API_CreateDomain_RequestBody">AdvancedOptions</a> in the OpenSearch Service API reference.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedOptions(java.util.Map<java.lang.String, java.lang.String> advancedOptions) {
            this.advancedOptions = advancedOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getAdvancedSecurityOptions}
         * @param advancedSecurityOptions Specifies options for fine-grained access control and SAML authentication.
         *                                If you specify advanced security options, you must also enable node-to-node encryption ( <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodetonodeencryptionoptions.html">NodeToNodeEncryptionOptions</a> ) and encryption at rest ( <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-encryptionatrestoptions.html">EncryptionAtRestOptions</a> ). You must also enable <code>EnforceHTTPS</code> within <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-domainendpointoptions.html">DomainEndpointOptions</a> , which requires HTTPS for all traffic to the domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedSecurityOptions(software.amazon.awscdk.IResolvable advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getAdvancedSecurityOptions}
         * @param advancedSecurityOptions Specifies options for fine-grained access control and SAML authentication.
         *                                If you specify advanced security options, you must also enable node-to-node encryption ( <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodetonodeencryptionoptions.html">NodeToNodeEncryptionOptions</a> ) and encryption at rest ( <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-encryptionatrestoptions.html">EncryptionAtRestOptions</a> ). You must also enable <code>EnforceHTTPS</code> within <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-domainendpointoptions.html">DomainEndpointOptions</a> , which requires HTTPS for all traffic to the domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedSecurityOptions(software.amazon.awscdk.services.opensearchservice.CfnDomain.AdvancedSecurityOptionsInputProperty advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getClusterConfig}
         * @param clusterConfig Container for the cluster configuration of a domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterConfig(software.amazon.awscdk.IResolvable clusterConfig) {
            this.clusterConfig = clusterConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getClusterConfig}
         * @param clusterConfig Container for the cluster configuration of a domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterConfig(software.amazon.awscdk.services.opensearchservice.CfnDomain.ClusterConfigProperty clusterConfig) {
            this.clusterConfig = clusterConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getCognitoOptions}
         * @param cognitoOptions Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoOptions(software.amazon.awscdk.IResolvable cognitoOptions) {
            this.cognitoOptions = cognitoOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getCognitoOptions}
         * @param cognitoOptions Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoOptions(software.amazon.awscdk.services.opensearchservice.CfnDomain.CognitoOptionsProperty cognitoOptions) {
            this.cognitoOptions = cognitoOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDomainArn}
         * @param domainArn the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainArn(java.lang.String domainArn) {
            this.domainArn = domainArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDomainEndpointOptions}
         * @param domainEndpointOptions Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainEndpointOptions(software.amazon.awscdk.IResolvable domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDomainEndpointOptions}
         * @param domainEndpointOptions Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainEndpointOptions(software.amazon.awscdk.services.opensearchservice.CfnDomain.DomainEndpointOptionsProperty domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDomainName}
         * @param domainName A name for the OpenSearch Service domain.
         *                   The name must have a minimum length of 3 and a maximum length of 28. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the domain name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         *                   <p>
         *                   Required when creating a new domain.
         *                   <p>
         *                   <blockquote>
         *                   <p>
         *                   If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getEbsOptions}
         * @param ebsOptions The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain.
         *                   For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/limits.html#ebsresource">EBS volume size limits</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptions(software.amazon.awscdk.IResolvable ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getEbsOptions}
         * @param ebsOptions The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain.
         *                   For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/limits.html#ebsresource">EBS volume size limits</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptions(software.amazon.awscdk.services.opensearchservice.CfnDomain.EBSOptionsProperty ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getEncryptionAtRestOptions}
         * @param encryptionAtRestOptions Whether the domain should encrypt data at rest, and if so, the AWS KMS key to use.
         *                                See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/encryption-at-rest.html">Encryption of data at rest for Amazon OpenSearch Service</a> .
         *                                <p>
         *                                If no encryption at rest options were initially specified in the template, updating this property by adding it causes no interruption. However, if you change this property after it's already been set within a template, the domain is deleted and recreated in order to modify the property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionAtRestOptions(software.amazon.awscdk.IResolvable encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getEncryptionAtRestOptions}
         * @param encryptionAtRestOptions Whether the domain should encrypt data at rest, and if so, the AWS KMS key to use.
         *                                See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/encryption-at-rest.html">Encryption of data at rest for Amazon OpenSearch Service</a> .
         *                                <p>
         *                                If no encryption at rest options were initially specified in the template, updating this property by adding it causes no interruption. However, if you change this property after it's already been set within a template, the domain is deleted and recreated in order to modify the property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionAtRestOptions(software.amazon.awscdk.services.opensearchservice.CfnDomain.EncryptionAtRestOptionsProperty encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getEngineVersion}
         * @param engineVersion The version of OpenSearch to use.
         *                      The value must be in the format <code>OpenSearch_X.Y</code> or <code>Elasticsearch_X.Y</code> . If not specified, the latest version of OpenSearch is used. For information about the versions that OpenSearch Service supports, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/what-is.html#choosing-version">Supported versions of OpenSearch and Elasticsearch</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         *                      <p>
         *                      If you set the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-upgradeopensearchdomain">EnableVersionUpgrade</a> update policy to <code>true</code> , you can update <code>EngineVersion</code> without interruption. When <code>EnableVersionUpgrade</code> is set to <code>false</code> , or is not specified, updating <code>EngineVersion</code> results in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(java.lang.String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getIpAddressType}
         * @param ipAddressType Choose either dual stack or IPv4 as your IP address type.
         *                      Dual stack allows you to share domain resources across IPv4 and IPv6 address types, and is the recommended option. If you set your IP address type to dual stack, you can't change your address type later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(java.lang.String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getLogPublishingOptions}
         * @param logPublishingOptions An object with one or more of the following keys: <code>SEARCH_SLOW_LOGS</code> , <code>ES_APPLICATION_LOGS</code> , <code>INDEX_SLOW_LOGS</code> , <code>AUDIT_LOGS</code> , depending on the types of logs you want to publish.
         *                             Each key needs a valid <code>LogPublishingOption</code> value. For the full syntax, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#aws-resource-opensearchservice-domain--examples">examples</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logPublishingOptions(software.amazon.awscdk.IResolvable logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getLogPublishingOptions}
         * @param logPublishingOptions An object with one or more of the following keys: <code>SEARCH_SLOW_LOGS</code> , <code>ES_APPLICATION_LOGS</code> , <code>INDEX_SLOW_LOGS</code> , <code>AUDIT_LOGS</code> , depending on the types of logs you want to publish.
         *                             Each key needs a valid <code>LogPublishingOption</code> value. For the full syntax, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#aws-resource-opensearchservice-domain--examples">examples</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logPublishingOptions(java.util.Map<java.lang.String, ? extends java.lang.Object> logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getNodeToNodeEncryptionOptions}
         * @param nodeToNodeEncryptionOptions Specifies whether node-to-node encryption is enabled.
         *                                    See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ntn.html">Node-to-node encryption for Amazon OpenSearch Service</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeToNodeEncryptionOptions(software.amazon.awscdk.IResolvable nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getNodeToNodeEncryptionOptions}
         * @param nodeToNodeEncryptionOptions Specifies whether node-to-node encryption is enabled.
         *                                    See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ntn.html">Node-to-node encryption for Amazon OpenSearch Service</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeToNodeEncryptionOptions(software.amazon.awscdk.services.opensearchservice.CfnDomain.NodeToNodeEncryptionOptionsProperty nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getOffPeakWindowOptions}
         * @param offPeakWindowOptions Options for a domain's off-peak window, during which OpenSearch Service can perform mandatory configuration changes on the domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder offPeakWindowOptions(software.amazon.awscdk.IResolvable offPeakWindowOptions) {
            this.offPeakWindowOptions = offPeakWindowOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getOffPeakWindowOptions}
         * @param offPeakWindowOptions Options for a domain's off-peak window, during which OpenSearch Service can perform mandatory configuration changes on the domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder offPeakWindowOptions(software.amazon.awscdk.services.opensearchservice.CfnDomain.OffPeakWindowOptionsProperty offPeakWindowOptions) {
            this.offPeakWindowOptions = offPeakWindowOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getSkipShardMigrationWait}
         * @param skipShardMigrationWait the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skipShardMigrationWait(java.lang.Boolean skipShardMigrationWait) {
            this.skipShardMigrationWait = skipShardMigrationWait;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getSkipShardMigrationWait}
         * @param skipShardMigrationWait the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skipShardMigrationWait(software.amazon.awscdk.IResolvable skipShardMigrationWait) {
            this.skipShardMigrationWait = skipShardMigrationWait;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getSnapshotOptions}
         * @param snapshotOptions <em>DEPRECATED</em> .
         *                        The automated snapshot configuration for the OpenSearch Service domain indexes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotOptions(software.amazon.awscdk.IResolvable snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getSnapshotOptions}
         * @param snapshotOptions <em>DEPRECATED</em> .
         *                        The automated snapshot configuration for the OpenSearch Service domain indexes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotOptions(software.amazon.awscdk.services.opensearchservice.CfnDomain.SnapshotOptionsProperty snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getSoftwareUpdateOptions}
         * @param softwareUpdateOptions Service software update options for the domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder softwareUpdateOptions(software.amazon.awscdk.IResolvable softwareUpdateOptions) {
            this.softwareUpdateOptions = softwareUpdateOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getSoftwareUpdateOptions}
         * @param softwareUpdateOptions Service software update options for the domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder softwareUpdateOptions(software.amazon.awscdk.services.opensearchservice.CfnDomain.SoftwareUpdateOptionsProperty softwareUpdateOptions) {
            this.softwareUpdateOptions = softwareUpdateOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getTags}
         * @param tags An arbitrary set of tags (key–value pairs) to associate with the OpenSearch Service domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getVpcOptions}
         * @param vpcOptions The virtual private cloud (VPC) configuration for the OpenSearch Service domain.
         *                   For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your Amazon OpenSearch Service domains within a VPC</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         *                   <p>
         *                   If you remove this entity altogether, along with its associated properties, it causes a replacement. You might encounter this scenario if you're updating your security configuration from a VPC to a public endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcOptions(software.amazon.awscdk.IResolvable vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getVpcOptions}
         * @param vpcOptions The virtual private cloud (VPC) configuration for the OpenSearch Service domain.
         *                   For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your Amazon OpenSearch Service domains within a VPC</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         *                   <p>
         *                   If you remove this entity altogether, along with its associated properties, it causes a replacement. You might encounter this scenario if you're updating your security configuration from a VPC to a public endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcOptions(software.amazon.awscdk.services.opensearchservice.CfnDomain.VPCOptionsProperty vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDomainProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDomainProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDomainProps {
        private final java.lang.Object accessPolicies;
        private final java.lang.Object advancedOptions;
        private final java.lang.Object advancedSecurityOptions;
        private final java.lang.Object clusterConfig;
        private final java.lang.Object cognitoOptions;
        private final java.lang.String domainArn;
        private final java.lang.Object domainEndpointOptions;
        private final java.lang.String domainName;
        private final java.lang.Object ebsOptions;
        private final java.lang.Object encryptionAtRestOptions;
        private final java.lang.String engineVersion;
        private final java.lang.String ipAddressType;
        private final java.lang.Object logPublishingOptions;
        private final java.lang.Object nodeToNodeEncryptionOptions;
        private final java.lang.Object offPeakWindowOptions;
        private final java.lang.Object skipShardMigrationWait;
        private final java.lang.Object snapshotOptions;
        private final java.lang.Object softwareUpdateOptions;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object vpcOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessPolicies = software.amazon.jsii.Kernel.get(this, "accessPolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.advancedOptions = software.amazon.jsii.Kernel.get(this, "advancedOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.advancedSecurityOptions = software.amazon.jsii.Kernel.get(this, "advancedSecurityOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.clusterConfig = software.amazon.jsii.Kernel.get(this, "clusterConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cognitoOptions = software.amazon.jsii.Kernel.get(this, "cognitoOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.domainArn = software.amazon.jsii.Kernel.get(this, "domainArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainEndpointOptions = software.amazon.jsii.Kernel.get(this, "domainEndpointOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ebsOptions = software.amazon.jsii.Kernel.get(this, "ebsOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.encryptionAtRestOptions = software.amazon.jsii.Kernel.get(this, "encryptionAtRestOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.engineVersion = software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipAddressType = software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logPublishingOptions = software.amazon.jsii.Kernel.get(this, "logPublishingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.nodeToNodeEncryptionOptions = software.amazon.jsii.Kernel.get(this, "nodeToNodeEncryptionOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.offPeakWindowOptions = software.amazon.jsii.Kernel.get(this, "offPeakWindowOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.skipShardMigrationWait = software.amazon.jsii.Kernel.get(this, "skipShardMigrationWait", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.snapshotOptions = software.amazon.jsii.Kernel.get(this, "snapshotOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.softwareUpdateOptions = software.amazon.jsii.Kernel.get(this, "softwareUpdateOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.vpcOptions = software.amazon.jsii.Kernel.get(this, "vpcOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessPolicies = builder.accessPolicies;
            this.advancedOptions = builder.advancedOptions;
            this.advancedSecurityOptions = builder.advancedSecurityOptions;
            this.clusterConfig = builder.clusterConfig;
            this.cognitoOptions = builder.cognitoOptions;
            this.domainArn = builder.domainArn;
            this.domainEndpointOptions = builder.domainEndpointOptions;
            this.domainName = builder.domainName;
            this.ebsOptions = builder.ebsOptions;
            this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
            this.engineVersion = builder.engineVersion;
            this.ipAddressType = builder.ipAddressType;
            this.logPublishingOptions = builder.logPublishingOptions;
            this.nodeToNodeEncryptionOptions = builder.nodeToNodeEncryptionOptions;
            this.offPeakWindowOptions = builder.offPeakWindowOptions;
            this.skipShardMigrationWait = builder.skipShardMigrationWait;
            this.snapshotOptions = builder.snapshotOptions;
            this.softwareUpdateOptions = builder.softwareUpdateOptions;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.vpcOptions = builder.vpcOptions;
        }

        @Override
        public final java.lang.Object getAccessPolicies() {
            return this.accessPolicies;
        }

        @Override
        public final java.lang.Object getAdvancedOptions() {
            return this.advancedOptions;
        }

        @Override
        public final java.lang.Object getAdvancedSecurityOptions() {
            return this.advancedSecurityOptions;
        }

        @Override
        public final java.lang.Object getClusterConfig() {
            return this.clusterConfig;
        }

        @Override
        public final java.lang.Object getCognitoOptions() {
            return this.cognitoOptions;
        }

        @Override
        public final java.lang.String getDomainArn() {
            return this.domainArn;
        }

        @Override
        public final java.lang.Object getDomainEndpointOptions() {
            return this.domainEndpointOptions;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.Object getEbsOptions() {
            return this.ebsOptions;
        }

        @Override
        public final java.lang.Object getEncryptionAtRestOptions() {
            return this.encryptionAtRestOptions;
        }

        @Override
        public final java.lang.String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final java.lang.String getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public final java.lang.Object getLogPublishingOptions() {
            return this.logPublishingOptions;
        }

        @Override
        public final java.lang.Object getNodeToNodeEncryptionOptions() {
            return this.nodeToNodeEncryptionOptions;
        }

        @Override
        public final java.lang.Object getOffPeakWindowOptions() {
            return this.offPeakWindowOptions;
        }

        @Override
        public final java.lang.Object getSkipShardMigrationWait() {
            return this.skipShardMigrationWait;
        }

        @Override
        public final java.lang.Object getSnapshotOptions() {
            return this.snapshotOptions;
        }

        @Override
        public final java.lang.Object getSoftwareUpdateOptions() {
            return this.softwareUpdateOptions;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getVpcOptions() {
            return this.vpcOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccessPolicies() != null) {
                data.set("accessPolicies", om.valueToTree(this.getAccessPolicies()));
            }
            if (this.getAdvancedOptions() != null) {
                data.set("advancedOptions", om.valueToTree(this.getAdvancedOptions()));
            }
            if (this.getAdvancedSecurityOptions() != null) {
                data.set("advancedSecurityOptions", om.valueToTree(this.getAdvancedSecurityOptions()));
            }
            if (this.getClusterConfig() != null) {
                data.set("clusterConfig", om.valueToTree(this.getClusterConfig()));
            }
            if (this.getCognitoOptions() != null) {
                data.set("cognitoOptions", om.valueToTree(this.getCognitoOptions()));
            }
            if (this.getDomainArn() != null) {
                data.set("domainArn", om.valueToTree(this.getDomainArn()));
            }
            if (this.getDomainEndpointOptions() != null) {
                data.set("domainEndpointOptions", om.valueToTree(this.getDomainEndpointOptions()));
            }
            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getEbsOptions() != null) {
                data.set("ebsOptions", om.valueToTree(this.getEbsOptions()));
            }
            if (this.getEncryptionAtRestOptions() != null) {
                data.set("encryptionAtRestOptions", om.valueToTree(this.getEncryptionAtRestOptions()));
            }
            if (this.getEngineVersion() != null) {
                data.set("engineVersion", om.valueToTree(this.getEngineVersion()));
            }
            if (this.getIpAddressType() != null) {
                data.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
            }
            if (this.getLogPublishingOptions() != null) {
                data.set("logPublishingOptions", om.valueToTree(this.getLogPublishingOptions()));
            }
            if (this.getNodeToNodeEncryptionOptions() != null) {
                data.set("nodeToNodeEncryptionOptions", om.valueToTree(this.getNodeToNodeEncryptionOptions()));
            }
            if (this.getOffPeakWindowOptions() != null) {
                data.set("offPeakWindowOptions", om.valueToTree(this.getOffPeakWindowOptions()));
            }
            if (this.getSkipShardMigrationWait() != null) {
                data.set("skipShardMigrationWait", om.valueToTree(this.getSkipShardMigrationWait()));
            }
            if (this.getSnapshotOptions() != null) {
                data.set("snapshotOptions", om.valueToTree(this.getSnapshotOptions()));
            }
            if (this.getSoftwareUpdateOptions() != null) {
                data.set("softwareUpdateOptions", om.valueToTree(this.getSoftwareUpdateOptions()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpcOptions() != null) {
                data.set("vpcOptions", om.valueToTree(this.getVpcOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomainProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDomainProps.Jsii$Proxy that = (CfnDomainProps.Jsii$Proxy) o;

            if (this.accessPolicies != null ? !this.accessPolicies.equals(that.accessPolicies) : that.accessPolicies != null) return false;
            if (this.advancedOptions != null ? !this.advancedOptions.equals(that.advancedOptions) : that.advancedOptions != null) return false;
            if (this.advancedSecurityOptions != null ? !this.advancedSecurityOptions.equals(that.advancedSecurityOptions) : that.advancedSecurityOptions != null) return false;
            if (this.clusterConfig != null ? !this.clusterConfig.equals(that.clusterConfig) : that.clusterConfig != null) return false;
            if (this.cognitoOptions != null ? !this.cognitoOptions.equals(that.cognitoOptions) : that.cognitoOptions != null) return false;
            if (this.domainArn != null ? !this.domainArn.equals(that.domainArn) : that.domainArn != null) return false;
            if (this.domainEndpointOptions != null ? !this.domainEndpointOptions.equals(that.domainEndpointOptions) : that.domainEndpointOptions != null) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.ebsOptions != null ? !this.ebsOptions.equals(that.ebsOptions) : that.ebsOptions != null) return false;
            if (this.encryptionAtRestOptions != null ? !this.encryptionAtRestOptions.equals(that.encryptionAtRestOptions) : that.encryptionAtRestOptions != null) return false;
            if (this.engineVersion != null ? !this.engineVersion.equals(that.engineVersion) : that.engineVersion != null) return false;
            if (this.ipAddressType != null ? !this.ipAddressType.equals(that.ipAddressType) : that.ipAddressType != null) return false;
            if (this.logPublishingOptions != null ? !this.logPublishingOptions.equals(that.logPublishingOptions) : that.logPublishingOptions != null) return false;
            if (this.nodeToNodeEncryptionOptions != null ? !this.nodeToNodeEncryptionOptions.equals(that.nodeToNodeEncryptionOptions) : that.nodeToNodeEncryptionOptions != null) return false;
            if (this.offPeakWindowOptions != null ? !this.offPeakWindowOptions.equals(that.offPeakWindowOptions) : that.offPeakWindowOptions != null) return false;
            if (this.skipShardMigrationWait != null ? !this.skipShardMigrationWait.equals(that.skipShardMigrationWait) : that.skipShardMigrationWait != null) return false;
            if (this.snapshotOptions != null ? !this.snapshotOptions.equals(that.snapshotOptions) : that.snapshotOptions != null) return false;
            if (this.softwareUpdateOptions != null ? !this.softwareUpdateOptions.equals(that.softwareUpdateOptions) : that.softwareUpdateOptions != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpcOptions != null ? this.vpcOptions.equals(that.vpcOptions) : that.vpcOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessPolicies != null ? this.accessPolicies.hashCode() : 0;
            result = 31 * result + (this.advancedOptions != null ? this.advancedOptions.hashCode() : 0);
            result = 31 * result + (this.advancedSecurityOptions != null ? this.advancedSecurityOptions.hashCode() : 0);
            result = 31 * result + (this.clusterConfig != null ? this.clusterConfig.hashCode() : 0);
            result = 31 * result + (this.cognitoOptions != null ? this.cognitoOptions.hashCode() : 0);
            result = 31 * result + (this.domainArn != null ? this.domainArn.hashCode() : 0);
            result = 31 * result + (this.domainEndpointOptions != null ? this.domainEndpointOptions.hashCode() : 0);
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.ebsOptions != null ? this.ebsOptions.hashCode() : 0);
            result = 31 * result + (this.encryptionAtRestOptions != null ? this.encryptionAtRestOptions.hashCode() : 0);
            result = 31 * result + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
            result = 31 * result + (this.ipAddressType != null ? this.ipAddressType.hashCode() : 0);
            result = 31 * result + (this.logPublishingOptions != null ? this.logPublishingOptions.hashCode() : 0);
            result = 31 * result + (this.nodeToNodeEncryptionOptions != null ? this.nodeToNodeEncryptionOptions.hashCode() : 0);
            result = 31 * result + (this.offPeakWindowOptions != null ? this.offPeakWindowOptions.hashCode() : 0);
            result = 31 * result + (this.skipShardMigrationWait != null ? this.skipShardMigrationWait.hashCode() : 0);
            result = 31 * result + (this.snapshotOptions != null ? this.snapshotOptions.hashCode() : 0);
            result = 31 * result + (this.softwareUpdateOptions != null ? this.softwareUpdateOptions.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpcOptions != null ? this.vpcOptions.hashCode() : 0);
            return result;
        }
    }
}
