package software.amazon.awscdk.services.opensearchservice;

/**
 * OpenSearch version.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Domain domain = Domain.Builder.create(this, "Domain")
 *         .version(EngineVersion.OPENSEARCH_1_0)
 *         .ebs(EbsOptions.builder()
 *                 .volumeSize(100)
 *                 .volumeType(EbsDeviceVolumeType.GENERAL_PURPOSE_SSD)
 *                 .build())
 *         .nodeToNodeEncryption(true)
 *         .encryptionAtRest(EncryptionAtRestOptions.builder()
 *                 .enabled(true)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:35.458Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.EngineVersion")
public class EngineVersion extends software.amazon.jsii.JsiiObject {

    protected EngineVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EngineVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ELASTICSEARCH_1_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "ELASTICSEARCH_1_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        ELASTICSEARCH_2_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "ELASTICSEARCH_2_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        ELASTICSEARCH_5_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "ELASTICSEARCH_5_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        ELASTICSEARCH_5_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "ELASTICSEARCH_5_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        ELASTICSEARCH_5_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "ELASTICSEARCH_5_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        ELASTICSEARCH_5_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "ELASTICSEARCH_5_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        ELASTICSEARCH_6_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "ELASTICSEARCH_6_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        ELASTICSEARCH_6_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "ELASTICSEARCH_6_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        ELASTICSEARCH_6_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "ELASTICSEARCH_6_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        ELASTICSEARCH_6_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "ELASTICSEARCH_6_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        ELASTICSEARCH_6_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "ELASTICSEARCH_6_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        ELASTICSEARCH_6_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "ELASTICSEARCH_6_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        ELASTICSEARCH_6_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "ELASTICSEARCH_6_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        ELASTICSEARCH_7_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "ELASTICSEARCH_7_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        ELASTICSEARCH_7_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "ELASTICSEARCH_7_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        ELASTICSEARCH_7_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "ELASTICSEARCH_7_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        ELASTICSEARCH_7_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "ELASTICSEARCH_7_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        ELASTICSEARCH_7_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "ELASTICSEARCH_7_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        ELASTICSEARCH_7_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "ELASTICSEARCH_7_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        OPENSEARCH_1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "OPENSEARCH_1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        OPENSEARCH_1_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "OPENSEARCH_1_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        OPENSEARCH_1_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "OPENSEARCH_1_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        OPENSEARCH_1_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "OPENSEARCH_1_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        OPENSEARCH_2_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "OPENSEARCH_2_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        OPENSEARCH_2_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "OPENSEARCH_2_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        OPENSEARCH_2_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "OPENSEARCH_2_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        OPENSEARCH_2_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "OPENSEARCH_2_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        OPENSEARCH_2_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "OPENSEARCH_2_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        OPENSEARCH_2_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "OPENSEARCH_2_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        OPENSEARCH_2_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "OPENSEARCH_2_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
        OPENSEARCH_2_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "OPENSEARCH_2_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class));
    }

    /**
     * Custom ElasticSearch version.
     * <p>
     * @param version custom version number. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.opensearchservice.EngineVersion elasticsearch(final @org.jetbrains.annotations.NotNull java.lang.String version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "elasticsearch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * Custom OpenSearch version.
     * <p>
     * @param version custom version number. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.opensearchservice.EngineVersion openSearch(final @org.jetbrains.annotations.NotNull java.lang.String version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.opensearchservice.EngineVersion.class, "openSearch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.EngineVersion.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * AWS Elasticsearch 1.5.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion ELASTICSEARCH_1_5;

    /**
     * AWS Elasticsearch 2.3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion ELASTICSEARCH_2_3;

    /**
     * AWS Elasticsearch 5.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion ELASTICSEARCH_5_1;

    /**
     * AWS Elasticsearch 5.3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion ELASTICSEARCH_5_3;

    /**
     * AWS Elasticsearch 5.5.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion ELASTICSEARCH_5_5;

    /**
     * AWS Elasticsearch 5.6.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion ELASTICSEARCH_5_6;

    /**
     * AWS Elasticsearch 6.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion ELASTICSEARCH_6_0;

    /**
     * AWS Elasticsearch 6.2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion ELASTICSEARCH_6_2;

    /**
     * AWS Elasticsearch 6.3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion ELASTICSEARCH_6_3;

    /**
     * AWS Elasticsearch 6.4.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion ELASTICSEARCH_6_4;

    /**
     * AWS Elasticsearch 6.5.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion ELASTICSEARCH_6_5;

    /**
     * AWS Elasticsearch 6.7.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion ELASTICSEARCH_6_7;

    /**
     * AWS Elasticsearch 6.8.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion ELASTICSEARCH_6_8;

    /**
     * AWS Elasticsearch 7.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion ELASTICSEARCH_7_1;

    /**
     * AWS Elasticsearch 7.10.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion ELASTICSEARCH_7_10;

    /**
     * AWS Elasticsearch 7.4.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion ELASTICSEARCH_7_4;

    /**
     * AWS Elasticsearch 7.7.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion ELASTICSEARCH_7_7;

    /**
     * AWS Elasticsearch 7.8.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion ELASTICSEARCH_7_8;

    /**
     * AWS Elasticsearch 7.9.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion ELASTICSEARCH_7_9;

    /**
     * AWS OpenSearch 1.0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion OPENSEARCH_1_0;

    /**
     * AWS OpenSearch 1.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion OPENSEARCH_1_1;

    /**
     * AWS OpenSearch 1.2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion OPENSEARCH_1_2;

    /**
     * AWS OpenSearch 1.3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion OPENSEARCH_1_3;

    /**
     * (deprecated) AWS OpenSearch 2.10.
     * <p>
     * @deprecated use latest version of the OpenSearch engine
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion OPENSEARCH_2_10;

    /**
     * AWS OpenSearch 2.11.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion OPENSEARCH_2_11;

    /**
     * AWS OpenSearch 2.13.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion OPENSEARCH_2_13;

    /**
     * AWS OpenSearch 2.15.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion OPENSEARCH_2_15;

    /**
     * AWS OpenSearch 2.3.
     * <p>
     * OpenSearch 2.3 is now available on Amazon OpenSearch Service across 26
     * regions globally. Please refer to the AWS Region Table for more
     * information about Amazon OpenSearch Service availability:
     * https://aws.amazon.com/about-aws/global-infrastructure/regional-product-services/
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion OPENSEARCH_2_3;

    /**
     * AWS OpenSearch 2.5.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion OPENSEARCH_2_5;

    /**
     * AWS OpenSearch 2.7.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion OPENSEARCH_2_7;

    /**
     * AWS OpenSearch 2.9.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.opensearchservice.EngineVersion OPENSEARCH_2_9;

    /**
     * engine version identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
