package software.amazon.awscdk.services.opensearchservice;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * Domain domain = Domain.Builder.create(this, "Domain")
 *         .version(EngineVersion.OPENSEARCH_1_3)
 *         .offPeakWindowEnabled(true) // can be omitted if offPeakWindowStart is set
 *         .offPeakWindowStart(WindowStartTime.builder()
 *                 .hours(20)
 *                 .minutes(0)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.103.1 (build bef2dea)", date = "2024-09-24T10:56:35.464Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.WindowStartTime")
@software.amazon.jsii.Jsii.Proxy(WindowStartTime.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WindowStartTime extends software.amazon.jsii.JsiiSerializable {

    /**
     * The start hour of the window in Coordinated Universal Time (UTC), using 24-hour time.
     * <p>
     * For example, 17 refers to 5:00 P.M. UTC.
     * <p>
     * Default: - 22
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getHours();

    /**
     * The start minute of the window, in UTC.
     * <p>
     * Default: - 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMinutes();

    /**
     * @return a {@link Builder} of {@link WindowStartTime}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WindowStartTime}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WindowStartTime> {
        java.lang.Number hours;
        java.lang.Number minutes;

        /**
         * Sets the value of {@link WindowStartTime#getHours}
         * @param hours The start hour of the window in Coordinated Universal Time (UTC), using 24-hour time. This parameter is required.
         *              For example, 17 refers to 5:00 P.M. UTC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hours(java.lang.Number hours) {
            this.hours = hours;
            return this;
        }

        /**
         * Sets the value of {@link WindowStartTime#getMinutes}
         * @param minutes The start minute of the window, in UTC. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minutes(java.lang.Number minutes) {
            this.minutes = minutes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WindowStartTime}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WindowStartTime build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WindowStartTime}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WindowStartTime {
        private final java.lang.Number hours;
        private final java.lang.Number minutes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hours = software.amazon.jsii.Kernel.get(this, "hours", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minutes = software.amazon.jsii.Kernel.get(this, "minutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hours = java.util.Objects.requireNonNull(builder.hours, "hours is required");
            this.minutes = java.util.Objects.requireNonNull(builder.minutes, "minutes is required");
        }

        @Override
        public final java.lang.Number getHours() {
            return this.hours;
        }

        @Override
        public final java.lang.Number getMinutes() {
            return this.minutes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("hours", om.valueToTree(this.getHours()));
            data.set("minutes", om.valueToTree(this.getMinutes()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.WindowStartTime"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WindowStartTime.Jsii$Proxy that = (WindowStartTime.Jsii$Proxy) o;

            if (!hours.equals(that.hours)) return false;
            return this.minutes.equals(that.minutes);
        }

        @Override
        public final int hashCode() {
            int result = this.hours.hashCode();
            result = 31 * result + (this.minutes.hashCode());
            return result;
        }
    }
}
